/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as z}from"./chunk-DPQZPDIL.js";import{h as I,i as b}from"./chunk-YJEV67VS.js";import{a as W,b as O,d as L}from"./chunk-XFVXIGTK.js";import{a as m}from"./chunk-MPRZ6V46.js";import{a as v}from"./chunk-VZMWSUG7.js";import{e as k}from"./chunk-362ETHZ6.js";var Z=Math.cos,B=Math.sin,p=Math.sqrt,N={computePosition:function(t,n,a,r,o,s,e){let i=n.radiiSquared,l=t.nwCorner,h=t.boundingRectangle,u=l.latitude-t.granYCos*r+o*t.granXSin,g=Z(u),c=B(u),m=i.z*c,S=l.longitude+r*t.granYSin+o*t.granXCos,d=g*Z(S),C=g*B(S),w=i.x*d,X=i.y*C,O=p(w*d+X*C+m*c);if(s.x=w/O,s.y=X/O,s.z=m/O,a){let n=t.stNwCorner;k(n)?(u=n.latitude-t.stGranYCos*r+o*t.stGranXSin,S=n.longitude+r*t.stGranYSin+o*t.stGranXCos,e.x=(S-t.stWest)*t.lonScalar,e.y=(u-t.stSouth)*t.latScalar):(e.x=(S-h.west)*t.lonScalar,e.y=(u-h.south)*t.latScalar)}}},A=new b,l=new W,F=new O,j=new W,y=new z;function D(t,n,a,r,o,s,e){let i=Math.cos(n),h=r*i,u=a*i,g=Math.sin(n),c=r*g,m=a*g;y._ellipsoid=L.default,l=y.project(t,l),l=W.subtract(l,j,l);let S=b.fromRotation(n,A);l=b.multiplyByVector(S,l,l),l=W.add(l,j,l),s-=1,e-=1;let d=(t=y.unproject(l,t)).latitude,C=d+s*m,p=d-h*e,w=d-h*e+s*m,X=Math.max(d,C,p,w),O=Math.min(d,C,p,w),Y=t.longitude,f=Y+s*u,I=Y+e*c,_=Y+e*c+s*u;return{north:X,south:O,east:Math.max(Y,f,I,_),west:Math.min(Y,f,I,_),granYCos:h,granYSin:c,granXCos:u,granXSin:m,nwCorner:t}}N.computeOptions=function(t,n,a,r,o,s,e){let i=t.east,l=t.west,h=t.north,u=t.south,g=!1,c=!1;h===m.PI_OVER_TWO&&(g=!0),u===-m.PI_OVER_TWO&&(c=!0);let S,d=h-u;S=l>i?m.TWO_PI-l+i:i-l;let C=Math.ceil(S/n)+1,p=Math.ceil(d/n)+1,w=S/(C-1),X=d/(p-1),O=I.northwest(t,s),Y=I.center(t,F);(0!==a||0!==r)&&(Y.longitude<O.longitude&&(Y.longitude+=m.TWO_PI),y._ellipsoid=L.default,j=y.project(Y,j));let f=X,W=w,_=I.clone(t,o),M={granYCos:f,granYSin:0,granXCos:W,granXSin:0,nwCorner:O,boundingRectangle:_,width:C,height:p,northCap:g,southCap:c};if(0!==a){let t=D(O,a,w,X,Y,C,p);if(h=t.north,u=t.south,i=t.east,l=t.west,h<-m.PI_OVER_TWO||h>m.PI_OVER_TWO||u<-m.PI_OVER_TWO||u>m.PI_OVER_TWO)throw new v("Rotated rectangle is invalid.  It crosses over either the north or south pole.");M.granYCos=t.granYCos,M.granYSin=t.granYSin,M.granXCos=t.granXCos,M.granXSin=t.granXSin,_.north=h,_.south=u,_.east=i,_.west=l}if(0!==r){a-=r;let t=I.northwest(_,e),n=D(t,a,w,X,Y,C,p);M.stGranYCos=n.granYCos,M.stGranXCos=n.granXCos,M.stGranYSin=n.granYSin,M.stGranXSin=n.granXSin,M.stNwCorner=t,M.stWest=n.west,M.stSouth=n.south}return M};var st=N;export{st as a};