/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as R}from"./chunk-Z5ZDCTRN.js";import{a as ct}from"./chunk-HCF5XBCP.js";import{a as Z,b as H}from"./chunk-EIJCAXME.js";import{a as V}from"./chunk-2DWCJX3G.js";import{a as U}from"./chunk-L3YV42ES.js";import{b as ot}from"./chunk-QTPIBP7S.js";import{a as it}from"./chunk-ZCCOD3XE.js";import{a as nt}from"./chunk-SFW65PGL.js";import{a as et}from"./chunk-BTGP76WP.js";import{b as J,c as X,d as z}from"./chunk-YQL7OPIW.js";import{f as K}from"./chunk-YJEV67VS.js";import{a as k}from"./chunk-4BTDTSQG.js";import{a as w,b as q,c as M,d as tt,e as F}from"./chunk-XFVXIGTK.js";import{a as I}from"./chunk-MPRZ6V46.js";import{e as x}from"./chunk-362ETHZ6.js";function ft(t,e){this.positions=x(t)?t:[],this.holes=x(e)?e:[]}var st=ft;function S(){this._array=[],this._offset=0,this._length=0}Object.defineProperties(S.prototype,{length:{get:function(){return this._length}}}),S.prototype.enqueue=function(t){this._array.push(t),this._length++},S.prototype.dequeue=function(){if(0===this._length)return;let t=this._array,e=this._offset,n=t[e];return t[e]=void 0,e++,e>10&&2*e>t.length&&(this._array=t.slice(e),e=0),this._offset=e,this._length--,n},S.prototype.peek=function(){if(0!==this._length)return this._array[this._offset]},S.prototype.contains=function(t){return-1!==this._array.indexOf(t)},S.prototype.clear=function(){this._array.length=this._offset=this._length=0},S.prototype.sort=function(t){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(t)};var $=S,b={computeHierarchyPackedLength:function(t,e){let n=0,i=[t];for(;i.length>0;){let t=i.pop();if(!x(t))continue;n+=2;let o=t.positions,r=t.holes;if(x(o)&&o.length>0&&(n+=o.length*e.packedLength),x(r)){let t=r.length;for(let e=0;e<t;++e)i.push(r[e])}}return n},packPolygonHierarchy:function(t,e,n,i){let o=[t];for(;o.length>0;){let t=o.pop();if(!x(t))continue;let r=t.positions,s=t.holes;if(e[n++]=x(r)?r.length:0,e[n++]=x(s)?s.length:0,x(r)){let t=r.length;for(let o=0;o<t;++o,n+=i.packedLength)i.pack(r[o],e,n)}if(x(s)){let t=s.length;for(let e=0;e<t;++e)o.push(s[e])}}return n},unpackPolygonHierarchy:function(t,e,n){let i=t[e++],o=t[e++],r=new Array(i),s=o>0?new Array(o):void 0;for(let o=0;o<i;++o,e+=n.packedLength)r[o]=n.unpack(t,e);for(let i=0;i<o;++i)s[i]=b.unpackPolygonHierarchy(t,e,n),e=s[i].startingIndex,delete s[i].startingIndex;return{positions:r,holes:s,startingIndex:e}}},O=new M;function at(t,e,n,i){return M.subtract(e,t,O),M.multiplyByScalar(O,n/i,O),M.add(t,O,O),[O.x,O.y]}var G=new w;function gt(t,e,n,i){return w.subtract(e,t,G),w.multiplyByScalar(G,n/i,G),w.add(t,G,G),[G.x,G.y,G.z]}b.subdivideLineCount=function(t,e,n){let i=w.distance(t,e)/n,o=Math.max(0,Math.ceil(I.log2(i)));return Math.pow(2,o)};var j=new q,Q=new q,dt=new q,pt=new w,Y=new U;b.subdivideRhumbLineCount=function(t,e,n,i){let o=t.cartesianToCartographic(e,j),r=t.cartesianToCartographic(n,Q),s=new U(o,r,t).surfaceDistance/i,a=Math.max(0,Math.ceil(I.log2(s)));return Math.pow(2,a)},b.subdivideTexcoordLine=function(t,e,n,i,o,r){let s=b.subdivideLineCount(n,i,o),a=M.distance(t,e),l=a/s,u=r;u.length=2*s;let h=0;for(let n=0;n<s;n++){let i=at(t,e,n*l,a);u[h++]=i[0],u[h++]=i[1]}return u},b.subdivideLine=function(t,e,n,i){let o=b.subdivideLineCount(t,e,n),r=w.distance(t,e),s=r/o;x(i)||(i=[]);let a=i;a.length=3*o;let l=0;for(let n=0;n<o;n++){let i=gt(t,e,n*s,r);a[l++]=i[0],a[l++]=i[1],a[l++]=i[2]}return a},b.subdivideTexcoordRhumbLine=function(t,e,n,i,o,r,s){let a=n.cartesianToCartographic(i,j),l=n.cartesianToCartographic(o,Q);Y.setEndPoints(a,l);let u=Y.surfaceDistance/r,h=Math.max(0,Math.ceil(I.log2(u))),c=Math.pow(2,h),f=M.distance(t,e),p=f/c,g=s;g.length=2*c;let d=0;for(let n=0;n<c;n++){let i=at(t,e,n*p,f);g[d++]=i[0],g[d++]=i[1]}return g},b.subdivideRhumbLine=function(t,e,n,i,o){let r=t.cartesianToCartographic(e,j),s=t.cartesianToCartographic(n,Q),a=new U(r,s,t);if(x(o)||(o=[]),a.surfaceDistance<=i)return o.length=3,o[0]=e.x,o[1]=e.y,o[2]=e.z,o;let l=a.surfaceDistance/i,u=Math.max(0,Math.ceil(I.log2(l))),h=Math.pow(2,u),c=a.surfaceDistance/h,f=o;f.length=3*h;let p=0;for(let e=0;e<h;e++){let n=a.interpolateUsingSurfaceDistance(e*c,dt),i=t.cartographicToCartesian(n,pt);f[p++]=i.x,f[p++]=i.y,f[p++]=i.z}return f};var mt=new w,yt=new w,xt=new w,wt=new w;b.scaleToGeodeticHeightExtruded=function(t,e,n,i,o){i=i??tt.default;let r=mt,s=yt,a=xt,l=wt;if(x(t)&&x(t.attributes)&&x(t.attributes.position)){let u=t.attributes.position.values,h=u.length/2;for(let t=0;t<h;t+=3)w.fromArray(u,t,a),i.geodeticSurfaceNormal(a,r),l=i.scaleToGeodeticSurface(a,l),s=w.multiplyByScalar(r,n,s),s=w.add(l,s,s),u[t+h]=s.x,u[t+1+h]=s.y,u[t+2+h]=s.z,o&&(l=w.clone(a,l)),s=w.multiplyByScalar(r,e,s),s=w.add(l,s,s),u[t]=s.x,u[t+1]=s.y,u[t+2]=s.z}return t},b.polygonOutlinesFromHierarchy=function(t,e,n){let i,o,r,s=[],a=new $;for(a.enqueue(t);0!==a.length;){let t=a.dequeue(),l=t.positions;if(e)for(r=l.length,i=0;i<r;i++)n.scaleToGeodeticSurface(l[i],l[i]);if(l=V(l,w.equalsEpsilon,!0),l.length<3)continue;let u=t.holes?t.holes.length:0;for(i=0;i<u;i++){let l=t.holes[i],u=l.positions;if(e)for(r=u.length,o=0;o<r;++o)n.scaleToGeodeticSurface(u[o],u[o]);if(u=V(u,w.equalsEpsilon,!0),u.length<3)continue;s.push(u);let h=0;for(x(l.holes)&&(h=l.holes.length),o=0;o<h;o++)a.enqueue(l.holes[o])}s.push(l)}return s};var bt=new q;function Lt(t,e,n){let i=n.cartesianToCartographic(t,j),o=n.cartesianToCartographic(e,Q);if(Math.sign(i.latitude)===Math.sign(o.latitude))return;Y.setEndPoints(i,o);let r=Y.findIntersectionWithLatitude(0,bt);if(!x(r))return;let s=Math.min(i.longitude,o.longitude),a=Math.max(i.longitude,o.longitude);if(Math.abs(a-s)>I.PI){let t=s;s=a,a=t}return r.longitude<s||r.longitude>a?void 0:n.cartographicToCartesian(r)}function Tt(t,e,n,i){if(i===R.RHUMB)return Lt(t,e,n);let o=ot.lineSegmentPlane(t,e,it.ORIGIN_XY_PLANE);return x(o)?n.scaleToGeodeticSurface(o,o):void 0}var Et=new q;function vt(t,e,n){let i,o,r,s,a,l=[],u=0;for(;u<t.length;){i=t[u],o=t[(u+1)%t.length],r=I.sign(i.z),s=I.sign(o.z);let h=t=>e.cartesianToCartographic(t,Et).longitude;if(0===r)l.push({position:u,type:r,visited:!1,next:s,theta:h(i)});else if(0!==s){if(a=Tt(i,o,e,n),++u,!x(a))continue;t.splice(u,0,a),l.push({position:u,type:r,visited:!1,next:s,theta:h(a)})}++u}return l}function ht(t,e,n,i,o,r,s){let a=[],l=r,u=t=>e=>e.position===t,h=[];do{let t=n[l];a.push(t);let e=i.findIndex(u(l)),o=i[e];if(!x(o)){++l;continue}let{visited:c,type:f,next:p}=o;if(o.visited=!0,0===f){if(0===p){let t=i[e-(s?1:-1)];if(t?.position!==l+1){++l;continue}t.visited=!0}if(!c&&s&&p>0||r===l&&!s&&p<0){++l;continue}}if(!(s?f>=0:f<=0)){++l;continue}c||h.push(l);let g=i[e+(s?1:-1)];x(g)?l=g.position:++l}while(l<n.length&&l>=0&&l!==r&&a.length<n.length);t.splice(e,o,a);for(let o of h)e=ht(t,++e,n,i,0,o,!s);return e}b.splitPolygonsOnEquator=function(t,e,n,i){x(i)||(i=[]),i.splice(0,0,...t),i.length=t.length;let o=0;for(;o<i.length;){let t=i[o],r=t.slice();if(t.length<3){i[o]=r,++o;continue}let s=vt(r,e,n);r.length===t.length||s.length<=1?(i[o]=r,++o):(s.sort(((t,e)=>t.theta-e.theta)),o=ht(i,o,r,s,1,0,r[0].z>=0))}return i},b.polygonsFromHierarchy=function(t,e,n,i,o,r){let s=[],a=[],l=new $;l.enqueue(t);let u=x(r);for(;0!==l.length;){let t,h,c=l.dequeue(),f=c.positions,p=c.holes;if(i)for(h=f.length,t=0;t<h;t++)o.scaleToGeodeticSurface(f[t],f[t]);if(e||(f=V(f,w.equalsEpsilon,!0)),f.length<3)continue;let g=n(f);if(!x(g))continue;let d=[],m=H.computeWindingOrder2D(g);if(m===Z.CLOCKWISE&&(g.reverse(),f=f.slice().reverse()),u){u=!1;let t=[f];if(t=r(t,t),t.length>1){for(let e of t)l.enqueue(new st(e,p));continue}}let y,b=f.slice(),I=x(p)?p.length:0,v=[];for(t=0;t<I;t++){let r=p[t],s=r.positions;if(i)for(h=s.length,y=0;y<h;++y)o.scaleToGeodeticSurface(s[y],s[y]);if(e||(s=V(s,w.equalsEpsilon,!0)),s.length<3)continue;let a=n(s);if(!x(a))continue;m=H.computeWindingOrder2D(a),m===Z.CLOCKWISE&&(a.reverse(),s=s.slice().reverse()),v.push(s),d.push(b.length),b=b.concat(s),g=g.concat(a);let u=0;for(x(r.holes)&&(u=r.holes.length),y=0;y<u;y++)l.enqueue(r.holes[y])}s.push({outerRing:f,holes:v}),a.push({positions:b,positions2D:g,holes:d})}return{hierarchy:s,polygons:a}};var Ct=new M,Pt=new w,Dt=new K,It=new F;b.computeBoundingRectangle=function(t,e,n,i,o){let r=K.fromAxisAngle(t,i,Dt),s=F.fromQuaternion(r,It),a=Number.POSITIVE_INFINITY,l=Number.NEGATIVE_INFINITY,u=Number.POSITIVE_INFINITY,h=Number.NEGATIVE_INFINITY,c=n.length;for(let t=0;t<c;++t){let i=w.clone(n[t],Pt);F.multiplyByVector(s,i,i);let o=e(i,Ct);x(o)&&(a=Math.min(a,o.x),l=Math.max(l,o.x),u=Math.min(u,o.y),h=Math.max(h,o.y))}return o.x=a,o.y=u,o.width=l-a,o.height=h-u,o},b.createGeometryFromPositions=function(t,e,n,i,o,r,s){let a=H.triangulate(e.positions2D,e.holes);a.length<3&&(a=[0,1,2]);let l=e.positions,u=x(n),h=u?n.positions:void 0;if(o){let t=l.length,e=new Array(3*t),n=0;for(let i=0;i<t;i++){let t=l[i];e[n++]=t.x,e[n++]=t.y,e[n++]=t.z}let i={attributes:{position:new z({componentDatatype:k.DOUBLE,componentsPerAttribute:3,values:e})},indices:a,primitiveType:J.TRIANGLES};u&&(i.attributes.st=new z({componentDatatype:k.FLOAT,componentsPerAttribute:2,values:M.packArray(h)}));let o=new X(i);return r.normal?ct.computeNormal(o):o}return s===R.GEODESIC?H.computeSubdivision(t,l,a,h,i):s===R.RHUMB?H.computeRhumbLineSubdivision(t,l,a,h,i):void 0};var rt=[],ut=[],_t=new w,At=new w;b.computeWallGeometry=function(t,e,n,i,o,r){let s,a,l,u,h,c,f,p,g,d=t.length,m=0,y=0,v=x(e),T=v?e.positions:void 0;if(o)for(a=3*d*2,s=new Array(2*a),v&&(g=2*d*2,p=new Array(2*g)),l=0;l<d;l++)u=t[l],h=t[(l+1)%d],s[m]=s[m+a]=u.x,++m,s[m]=s[m+a]=u.y,++m,s[m]=s[m+a]=u.z,++m,s[m]=s[m+a]=h.x,++m,s[m]=s[m+a]=h.y,++m,s[m]=s[m+a]=h.z,++m,v&&(c=T[l],f=T[(l+1)%d],p[y]=p[y+g]=c.x,++y,p[y]=p[y+g]=c.y,++y,p[y]=p[y+g]=f.x,++y,p[y]=p[y+g]=f.y,++y);else{let e=I.chordLength(i,n.maximumRadius),o=0;if(r===R.GEODESIC)for(l=0;l<d;l++)o+=b.subdivideLineCount(t[l],t[(l+1)%d],e);else if(r===R.RHUMB)for(l=0;l<d;l++)o+=b.subdivideRhumbLineCount(n,t[l],t[(l+1)%d],e);for(a=3*(o+d),s=new Array(2*a),v&&(g=2*(o+d),p=new Array(2*g)),l=0;l<d;l++){let i,o;u=t[l],h=t[(l+1)%d],v&&(c=T[l],f=T[(l+1)%d]),r===R.GEODESIC?(i=b.subdivideLine(u,h,e,ut),v&&(o=b.subdivideTexcoordLine(c,f,u,h,e,rt))):r===R.RHUMB&&(i=b.subdivideRhumbLine(n,u,h,e,ut),v&&(o=b.subdivideTexcoordRhumbLine(c,f,n,u,h,e,rt)));let w=i.length;for(let t=0;t<w;++t,++m)s[m]=i[t],s[m+a]=i[t];if(s[m]=h.x,s[m+a]=h.x,++m,s[m]=h.y,s[m+a]=h.y,++m,s[m]=h.z,s[m+a]=h.z,++m,v){let t=o.length;for(let e=0;e<t;++e,++y)p[y]=o[e],p[y+g]=o[e];p[y]=f.x,p[y+g]=f.x,++y,p[y]=f.y,p[y+g]=f.y,++y}}}d=s.length;let S=nt.createTypedArray(d/3,d-6*t.length),E=0;for(d/=6,l=0;l<d;l++){let t=l,e=t+1,n=t+d,i=n+1;u=w.fromArray(s,3*t,_t),h=w.fromArray(s,3*e,At),!w.equalsEpsilon(u,h,I.EPSILON10,I.EPSILON10)&&(S[E++]=t,S[E++]=n,S[E++]=e,S[E++]=e,S[E++]=n,S[E++]=i)}let L={attributes:new et({position:new z({componentDatatype:k.DOUBLE,componentsPerAttribute:3,values:s})}),indices:S,primitiveType:J.TRIANGLES};return v&&(L.attributes.st=new z({componentDatatype:k.FLOAT,componentsPerAttribute:2,values:p})),new X(L)};var ie=b;export{ie as a};