/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{b as Z,h as A}from"./chunk-YJEV67VS.js";import{a as n,b as v,d as N,e as _}from"./chunk-XFVXIGTK.js";import{a as on}from"./chunk-MPRZ6V46.js";import{a as en,b as h}from"./chunk-VZMWSUG7.js";import{e as x}from"./chunk-362ETHZ6.js";function I(n){this._ellipsoid=n??N.default,this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}Object.defineProperties(I.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),I.prototype.project=function(e,t){let r=this._semimajorAxis,a=e.longitude*r,o=e.latitude*r,c=e.height;return x(t)?(t.x=a,t.y=o,t.z=c,t):new n(a,o,c)},I.prototype.unproject=function(n,e){if(!x(n))throw new en("cartesian is required");let t=this._oneOverSemimajorAxis,r=n.x*t,a=n.y*t,o=n.z;return x(e)?(e.longitude=r,e.latitude=a,e.height=o,e):new v(r,a,o)};var k=I,sn={OUTSIDE:-1,INTERSECTING:0,INSIDE:1},U=Object.freeze(sn);function mn(n,e){this.start=n??0,this.stop=e??0}var cn=mn;function a(e,t){this.center=n.clone(e??n.ZERO),this.radius=t??0}var X=new n,F=new n,Y=new n,J=new n,K=new n,Q=new n,$=new n,b=new n,L=new n,H=new n,nn=new n,tn=new n,un=4/3*on.PI;a.fromPoints=function(e,t){if(x(t)||(t=new a),!x(e)||0===e.length)return t.center=n.clone(n.ZERO,t.center),t.radius=0,t;let r,o=n.clone(e[0],$),c=n.clone(o,X),i=n.clone(o,F),u=n.clone(o,Y),l=n.clone(o,J),s=n.clone(o,K),d=n.clone(o,Q),f=e.length;for(r=1;r<f;r++){n.clone(e[r],o);let t=o.x,a=o.y,f=o.z;t<c.x&&n.clone(o,c),t>l.x&&n.clone(o,l),a<i.y&&n.clone(o,i),a>s.y&&n.clone(o,s),f<u.z&&n.clone(o,u),f>d.z&&n.clone(o,d)}let y=n.magnitudeSquared(n.subtract(l,c,b)),h=n.magnitudeSquared(n.subtract(s,i,b)),p=n.magnitudeSquared(n.subtract(d,u,b)),m=c,g=l,z=y;h>z&&(z=h,m=i,g=s),p>z&&(z=p,m=u,g=d);let w=L;w.x=.5*(m.x+g.x),w.y=.5*(m.y+g.y),w.z=.5*(m.z+g.z);let O=n.magnitudeSquared(n.subtract(g,w,b)),j=Math.sqrt(O),S=H;S.x=c.x,S.y=i.y,S.z=u.z;let q=nn;q.x=l.x,q.y=s.y,q.z=d.z;let E=n.midpoint(S,q,tn),v=0;for(r=0;r<f;r++){n.clone(e[r],o);let t=n.magnitude(n.subtract(o,E,b));t>v&&(v=t);let a=n.magnitudeSquared(n.subtract(o,w,b));if(a>O){let n=Math.sqrt(a);j=.5*(j+n),O=j*j;let e=n-j;w.x=(j*w.x+e*o.x)/n,w.y=(j*w.y+e*o.y)/n,w.z=(j*w.z+e*o.z)/n}}return j<v?(n.clone(w,t.center),t.radius=j):(n.clone(E,t.center),t.radius=v),t};var rn=new k,xn=new n,yn=new n,G=new v,V=new v;a.fromRectangle2D=function(n,e,t){return a.fromRectangleWithHeights2D(n,e,0,0,t)},a.fromRectangleWithHeights2D=function(e,t,r,o,c){if(x(c)||(c=new a),!x(e))return c.center=n.clone(n.ZERO,c.center),c.radius=0,c;rn._ellipsoid=N.default,t=t??rn,A.southwest(e,G),G.height=r,A.northeast(e,V),V.height=o;let i=t.project(G,xn),u=t.project(V,yn),l=u.x-i.x,s=u.y-i.y,d=u.z-i.z;c.radius=.5*Math.sqrt(l*l+s*s+d*d);let f=c.center;return f.x=i.x+.5*l,f.y=i.y+.5*s,f.z=i.z+.5*d,c};var ln=[];a.fromRectangle3D=function(e,t,r,o){if(t=t??N.default,r=r??0,x(o)||(o=new a),!x(e))return o.center=n.clone(n.ZERO,o.center),o.radius=0,o;let c=A.subsample(e,t,r,ln);return a.fromPoints(c,o)},a.fromVertices=function(e,t,r,o){if(x(o)||(o=new a),!x(e)||0===e.length)return o.center=n.clone(n.ZERO,o.center),o.radius=0,o;t=t??n.ZERO,r=r??3,h.typeOf.number.greaterThanOrEquals("stride",r,3);let c=$;c.x=e[0]+t.x,c.y=e[1]+t.y,c.z=e[2]+t.z;let i,u=n.clone(c,X),l=n.clone(c,F),s=n.clone(c,Y),d=n.clone(c,J),f=n.clone(c,K),y=n.clone(c,Q),p=e.length;for(i=0;i<p;i+=r){let r=e[i]+t.x,a=e[i+1]+t.y,o=e[i+2]+t.z;c.x=r,c.y=a,c.z=o,r<u.x&&n.clone(c,u),r>d.x&&n.clone(c,d),a<l.y&&n.clone(c,l),a>f.y&&n.clone(c,f),o<s.z&&n.clone(c,s),o>y.z&&n.clone(c,y)}let m=n.magnitudeSquared(n.subtract(d,u,b)),g=n.magnitudeSquared(n.subtract(f,l,b)),z=n.magnitudeSquared(n.subtract(y,s,b)),w=u,O=d,j=m;g>j&&(j=g,w=l,O=f),z>j&&(j=z,w=s,O=y);let S=L;S.x=.5*(w.x+O.x),S.y=.5*(w.y+O.y),S.z=.5*(w.z+O.z);let q=n.magnitudeSquared(n.subtract(O,S,b)),E=Math.sqrt(q),v=H;v.x=u.x,v.y=l.y,v.z=s.z;let R=nn;R.x=d.x,R.y=f.y,R.z=y.z;let T=n.midpoint(v,R,tn),Z=0;for(i=0;i<p;i+=r){c.x=e[i]+t.x,c.y=e[i+1]+t.y,c.z=e[i+2]+t.z;let r=n.magnitude(n.subtract(c,T,b));r>Z&&(Z=r);let a=n.magnitudeSquared(n.subtract(c,S,b));if(a>q){let n=Math.sqrt(a);E=.5*(E+n),q=E*E;let e=n-E;S.x=(E*S.x+e*c.x)/n,S.y=(E*S.y+e*c.y)/n,S.z=(E*S.z+e*c.z)/n}}return E<Z?(n.clone(S,o.center),o.radius=E):(n.clone(T,o.center),o.radius=Z),o},a.fromEncodedCartesianVertices=function(e,t,r){if(x(r)||(r=new a),!x(e)||!x(t)||e.length!==t.length||0===e.length)return r.center=n.clone(n.ZERO,r.center),r.radius=0,r;let o=$;o.x=e[0]+t[0],o.y=e[1]+t[1],o.z=e[2]+t[2];let c,i=n.clone(o,X),u=n.clone(o,F),l=n.clone(o,Y),s=n.clone(o,J),d=n.clone(o,K),f=n.clone(o,Q),y=e.length;for(c=0;c<y;c+=3){let r=e[c]+t[c],a=e[c+1]+t[c+1],y=e[c+2]+t[c+2];o.x=r,o.y=a,o.z=y,r<i.x&&n.clone(o,i),r>s.x&&n.clone(o,s),a<u.y&&n.clone(o,u),a>d.y&&n.clone(o,d),y<l.z&&n.clone(o,l),y>f.z&&n.clone(o,f)}let h=n.magnitudeSquared(n.subtract(s,i,b)),p=n.magnitudeSquared(n.subtract(d,u,b)),m=n.magnitudeSquared(n.subtract(f,l,b)),g=i,z=s,w=h;p>w&&(w=p,g=u,z=d),m>w&&(w=m,g=l,z=f);let O=L;O.x=.5*(g.x+z.x),O.y=.5*(g.y+z.y),O.z=.5*(g.z+z.z);let j=n.magnitudeSquared(n.subtract(z,O,b)),S=Math.sqrt(j),q=H;q.x=i.x,q.y=u.y,q.z=l.z;let E=nn;E.x=s.x,E.y=d.y,E.z=f.z;let v=n.midpoint(q,E,tn),R=0;for(c=0;c<y;c+=3){o.x=e[c]+t[c],o.y=e[c+1]+t[c+1],o.z=e[c+2]+t[c+2];let r=n.magnitude(n.subtract(o,v,b));r>R&&(R=r);let a=n.magnitudeSquared(n.subtract(o,O,b));if(a>j){let n=Math.sqrt(a);S=.5*(S+n),j=S*S;let e=n-S;O.x=(S*O.x+e*o.x)/n,O.y=(S*O.y+e*o.y)/n,O.z=(S*O.z+e*o.z)/n}}return S<R?(n.clone(O,r.center),r.radius=S):(n.clone(v,r.center),r.radius=R),r},a.fromCornerPoints=function(e,t,r){h.typeOf.object("corner",e),h.typeOf.object("oppositeCorner",t),x(r)||(r=new a);let o=n.midpoint(e,t,r.center);return r.radius=n.distance(o,t),r},a.fromEllipsoid=function(e,t){return h.typeOf.object("ellipsoid",e),x(t)||(t=new a),n.clone(n.ZERO,t.center),t.radius=e.maximumRadius,t};var pn=new n;a.fromBoundingSpheres=function(e,t){if(x(t)||(t=new a),!x(e)||0===e.length)return t.center=n.clone(n.ZERO,t.center),t.radius=0,t;let r=e.length;if(1===r)return a.clone(e[0],t);if(2===r)return a.union(e[0],e[1],t);let o,c=[];for(o=0;o<r;o++)c.push(e[o].center);let i=(t=a.fromPoints(c,t)).center,u=t.radius;for(o=0;o<r;o++){let t=e[o];u=Math.max(u,n.distance(i,t.center,pn)+t.radius)}return t.radius=u,t};var hn=new n,zn=new n,Sn=new n;a.fromOrientedBoundingBox=function(e,t){h.defined("orientedBoundingBox",e),x(t)||(t=new a);let r=e.halfAxes,o=_.getColumn(r,0,hn),c=_.getColumn(r,1,zn),i=_.getColumn(r,2,Sn);return n.add(o,c,o),n.add(o,i,o),t.center=n.clone(e.center,t.center),t.radius=n.magnitude(o),t};var wn=new n,Pn=new n;a.fromTransformation=function(e,t){h.typeOf.object("transformation",e),x(t)||(t=new a);let r=Z.getTranslation(e,wn),o=Z.getScale(e,Pn),c=.5*n.magnitude(o);return t.center=n.clone(r,t.center),t.radius=c,t},a.clone=function(e,t){if(x(e))return x(t)?(t.center=n.clone(e.center,t.center),t.radius=e.radius,t):new a(e.center,e.radius)},a.packedLength=4,a.pack=function(n,e,t){h.typeOf.object("value",n),h.defined("array",e),t=t??0;let r=n.center;return e[t++]=r.x,e[t++]=r.y,e[t++]=r.z,e[t]=n.radius,e},a.unpack=function(n,e,t){h.defined("array",n),e=e??0,x(t)||(t=new a);let r=t.center;return r.x=n[e++],r.y=n[e++],r.z=n[e++],t.radius=n[e],t};var gn=new n,On=new n;a.union=function(e,t,r){h.typeOf.object("left",e),h.typeOf.object("right",t),x(r)||(r=new a);let o=e.center,c=e.radius,i=t.center,u=t.radius,l=n.subtract(i,o,gn),s=n.magnitude(l);if(c>=s+u)return e.clone(r),r;if(u>=s+c)return t.clone(r),r;let d=.5*(c+s+u),f=n.multiplyByScalar(l,(-c+d)/s,On);return n.add(f,o,f),n.clone(f,r.center),r.radius=d,r};var jn=new n;a.expand=function(e,t,r){h.typeOf.object("sphere",e),h.typeOf.object("point",t),r=a.clone(e,r);let o=n.magnitude(n.subtract(t,r.center,jn));return o>r.radius&&(r.radius=o),r},a.intersectPlane=function(e,t){h.typeOf.object("sphere",e),h.typeOf.object("plane",t);let r=e.center,a=e.radius,o=t.normal,c=n.dot(o,r)+t.distance;return c<-a?U.OUTSIDE:c<a?U.INTERSECTING:U.INSIDE},a.transform=function(n,e,t){return h.typeOf.object("sphere",n),h.typeOf.object("transform",e),x(t)||(t=new a),t.center=Z.multiplyByPoint(e,n.center,t.center),t.radius=Z.getMaximumScale(e)*n.radius,t};var bn=new n;a.distanceSquaredTo=function(e,t){h.typeOf.object("sphere",e),h.typeOf.object("cartesian",t);let r=n.subtract(e.center,t,bn),a=n.magnitude(r)-e.radius;return a<=0?0:a*a},a.transformWithoutScale=function(n,e,t){return h.typeOf.object("sphere",n),h.typeOf.object("transform",e),x(t)||(t=new a),t.center=Z.multiplyByPoint(e,n.center,t.center),t.radius=n.radius,t};var qn=new n;a.computePlaneDistances=function(e,t,r,a){h.typeOf.object("sphere",e),h.typeOf.object("position",t),h.typeOf.object("direction",r),x(a)||(a=new cn);let o=n.subtract(e.center,t,qn),c=n.dot(r,o);return a.start=c-e.radius,a.stop=c+e.radius,a};var an=new n,Mn=new n,Tn=new n,Cn=new n,Rn=new n,En=new v,fn=new Array(8);for(let e=0;e<8;++e)fn[e]=new n;var dn=new k;a.projectTo2D=function(e,t,r){h.typeOf.object("sphere",e),dn._ellipsoid=N.default;let o,c=(t=t??dn).ellipsoid,i=e.center,u=e.radius;o=n.equals(i,n.ZERO)?n.clone(n.UNIT_X,an):c.geodeticSurfaceNormal(i,an);let l=n.cross(n.UNIT_Z,o,Mn);n.normalize(l,l);let s=n.cross(o,l,Tn);n.normalize(s,s),n.multiplyByScalar(o,u,o),n.multiplyByScalar(s,u,s),n.multiplyByScalar(l,u,l);let d=n.negate(s,Rn),f=n.negate(l,Cn),y=fn,p=y[0];n.add(o,s,p),n.add(p,l,p),p=y[1],n.add(o,s,p),n.add(p,f,p),p=y[2],n.add(o,d,p),n.add(p,f,p),p=y[3],n.add(o,d,p),n.add(p,l,p),n.negate(o,o),p=y[4],n.add(o,s,p),n.add(p,l,p),p=y[5],n.add(o,s,p),n.add(p,f,p),p=y[6],n.add(o,d,p),n.add(p,f,p),p=y[7],n.add(o,d,p),n.add(p,l,p);let x=y.length;for(let e=0;e<x;++e){let r=y[e];n.add(i,r,r);let a=c.cartesianToCartographic(r,En);t.project(a,r)}i=(r=a.fromPoints(y,r)).center;let m=i.x,b=i.y,g=i.z;return i.x=g,i.y=m,i.z=b,r},a.isOccluded=function(n,e){return h.typeOf.object("sphere",n),h.typeOf.object("occluder",e),!e.isBoundingSphereVisible(n)},a.equals=function(e,t){return e===t||x(e)&&x(t)&&n.equals(e.center,t.center)&&e.radius===t.radius},a.prototype.intersectPlane=function(n){return a.intersectPlane(this,n)},a.prototype.distanceSquaredTo=function(n){return a.distanceSquaredTo(this,n)},a.prototype.computePlaneDistances=function(n,e,t){return a.computePlaneDistances(this,n,e,t)},a.prototype.isOccluded=function(n){return a.isOccluded(this,n)},a.prototype.equals=function(n){return a.equals(this,n)},a.prototype.clone=function(n){return a.clone(this,n)},a.prototype.volume=function(){let n=this.radius;return un*n*n*n};var Ln=a;export{k as a,U as b,cn as c,Ln as d};