/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as st}from"./chunk-L3YV42ES.js";import{b as xt,c as at,d as et}from"./chunk-YQL7OPIW.js";import{a as tt}from"./chunk-4BTDTSQG.js";import{a,b as Y,c as g,d as gt}from"./chunk-XFVXIGTK.js";import{a as X}from"./chunk-MPRZ6V46.js";import{a as ft}from"./chunk-FO77LMQ7.js";import{b as A}from"./chunk-VZMWSUG7.js";import{e as F}from"./chunk-362ETHZ6.js";var ct={CLOCKWISE:ft.CW,COUNTER_CLOCKWISE:ft.CCW,validate:function(t){return t===ct.CLOCKWISE||t===ct.COUNTER_CLOCKWISE}},ht=Object.freeze(ct);function mt(t,e,n=2){let r,i,a,u=e&&e.length,l=u?e[0]*n:t.length,x=wt(t,0,l,n,!0),o=[];if(!x||x.next===x.prev)return o;if(u&&(x=It(t,e,x,n)),t.length>80*n){r=1/0,i=1/0;let e=-1/0,u=-1/0;for(let a=n;a<l;a+=n){let n=t[a],l=t[a+1];n<r&&(r=n),l<i&&(i=l),n>e&&(e=n),l>u&&(u=l)}a=Math.max(e-r,u-i),a=0!==a?32767/a:0}return rt(x,o,n,r,i,a,0),o}function wt(t,e,n,r,i){let a;if(i===Vt(t,e,n,r)>0)for(let i=e;i<n;i+=r)a=vt(i/r|0,t[i],t[i+1],a);else for(let i=n-r;i>=e;i-=r)a=vt(i/r|0,t[i],t[i+1],a);return a&&K(a,a.next)&&(ot(a),a=a.next),a}function N(t,e){if(!t)return t;e||(e=t);let n,r=t;do{if(n=!1,r.steiner||!K(r,r.next)&&0!==w(r.prev,r,r.next))r=r.next;else{if(ot(r),r=e=r.prev,r===r.next)break;n=!0}}while(n||r!==e);return e}function rt(t,e,n,r,i,a,u){if(!t)return;!u&&a&&Nt(t,r,i,a);let l=t;for(;t.prev!==t.next;){let x=t.prev,o=t.next;if(a?Rt(t,r,i,a):Pt(t))e.push(x.i,t.i,o.i),ot(t),t=o.next,l=o.next;else if((t=o)===l){u?1===u?rt(t=zt(N(t),e),e,n,r,i,a,2):2===u&&Bt(t,e,n,r,i,a):rt(N(t),e,n,r,i,a,1);break}}}function Pt(t){let e=t.prev,n=t,r=t.next;if(w(e,n,r)>=0)return!1;let i=e.x,a=n.x,u=r.x,l=e.y,x=n.y,o=r.y,p=Math.min(i,a,u),y=Math.min(l,x,o),s=Math.max(i,a,u),f=Math.max(l,x,o),h=r.next;for(;h!==e;){if(h.x>=p&&h.x<=s&&h.y>=y&&h.y<=f&&nt(i,l,a,x,u,o,h.x,h.y)&&w(h.prev,h,h.next)>=0)return!1;h=h.next}return!0}function Rt(t,e,n,r){let i=t.prev,a=t,u=t.next;if(w(i,a,u)>=0)return!1;let l=i.x,x=a.x,o=u.x,p=i.y,y=a.y,s=u.y,f=Math.min(l,x,o),h=Math.min(p,y,s),c=Math.max(l,x,o),m=Math.max(p,y,s),d=pt(f,h,e,n,r),g=pt(c,m,e,n,r),v=t.prevZ,A=t.nextZ;for(;v&&v.z>=d&&A&&A.z<=g;){if(v.x>=f&&v.x<=c&&v.y>=h&&v.y<=m&&v!==i&&v!==u&&nt(l,p,x,y,o,s,v.x,v.y)&&w(v.prev,v,v.next)>=0||(v=v.prevZ,A.x>=f&&A.x<=c&&A.y>=h&&A.y<=m&&A!==i&&A!==u&&nt(l,p,x,y,o,s,A.x,A.y)&&w(A.prev,A,A.next)>=0))return!1;A=A.nextZ}for(;v&&v.z>=d;){if(v.x>=f&&v.x<=c&&v.y>=h&&v.y<=m&&v!==i&&v!==u&&nt(l,p,x,y,o,s,v.x,v.y)&&w(v.prev,v,v.next)>=0)return!1;v=v.prevZ}for(;A&&A.z<=g;){if(A.x>=f&&A.x<=c&&A.y>=h&&A.y<=m&&A!==i&&A!==u&&nt(l,p,x,y,o,s,A.x,A.y)&&w(A.prev,A,A.next)>=0)return!1;A=A.nextZ}return!0}function zt(t,e){let n=t;do{let r=n.prev,i=n.next.next;!K(r,i)&&bt(r,n,n.next,i)&&it(r,i)&&it(i,r)&&(e.push(r.i,n.i,i.i),ot(n),ot(n.next),n=t=i),n=n.next}while(n!==t);return N(n)}function Bt(t,e,n,r,i,a){let u=t;do{let t=u.next.next;for(;t!==u.prev;){if(u.i!==t.i&&_t(u,t)){let l=Mt(u,t);return u=N(u,u.next),l=N(l,l.next),rt(u,e,n,r,i,a,0),void rt(l,e,n,r,i,a,0)}t=t.next}u=u.next}while(u!==t)}function It(t,e,n,r){let i=[];for(let n=0,a=e.length;n<a;n++){let u=wt(t,e[n]*r,n<a-1?e[n+1]*r:t.length,r,!1);u===u.next&&(u.steiner=!0),i.push(Ut(u))}i.sort(Wt);for(let t=0;t<i.length;t++)n=$t(i[t],n);return n}function Wt(t,e){let n=t.x-e.x;if(0===n&&(n=t.y-e.y,0===n)){n=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)}return n}function $t(t,e){let n=Gt(t,e);if(!n)return e;let r=Mt(n,t);return N(r,r.next),N(n,n.next)}function Gt(t,e){let n,r=e,i=t.x,a=t.y,u=-1/0;if(K(t,r))return r;do{if(K(t,r.next))return r.next;if(a<=r.y&&a>=r.next.y&&r.next.y!==r.y){let t=r.x+(a-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(t<=i&&t>u&&(u=t,n=r.x<r.next.x?r:r.next,t===i))return n}r=r.next}while(r!==e);if(!n)return null;let l=n,x=n.x,o=n.y,p=1/0;r=n;do{if(i>=r.x&&r.x>=x&&i!==r.x&&St(a<o?i:u,a,x,o,a<o?u:i,a,r.x,r.y)){let e=Math.abs(a-r.y)/(i-r.x);it(r,t)&&(e<p||e===p&&(r.x>n.x||r.x===n.x&&Ht(n,r)))&&(n=r,p=e)}r=r.next}while(r!==l);return n}function Ht(t,e){return w(t.prev,t,e.prev)<0&&w(e.next,t,t.next)<0}function Nt(t,e,n,r){let i=t;do{0===i.z&&(i.z=pt(i.x,i.y,e,n,r)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,kt(i)}function kt(t){let e,n=1;do{let r,i=t;t=null;let a=null;for(e=0;i;){e++;let u=i,l=0;for(let t=0;t<n&&(l++,u=u.nextZ,u);t++);let x=n;for(;l>0||x>0&&u;)0!==l&&(0===x||!u||i.z<=u.z)?(r=i,i=i.nextZ,l--):(r=u,u=u.nextZ,x--),a?a.nextZ=r:t=r,r.prevZ=a,a=r;i=u}a.nextZ=null,n*=2}while(e>1);return t}function pt(t,e,n,r,i){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-n)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-r)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function Ut(t){let e=t,n=t;do{(e.x<n.x||e.x===n.x&&e.y<n.y)&&(n=e),e=e.next}while(e!==t);return n}function St(t,e,n,r,i,a,u,l){return(i-u)*(e-l)>=(t-u)*(a-l)&&(t-u)*(r-l)>=(n-u)*(e-l)&&(n-u)*(a-l)>=(i-u)*(r-l)}function nt(t,e,n,r,i,a,u,l){return!(t===u&&e===l)&&St(t,e,n,r,i,a,u,l)}function _t(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!Kt(t,e)&&(it(t,e)&&it(e,t)&&jt(t,e)&&(w(t.prev,t,e.prev)||w(t,e.prev,e))||K(t,e)&&w(t.prev,t,t.next)>0&&w(e.prev,e,e.next)>0)}function w(t,e,n){return(e.y-t.y)*(n.x-e.x)-(e.x-t.x)*(n.y-e.y)}function K(t,e){return t.x===e.x&&t.y===e.y}function bt(t,e,n,r){let i=lt(w(t,e,n)),a=lt(w(t,e,r)),u=lt(w(n,r,t)),l=lt(w(n,r,e));return!!(i!==a&&u!==l||0===i&&ut(t,n,e)||0===a&&ut(t,r,e)||0===u&&ut(n,t,r)||0===l&&ut(n,e,r))}function ut(t,e,n){return e.x<=Math.max(t.x,n.x)&&e.x>=Math.min(t.x,n.x)&&e.y<=Math.max(t.y,n.y)&&e.y>=Math.min(t.y,n.y)}function lt(t){return t>0?1:t<0?-1:0}function Kt(t,e){let n=t;do{if(n.i!==t.i&&n.next.i!==t.i&&n.i!==e.i&&n.next.i!==e.i&&bt(n,n.next,t,e))return!0;n=n.next}while(n!==t);return!1}function it(t,e){return w(t.prev,t,t.next)<0?w(t,e,t.next)>=0&&w(t,t.prev,e)>=0:w(t,e,t.prev)<0||w(t,t.next,e)<0}function jt(t,e){let n=t,r=!1,i=(t.x+e.x)/2,a=(t.y+e.y)/2;do{n.y>a!=n.next.y>a&&n.next.y!==n.y&&i<(n.next.x-n.x)*(a-n.y)/(n.next.y-n.y)+n.x&&(r=!r),n=n.next}while(n!==t);return r}function Mt(t,e){let n=yt(t.i,t.x,t.y),r=yt(e.i,e.x,e.y),i=t.next,a=e.prev;return t.next=e,e.prev=t,n.next=i,i.prev=n,r.next=n,n.prev=r,a.next=r,r.prev=a,r}function vt(t,e,n,r){let i=yt(t,e,n);return r?(i.next=r.next,i.prev=r,r.next.prev=i,r.next=i):(i.prev=i,i.next=i),i}function ot(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function yt(t,e,n){return{i:t,x:e,y:n,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}function Vt(t,e,n,r){let i=0;for(let a=e,u=n-r;a<n;a+=r)i+=(t[u]-t[a])*(t[a+1]+t[u+1]),u=a;return i}var qt=new a,Jt=new a,B={computeArea2D:function(t){A.defined("positions",t),A.typeOf.number.greaterThanOrEquals("positions.length",t.length,3);let e=t.length,n=0;for(let r=e-1,i=0;i<e;r=i++){let e=t[r],a=t[i];n+=e.x*a.y-a.x*e.y}return.5*n},computeWindingOrder2D:function(t){return B.computeArea2D(t)>0?ht.COUNTER_CLOCKWISE:ht.CLOCKWISE},triangulate:function(t,e){return A.defined("positions",t),mt(g.packArray(t),e,2)}},Tt=new a,Ot=new a,Zt=new a,At=new a,Ct=new a,Et=new a,R=new a,Lt=new g,Ft=new g,Dt=new g,j=new g;B.computeSubdivision=function(t,e,n,r,i){i=i??X.RADIANS_PER_DEGREE;let u=F(r);A.typeOf.object("ellipsoid",t),A.defined("positions",e),A.defined("indices",n),A.typeOf.number.greaterThanOrEquals("indices.length",n.length,3),A.typeOf.number.equals("indices.length % 3","0",n.length%3,0),A.typeOf.number.greaterThan("granularity",i,0);let l,x=n.slice(0),o=e.length,p=new Array(3*o),y=new Array(2*o),s=0,f=0;for(l=0;l<o;l++){let t=e[l];if(p[s++]=t.x,p[s++]=t.y,p[s++]=t.z,u){let t=r[l];y[f++]=t.x,y[f++]=t.y}}let h=[],c={},m=t.maximumRadius,d=X.chordLength(i,m),v=d*d;for(;x.length>0;){let t,e,n,r=x.pop(),i=x.pop(),o=x.pop(),s=a.fromArray(p,3*o,Tt),f=a.fromArray(p,3*i,Ot),d=a.fromArray(p,3*r,Zt);u&&(t=g.fromArray(y,2*o,Lt),e=g.fromArray(y,2*i,Ft),n=g.fromArray(y,2*r,Dt));let w,A,S,b=a.multiplyByScalar(a.normalize(s,At),m,At),M=a.multiplyByScalar(a.normalize(f,Ct),m,Ct),Z=a.multiplyByScalar(a.normalize(d,Et),m,Et),E=a.magnitudeSquared(a.subtract(b,M,R)),O=a.magnitudeSquared(a.subtract(M,Z,R)),T=a.magnitudeSquared(a.subtract(Z,b,R)),z=Math.max(E,O,T);z>v?E===z?(w=`${Math.min(o,i)} ${Math.max(o,i)}`,l=c[w],F(l)||(A=a.add(s,f,R),a.multiplyByScalar(A,.5,A),p.push(A.x,A.y,A.z),l=p.length/3-1,c[w]=l,u&&(S=g.add(t,e,j),g.multiplyByScalar(S,.5,S),y.push(S.x,S.y))),x.push(o,l,r),x.push(l,i,r)):O===z?(w=`${Math.min(i,r)} ${Math.max(i,r)}`,l=c[w],F(l)||(A=a.add(f,d,R),a.multiplyByScalar(A,.5,A),p.push(A.x,A.y,A.z),l=p.length/3-1,c[w]=l,u&&(S=g.add(e,n,j),g.multiplyByScalar(S,.5,S),y.push(S.x,S.y))),x.push(i,l,o),x.push(l,r,o)):T===z&&(w=`${Math.min(r,o)} ${Math.max(r,o)}`,l=c[w],F(l)||(A=a.add(d,s,R),a.multiplyByScalar(A,.5,A),p.push(A.x,A.y,A.z),l=p.length/3-1,c[w]=l,u&&(S=g.add(n,t,j),g.multiplyByScalar(S,.5,S),y.push(S.x,S.y))),x.push(r,l,i),x.push(l,o,i)):(h.push(o),h.push(i),h.push(r))}let w={attributes:{position:new et({componentDatatype:tt.DOUBLE,componentsPerAttribute:3,values:p})},indices:h,primitiveType:xt.TRIANGLES};return u&&(w.attributes.st=new et({componentDatatype:tt.FLOAT,componentsPerAttribute:2,values:y})),new at(w)};var Qt=new Y,Xt=new Y,Yt=new Y,dt=new Y;B.computeRhumbLineSubdivision=function(t,e,n,r,i){i=i??X.RADIANS_PER_DEGREE;let u=F(r);A.typeOf.object("ellipsoid",t),A.defined("positions",e),A.defined("indices",n),A.typeOf.number.greaterThanOrEquals("indices.length",n.length,3),A.typeOf.number.equals("indices.length % 3","0",n.length%3,0),A.typeOf.number.greaterThan("granularity",i,0);let l,x=n.slice(0),o=e.length,p=new Array(3*o),y=new Array(2*o),s=0,f=0;for(l=0;l<o;l++){let t=e[l];if(p[s++]=t.x,p[s++]=t.y,p[s++]=t.z,u){let t=r[l];y[f++]=t.x,y[f++]=t.y}}let h=[],c={},m=t.maximumRadius,d=X.chordLength(i,m),v=new st(void 0,void 0,t),w=new st(void 0,void 0,t),S=new st(void 0,void 0,t);for(;x.length>0;){let e,n,r,i=x.pop(),o=x.pop(),s=x.pop(),f=a.fromArray(p,3*s,Tt),m=a.fromArray(p,3*o,Ot),A=a.fromArray(p,3*i,Zt);u&&(e=g.fromArray(y,2*s,Lt),n=g.fromArray(y,2*o,Ft),r=g.fromArray(y,2*i,Dt));let b=t.cartesianToCartographic(f,Qt),M=t.cartesianToCartographic(m,Xt),Z=t.cartesianToCartographic(A,Yt);v.setEndPoints(b,M);let E=v.surfaceDistance;w.setEndPoints(M,Z);let O=w.surfaceDistance;S.setEndPoints(Z,b);let T,z,B,C,L,D=S.surfaceDistance,N=Math.max(E,O,D);N>d?E===N?(T=`${Math.min(s,o)} ${Math.max(s,o)}`,l=c[T],F(l)||(z=v.interpolateUsingFraction(.5,dt),B=.5*(b.height+M.height),C=a.fromRadians(z.longitude,z.latitude,B,t,R),p.push(C.x,C.y,C.z),l=p.length/3-1,c[T]=l,u&&(L=g.add(e,n,j),g.multiplyByScalar(L,.5,L),y.push(L.x,L.y))),x.push(s,l,i),x.push(l,o,i)):O===N?(T=`${Math.min(o,i)} ${Math.max(o,i)}`,l=c[T],F(l)||(z=w.interpolateUsingFraction(.5,dt),B=.5*(M.height+Z.height),C=a.fromRadians(z.longitude,z.latitude,B,t,R),p.push(C.x,C.y,C.z),l=p.length/3-1,c[T]=l,u&&(L=g.add(n,r,j),g.multiplyByScalar(L,.5,L),y.push(L.x,L.y))),x.push(o,l,s),x.push(l,i,s)):D===N&&(T=`${Math.min(i,s)} ${Math.max(i,s)}`,l=c[T],F(l)||(z=S.interpolateUsingFraction(.5,dt),B=.5*(Z.height+b.height),C=a.fromRadians(z.longitude,z.latitude,B,t,R),p.push(C.x,C.y,C.z),l=p.length/3-1,c[T]=l,u&&(L=g.add(r,e,j),g.multiplyByScalar(L,.5,L),y.push(L.x,L.y))),x.push(i,l,o),x.push(l,s,o)):(h.push(s),h.push(o),h.push(i))}let b={attributes:{position:new et({componentDatatype:tt.DOUBLE,componentsPerAttribute:3,values:p})},indices:h,primitiveType:xt.TRIANGLES};return u&&(b.attributes.st=new et({componentDatatype:tt.FLOAT,componentsPerAttribute:2,values:y})),new at(b)},B.scaleToGeodeticHeight=function(t,e,n,r){n=n??gt.default;let i=qt,u=Jt;if(e=e??0,r=r??!0,F(t)){let l=t.length;for(let x=0;x<l;x+=3)a.fromArray(t,x,u),r&&(u=n.scaleToGeodeticSurface(u,u)),0!==e&&(i=n.geodeticSurfaceNormal(u,i),a.multiplyByScalar(i,e,i),a.add(u,i,u)),t[x]=u.x,t[x+1]=u.y,t[x+2]=u.z}return t};var de=B;export{ht as a,de as b};