/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as tt}from"./chunk-II365YZS.js";import{a as jt}from"./chunk-IODKIN3W.js";import{b as Lt}from"./chunk-QTPIBP7S.js";import{a as Et}from"./chunk-ZCCOD3XE.js";import{a as j}from"./chunk-SFW65PGL.js";import{a as dt,b as D,c as B,d as U}from"./chunk-YQL7OPIW.js";import{a as _t,b as Ut,d as ot}from"./chunk-DPQZPDIL.js";import{a as pt,b as H}from"./chunk-YJEV67VS.js";import{a as F}from"./chunk-4BTDTSQG.js";import{a as r,b as Mt,c as V,e as gt,f as Ot}from"./chunk-XFVXIGTK.js";import{a as N}from"./chunk-MPRZ6V46.js";import{a as I,b as ft}from"./chunk-VZMWSUG7.js";import{e as f}from"./chunk-362ETHZ6.js";var Yt=new r,Zt=new r,Xt=new r;function pe(e,t,i,n,o){let s,a,u,l,p,c,m,y;if(ft.defined("point",e),ft.defined("p0",t),ft.defined("p1",i),ft.defined("p2",n),f(o)||(o=new r),f(t.z)){if(r.equalsEpsilon(e,t,N.EPSILON14))return r.clone(r.UNIT_X,o);if(r.equalsEpsilon(e,i,N.EPSILON14))return r.clone(r.UNIT_Y,o);if(r.equalsEpsilon(e,n,N.EPSILON14))return r.clone(r.UNIT_Z,o);s=r.subtract(i,t,Yt),a=r.subtract(n,t,Zt),u=r.subtract(e,t,Xt),l=r.dot(s,s),p=r.dot(s,a),c=r.dot(s,u),m=r.dot(a,a),y=r.dot(a,u)}else{if(V.equalsEpsilon(e,t,N.EPSILON14))return r.clone(r.UNIT_X,o);if(V.equalsEpsilon(e,i,N.EPSILON14))return r.clone(r.UNIT_Y,o);if(V.equalsEpsilon(e,n,N.EPSILON14))return r.clone(r.UNIT_Z,o);s=V.subtract(i,t,Yt),a=V.subtract(n,t,Zt),u=V.subtract(e,t,Xt),l=V.dot(s,s),p=V.dot(s,a),c=V.dot(s,u),m=V.dot(a,a),y=V.dot(a,u)}o.y=m*c-p*y,o.z=l*y-p*c;let h=l*m-p*p;if(0!==h)return o.y/=h,o.z/=h,o.x=1-o.y-o.z,o}var Ht=pe,Nt={calculateACMR:function(e){let t=(e=e??Ot.EMPTY_OBJECT).indices,r=e.maximumIndex,i=e.cacheSize??24;if(!f(t))throw new I("indices is required.");let n=t.length;if(n<3||n%3!=0)throw new I("indices length must be a multiple of three.");if(r<=0)throw new I("maximumIndex must be greater than zero.");if(i<3)throw new I("cacheSize must be greater than two.");if(!f(r)){r=0;let e=0,i=t[e];for(;e<n;)i>r&&(r=i),++e,i=t[e]}let o=[];for(let e=0;e<r+1;e++)o[e]=0;let s=i+1;for(let e=0;e<n;++e)s-o[t[e]]>i&&(o[t[e]]=s,++s);return(s-i+1)/(n/3)}};Nt.tipsify=function(e){let t,r=(e=e??Ot.EMPTY_OBJECT).indices,i=e.maximumIndex,n=e.cacheSize??24;function o(e,r,i,n,o,s,a){let u,l=-1,f=-1,p=0;for(;p<i.length;){let e=i[p];n[e].numLiveTriangles&&(u=0,o-n[e].timeStamp+2*n[e].numLiveTriangles<=r&&(u=o-n[e].timeStamp),(u>f||-1===f)&&(f=u,l=e)),++p}return-1===l?function(e,r,i,n){for(;r.length>=1;){let t=r[r.length-1];if(r.splice(r.length-1,1),e[t].numLiveTriangles>0)return t}for(;t<n;){if(e[t].numLiveTriangles>0)return++t,t-1;++t}return-1}(n,s,0,a):l}if(!f(r))throw new I("indices is required.");let s=r.length;if(s<3||s%3!=0)throw new I("indices length must be a multiple of three.");if(i<=0)throw new I("maximumIndex must be greater than zero.");if(n<3)throw new I("cacheSize must be greater than two.");let a=0,u=0,l=r[u],p=s;if(f(i))a=i+1;else{for(;u<p;)l>a&&(a=l),++u,l=r[u];if(-1===a)return 0;++a}let c,m=[];for(c=0;c<a;c++)m[c]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};u=0;let y=0;for(;u<p;)m[r[u]].vertexTriangles.push(y),++m[r[u]].numLiveTriangles,m[r[u+1]].vertexTriangles.push(y),++m[r[u+1]].numLiveTriangles,m[r[u+2]].vertexTriangles.push(y),++m[r[u+2]].numLiveTriangles,++y,u+=3;let h=0,d=n+1;t=1;let v,b,w,g,T=[],A=[],N=0,x=[],S=s/3,P=[];for(c=0;c<S;c++)P[c]=!1;for(;-1!==h;){T=[],b=m[h],g=b.vertexTriangles.length;for(let e=0;e<g;++e)if(y=b.vertexTriangles[e],!P[y]){P[y]=!0,u=y+y+y;for(let e=0;e<3;++e)w=r[u],T.push(w),A.push(w),x[N]=w,++N,v=m[w],--v.numLiveTriangles,d-v.timeStamp>n&&(v.timeStamp=d,++d),++u}h=o(0,n,T,m,d,A,a)}return x};var Wt=Nt,k={};function It(e,t,r,i,n){e[t++]=r,e[t++]=i,e[t++]=i,e[t++]=n,e[t++]=n,e[t]=r}function de(e){let t=e.length,r=t/3*6,i=j.createTypedArray(t,r),n=0;for(let r=0;r<t;r+=3,n+=6)It(i,n,e[r],e[r+1],e[r+2]);return i}function me(e){let t=e.length;if(t>=3){let r=6*(t-2),i=j.createTypedArray(t,r);It(i,0,e[0],e[1],e[2]);let n=6;for(let r=3;r<t;++r,n+=6)It(i,n,e[r-1],e[r],e[r-2]);return i}return new Uint16Array}function he(e){if(e.length>0){let t=e.length-1,r=6*(t-1),i=j.createTypedArray(t,r),n=e[0],o=0;for(let r=1;r<t;++r,o+=6)It(i,o,n,e[r],e[r+1]);return i}return new Uint16Array}function $t(e){let t={};for(let r in e)if(e.hasOwnProperty(r)&&f(e[r])&&f(e[r].values)){let i=e[r];t[r]=new U({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return t}function be(e,t,r){for(let i in t)if(t.hasOwnProperty(i)&&f(t[i])&&f(t[i].values)){let n=t[i];for(let t=0;t<n.componentsPerAttribute;++t)e[i].values.push(n.values[r*n.componentsPerAttribute+t])}}k.toWireframe=function(e){if(!f(e))throw new I("geometry is required.");let t=e.indices;if(f(t)){switch(e.primitiveType){case D.TRIANGLES:e.indices=de(t);break;case D.TRIANGLE_STRIP:e.indices=me(t);break;case D.TRIANGLE_FAN:e.indices=he(t);break;default:throw new I("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=D.LINES}return e},k.createLineSegmentsForVectors=function(e,t,r){if(t=t??"normal",!f(e))throw new I("geometry is required.");if(!f(e.attributes.position))throw new I("geometry.attributes.position is required.");if(!f(e.attributes[t]))throw new I(`geometry.attributes must have an attribute with the same name as the attributeName parameter, ${t}.`);r=r??1e4;let i=e.attributes.position.values,n=e.attributes[t].values,o=i.length,s=new Float64Array(2*o),a=0;for(let e=0;e<o;e+=3)s[a++]=i[e],s[a++]=i[e+1],s[a++]=i[e+2],s[a++]=i[e]+n[e]*r,s[a++]=i[e+1]+n[e+1]*r,s[a++]=i[e+2]+n[e+2]*r;let u,l=e.boundingSphere;return f(l)&&(u=new ot(l.center,l.radius+r)),new B({attributes:{position:new U({componentDatatype:F.DOUBLE,componentsPerAttribute:3,values:s})},primitiveType:D.LINES,boundingSphere:u})},k.createAttributeLocations=function(e){if(!f(e))throw new I("geometry is required.");let t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],i=e.attributes,n={},o=0,s=r.length;for(t=0;t<s;++t){let e=r[t];f(i[e])&&(n[e]=o++)}for(let e in i)i.hasOwnProperty(e)&&!f(n[e])&&(n[e]=o++);return n},k.reorderForPreVertexCache=function(e){if(!f(e))throw new I("geometry is required.");let t=B.computeNumberOfVertices(e),r=e.indices;if(f(r)){let i=new Int32Array(t);for(let e=0;e<t;e++)i[e]=-1;let n,o=r,s=o.length,a=j.createTypedArray(t,s),u=0,l=0,p=0;for(;u<s;)n=i[o[u]],-1!==n?a[l]=n:(n=o[u],i[n]=p,a[l]=p,++p),++u,++l;e.indices=a;let c=e.attributes;for(let e in c)if(c.hasOwnProperty(e)&&f(c[e])&&f(c[e].values)){let r=c[e],n=r.values,o=0,s=r.componentsPerAttribute,a=F.createTypedArray(r.componentDatatype,p*s);for(;o<t;){let e=i[o];if(-1!==e)for(let t=0;t<s;t++)a[s*e+t]=n[s*o+t];++o}r.values=a}}return e},k.reorderForPostVertexCache=function(e,t){if(!f(e))throw new I("geometry is required.");let r=e.indices;if(e.primitiveType===D.TRIANGLES&&f(r)){let i=r.length,n=0;for(let e=0;e<i;e++)r[e]>n&&(n=r[e]);e.indices=Wt.tipsify({indices:r,maximumIndex:n,cacheSize:t})}return e},k.fitToUnsignedShortIndices=function(e){if(!f(e))throw new I("geometry is required.");if(f(e.indices)&&e.primitiveType!==D.TRIANGLES&&e.primitiveType!==D.LINES&&e.primitiveType!==D.POINTS)throw new I("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");let t=[],r=B.computeNumberOfVertices(e);if(f(e.indices)&&r>=N.SIXTY_FOUR_KILOBYTES){let r,i=[],n=[],o=0,s=$t(e.attributes),a=e.indices,u=a.length;e.primitiveType===D.TRIANGLES?r=3:e.primitiveType===D.LINES?r=2:e.primitiveType===D.POINTS&&(r=1);for(let l=0;l<u;l+=r){for(let t=0;t<r;++t){let r=a[l+t],u=i[r];f(u)||(u=o++,i[r]=u,be(s,e.attributes,r)),n.push(u)}o+r>=N.SIXTY_FOUR_KILOBYTES&&(t.push(new B({attributes:s,indices:n,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),i=[],n=[],o=0,s=$t(e.attributes))}0!==n.length&&t.push(new B({attributes:s,indices:n,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var Jt=new r,we=new Mt;k.projectTo2D=function(e,t,i,n,o){if(!f(e))throw new I("geometry is required.");if(!f(t))throw new I("attributeName is required.");if(!f(i))throw new I("attributeName3D is required.");if(!f(n))throw new I("attributeName2D is required.");if(!f(e.attributes[t]))throw new I(`geometry must have attribute matching the attributeName argument: ${t}.`);if(e.attributes[t].componentDatatype!==F.DOUBLE)throw new I("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");let s=e.attributes[t],a=(o=f(o)?o:new _t).ellipsoid,u=s.values,l=new Float64Array(u.length),p=0;for(let e=0;e<u.length;e+=3){let t=r.fromArray(u,e,Jt),i=a.cartesianToCartographic(t,we);if(!f(i))throw new I(`Could not project point (${t.x}, ${t.y}, ${t.z}) to 2D.`);let n=o.project(i,Jt);l[p++]=n.x,l[p++]=n.y,l[p++]=n.z}return e.attributes[i]=s,e.attributes[n]=new U({componentDatatype:F.DOUBLE,componentsPerAttribute:3,values:l}),delete e.attributes[t],e};var zt={high:0,low:0};k.encodeAttribute=function(e,t,r,i){if(!f(e))throw new I("geometry is required.");if(!f(t))throw new I("attributeName is required.");if(!f(r))throw new I("attributeHighName is required.");if(!f(i))throw new I("attributeLowName is required.");if(!f(e.attributes[t]))throw new I(`geometry must have attribute matching the attributeName argument: ${t}.`);if(e.attributes[t].componentDatatype!==F.DOUBLE)throw new I("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");let n=e.attributes[t],o=n.values,s=o.length,a=new Float32Array(s),u=new Float32Array(s);for(let e=0;e<s;++e)jt.encode(o[e],zt),a[e]=zt.high,u[e]=zt.low;let l=n.componentsPerAttribute;return e.attributes[r]=new U({componentDatatype:F.FLOAT,componentsPerAttribute:l,values:a}),e.attributes[i]=new U({componentDatatype:F.FLOAT,componentsPerAttribute:l,values:u}),delete e.attributes[t],e};var $=new r;function Dt(e,t){if(f(t)){let i=t.values,n=i.length;for(let t=0;t<n;t+=3)r.unpack(i,t,$),H.multiplyByPoint(e,$,$),r.pack($,i,t)}}function qt(e,t){if(f(t)){let i=t.values,n=i.length;for(let t=0;t<n;t+=3)r.unpack(i,t,$),gt.multiplyByVector(e,$,$),$=r.normalize($,$),r.pack($,i,t)}}var wt=new H,vt=new gt;function ve(e,t){let r,i=e.length,n={},o=e[0][t].attributes;for(r in o)if(o.hasOwnProperty(r)&&f(o[r])&&f(o[r].values)){let s=o[r],a=s.values.length,u=!0;for(let n=1;n<i;++n){let i=e[n][t].attributes[r];if(!f(i)||s.componentDatatype!==i.componentDatatype||s.componentsPerAttribute!==i.componentsPerAttribute||s.normalize!==i.normalize){u=!1;break}a+=i.values.length}u&&(n[r]=new U({componentDatatype:s.componentDatatype,componentsPerAttribute:s.componentsPerAttribute,normalize:s.normalize,values:F.createTypedArray(s.componentDatatype,a)}))}return n}k.transformToWorldCoordinates=function(e){if(!f(e))throw new I("instance is required.");let t=e.modelMatrix;if(H.equals(t,H.IDENTITY))return e;let r=e.geometry.attributes;Dt(t,r.position),Dt(t,r.prevPosition),Dt(t,r.nextPosition),(f(r.normal)||f(r.tangent)||f(r.bitangent))&&(H.inverse(t,wt),H.transpose(wt,wt),H.getMatrix3(wt,vt),qt(vt,r.normal),qt(vt,r.tangent),qt(vt,r.bitangent));let i=e.geometry.boundingSphere;return f(i)&&(e.geometry.boundingSphere=ot.transform(i,t,i)),e.modelMatrix=H.clone(H.IDENTITY),e};var ye=new r;function Rt(e,t){let i,n,o,s,a=e.length,u=e[0].modelMatrix,l=f(e[0][t].indices),p=e[0][t].primitiveType;for(n=1;n<a;++n){if(!H.equals(e[n].modelMatrix,u))throw new I("All instances must have the same modelMatrix.");if(f(e[n][t].indices)!==l)throw new I("All instance geometries must have an indices or not have one.");if(e[n][t].primitiveType!==p)throw new I("All instance geometries must have the same primitiveType.")}let c,m,y,h,d=ve(e,t);for(i in d)if(d.hasOwnProperty(i))for(c=d[i].values,s=0,n=0;n<a;++n)for(m=e[n][t].attributes[i].values,y=m.length,o=0;o<y;++o)c[s++]=m[o];if(l){let r=0;for(n=0;n<a;++n)r+=e[n][t].indices.length;let i=B.computeNumberOfVertices(new B({attributes:d,primitiveType:D.POINTS})),o=j.createTypedArray(i,r),u=0,l=0;for(n=0;n<a;++n){let r=e[n][t].indices,i=r.length;for(s=0;s<i;++s)o[u++]=l+r[s];l+=B.computeNumberOfVertices(e[n][t])}h=o}let v,b=new r,w=0;for(n=0;n<a;++n){if(v=e[n][t].boundingSphere,!f(v)){b=void 0;break}r.add(v.center,b,b)}if(f(b))for(r.divideByScalar(b,a,b),n=0;n<a;++n){v=e[n][t].boundingSphere;let i=r.magnitude(r.subtract(v.center,b,ye))+v.radius;i>w&&(w=i)}return new B({attributes:d,indices:h,primitiveType:p,boundingSphere:f(b)?new ot(b,w):void 0})}k.combineInstances=function(e){if(!f(e)||e.length<1)throw new I("instances is required and must have length greater than zero.");let t=[],r=[],i=e.length;for(let n=0;n<i;++n){let i=e[n];f(i.geometry)?t.push(i):f(i.westHemisphereGeometry)&&f(i.eastHemisphereGeometry)&&r.push(i)}let n=[];return t.length>0&&n.push(Rt(t,"geometry")),r.length>0&&(n.push(Rt(r,"westHemisphereGeometry")),n.push(Rt(r,"eastHemisphereGeometry"))),n};var Z=new r,mt=new r,rt=new r,ct=new r;k.computeNormal=function(e){if(!f(e))throw new I("geometry is required.");if(!f(e.attributes.position)||!f(e.attributes.position.values))throw new I("geometry.attributes.position.values is required.");if(!f(e.indices))throw new I("geometry.indices is required.");if(e.indices.length<2||e.indices.length%3!=0)throw new I("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==D.TRIANGLES)throw new I("geometry.primitiveType must be PrimitiveType.TRIANGLES.");let t,i=e.indices,n=e.attributes,o=n.position.values,s=n.position.values.length/3,a=i.length,u=new Array(s),l=new Array(a/3),p=new Array(a);for(t=0;t<s;t++)u[t]={indexOffset:0,count:0,currentCount:0};let c=0;for(t=0;t<a;t+=3){let e=i[t],n=i[t+1],s=i[t+2],a=3*e,f=3*n,p=3*s;mt.x=o[a],mt.y=o[a+1],mt.z=o[a+2],rt.x=o[f],rt.y=o[f+1],rt.z=o[f+2],ct.x=o[p],ct.y=o[p+1],ct.z=o[p+2],u[e].count++,u[n].count++,u[s].count++,r.subtract(rt,mt,rt),r.subtract(ct,mt,ct),l[c]=r.cross(rt,ct,new r),c++}let m,y=0;for(t=0;t<s;t++)u[t].indexOffset+=y,y+=u[t].count;for(c=0,t=0;t<a;t+=3){m=u[i[t]];let e=m.indexOffset+m.currentCount;p[e]=c,m.currentCount++,m=u[i[t+1]],e=m.indexOffset+m.currentCount,p[e]=c,m.currentCount++,m=u[i[t+2]],e=m.indexOffset+m.currentCount,p[e]=c,m.currentCount++,c++}let h=new Float32Array(3*s);for(t=0;t<s;t++){let e=3*t;if(m=u[t],r.clone(r.ZERO,Z),m.count>0){for(c=0;c<m.count;c++)r.add(Z,l[p[m.indexOffset+c]],Z);r.equalsEpsilon(r.ZERO,Z,N.EPSILON10)&&r.clone(l[p[m.indexOffset]],Z)}r.equalsEpsilon(r.ZERO,Z,N.EPSILON10)&&(Z.z=1),r.normalize(Z,Z),h[e]=Z.x,h[e+1]=Z.y,h[e+2]=Z.z}return e.attributes.normal=new U({componentDatatype:F.FLOAT,componentsPerAttribute:3,values:h}),e};var xe=new r,Kt=new r,Te=new r;k.computeTangentAndBitangent=function(e){if(!f(e))throw new I("geometry is required.");let t=e.attributes,i=e.indices;if(!f(t.position)||!f(t.position.values))throw new I("geometry.attributes.position.values is required.");if(!f(t.normal)||!f(t.normal.values))throw new I("geometry.attributes.normal.values is required.");if(!f(t.st)||!f(t.st.values))throw new I("geometry.attributes.st.values is required.");if(!f(i))throw new I("geometry.indices is required.");if(i.length<2||i.length%3!=0)throw new I("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==D.TRIANGLES)throw new I("geometry.primitiveType must be PrimitiveType.TRIANGLES.");let n,o,s,a,u=e.attributes.position.values,l=e.attributes.normal.values,p=e.attributes.st.values,c=e.attributes.position.values.length/3,m=i.length,y=new Array(3*c);for(n=0;n<y.length;n++)y[n]=0;for(n=0;n<m;n+=3){let e=i[n],t=i[n+1],r=i[n+2];o=3*e,s=3*t,a=3*r;let l=2*e,f=2*t,c=2*r,m=u[o],h=u[o+1],d=u[o+2],v=p[l],b=p[l+1],w=p[f+1]-b,g=p[c+1]-b,I=1/((p[f]-v)*g-(p[c]-v)*w),T=(g*(u[s]-m)-w*(u[a]-m))*I,A=(g*(u[s+1]-h)-w*(u[a+1]-h))*I,N=(g*(u[s+2]-d)-w*(u[a+2]-d))*I;y[o]+=T,y[o+1]+=A,y[o+2]+=N,y[s]+=T,y[s+1]+=A,y[s+2]+=N,y[a]+=T,y[a+1]+=A,y[a+2]+=N}let h=new Float32Array(3*c),d=new Float32Array(3*c);for(n=0;n<c;n++){o=3*n,s=o+1,a=o+2;let e=r.fromArray(l,o,xe),t=r.fromArray(y,o,Te),i=r.dot(e,t);r.multiplyByScalar(e,i,Kt),r.normalize(r.subtract(t,Kt,t),t),h[o]=t.x,h[s]=t.y,h[a]=t.z,r.normalize(r.cross(e,t,t),t),d[o]=t.x,d[s]=t.y,d[a]=t.z}return e.attributes.tangent=new U({componentDatatype:F.FLOAT,componentsPerAttribute:3,values:h}),e.attributes.bitangent=new U({componentDatatype:F.FLOAT,componentsPerAttribute:3,values:d}),e};var ht=new V,W=new r,Qt=new r,te=new r,yt=new V;function Ae(e){if(f(e.indices))return e;let t=B.computeNumberOfVertices(e);if(t<3)throw new I("The number of vertices must be at least three.");if(t%3!=0)throw new I("The number of vertices must be a multiple of three.");let r=j.createTypedArray(t,t);for(let e=0;e<t;++e)r[e]=e;return e.indices=r,e}function Ie(e){let t=B.computeNumberOfVertices(e);if(t<3)throw new I("The number of vertices must be at least three.");let r=j.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;let i=3;for(let e=3;e<t;++e)r[i++]=e-1,r[i++]=0,r[i++]=e;return e.indices=r,e.primitiveType=D.TRIANGLES,e}function Se(e){let t=B.computeNumberOfVertices(e);if(t<3)throw new I("The number of vertices must be at least 3.");let r=j.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);let i=6;for(let e=3;e<t-1;e+=2)r[i++]=e,r[i++]=e-1,r[i++]=e+1,e+2<t&&(r[i++]=e,r[i++]=e+1,r[i++]=e+2);return e.indices=r,e.primitiveType=D.TRIANGLES,e}function Pe(e){if(f(e.indices))return e;let t=B.computeNumberOfVertices(e);if(t<2)throw new I("The number of vertices must be at least two.");if(t%2!=0)throw new I("The number of vertices must be a multiple of 2.");let r=j.createTypedArray(t,t);for(let e=0;e<t;++e)r[e]=e;return e.indices=r,e}function ge(e){let t=B.computeNumberOfVertices(e);if(t<2)throw new I("The number of vertices must be at least two.");let r=j.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;let i=2;for(let e=2;e<t;++e)r[i++]=e-1,r[i++]=e;return e.indices=r,e.primitiveType=D.LINES,e}function Oe(e){let t=B.computeNumberOfVertices(e);if(t<2)throw new I("The number of vertices must be at least two.");let r=j.createTypedArray(t,2*t);r[0]=0,r[1]=1;let i=2;for(let e=2;e<t;++e)r[i++]=e-1,r[i++]=e;return r[i++]=t-1,r[i]=0,e.indices=r,e.primitiveType=D.LINES,e}function Le(e){switch(e.primitiveType){case D.TRIANGLE_FAN:return Ie(e);case D.TRIANGLE_STRIP:return Se(e);case D.TRIANGLES:return Ae(e);case D.LINE_STRIP:return ge(e);case D.LINE_LOOP:return Oe(e);case D.LINES:return Pe(e)}return e}function Q(e,t){Math.abs(e.y)<N.EPSILON6&&(e.y=t?-N.EPSILON6:N.EPSILON6)}function Ee(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return Q(e,e.y<0),Q(t,t.y<0),void Q(r,r.y<0);let i,n=Math.abs(e.y),o=Math.abs(t.y),s=Math.abs(r.y);i=n>o?n>s?N.sign(e.y):N.sign(r.y):o>s?N.sign(t.y):N.sign(r.y);let a=i<0;Q(e,a),Q(t,a),Q(r,a)}k.compressVertices=function(e){if(!f(e))throw new I("geometry is required.");let t,i,n=e.attributes.extrudeDirection;if(f(n)){let o=n.values;i=o.length/3;let s=new Float32Array(2*i),a=0;for(t=0;t<i;++t)r.fromArray(o,3*t,W),r.equals(W,r.ZERO)?a+=2:(yt=tt.octEncodeInRange(W,65535,yt),s[a++]=yt.x,s[a++]=yt.y);return e.attributes.compressedAttributes=new U({componentDatatype:F.FLOAT,componentsPerAttribute:2,values:s}),delete e.attributes.extrudeDirection,e}let o=e.attributes.normal,s=e.attributes.st,a=f(o),u=f(s);if(!a&&!u)return e;let l,p,c,m,y=e.attributes.tangent,h=e.attributes.bitangent,d=f(y),v=f(h);a&&(l=o.values),u&&(p=s.values),d&&(c=y.values),v&&(m=h.values),i=(a?l.length:p.length)/(a?3:2);let b=i,w=u&&a?2:1;w+=d||v?1:0,b*=w;let g=new Float32Array(b),T=0;for(t=0;t<i;++t){u&&(V.fromArray(p,2*t,ht),g[T++]=tt.compressTextureCoordinates(ht));let e=3*t;a&&f(c)&&f(m)?(r.fromArray(l,e,W),r.fromArray(c,e,Qt),r.fromArray(m,e,te),tt.octPack(W,Qt,te,ht),g[T++]=ht.x,g[T++]=ht.y):(a&&(r.fromArray(l,e,W),g[T++]=tt.octEncodeFloat(W)),d&&(r.fromArray(c,e,W),g[T++]=tt.octEncodeFloat(W)),v&&(r.fromArray(m,e,W),g[T++]=tt.octEncodeFloat(W)))}return e.attributes.compressedAttributes=new U({componentDatatype:F.FLOAT,componentsPerAttribute:w,values:g}),a&&delete e.attributes.normal,u&&delete e.attributes.st,v&&delete e.attributes.bitangent,d&&delete e.attributes.tangent,e};var ee=new r;function X(e,t,i,n){r.add(e,r.multiplyByScalar(r.subtract(t,e,ee),e.y/(e.y-t.y),ee),i),r.clone(i,n),Q(i,!0),Q(n,!1)}var et=new r,nt=new r,it=new r,st=new r,Vt={positions:new Array(7),indices:new Array(9)};function Ne(e,t,r){if(e.x>=0||t.x>=0||r.x>=0)return;Ee(e,t,r);let i=e.y<0,n=t.y<0,o=r.y<0,s=0;s+=i?1:0,s+=n?1:0,s+=o?1:0;let a=Vt.indices;1===s?(a[1]=3,a[2]=4,a[5]=6,a[7]=6,a[8]=5,i?(X(e,t,et,it),X(e,r,nt,st),a[0]=0,a[3]=1,a[4]=2,a[6]=1):n?(X(t,r,et,it),X(t,e,nt,st),a[0]=1,a[3]=2,a[4]=0,a[6]=2):o&&(X(r,e,et,it),X(r,t,nt,st),a[0]=2,a[3]=0,a[4]=1,a[6]=0)):2===s&&(a[2]=4,a[4]=4,a[5]=3,a[7]=5,a[8]=6,i?n?o||(X(r,e,et,it),X(r,t,nt,st),a[0]=0,a[1]=1,a[3]=0,a[6]=2):(X(t,r,et,it),X(t,e,nt,st),a[0]=2,a[1]=0,a[3]=2,a[6]=1):(X(e,t,et,it),X(e,r,nt,st),a[0]=1,a[1]=2,a[3]=1,a[6]=0));let u=Vt.positions;return u[0]=e,u[1]=t,u[2]=r,u.length=3,(1===s||2===s)&&(u[3]=et,u[4]=nt,u[5]=it,u[6]=st,u.length=7),Vt}function ne(e,t){let r=e.attributes;if(0===r.position.values.length)return;for(let e in r)if(r.hasOwnProperty(e)&&f(r[e])&&f(r[e].values)){let t=r[e];t.values=F.createTypedArray(t.componentDatatype,t.values)}let i=B.computeNumberOfVertices(e);return e.indices=j.createTypedArray(i,e.indices),t&&(e.boundingSphere=ot.fromVertices(r.position.values)),e}function ut(e){let t=e.attributes,r={};for(let e in t)if(t.hasOwnProperty(e)&&f(t[e])&&f(t[e].values)){let i=t[e];r[e]=new U({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return new B({attributes:r,indices:[],primitiveType:e.primitiveType})}function Ft(e,t,r){let i=f(e.geometry.boundingSphere);t=ne(t,i),r=ne(r,i),f(r)&&!f(t)?e.geometry=r:!f(r)&&f(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function kt(e,t){let r=new e,i=new e,n=new e;return function(o,s,a,u,l,f,p,c){let m=e.fromArray(l,o*t,r),y=e.fromArray(l,s*t,i),h=e.fromArray(l,a*t,n);e.multiplyByScalar(m,u.x,m),e.multiplyByScalar(y,u.y,y),e.multiplyByScalar(h,u.z,h);let d=e.add(m,y,m);e.add(d,h,d),c&&e.normalize(d,d),e.pack(d,f,p*t)}}var ze=kt(pt,4),At=kt(r,3),ae=kt(V,2),De=function(e,t,r,i,n,o,s){let a=n[e]*i.x,u=n[t]*i.y,l=n[r]*i.z;o[s]=a+u+l>N.EPSILON6?1:0},bt=new r,Gt=new r,Ct=new r,qe=new r;function xt(e,t,i,n,o,s,a,u,l,p,c,m,y,h,d,v){if(!(f(s)||f(a)||f(u)||f(l)||f(p)||0!==h))return;let b=r.fromArray(o,3*e,bt),w=r.fromArray(o,3*t,Gt),g=r.fromArray(o,3*i,Ct),I=Ht(n,b,w,g,qe);if(f(I)){if(f(s)&&At(e,t,i,I,s,m.normal.values,v,!0),f(p)){let n,o=r.fromArray(p,3*e,bt),s=r.fromArray(p,3*t,Gt),a=r.fromArray(p,3*i,Ct);r.multiplyByScalar(o,I.x,o),r.multiplyByScalar(s,I.y,s),r.multiplyByScalar(a,I.z,a),r.equals(o,r.ZERO)&&r.equals(s,r.ZERO)&&r.equals(a,r.ZERO)?(n=bt,n.x=0,n.y=0,n.z=0):(n=r.add(o,s,o),r.add(n,a,n),r.normalize(n,n)),r.pack(n,m.extrudeDirection.values,3*v)}if(f(c)&&De(e,t,i,I,c,m.applyOffset.values,v),f(a)&&At(e,t,i,I,a,m.tangent.values,v,!0),f(u)&&At(e,t,i,I,u,m.bitangent.values,v,!0),f(l)&&ae(e,t,i,I,l,m.st.values,v),h>0)for(let r=0;r<h;r++){let n=y[r];Re(e,t,i,I,v,d[n],m[n])}}}function Re(e,t,r,i,n,o,s){let a=o.componentsPerAttribute,u=o.values,l=s.values;switch(a){case 4:ze(e,t,r,i,u,l,n,!1);break;case 3:At(e,t,r,i,u,l,n,!1);break;case 2:ae(e,t,r,i,u,l,n,!1);break;default:l[n]=u[e]*i.x+u[t]*i.y+u[r]*i.z}}function K(e,t,r,i,n,o){let s=e.position.values.length/3;if(-1!==n){let a=i[n],u=r[a];return-1===u?(r[a]=s,e.position.values.push(o.x,o.y,o.z),t.push(s),s):(t.push(u),u)}return e.position.values.push(o.x,o.y,o.z),t.push(s),s}var Ve={position:!0,normal:!0,bitangent:!0,tangent:!0,st:!0,extrudeDirection:!0,applyOffset:!0};function ie(e){let t=e.geometry,i=t.attributes,n=i.position.values,o=f(i.normal)?i.normal.values:void 0,s=f(i.bitangent)?i.bitangent.values:void 0,a=f(i.tangent)?i.tangent.values:void 0,u=f(i.st)?i.st.values:void 0,l=f(i.extrudeDirection)?i.extrudeDirection.values:void 0,p=f(i.applyOffset)?i.applyOffset.values:void 0,c=t.indices,m=[];for(let e in i)i.hasOwnProperty(e)&&!Ve[e]&&f(i[e])&&m.push(e);let y,h,d,v,b,w=m.length,g=ut(t),I=ut(t),T=[];T.length=n.length/3;let A=[];for(A.length=n.length/3,b=0;b<T.length;++b)T[b]=-1,A[b]=-1;let N=c.length;for(b=0;b<N;b+=3){let e=c[b],t=c[b+1],N=c[b+2],x=r.fromArray(n,3*e),S=r.fromArray(n,3*t),P=r.fromArray(n,3*N),E=Ne(x,S,P);if(f(E)&&E.positions.length>3){let r=E.positions,f=E.indices,x=f.length;for(let S=0;S<x;++S){let x=f[S],P=r[x];P.y<0?(y=I.attributes,h=I.indices,d=T):(y=g.attributes,h=g.indices,d=A),v=K(y,h,d,c,x<3?b+x:-1,P),xt(e,t,N,P,n,o,a,s,u,l,p,y,m,w,i,v)}}else f(E)&&(x=E.positions[0],S=E.positions[1],P=E.positions[2]),x.y<0?(y=I.attributes,h=I.indices,d=T):(y=g.attributes,h=g.indices,d=A),v=K(y,h,d,c,b,x),xt(e,t,N,x,n,o,a,s,u,l,p,y,m,w,i,v),v=K(y,h,d,c,b+1,S),xt(e,t,N,S,n,o,a,s,u,l,p,y,m,w,i,v),v=K(y,h,d,c,b+2,P),xt(e,t,N,P,n,o,a,s,u,l,p,y,m,w,i,v)}Ft(e,I,g)}var ue=Et.fromPointNormal(r.ZERO,r.UNIT_Y),Ge=new r,Ce=new r;function at(e,t,i,n,o,s,a){if(!f(a))return;let u=r.fromArray(n,3*e,bt);r.equalsEpsilon(u,i,N.EPSILON10)?s.applyOffset.values[o]=a[e]:s.applyOffset.values[o]=a[t]}function se(e){let t,i=e.geometry,n=i.attributes,o=n.position.values,s=f(n.applyOffset)?n.applyOffset.values:void 0,a=i.indices,u=ut(i),l=ut(i),p=a.length,c=[];c.length=o.length/3;let m=[];for(m.length=o.length/3,t=0;t<c.length;++t)c[t]=-1,m[t]=-1;for(t=0;t<p;t+=2){let e,i=a[t],n=a[t+1],p=r.fromArray(o,3*i,bt),y=r.fromArray(o,3*n,Gt);Math.abs(p.y)<N.EPSILON6&&(p.y<0?p.y=-N.EPSILON6:p.y=N.EPSILON6),Math.abs(y.y)<N.EPSILON6&&(y.y<0?y.y=-N.EPSILON6:y.y=N.EPSILON6);let h=u.attributes,d=u.indices,v=m,b=l.attributes,w=l.indices,g=c,I=Lt.lineSegmentPlane(p,y,ue,Ct);if(f(I)){let f=r.multiplyByScalar(r.UNIT_Y,5*N.EPSILON9,Ge);p.y<0&&(r.negate(f,f),h=l.attributes,d=l.indices,v=c,b=u.attributes,w=u.indices,g=m);let T=r.add(I,f,Ce);e=K(h,d,v,a,t,p),at(i,n,p,o,e,h,s),e=K(h,d,v,a,-1,T),at(i,n,T,o,e,h,s),r.negate(f,f),r.add(I,f,T),e=K(b,w,g,a,-1,T),at(i,n,T,o,e,b,s),e=K(b,w,g,a,t+1,y),at(i,n,y,o,e,b,s)}else{let r,f,h;p.y<0?(r=l.attributes,f=l.indices,h=c):(r=u.attributes,f=u.indices,h=m),e=K(r,f,h,a,t,p),at(i,n,p,o,e,r,s),e=K(r,f,h,a,t+1,y),at(i,n,y,o,e,r,s)}}Ft(e,l,u)}var oe=new V,Be=new V,le=new r,fe=new r,Bt=new r,Fe=new r,ke=new r,Me=new r,re=new pt;function ce(e){let t=e.attributes,i=t.position.values,n=t.prevPosition.values,o=t.nextPosition.values,s=i.length;for(let e=0;e<s;e+=3){let t=r.unpack(i,e,le);if(t.x>0)continue;let a=r.unpack(n,e,fe);(t.y<0&&a.y>0||t.y>0&&a.y<0)&&(e-3>0?(n[e]=i[e-3],n[e+1]=i[e-2],n[e+2]=i[e-1]):r.pack(t,n,e));let u=r.unpack(o,e,Bt);(t.y<0&&u.y>0||t.y>0&&u.y<0)&&(e+3<s?(o[e]=i[e+3],o[e+1]=i[e+4],o[e+2]=i[e+5]):r.pack(t,o,e))}}var _e=5*N.EPSILON9,Tt=N.EPSILON6;function Ue(e){let t,i,n,o=e.geometry,s=o.attributes,a=s.position.values,u=s.prevPosition.values,l=s.nextPosition.values,p=s.expandAndWidth.values,c=f(s.st)?s.st.values:void 0,m=f(s.color)?s.color.values:void 0,y=ut(o),h=ut(o),d=!1,v=a.length/3;for(t=0;t<v;t+=4){let e=t,o=t+2,s=r.fromArray(a,3*e,le),v=r.fromArray(a,3*o,fe);if(Math.abs(s.y)<Tt)for(s.y=Tt*(v.y<0?-1:1),a[3*t+1]=s.y,a[3*(t+1)+1]=s.y,i=3*e;i<3*e+12;i+=3)u[i]=a[3*t],u[i+1]=a[3*t+1],u[i+2]=a[3*t+2];if(Math.abs(v.y)<Tt)for(v.y=Tt*(s.y<0?-1:1),a[3*(t+2)+1]=v.y,a[3*(t+3)+1]=v.y,i=3*e;i<3*e+12;i+=3)l[i]=a[3*(t+2)],l[i+1]=a[3*(t+2)+1],l[i+2]=a[3*(t+2)+2];let b=y.attributes,w=y.indices,g=h.attributes,I=h.indices,T=Lt.lineSegmentPlane(s,v,ue,Fe);if(f(T)){d=!0;let a=r.multiplyByScalar(r.UNIT_Y,_e,ke);s.y<0&&(r.negate(a,a),b=h.attributes,w=h.indices,g=y.attributes,I=y.indices);let A=r.add(T,a,Me);b.position.values.push(s.x,s.y,s.z,s.x,s.y,s.z),b.position.values.push(A.x,A.y,A.z),b.position.values.push(A.x,A.y,A.z),b.prevPosition.values.push(u[3*e],u[3*e+1],u[3*e+2]),b.prevPosition.values.push(u[3*e+3],u[3*e+4],u[3*e+5]),b.prevPosition.values.push(s.x,s.y,s.z,s.x,s.y,s.z),b.nextPosition.values.push(A.x,A.y,A.z),b.nextPosition.values.push(A.x,A.y,A.z),b.nextPosition.values.push(A.x,A.y,A.z),b.nextPosition.values.push(A.x,A.y,A.z),r.negate(a,a),r.add(T,a,A),g.position.values.push(A.x,A.y,A.z),g.position.values.push(A.x,A.y,A.z),g.position.values.push(v.x,v.y,v.z,v.x,v.y,v.z),g.prevPosition.values.push(A.x,A.y,A.z),g.prevPosition.values.push(A.x,A.y,A.z),g.prevPosition.values.push(A.x,A.y,A.z),g.prevPosition.values.push(A.x,A.y,A.z),g.nextPosition.values.push(v.x,v.y,v.z,v.x,v.y,v.z),g.nextPosition.values.push(l[3*o],l[3*o+1],l[3*o+2]),g.nextPosition.values.push(l[3*o+3],l[3*o+4],l[3*o+5]);let x=V.fromArray(p,2*e,oe),S=Math.abs(x.y);b.expandAndWidth.values.push(-1,S,1,S),b.expandAndWidth.values.push(-1,-S,1,-S),g.expandAndWidth.values.push(-1,S,1,S),g.expandAndWidth.values.push(-1,-S,1,-S);let P=r.magnitudeSquared(r.subtract(T,s,Bt));if(P/=r.magnitudeSquared(r.subtract(v,s,Bt)),f(m)){let t=pt.fromArray(m,4*e,re),r=pt.fromArray(m,4*o,re),n=N.lerp(t.x,r.x,P),s=N.lerp(t.y,r.y,P),a=N.lerp(t.z,r.z,P),u=N.lerp(t.w,r.w,P);for(i=4*e;i<4*e+8;++i)b.color.values.push(m[i]);for(b.color.values.push(n,s,a,u),b.color.values.push(n,s,a,u),g.color.values.push(n,s,a,u),g.color.values.push(n,s,a,u),i=4*o;i<4*o+8;++i)g.color.values.push(m[i])}if(f(c)){let r=V.fromArray(c,2*e,oe),n=V.fromArray(c,2*(t+3),Be),s=N.lerp(r.x,n.x,P);for(i=2*e;i<2*e+4;++i)b.st.values.push(c[i]);for(b.st.values.push(s,r.y),b.st.values.push(s,n.y),g.st.values.push(s,r.y),g.st.values.push(s,n.y),i=2*o;i<2*o+4;++i)g.st.values.push(c[i])}n=b.position.values.length/3-4,w.push(n,n+2,n+1),w.push(n+1,n+2,n+3),n=g.position.values.length/3-4,I.push(n,n+2,n+1),I.push(n+1,n+2,n+3)}else{let e,r;for(s.y<0?(e=h.attributes,r=h.indices):(e=y.attributes,r=y.indices),e.position.values.push(s.x,s.y,s.z),e.position.values.push(s.x,s.y,s.z),e.position.values.push(v.x,v.y,v.z),e.position.values.push(v.x,v.y,v.z),i=3*t;i<3*t+12;++i)e.prevPosition.values.push(u[i]),e.nextPosition.values.push(l[i]);for(i=2*t;i<2*t+8;++i)e.expandAndWidth.values.push(p[i]),f(c)&&e.st.values.push(c[i]);if(f(m))for(i=4*t;i<4*t+16;++i)e.color.values.push(m[i]);n=e.position.values.length/3-4,r.push(n,n+2,n+1),r.push(n+1,n+2,n+3)}}d&&(ce(h),ce(y)),Ft(e,h,y)}k.splitLongitude=function(e){if(!f(e))throw new I("instance is required.");let t=e.geometry,r=t.boundingSphere;if(f(r)&&(r.center.x-r.radius>0||ot.intersectPlane(r,Et.ORIGIN_ZX_PLANE)!==Ut.INTERSECTING))return e;if(t.geometryType!==dt.NONE)switch(t.geometryType){case dt.POLYLINES:Ue(e);break;case dt.TRIANGLES:ie(e);break;case dt.LINES:se(e)}else Le(t),t.primitiveType===D.TRIANGLES?ie(e):t.primitiveType===D.LINES&&se(e);return e};var Pn=k;export{Pn as a};