/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as N}from"./chunk-QL3VAYCR.js";import{a as Q}from"./chunk-ZCCOD3XE.js";import{a as ae}from"./chunk-BTGP76WP.js";import{b as oe,c as re,d as J}from"./chunk-YQL7OPIW.js";import{b as E,d as ie}from"./chunk-DPQZPDIL.js";import{a as C,b as F,f as D}from"./chunk-YJEV67VS.js";import{a as H}from"./chunk-4BTDTSQG.js";import{a as r,e as G,f as A}from"./chunk-XFVXIGTK.js";import{a as O}from"./chunk-MPRZ6V46.js";import{a as w,b}from"./chunk-VZMWSUG7.js";import{e as a}from"./chunk-362ETHZ6.js";function R(t){this.planes=t??[]}var X=[new r,new r,new r];r.clone(r.UNIT_X,X[0]),r.clone(r.UNIT_Y,X[1]),r.clone(r.UNIT_Z,X[2]);var j=new r,de=new r,fe=new Q(new r(1,0,0),0);R.fromBoundingSphere=function(t,e){if(!a(t))throw new w("boundingSphere is required.");a(e)||(e=new R);let i=X.length,n=e.planes;n.length=2*i;let o=t.center,s=t.radius,f=0;for(let t=0;t<i;++t){let e=X[t],i=n[f],u=n[f+1];a(i)||(i=n[f]=new C),a(u)||(u=n[f+1]=new C),r.multiplyByScalar(e,-s,j),r.add(o,j,j),i.x=e.x,i.y=e.y,i.z=e.z,i.w=-r.dot(e,j),r.multiplyByScalar(e,s,j),r.add(o,j,j),u.x=-e.x,u.y=-e.y,u.z=-e.z,u.w=-r.dot(r.negate(e,de),j),f+=2}return e},R.prototype.computeVisibility=function(t){if(!a(t))throw new w("boundingVolume is required.");let e=this.planes,r=!1;for(let i=0,a=e.length;i<a;++i){let a=t.intersectPlane(Q.fromCartesian4(e[i],fe));if(a===E.OUTSIDE)return E.OUTSIDE;a===E.INTERSECTING&&(r=!0)}return r?E.INTERSECTING:E.INSIDE},R.prototype.computeVisibilityWithPlaneMask=function(t,e){if(!a(t))throw new w("boundingVolume is required.");if(!a(e))throw new w("parentPlaneMask is required.");if(e===R.MASK_OUTSIDE||e===R.MASK_INSIDE)return e;let r=R.MASK_INSIDE,i=this.planes;for(let a=0,n=i.length;a<n;++a){let n=a<31?1<<a:0;if(a<31&&0===(e&n))continue;let o=t.intersectPlane(Q.fromCartesian4(i[a],fe));if(o===E.OUTSIDE)return R.MASK_OUTSIDE;o===E.INTERSECTING&&(r|=n)}return r},R.MASK_OUTSIDE=4294967295,R.MASK_INSIDE=0,R.MASK_INDETERMINATE=2147483647;var $=R;function M(t){t=t??A.EMPTY_OBJECT,this.left=t.left,this._left=void 0,this.right=t.right,this._right=void 0,this.top=t.top,this._top=void 0,this.bottom=t.bottom,this._bottom=void 0,this.near=t.near??1,this._near=this.near,this.far=t.far??5e8,this._far=this.far,this._cullingVolume=new $,this._orthographicMatrix=new F}function ce(t){if(!(a(t.right)&&a(t.left)&&a(t.top)&&a(t.bottom)&&a(t.near)&&a(t.far)))throw new w("right, left, top, bottom, near, or far parameters are not set.");if(t.top!==t._top||t.bottom!==t._bottom||t.left!==t._left||t.right!==t._right||t.near!==t._near||t.far!==t._far){if(t.left>t.right)throw new w("right must be greater than left.");if(t.bottom>t.top)throw new w("top must be greater than bottom.");if(t.near<=0||t.near>t.far)throw new w("near must be greater than zero and less than far.");t._left=t.left,t._right=t.right,t._top=t.top,t._bottom=t.bottom,t._near=t.near,t._far=t.far,t._orthographicMatrix=F.computeOrthographicOffCenter(t.left,t.right,t.bottom,t.top,t.near,t.far,t._orthographicMatrix)}}Object.defineProperties(M.prototype,{projectionMatrix:{get:function(){return ce(this),this._orthographicMatrix}}});var me=new r,ye=new r,ge=new r,ee=new r;M.prototype.computeCullingVolume=function(t,e,i){if(!a(t))throw new w("position is required.");if(!a(e))throw new w("direction is required.");if(!a(i))throw new w("up is required.");let n=this._cullingVolume.planes,o=this.top,s=this.bottom,f=this.right,u=this.left,h=this.near,p=this.far,l=r.cross(e,i,me);r.normalize(l,l);let c=ye;r.multiplyByScalar(e,h,c),r.add(t,c,c);let m=ge;r.multiplyByScalar(l,u,m),r.add(c,m,m);let d=n[0];return a(d)||(d=n[0]=new C),d.x=l.x,d.y=l.y,d.z=l.z,d.w=-r.dot(l,m),r.multiplyByScalar(l,f,m),r.add(c,m,m),d=n[1],a(d)||(d=n[1]=new C),d.x=-l.x,d.y=-l.y,d.z=-l.z,d.w=-r.dot(r.negate(l,ee),m),r.multiplyByScalar(i,s,m),r.add(c,m,m),d=n[2],a(d)||(d=n[2]=new C),d.x=i.x,d.y=i.y,d.z=i.z,d.w=-r.dot(i,m),r.multiplyByScalar(i,o,m),r.add(c,m,m),d=n[3],a(d)||(d=n[3]=new C),d.x=-i.x,d.y=-i.y,d.z=-i.z,d.w=-r.dot(r.negate(i,ee),m),d=n[4],a(d)||(d=n[4]=new C),d.x=e.x,d.y=e.y,d.z=e.z,d.w=-r.dot(e,c),r.multiplyByScalar(e,p,m),r.add(t,m,m),d=n[5],a(d)||(d=n[5]=new C),d.x=-e.x,d.y=-e.y,d.z=-e.z,d.w=-r.dot(r.negate(e,ee),m),this._cullingVolume},M.prototype.getPixelDimensions=function(t,e,r,i,n){if(ce(this),!a(t)||!a(e))throw new w("Both drawingBufferWidth and drawingBufferHeight are required.");if(t<=0)throw new w("drawingBufferWidth must be greater than zero.");if(e<=0)throw new w("drawingBufferHeight must be greater than zero.");if(!a(r))throw new w("distance is required.");if(!a(i))throw new w("pixelRatio is required.");if(i<=0)throw new w("pixelRatio must be greater than zero.");if(!a(n))throw new w("A result object is required.");let o=i*(this.right-this.left)/t,s=i*(this.top-this.bottom)/e;return n.x=o,n.y=s,n},M.prototype.clone=function(t){return a(t)||(t=new M),t.left=this.left,t.right=this.right,t.top=this.top,t.bottom=this.bottom,t.near=this.near,t.far=this.far,t._left=void 0,t._right=void 0,t._top=void 0,t._bottom=void 0,t._near=void 0,t._far=void 0,t},M.prototype.equals=function(t){return a(t)&&t instanceof M&&this.right===t.right&&this.left===t.left&&this.top===t.top&&this.bottom===t.bottom&&this.near===t.near&&this.far===t.far},M.prototype.equalsEpsilon=function(t,e,r){return t===this||a(t)&&t instanceof M&&O.equalsEpsilon(this.right,t.right,e,r)&&O.equalsEpsilon(this.left,t.left,e,r)&&O.equalsEpsilon(this.top,t.top,e,r)&&O.equalsEpsilon(this.bottom,t.bottom,e,r)&&O.equalsEpsilon(this.near,t.near,e,r)&&O.equalsEpsilon(this.far,t.far,e,r)};var he=M;function x(t){t=t??A.EMPTY_OBJECT,this._offCenterFrustum=new he,this.width=t.width,this._width=void 0,this.aspectRatio=t.aspectRatio,this._aspectRatio=void 0,this.near=t.near??1,this._near=this.near,this.far=t.far??5e8,this._far=this.far}function B(t){if(!(a(t.width)&&a(t.aspectRatio)&&a(t.near)&&a(t.far)))throw new w("width, aspectRatio, near, or far parameters are not set.");let e=t._offCenterFrustum;if(t.width!==t._width||t.aspectRatio!==t._aspectRatio||t.near!==t._near||t.far!==t._far){if(t.aspectRatio<0)throw new w("aspectRatio must be positive.");if(t.near<0||t.near>t.far)throw new w("near must be greater than zero and less than far.");t._aspectRatio=t.aspectRatio,t._width=t.width,t._near=t.near,t._far=t.far;let r=1/t.aspectRatio;e.right=.5*t.width,e.left=-e.right,e.top=r*e.right,e.bottom=-e.top,e.near=t.near,e.far=t.far}}x.packedLength=4,x.pack=function(t,e,r){return b.typeOf.object("value",t),b.defined("array",e),r=r??0,e[r++]=t.width,e[r++]=t.aspectRatio,e[r++]=t.near,e[r]=t.far,e},x.unpack=function(t,e,r){return b.defined("array",t),e=e??0,a(r)||(r=new x),r.width=t[e++],r.aspectRatio=t[e++],r.near=t[e++],r.far=t[e],r},Object.defineProperties(x.prototype,{projectionMatrix:{get:function(){return B(this),this._offCenterFrustum.projectionMatrix}},offCenterFrustum:{get:function(){return B(this),this._offCenterFrustum}}}),x.prototype.computeCullingVolume=function(t,e,r){return B(this),this._offCenterFrustum.computeCullingVolume(t,e,r)},x.prototype.getPixelDimensions=function(t,e,r,i,a){return B(this),this._offCenterFrustum.getPixelDimensions(t,e,r,i,a)},x.prototype.clone=function(t){return a(t)||(t=new x),t.aspectRatio=this.aspectRatio,t.width=this.width,t.near=this.near,t.far=this.far,t._aspectRatio=void 0,t._width=void 0,t._near=void 0,t._far=void 0,this._offCenterFrustum.clone(t._offCenterFrustum),t},x.prototype.equals=function(t){return!!(a(t)&&t instanceof x)&&(B(this),B(t),this.width===t.width&&this.aspectRatio===t.aspectRatio&&this._offCenterFrustum.equals(t._offCenterFrustum))},x.prototype.equalsEpsilon=function(t,e,r){return!!(a(t)&&t instanceof x)&&(B(this),B(t),O.equalsEpsilon(this.width,t.width,e,r)&&O.equalsEpsilon(this.aspectRatio,t.aspectRatio,e,r)&&this._offCenterFrustum.equalsEpsilon(t._offCenterFrustum,e,r))};var V=x;function k(t){t=t??A.EMPTY_OBJECT,this.left=t.left,this._left=void 0,this.right=t.right,this._right=void 0,this.top=t.top,this._top=void 0,this.bottom=t.bottom,this._bottom=void 0,this.near=t.near??1,this._near=this.near,this.far=t.far??5e8,this._far=this.far,this._cullingVolume=new $,this._perspectiveMatrix=new F,this._infinitePerspective=new F}function te(t){if(!(a(t.right)&&a(t.left)&&a(t.top)&&a(t.bottom)&&a(t.near)&&a(t.far)))throw new w("right, left, top, bottom, near, or far parameters are not set.");let{top:e,bottom:r,right:i,left:n,near:o,far:s}=t;if(e!==t._top||r!==t._bottom||n!==t._left||i!==t._right||o!==t._near||s!==t._far){if(t.near<=0||t.near>t.far)throw new w("near must be greater than zero and less than far.");t._left=n,t._right=i,t._top=e,t._bottom=r,t._near=o,t._far=s,t._perspectiveMatrix=F.computePerspectiveOffCenter(n,i,r,e,o,s,t._perspectiveMatrix),t._infinitePerspective=F.computeInfinitePerspectiveOffCenter(n,i,r,e,o,t._infinitePerspective)}}Object.defineProperties(k.prototype,{projectionMatrix:{get:function(){return te(this),this._perspectiveMatrix}},infiniteProjectionMatrix:{get:function(){return te(this),this._infinitePerspective}}});var Ce=new r,be=new r,Oe=new r,Fe=new r;k.prototype.computeCullingVolume=function(t,e,i){if(!a(t))throw new w("position is required.");if(!a(e))throw new w("direction is required.");if(!a(i))throw new w("up is required.");let n=this._cullingVolume.planes,o=this.top,s=this.bottom,f=this.right,u=this.left,h=this.near,p=this.far,l=r.cross(e,i,Ce),c=be;r.multiplyByScalar(e,h,c),r.add(t,c,c);let m=Oe;r.multiplyByScalar(e,p,m),r.add(t,m,m);let d=Fe;r.multiplyByScalar(l,u,d),r.add(c,d,d),r.subtract(d,t,d),r.normalize(d,d),r.cross(d,i,d),r.normalize(d,d);let _=n[0];return a(_)||(_=n[0]=new C),_.x=d.x,_.y=d.y,_.z=d.z,_.w=-r.dot(d,t),r.multiplyByScalar(l,f,d),r.add(c,d,d),r.subtract(d,t,d),r.cross(i,d,d),r.normalize(d,d),_=n[1],a(_)||(_=n[1]=new C),_.x=d.x,_.y=d.y,_.z=d.z,_.w=-r.dot(d,t),r.multiplyByScalar(i,s,d),r.add(c,d,d),r.subtract(d,t,d),r.cross(l,d,d),r.normalize(d,d),_=n[2],a(_)||(_=n[2]=new C),_.x=d.x,_.y=d.y,_.z=d.z,_.w=-r.dot(d,t),r.multiplyByScalar(i,o,d),r.add(c,d,d),r.subtract(d,t,d),r.cross(d,l,d),r.normalize(d,d),_=n[3],a(_)||(_=n[3]=new C),_.x=d.x,_.y=d.y,_.z=d.z,_.w=-r.dot(d,t),_=n[4],a(_)||(_=n[4]=new C),_.x=e.x,_.y=e.y,_.z=e.z,_.w=-r.dot(e,c),r.negate(e,d),_=n[5],a(_)||(_=n[5]=new C),_.x=d.x,_.y=d.y,_.z=d.z,_.w=-r.dot(d,m),this._cullingVolume},k.prototype.getPixelDimensions=function(t,e,r,i,n){if(te(this),!a(t)||!a(e))throw new w("Both drawingBufferWidth and drawingBufferHeight are required.");if(t<=0)throw new w("drawingBufferWidth must be greater than zero.");if(e<=0)throw new w("drawingBufferHeight must be greater than zero.");if(!a(r))throw new w("distance is required.");if(!a(i))throw new w("pixelRatio is required");if(i<=0)throw new w("pixelRatio must be greater than zero.");if(!a(n))throw new w("A result object is required.");let o=1/this.near,s=this.top*o,f=2*i*r*s/e;s=this.right*o;let u=2*i*r*s/t;return n.x=u,n.y=f,n},k.prototype.clone=function(t){return a(t)||(t=new k),t.right=this.right,t.left=this.left,t.top=this.top,t.bottom=this.bottom,t.near=this.near,t.far=this.far,t._left=void 0,t._right=void 0,t._top=void 0,t._bottom=void 0,t._near=void 0,t._far=void 0,t},k.prototype.equals=function(t){return a(t)&&t instanceof k&&this.right===t.right&&this.left===t.left&&this.top===t.top&&this.bottom===t.bottom&&this.near===t.near&&this.far===t.far},k.prototype.equalsEpsilon=function(t,e,r){return t===this||a(t)&&t instanceof k&&O.equalsEpsilon(this.right,t.right,e,r)&&O.equalsEpsilon(this.left,t.left,e,r)&&O.equalsEpsilon(this.top,t.top,e,r)&&O.equalsEpsilon(this.bottom,t.bottom,e,r)&&O.equalsEpsilon(this.near,t.near,e,r)&&O.equalsEpsilon(this.far,t.far,e,r)};var se=k;function v(t){t=t??A.EMPTY_OBJECT,this._offCenterFrustum=new se,this.fov=t.fov,this._fov=void 0,this._fovy=void 0,this._sseDenominator=void 0,this.aspectRatio=t.aspectRatio,this._aspectRatio=void 0,this.near=t.near??1,this._near=this.near,this.far=t.far??5e8,this._far=this.far,this.xOffset=t.xOffset??0,this._xOffset=this.xOffset,this.yOffset=t.yOffset??0,this._yOffset=this.yOffset}function T(t){if(!(a(t.fov)&&a(t.aspectRatio)&&a(t.near)&&a(t.far)))throw new w("fov, aspectRatio, near, or far parameters are not set.");if(t.fov===t._fov&&t.aspectRatio===t._aspectRatio&&t.near===t._near&&t.far===t._far&&t.xOffset===t._xOffset&&t.yOffset===t._yOffset)return;if(b.typeOf.number.greaterThanOrEquals("fov",t.fov,0),b.typeOf.number.lessThan("fov",t.fov,Math.PI),b.typeOf.number.greaterThanOrEquals("aspectRatio",t.aspectRatio,0),b.typeOf.number.greaterThanOrEquals("near",t.near,0),t.near>t.far)throw new w("near must be less than far.");t._aspectRatio=t.aspectRatio,t._fov=t.fov,t._fovy=t.aspectRatio<=1?t.fov:2*Math.atan(Math.tan(.5*t.fov)/t.aspectRatio),t._near=t.near,t._far=t.far,t._sseDenominator=2*Math.tan(.5*t._fovy),t._xOffset=t.xOffset,t._yOffset=t.yOffset;let e=t._offCenterFrustum;e.top=t.near*Math.tan(.5*t._fovy),e.bottom=-e.top,e.right=t.aspectRatio*e.top,e.left=-e.right,e.near=t.near,e.far=t.far,e.right+=t.xOffset,e.left+=t.xOffset,e.top+=t.yOffset,e.bottom+=t.yOffset}v.packedLength=6,v.pack=function(t,e,r){return b.typeOf.object("value",t),b.defined("array",e),r=r??0,e[r++]=t.fov,e[r++]=t.aspectRatio,e[r++]=t.near,e[r++]=t.far,e[r++]=t.xOffset,e[r]=t.yOffset,e},v.unpack=function(t,e,r){return b.defined("array",t),e=e??0,a(r)||(r=new v),r.fov=t[e++],r.aspectRatio=t[e++],r.near=t[e++],r.far=t[e++],r.xOffset=t[e++],r.yOffset=t[e],r},Object.defineProperties(v.prototype,{projectionMatrix:{get:function(){return T(this),this._offCenterFrustum.projectionMatrix}},infiniteProjectionMatrix:{get:function(){return T(this),this._offCenterFrustum.infiniteProjectionMatrix}},fovy:{get:function(){return T(this),this._fovy}},sseDenominator:{get:function(){return T(this),this._sseDenominator}},offCenterFrustum:{get:function(){return T(this),this._offCenterFrustum}}}),v.prototype.computeCullingVolume=function(t,e,r){return T(this),this._offCenterFrustum.computeCullingVolume(t,e,r)},v.prototype.getPixelDimensions=function(t,e,r,i,a){return T(this),this._offCenterFrustum.getPixelDimensions(t,e,r,i,a)},v.prototype.clone=function(t){return a(t)||(t=new v),t.aspectRatio=this.aspectRatio,t.fov=this.fov,t.near=this.near,t.far=this.far,t._aspectRatio=void 0,t._fov=void 0,t._near=void 0,t._far=void 0,this._offCenterFrustum.clone(t._offCenterFrustum),t},v.prototype.equals=function(t){return!!(a(t)&&t instanceof v)&&(T(this),T(t),this.fov===t.fov&&this.aspectRatio===t.aspectRatio&&this._offCenterFrustum.equals(t._offCenterFrustum))},v.prototype.equalsEpsilon=function(t,e,r){return!!(a(t)&&t instanceof v)&&(T(this),T(t),O.equalsEpsilon(this.fov,t.fov,e,r)&&O.equalsEpsilon(this.aspectRatio,t.aspectRatio,e,r)&&this._offCenterFrustum.equalsEpsilon(t._offCenterFrustum,e,r))};var L=v,I=0,Pe=1;function u(t){b.typeOf.object("options",t),b.typeOf.object("options.frustum",t.frustum),b.typeOf.object("options.origin",t.origin),b.typeOf.object("options.orientation",t.orientation);let e,i,a=t.frustum,n=t.orientation,o=t.origin,s=t.vertexFormat??N.DEFAULT,f=t._drawNearPlane??!0;a instanceof L?(e=I,i=L.packedLength):a instanceof V&&(e=Pe,i=V.packedLength),this._frustumType=e,this._frustum=a.clone(),this._origin=r.clone(o),this._orientation=D.clone(n),this._drawNearPlane=f,this._vertexFormat=s,this._workerName="createFrustumGeometry",this.packedLength=2+i+r.packedLength+D.packedLength+N.packedLength}u.pack=function(t,e,i){b.typeOf.object("value",t),b.defined("array",e),i=i??0;let a=t._frustumType,n=t._frustum;return e[i++]=a,a===I?(L.pack(n,e,i),i+=L.packedLength):(V.pack(n,e,i),i+=V.packedLength),r.pack(t._origin,e,i),i+=r.packedLength,D.pack(t._orientation,e,i),i+=D.packedLength,N.pack(t._vertexFormat,e,i),e[i+=N.packedLength]=t._drawNearPlane?1:0,e};var ze=new L,xe=new V,ve=new D,Re=new r,Te=new N;function W(t,e,r,i,n,o,s,f){let u=t/3*2;for(let n=0;n<4;++n)a(e)&&(e[t]=o.x,e[t+1]=o.y,e[t+2]=o.z),a(r)&&(r[t]=s.x,r[t+1]=s.y,r[t+2]=s.z),a(i)&&(i[t]=f.x,i[t+1]=f.y,i[t+2]=f.z),t+=3;n[u]=0,n[u+1]=0,n[u+2]=1,n[u+3]=0,n[u+4]=1,n[u+5]=1,n[u+6]=0,n[u+7]=1}u.unpack=function(t,e,i){b.defined("array",t),e=e??0;let n,o=t[e++];o===I?(n=L.unpack(t,e,ze),e+=L.packedLength):(n=V.unpack(t,e,xe),e+=V.packedLength);let s=r.unpack(t,e,Re);e+=r.packedLength;let f=D.unpack(t,e,ve);e+=D.packedLength;let h=N.unpack(t,e,Te),p=1===t[e+=N.packedLength];if(!a(i))return new u({frustum:n,origin:s,orientation:f,vertexFormat:h,_drawNearPlane:p});let l=o===i._frustumType?i._frustum:void 0;return i._frustum=n.clone(l),i._frustumType=o,i._origin=r.clone(s,i._origin),i._orientation=D.clone(f,i._orientation),i._vertexFormat=N.clone(h,i._vertexFormat),i._drawNearPlane=p,i};var qe=new G,Me=new F,ne=new F,pe=new r,le=new r,we=new r,ke=new r,Se=new r,De=new r,U=new Array(3),Z=new Array(4);Z[0]=new C(-1,-1,1,1),Z[1]=new C(1,-1,1,1),Z[2]=new C(1,1,1,1),Z[3]=new C(-1,1,1,1);var _e=new Array(4);for(let t=0;t<4;++t)_e[t]=new C;u._computeNearFarPlanes=function(t,e,i,n,o,s,f,u){let h=G.fromQuaternion(e,qe),p=s??pe,l=f??le,c=u??we;p=G.getColumn(h,0,p),l=G.getColumn(h,1,l),c=G.getColumn(h,2,c),r.normalize(p,p),r.normalize(l,l),r.normalize(c,c),r.negate(p,p);let w,m,d=F.computeView(t,c,l,p,Me),_=n.projectionMatrix;if(i===I){let t=F.multiply(_,d,ne);m=F.inverse(t,ne)}else w=F.inverseTransformation(d,ne);a(m)?(U[0]=n.near,U[1]=n.far):(U[0]=0,U[1]=n.near,U[2]=n.far);for(let e=0;e<2;++e)for(let i=0;i<4;++i){let s=C.clone(Z[i],_e[i]);if(a(m)){s=F.multiplyByVector(m,s,s);let i=1/s.w;r.multiplyByScalar(s,i,s),r.subtract(s,t,s),r.normalize(s,s);let a=r.dot(c,s);r.multiplyByScalar(s,U[e]/a,s),r.add(s,t,s)}else{let t=n.offCenterFrustum;a(t)&&(n=t);let r=U[e],i=U[e+1];s.x=.5*(s.x*(n.right-n.left)+n.left+n.right),s.y=.5*(s.y*(n.top-n.bottom)+n.bottom+n.top),s.z=.5*(s.z*(r-i)-r-i),s.w=1,F.multiplyByVector(w,s,s)}o[12*e+3*i]=s.x,o[12*e+3*i+1]=s.y,o[12*e+3*i+2]=s.z}},u.createGeometry=function(t){let e=t._frustumType,i=t._frustum,n=t._origin,o=t._orientation,s=t._drawNearPlane,f=t._vertexFormat,h=s?6:5,p=new Float64Array(72);u._computeNearFarPlanes(n,o,e,i,p);let l=24;p[l]=p[12],p[l+1]=p[13],p[l+2]=p[14],p[l+3]=p[0],p[l+4]=p[1],p[l+5]=p[2],p[l+6]=p[9],p[l+7]=p[10],p[l+8]=p[11],p[l+9]=p[21],p[l+10]=p[22],p[l+11]=p[23],l+=12,p[l]=p[15],p[l+1]=p[16],p[l+2]=p[17],p[l+3]=p[3],p[l+4]=p[4],p[l+5]=p[5],p[l+6]=p[0],p[l+7]=p[1],p[l+8]=p[2],p[l+9]=p[12],p[l+10]=p[13],p[l+11]=p[14],l+=12,p[l]=p[3],p[l+1]=p[4],p[l+2]=p[5],p[l+3]=p[15],p[l+4]=p[16],p[l+5]=p[17],p[l+6]=p[18],p[l+7]=p[19],p[l+8]=p[20],p[l+9]=p[6],p[l+10]=p[7],p[l+11]=p[8],l+=12,p[l]=p[6],p[l+1]=p[7],p[l+2]=p[8],p[l+3]=p[18],p[l+4]=p[19],p[l+5]=p[20],p[l+6]=p[21],p[l+7]=p[22],p[l+8]=p[23],p[l+9]=p[9],p[l+10]=p[10],p[l+11]=p[11],s||(p=p.subarray(12));let c=new ae({position:new J({componentDatatype:H.DOUBLE,componentsPerAttribute:3,values:p})});if(a(f.normal)||a(f.tangent)||a(f.bitangent)||a(f.st)){let t=a(f.normal)?new Float32Array(12*h):void 0,e=a(f.tangent)?new Float32Array(12*h):void 0,i=a(f.bitangent)?new Float32Array(12*h):void 0,n=a(f.st)?new Float32Array(8*h):void 0,o=pe,u=le,p=we,w=r.negate(o,ke),m=r.negate(u,Se),d=r.negate(p,De);l=0,s&&(W(l,t,e,i,n,d,o,u),l+=12),W(l,t,e,i,n,p,w,u),l+=12,W(l,t,e,i,n,w,d,u),l+=12,W(l,t,e,i,n,m,d,w),l+=12,W(l,t,e,i,n,o,p,u),l+=12,W(l,t,e,i,n,u,p,w),a(t)&&(c.normal=new J({componentDatatype:H.FLOAT,componentsPerAttribute:3,values:t})),a(e)&&(c.tangent=new J({componentDatatype:H.FLOAT,componentsPerAttribute:3,values:e})),a(i)&&(c.bitangent=new J({componentDatatype:H.FLOAT,componentsPerAttribute:3,values:i})),a(n)&&(c.st=new J({componentDatatype:H.FLOAT,componentsPerAttribute:2,values:n}))}let w=new Uint16Array(6*h);for(let t=0;t<h;++t){let e=6*t,r=4*t;w[e]=r,w[e+1]=r+1,w[e+2]=r+2,w[e+3]=r,w[e+4]=r+2,w[e+5]=r+3}return new re({attributes:c,indices:w,primitiveType:oe.TRIANGLES,boundingSphere:ie.fromVertices(p)})};var Et=u;export{V as a,L as b,Et as c};