/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as y}from"./chunk-II365YZS.js";import{d as L}from"./chunk-DPQZPDIL.js";import{b as d,h as W}from"./chunk-YJEV67VS.js";import{a as A}from"./chunk-4BTDTSQG.js";import{a as s,b as k,c as T,d as b}from"./chunk-XFVXIGTK.js";import{a as E}from"./chunk-MPRZ6V46.js";import{a as I,b as z}from"./chunk-VZMWSUG7.js";import{e as h}from"./chunk-362ETHZ6.js";function x(t,e){z.typeOf.object("ellipsoid",t),this._ellipsoid=t,this._cameraPosition=new s,this._cameraPositionInScaledSpace=new s,this._distanceToLimbInScaledSpaceSquared=0,h(e)&&(this.cameraPosition=e)}Object.defineProperties(x.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(t){let e=this._ellipsoid.transformPositionToScaledSpace(t,this._cameraPositionInScaledSpace),i=s.magnitudeSquared(e)-1;s.clone(t,this._cameraPosition),this._cameraPositionInScaledSpace=e,this._distanceToLimbInScaledSpaceSquared=i}}});var j=new s;x.prototype.isPointVisible=function(t){return D(this._ellipsoid.transformPositionToScaledSpace(t,j),this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)},x.prototype.isScaledSpacePointVisible=function(t){return D(t,this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)};var it=new s;x.prototype.isScaledSpacePointVisiblePossiblyUnderEllipsoid=function(t,e){let i,o,r=this._ellipsoid;return h(e)&&e<0&&r.minimumRadius>-e?(o=it,o.x=this._cameraPosition.x/(r.radii.x+e),o.y=this._cameraPosition.y/(r.radii.y+e),o.z=this._cameraPosition.z/(r.radii.z+e),i=o.x*o.x+o.y*o.y+o.z*o.z-1):(o=this._cameraPositionInScaledSpace,i=this._distanceToLimbInScaledSpaceSquared),D(t,o,i)},x.prototype.computeHorizonCullingPoint=function(t,e,i){return Z(this._ellipsoid,t,e,i)};var U=b.clone(b.UNIT_SPHERE);x.prototype.computeHorizonCullingPointPossiblyUnderEllipsoid=function(t,e,i,o){return Z(v(this._ellipsoid,i,U),t,e,o)},x.prototype.computeHorizonCullingPointFromVertices=function(t,e,i,o,r){return Q(this._ellipsoid,t,e,i,o,r)},x.prototype.computeHorizonCullingPointFromVerticesPossiblyUnderEllipsoid=function(t,e,i,o,r,s){return Q(v(this._ellipsoid,r,U),t,e,i,o,s)};var nt=[];x.prototype.computeHorizonCullingPointFromRectangle=function(t,e,i){z.typeOf.object("rectangle",t);let o=W.subsample(t,e,0,nt),r=L.fromPoints(o);if(!(s.magnitude(r.center)<.1*e.minimumRadius))return this.computeHorizonCullingPoint(r.center,o,i)};var at=new s;function v(t,e,i){if(h(e)&&e<0&&t.minimumRadius>-e){let o=s.fromElements(t.radii.x+e,t.radii.y+e,t.radii.z+e,at);t=b.fromCartesian3(o,i)}return t}function Z(t,e,i,o){z.typeOf.object("directionToPoint",e),z.defined("positions",i),h(o)||(o=new s);let r=X(t,e),a=0;for(let e=0,o=i.length;e<o;++e){let o=J(t,i[e],r);if(o<0)return;a=Math.max(a,o)}return K(r,a,o)}var q=new s;function Q(t,e,i,o,r,a){z.typeOf.object("directionToPoint",e),z.defined("vertices",i),z.typeOf.number("stride",o),h(a)||(a=new s),o=o??3,r=r??s.ZERO;let n=X(t,e),c=0;for(let e=0,s=i.length;e<s;e+=o){q.x=i[e]+r.x,q.y=i[e+1]+r.y,q.z=i[e+2]+r.z;let o=J(t,q,n);if(o<0)return;c=Math.max(c,o)}return K(n,c,a)}function D(t,e,i){let o=e,r=i,a=s.subtract(t,o,j),n=-s.dot(a,o);return!(r<0?n>0:n>r&&n*n/s.magnitudeSquared(a)>r)}var st=new s,ct=new s;function J(t,e,i){let o=t.transformPositionToScaledSpace(e,st),r=s.magnitudeSquared(o),a=Math.sqrt(r),n=s.divideByScalar(o,a,ct);r=Math.max(1,r),a=Math.max(1,a);let c=1/a;return 1/(s.dot(n,i)*c-s.magnitude(s.cross(n,i,n))*(Math.sqrt(r-1)*c))}function K(t,e,i){if(!(e<=0||e===1/0||e!=e))return s.multiplyByScalar(t,e,i)}var R=new s;function X(t,e){return s.equals(e,s.ZERO)?e:(t.transformPositionToScaledSpace(e,R),s.normalize(R,R))}var Tt=x,M={getHeight:function(t,e,i){if(!Number.isFinite(e))throw new I("scale must be a finite number.");if(!Number.isFinite(i))throw new I("relativeHeight must be a finite number.");return(t-i)*e+i}},rt=new k;M.getPosition=function(t,e,i,o,r){let a=e.cartesianToCartographic(t,rt);if(!h(a))return s.clone(t,r);let n=M.getHeight(a.height,i,o);return s.fromRadians(a.longitude,a.latitude,n,e,r)};var Y=M,mt={NONE:0,BITS12:1},S=Object.freeze(mt),_=new s,dt=new s,f=new T,O=new d,ht=new d,lt=Math.pow(2,12);function p(t,e,i,o,r,a,n,c,l,m){let u,f,p=S.NONE;if(h(e)&&h(i)&&h(o)&&h(r)){let t=e.minimum,a=e.maximum,n=s.subtract(a,t,dt),c=o-i;p=Math.max(s.maximumComponent(n),c)<lt-1?S.BITS12:S.NONE,u=d.inverseTransformation(r,new d);let l=s.negate(t,_);d.multiply(d.fromTranslation(l,O),u,u);let m=_;m.x=1/n.x,m.y=1/n.y,m.z=1/n.z,d.multiply(d.fromScale(m,O),u,u),f=d.clone(r),d.setTranslation(f,s.ZERO,f),r=d.clone(r,new d);let h=d.fromTranslation(t,O),x=d.fromScale(n,ht),y=d.multiply(h,x,O);d.multiply(r,y,r),d.multiply(f,y,f)}this.quantization=p,this.minimumHeight=i,this.maximumHeight=o,this.center=s.clone(t),this.toScaledENU=u,this.fromScaledENU=r,this.matrix=f,this.hasVertexNormals=a,this.hasWebMercatorT=n??!1,this.hasGeodeticSurfaceNormals=c??!1,this.exaggeration=l??1,this.exaggerationRelativeHeight=m??0,this.stride=0,this._offsetGeodeticSurfaceNormal=0,this._offsetVertexNormal=0,this._calculateStrideAndOffsets()}p.prototype.encode=function(t,e,i,o,r,a,n,c){let l=o.x,m=o.y;if(this.quantization===S.BITS12){(i=d.multiplyByPoint(this.toScaledENU,i,_)).x=E.clamp(i.x,0,1),i.y=E.clamp(i.y,0,1),i.z=E.clamp(i.z,0,1);let o=this.maximumHeight-this.minimumHeight,s=E.clamp((r-this.minimumHeight)/o,0,1);T.fromElements(i.x,i.y,f);let a=y.compressTextureCoordinates(f);T.fromElements(i.z,s,f);let c=y.compressTextureCoordinates(f);T.fromElements(l,m,f);let u=y.compressTextureCoordinates(f);if(t[e++]=a,t[e++]=c,t[e++]=u,this.hasWebMercatorT){T.fromElements(n,0,f);let i=y.compressTextureCoordinates(f);t[e++]=i}}else s.subtract(i,this.center,_),t[e++]=_.x,t[e++]=_.y,t[e++]=_.z,t[e++]=r,t[e++]=l,t[e++]=m,this.hasWebMercatorT&&(t[e++]=n);return this.hasVertexNormals&&(t[e++]=y.octPackFloat(a)),this.hasGeodeticSurfaceNormals&&(t[e++]=c.x,t[e++]=c.y,t[e++]=c.z),e};var pt=new s,$=new s;p.prototype.addGeodeticSurfaceNormals=function(t,e,i){if(this.hasGeodeticSurfaceNormals)return;let o=this.stride,r=t.length/o;this.hasGeodeticSurfaceNormals=!0,this._calculateStrideAndOffsets();let s=this.stride;for(let a=0;a<r;a++){for(let i=0;i<o;i++){let r=a*o+i;e[a*s+i]=t[r]}let r=this.decodePosition(e,a,pt),n=i.geodeticSurfaceNormal(r,$),c=a*s+this._offsetGeodeticSurfaceNormal;e[c]=n.x,e[c+1]=n.y,e[c+2]=n.z}},p.prototype.removeGeodeticSurfaceNormals=function(t,e){if(!this.hasGeodeticSurfaceNormals)return;let i=this.stride,o=t.length/i;this.hasGeodeticSurfaceNormals=!1,this._calculateStrideAndOffsets();let r=this.stride;for(let s=0;s<o;s++)for(let o=0;o<r;o++){let a=s*i+o;e[s*r+o]=t[a]}},p.prototype.decodePosition=function(t,e,i){if(h(i)||(i=new s),e*=this.stride,this.quantization===S.BITS12){let o=y.decompressTextureCoordinates(t[e],f);i.x=o.x,i.y=o.y;let r=y.decompressTextureCoordinates(t[e+1],f);return i.z=r.x,d.multiplyByPoint(this.fromScaledENU,i,i)}return i.x=t[e],i.y=t[e+1],i.z=t[e+2],s.add(i,this.center,i)},p.prototype.getExaggeratedPosition=function(t,e,i){i=this.decodePosition(t,e,i);let o=this.exaggeration,r=this.exaggerationRelativeHeight;if(1!==o&&this.hasGeodeticSurfaceNormals){let s=this.decodeGeodeticSurfaceNormal(t,e,$),a=this.decodeHeight(t,e),n=Y.getHeight(a,o,r)-a;i.x+=s.x*n,i.y+=s.y*n,i.z+=s.z*n}return i},p.prototype.decodeTextureCoordinates=function(t,e,i){return h(i)||(i=new T),e*=this.stride,this.quantization===S.BITS12?y.decompressTextureCoordinates(t[e+2],i):T.fromElements(t[e+4],t[e+5],i)},p.prototype.decodeHeight=function(t,e){return e*=this.stride,this.quantization===S.BITS12?y.decompressTextureCoordinates(t[e+1],f).y*(this.maximumHeight-this.minimumHeight)+this.minimumHeight:t[e+3]},p.prototype.decodeWebMercatorT=function(t,e){return e*=this.stride,this.quantization===S.BITS12?y.decompressTextureCoordinates(t[e+3],f).x:t[e+6]},p.prototype.getOctEncodedNormal=function(t,e,i){let o=t[e=e*this.stride+this._offsetVertexNormal]/256,r=Math.floor(o),s=256*(o-r);return T.fromElements(r,s,i)},p.prototype.decodeGeodeticSurfaceNormal=function(t,e,i){return e=e*this.stride+this._offsetGeodeticSurfaceNormal,i.x=t[e],i.y=t[e+1],i.z=t[e+2],i},p.prototype._calculateStrideAndOffsets=function(){let t=0;if(this.quantization===S.BITS12)t+=3;else t+=6;this.hasWebMercatorT&&(t+=1),this.hasVertexNormals&&(this._offsetVertexNormal=t,t+=1),this.hasGeodeticSurfaceNormals&&(this._offsetGeodeticSurfaceNormal=t,t+=3),this.stride=t};var G={position3DAndHeight:0,textureCoordAndEncodedNormals:1,geodeticSurfaceNormal:2},H={compressed0:0,compressed1:1,geodeticSurfaceNormal:2};p.prototype.getAttributes=function(t){let e=A.FLOAT,i=A.getSizeInBytes(e),o=this.stride*i,r=0,s=[];function a(a,n){s.push({index:a,vertexBuffer:t,componentDatatype:e,componentsPerAttribute:n,offsetInBytes:r,strideInBytes:o}),r+=n*i}if(this.quantization===S.NONE){a(G.position3DAndHeight,4);let t=2;t+=this.hasWebMercatorT?1:0,t+=this.hasVertexNormals?1:0,a(G.textureCoordAndEncodedNormals,t),this.hasGeodeticSurfaceNormals&&a(G.geodeticSurfaceNormal,3)}else{let t=this.hasWebMercatorT||this.hasVertexNormals,e=this.hasWebMercatorT&&this.hasVertexNormals;a(H.compressed0,t?4:3),e&&a(H.compressed1,1),this.hasGeodeticSurfaceNormals&&a(H.geodeticSurfaceNormal,3)}return s},p.prototype.getAttributeLocations=function(){return this.quantization===S.NONE?G:H},p.clone=function(t,e){if(h(t))return h(e)||(e=new p),e.quantization=t.quantization,e.minimumHeight=t.minimumHeight,e.maximumHeight=t.maximumHeight,e.center=s.clone(t.center),e.toScaledENU=d.clone(t.toScaledENU),e.fromScaledENU=d.clone(t.fromScaledENU),e.matrix=d.clone(t.matrix),e.hasVertexNormals=t.hasVertexNormals,e.hasWebMercatorT=t.hasWebMercatorT,e.hasGeodeticSurfaceNormals=t.hasGeodeticSurfaceNormals,e.exaggeration=t.exaggeration,e.exaggerationRelativeHeight=t.exaggerationRelativeHeight,e._calculateStrideAndOffsets(),e};var Dt=p;export{Tt as a,Dt as b};