/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as U}from"./chunk-WV2B3Y5P.js";import{a as b}from"./chunk-HCF5XBCP.js";import{a as E}from"./chunk-SFW65PGL.js";import{a as z}from"./chunk-BTGP76WP.js";import{c as B,d as D}from"./chunk-YQL7OPIW.js";import{a as V,d as y}from"./chunk-DPQZPDIL.js";import{b as G}from"./chunk-YJEV67VS.js";import{a as k}from"./chunk-4BTDTSQG.js";import{d as F}from"./chunk-XFVXIGTK.js";import{a as M,b as I}from"./chunk-VZMWSUG7.js";import{e as a}from"./chunk-362ETHZ6.js";function v(e,t,r){e=e??0,t=t??0,r=r??0,this.value=new Float32Array([e,t,r])}Object.defineProperties(v.prototype,{componentDatatype:{get:function(){return k.FLOAT}},componentsPerAttribute:{get:function(){return 3}},normalize:{get:function(){return!1}}}),v.fromCartesian3=function(e){return I.defined("offset",e),new v(e.x,e.y,e.z)},v.toValue=function(e,t){return I.defined("offset",e),a(t)||(t=new Float32Array([e.x,e.y,e.z])),t[0]=e.x,t[1]=e.y,t[2]=e.z,t};var $=v;function J(e,t,r){let n,o=!r,i=e.length;if(!o&&i>1){let t=e[0].modelMatrix;for(n=1;n<i;++n)if(!G.equals(t,e[n].modelMatrix)){o=!0;break}}if(o)for(n=0;n<i;++n)a(e[n].geometry)&&b.transformToWorldCoordinates(e[n]);else G.multiplyTransformation(t,e[0].modelMatrix,t)}function L(e,t){let r=e.attributes,n=r.position,o=n.values.length/n.componentsPerAttribute;r.batchId=new D({componentDatatype:k.FLOAT,componentsPerAttribute:1,values:new Float32Array(o)});let i=r.batchId.values;for(let e=0;e<o;++e)i[e]=t}function K(e){let t=e.length;for(let r=0;r<t;++r){let t=e[r];a(t.geometry)?L(t.geometry,r):a(t.westHemisphereGeometry)&&a(t.eastHemisphereGeometry)&&(L(t.westHemisphereGeometry,r),L(t.eastHemisphereGeometry,r))}}function N(e){let t,r,n,o=e.instances,i=e.projection,s=e.elementIndexUintSupported,l=e.scene3DOnly,c=e.vertexCacheOptimize,u=e.compressVertices,p=e.modelMatrix,f=o.length;for(t=0;t<f;++t)if(a(o[t].geometry)){n=o[t].geometry.primitiveType;break}for(t=1;t<f;++t)if(a(o[t].geometry)&&o[t].geometry.primitiveType!==n)throw new M("All instance geometries must have the same primitiveType.");if(J(o,p,l),!l)for(t=0;t<f;++t)a(o[t].geometry)&&b.splitLongitude(o[t]);if(K(o),c)for(t=0;t<f;++t){let e=o[t];a(e.geometry)?(b.reorderForPostVertexCache(e.geometry),b.reorderForPreVertexCache(e.geometry)):a(e.westHemisphereGeometry)&&a(e.eastHemisphereGeometry)&&(b.reorderForPostVertexCache(e.westHemisphereGeometry),b.reorderForPreVertexCache(e.westHemisphereGeometry),b.reorderForPostVertexCache(e.eastHemisphereGeometry),b.reorderForPreVertexCache(e.eastHemisphereGeometry))}let m=b.combineInstances(o);for(f=m.length,t=0;t<f;++t){r=m[t];let e=r.attributes;if(l)for(let t in e)e.hasOwnProperty(t)&&e[t].componentDatatype===k.DOUBLE&&b.encodeAttribute(r,t,`${t}3DHigh`,`${t}3DLow`);else for(let t in e)if(e.hasOwnProperty(t)&&e[t].componentDatatype===k.DOUBLE){let e=`${t}3D`,n=`${t}2D`;b.projectTo2D(r,t,e,n,i),a(r.boundingSphere)&&"position"===t&&(r.boundingSphereCV=y.fromVertices(r.attributes.position2D.values)),b.encodeAttribute(r,e,`${e}High`,`${e}Low`),b.encodeAttribute(r,n,`${n}High`,`${n}Low`)}u&&b.compressVertices(r)}if(!s){let e=[];for(f=m.length,t=0;t<f;++t)r=m[t],e=e.concat(b.fitToUnsignedShortIndices(r));m=e}return m}function P(e,t,r,n){let o,i,s,l=n.length-1;if(l>=0){let e=n[l];o=e.offset+e.count,s=e.index,i=r[s].indices.length}else o=0,s=0,i=r[s].indices.length;let c=e.length;for(let l=0;l<c;++l){let c=e[l][t];if(!a(c))continue;let u=c.indices.length;o+u>i&&(o=0,i=r[++s].indices.length),n.push({index:s,offset:o,count:u}),o+=u}}function Q(e,t){let r=[];return P(e,"geometry",t,r),P(e,"westHemisphereGeometry",t,r),P(e,"eastHemisphereGeometry",t,r),r}var S={};function X(e,t){let r=e.attributes;for(let e in r)if(r.hasOwnProperty(e)){let n=r[e];a(n)&&a(n.values)&&t.push(n.values.buffer)}a(e.indices)&&t.push(e.indices.buffer)}function Y(e,t){let r=e.length;for(let n=0;n<r;++n)X(e[n],t)}function Z(e){let t=1,r=e.length;for(let n=0;n<r;n++){let r=e[n];if(++t,!a(r))continue;let o=r.attributes;t+=7+2*y.packedLength+(a(r.indices)?r.indices.length:0);for(let e in o)if(o.hasOwnProperty(e)&&a(o[e])){t+=5+o[e].values.length}}return t}function _(e,t){let r=e.length,n=new Float64Array(1+19*r),o=0;n[o++]=r;for(let t=0;t<r;t++){let r=e[t];if(G.pack(r.modelMatrix,n,o),o+=G.packedLength,a(r.attributes)&&a(r.attributes.offset)){let e=r.attributes.offset.value;n[o]=e[0],n[o+1]=e[1],n[o+2]=e[2]}o+=3}return t.push(n.buffer),n}function ee(e){let t=e,r=new Array(t[0]),n=0,o=1;for(;o<t.length;){let e,i=G.unpack(t,o);o+=G.packedLength,a(t[o])&&(e={offset:new $(t[o],t[o+1],t[o+2])}),o+=3,r[n++]={modelMatrix:i,attributes:e}}return r}function j(e){let t=e.length,r=1+(y.packedLength+1)*t,n=new Float32Array(r),o=0;n[o++]=t;for(let r=0;r<t;++r){let t=e[r];a(t)?(n[o++]=1,y.pack(e[r],n,o)):n[o++]=0,o+=y.packedLength}return n}function R(e){let t=new Array(e[0]),r=0,n=1;for(;n<e.length;)1===e[n++]&&(t[r]=y.unpack(e,n)),++r,n+=y.packedLength;return t}S.combineGeometry=function(e){let t,r,n,o,i=e.instances,s=i.length,l=!1;s>0&&(t=N(e),t.length>0&&(r=b.createAttributeLocations(t[0]),e.createPickOffsets&&(n=Q(i,t))),a(i[0].attributes)&&a(i[0].attributes.offset)&&(o=new Array(s),l=!0));let c=new Array(s),u=new Array(s);for(let e=0;e<s;++e){let t=i[e],r=t.geometry;a(r)&&(c[e]=r.boundingSphere,u[e]=r.boundingSphereCV,l&&(o[e]=t.geometry.offsetAttribute));let n=t.eastHemisphereGeometry,s=t.westHemisphereGeometry;a(n)&&a(s)&&(a(n.boundingSphere)&&a(s.boundingSphere)&&(c[e]=y.union(n.boundingSphere,s.boundingSphere)),a(n.boundingSphereCV)&&a(s.boundingSphereCV)&&(u[e]=y.union(n.boundingSphereCV,s.boundingSphereCV)))}return{geometries:t,modelMatrix:e.modelMatrix,attributeLocations:r,pickOffsets:n,offsetInstanceExtend:o,boundingSpheres:c,boundingSpheresCV:u}},S.packCreateGeometryResults=function(e,t){let r=new Float64Array(Z(e)),n=[],o={},i=e.length,s=0;r[s++]=i;for(let t=0;t<i;t++){let i=e[t],l=a(i);if(r[s++]=l?1:0,!l)continue;r[s++]=i.primitiveType,r[s++]=i.geometryType,r[s++]=i.offsetAttribute??-1;let c=a(i.boundingSphere)?1:0;r[s++]=c,c&&y.pack(i.boundingSphere,r,s),s+=y.packedLength;let u=a(i.boundingSphereCV)?1:0;r[s++]=u,u&&y.pack(i.boundingSphereCV,r,s),s+=y.packedLength;let p=i.attributes,f=[];for(let e in p)p.hasOwnProperty(e)&&a(p[e])&&(f.push(e),a(o[e])||(o[e]=n.length,n.push(e)));r[s++]=f.length;for(let e=0;e<f.length;e++){let t=f[e],n=p[t];r[s++]=o[t],r[s++]=n.componentDatatype,r[s++]=n.componentsPerAttribute,r[s++]=n.normalize?1:0,r[s++]=n.values.length,r.set(n.values,s),s+=n.values.length}let m=a(i.indices)?i.indices.length:0;r[s++]=m,m>0&&(r.set(i.indices,s),s+=m)}return t.push(r.buffer),{stringTable:n,packedData:r}},S.unpackCreateGeometryResults=function(e){let t,r=e.stringTable,n=e.packedData,o=new Array(n[0]),i=0,a=1;for(;a<n.length;){if(1!==n[a++]){o[i++]=void 0;continue}let e,s,l=n[a++],c=n[a++],u=n[a++];-1===u&&(u=void 0),1===n[a++]&&(e=y.unpack(n,a)),a+=y.packedLength,1===n[a++]&&(s=y.unpack(n,a)),a+=y.packedLength;let p,f,m,h,d=new z,g=n[a++];for(t=0;t<g;t++){let e=r[n[a++]],t=n[a++];m=n[a++];let o=0!==n[a++];p=n[a++],f=k.createTypedArray(t,p);for(let e=0;e<p;e++)f[e]=n[a++];d[e]=new D({componentDatatype:t,componentsPerAttribute:m,normalize:o,values:f})}if(p=n[a++],p>0){let e=f.length/m;for(h=E.createTypedArray(e,p),t=0;t<p;t++)h[t]=n[a++]}o[i++]=new B({primitiveType:l,geometryType:c,boundingSphere:e,boundingSphereCV:s,indices:h,attributes:d,offsetAttribute:u})}return o},S.packCombineGeometryParameters=function(e,t){let r=e.createGeometryResults,n=r.length;for(let e=0;e<n;e++)t.push(r[e].packedData.buffer);return{createGeometryResults:e.createGeometryResults,packedInstances:_(e.instances,t),ellipsoid:e.ellipsoid,isGeographic:e.projection instanceof V,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix,createPickOffsets:e.createPickOffsets}},S.unpackCombineGeometryParameters=function(e){let t=ee(e.packedInstances),r=e.createGeometryResults,n=r.length,o=0;for(let e=0;e<n;e++){let n=S.unpackCreateGeometryResults(r[e]),i=n.length;for(let e=0;e<i;e++){let r=n[e];t[o].geometry=r,++o}}let i=F.clone(e.ellipsoid);return{instances:t,ellipsoid:i,projection:e.isGeographic?new V(i):new U(i),elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:G.clone(e.modelMatrix),createPickOffsets:e.createPickOffsets}},S.packCombineGeometryResults=function(e,t){a(e.geometries)&&Y(e.geometries,t);let r=j(e.boundingSpheres),n=j(e.boundingSpheresCV);return t.push(r.buffer,n.buffer),{geometries:e.geometries,attributeLocations:e.attributeLocations,modelMatrix:e.modelMatrix,pickOffsets:e.pickOffsets,offsetInstanceExtend:e.offsetInstanceExtend,boundingSpheres:r,boundingSpheresCV:n}},S.unpackCombineGeometryResults=function(e){return{geometries:e.geometries,attributeLocations:e.attributeLocations,modelMatrix:e.modelMatrix,pickOffsets:e.pickOffsets,offsetInstanceExtend:e.offsetInstanceExtend,boundingSpheres:R(e.boundingSpheres),boundingSpheresCV:R(e.boundingSpheresCV)}};var xe=S;export{xe as a};