/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as n,b as a}from"./chunk-VZMWSUG7.js";import{c as E,d as I,e as o}from"./chunk-362ETHZ6.js";var d=E(((t,r)=>{var n=function(t){null==t&&(t=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,t.constructor==Array?this.init_by_array(t,t.length):this.init_seed(t)};n.prototype.init_seed=function(t){for(this.mt[0]=t>>>0,this.mti=1;this.mti<this.N;this.mti++){t=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&t)>>>16)<<16)+1812433253*(65535&t)+this.mti,this.mt[this.mti]>>>=0}},n.prototype.init_by_array=function(t,r){var n,e,i;for(this.init_seed(19650218),n=1,e=0,i=this.N>r?this.N:r;i;i--){var o=this.mt[n-1]^this.mt[n-1]>>>30;this.mt[n]=(this.mt[n]^(1664525*((4294901760&o)>>>16)<<16)+1664525*(65535&o))+t[e]+e,this.mt[n]>>>=0,e++,++n>=this.N&&(this.mt[0]=this.mt[this.N-1],n=1),e>=r&&(e=0)}for(i=this.N-1;i;i--){o=this.mt[n-1]^this.mt[n-1]>>>30;this.mt[n]=(this.mt[n]^(1566083941*((4294901760&o)>>>16)<<16)+1566083941*(65535&o))-n,this.mt[n]>>>=0,++n>=this.N&&(this.mt[0]=this.mt[this.N-1],n=1)}this.mt[0]=2147483648},n.prototype.random_int=function(){var t,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_seed(5489),n=0;n<this.N-this.M;n++)t=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^t>>>1^r[1&t];for(;n<this.N-1;n++)t=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^t>>>1^r[1&t];t=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^t>>>1^r[1&t],this.mti=0}return t=this.mt[this.mti++],t^=t>>>11,t^=t<<7&2636928640,t^=t<<15&4022730752,(t^=t>>>18)>>>0},n.prototype.random_int31=function(){return this.random_int()>>>1},n.prototype.random_incl=function(){return this.random_int()*(1/4294967295)},n.prototype.random=function(){return this.random_int()*(1/4294967296)},n.prototype.random_excl=function(){return(this.random_int()+.5)*(1/4294967296)},n.prototype.random_long=function(){return(67108864*(this.random_int()>>>5)+(this.random_int()>>>6))*(1/9007199254740992)},r.exports=n})),w=I(d(),1),r={EPSILON1:.1,EPSILON2:.01,EPSILON3:.001,EPSILON4:1e-4,EPSILON5:1e-5,EPSILON6:1e-6,EPSILON7:1e-7,EPSILON8:1e-8,EPSILON9:1e-9,EPSILON10:1e-10,EPSILON11:1e-11,EPSILON12:1e-12,EPSILON13:1e-13,EPSILON14:1e-14,EPSILON15:1e-15,EPSILON16:1e-16,EPSILON17:1e-17,EPSILON18:1e-18,EPSILON19:1e-19,EPSILON20:1e-20,EPSILON21:1e-21,GRAVITATIONALPARAMETER:3986004418e5,SOLAR_RADIUS:6955e5,LUNAR_RADIUS:1737400,SIXTY_FOUR_KILOBYTES:65536,FOUR_GIGABYTES:4294967296};r.sign=Math.sign??function(t){return 0===(t=+t)||t!=t?t:t>0?1:-1},r.signNotZero=function(t){return t<0?-1:1},r.toSNorm=function(t,n){return n=n??255,Math.round((.5*r.clamp(t,-1,1)+.5)*n)},r.fromSNorm=function(t,n){return n=n??255,r.clamp(t,0,n)/n*2-1},r.normalize=function(t,n,e){return 0===(e=Math.max(e-n,0))?0:r.clamp((t-n)/e,0,1)},r.sinh=Math.sinh??function(t){return(Math.exp(t)-Math.exp(-t))/2},r.cosh=Math.cosh??function(t){return(Math.exp(t)+Math.exp(-t))/2},r.lerp=function(t,r,n){return(1-n)*t+n*r},r.PI=Math.PI,r.ONE_OVER_PI=1/Math.PI,r.PI_OVER_TWO=Math.PI/2,r.PI_OVER_THREE=Math.PI/3,r.PI_OVER_FOUR=Math.PI/4,r.PI_OVER_SIX=Math.PI/6,r.THREE_PI_OVER_TWO=3*Math.PI/2,r.TWO_PI=2*Math.PI,r.ONE_OVER_TWO_PI=1/(2*Math.PI),r.RADIANS_PER_DEGREE=Math.PI/180,r.DEGREES_PER_RADIAN=180/Math.PI,r.RADIANS_PER_ARCSECOND=r.RADIANS_PER_DEGREE/3600,r.toRadians=function(t){if(!o(t))throw new n("degrees is required.");return t*r.RADIANS_PER_DEGREE},r.toDegrees=function(t){if(!o(t))throw new n("radians is required.");return t*r.DEGREES_PER_RADIAN},r.convertLongitudeRange=function(t){if(!o(t))throw new n("angle is required.");let e=r.TWO_PI,i=t-Math.floor(t/e)*e;return i<-Math.PI?i+e:i>=Math.PI?i-e:i},r.clampToLatitudeRange=function(t){if(!o(t))throw new n("angle is required.");return r.clamp(t,-1*r.PI_OVER_TWO,r.PI_OVER_TWO)},r.negativePiToPi=function(t){if(!o(t))throw new n("angle is required.");return t>=-r.PI&&t<=r.PI?t:r.zeroToTwoPi(t+r.PI)-r.PI},r.zeroToTwoPi=function(t){if(!o(t))throw new n("angle is required.");if(t>=0&&t<=r.TWO_PI)return t;let e=r.mod(t,r.TWO_PI);return Math.abs(e)<r.EPSILON14&&Math.abs(t)>r.EPSILON14?r.TWO_PI:e},r.mod=function(t,e){if(!o(t))throw new n("m is required.");if(!o(e))throw new n("n is required.");if(0===e)throw new n("divisor cannot be 0.");return r.sign(t)===r.sign(e)&&Math.abs(t)<Math.abs(e)?t:(t%e+e)%e},r.equalsEpsilon=function(t,r,e,i){if(!o(t))throw new n("left is required.");if(!o(r))throw new n("right is required.");e=e??0,i=i??e;let s=Math.abs(t-r);return s<=i||s<=e*Math.max(Math.abs(t),Math.abs(r))},r.lessThan=function(t,r,e){if(!o(t))throw new n("first is required.");if(!o(r))throw new n("second is required.");if(!o(e))throw new n("absoluteEpsilon is required.");return t-r<-e},r.lessThanOrEquals=function(t,r,e){if(!o(t))throw new n("first is required.");if(!o(r))throw new n("second is required.");if(!o(e))throw new n("absoluteEpsilon is required.");return t-r<e},r.greaterThan=function(t,r,e){if(!o(t))throw new n("first is required.");if(!o(r))throw new n("second is required.");if(!o(e))throw new n("absoluteEpsilon is required.");return t-r>e},r.greaterThanOrEquals=function(t,r,e){if(!o(t))throw new n("first is required.");if(!o(r))throw new n("second is required.");if(!o(e))throw new n("absoluteEpsilon is required.");return t-r>-e};var c=[1];r.factorial=function(t){if("number"!=typeof t||t<0)throw new n("A number greater than or equal to 0 is required.");let r=c.length;if(t>=r){let n=c[r-1];for(let e=r;e<=t;e++){let t=n*e;c.push(t),n=t}}return c[t]},r.incrementWrap=function(t,r,e){if(e=e??0,!o(t))throw new n("n is required.");if(r<=e)throw new n("maximumValue must be greater than minimumValue.");return++t>r&&(t=e),t},r.isPowerOfTwo=function(t){if("number"!=typeof t||t<0||t>4294967295)throw new n("A number between 0 and (2^32)-1 is required.");return 0!==t&&!(t&t-1)},r.nextPowerOfTwo=function(t){if("number"!=typeof t||t<0||t>2147483648)throw new n("A number between 0 and 2^31 is required.");return--t,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,t|=t>>16,++t},r.previousPowerOfTwo=function(t){if("number"!=typeof t||t<0||t>4294967295)throw new n("A number between 0 and (2^32)-1 is required.");return t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,t|=t>>16,t=((t|=t>>32)>>>0)-(t>>>1)},r.clamp=function(t,r,n){return a.typeOf.number("value",t),a.typeOf.number("min",r),a.typeOf.number("max",n),t<r?r:t>n?n:t};var P=new w.default;r.setRandomNumberSeed=function(t){if(!o(t))throw new n("seed is required.");P=new w.default(t)},r.nextRandomNumber=function(){return P.random()},r.randomBetween=function(t,n){return r.nextRandomNumber()*(n-t)+t},r.acosClamped=function(t){if(!o(t))throw new n("value is required.");return Math.acos(r.clamp(t,-1,1))},r.asinClamped=function(t){if(!o(t))throw new n("value is required.");return Math.asin(r.clamp(t,-1,1))},r.chordLength=function(t,r){if(!o(t))throw new n("angle is required.");if(!o(r))throw new n("radius is required.");return 2*r*Math.sin(.5*t)},r.logBase=function(t,r){if(!o(t))throw new n("number is required.");if(!o(r))throw new n("base is required.");return Math.log(t)/Math.log(r)},r.cbrt=Math.cbrt??function(t){let r=Math.pow(Math.abs(t),.3333333333333333);return t<0?-r:r},r.log2=Math.log2??function(t){return Math.log(t)*Math.LOG2E},r.fog=function(t,r){let n=t*r;return 1-Math.exp(-n*n)},r.fastApproximateAtan=function(t){return a.typeOf.number("x",t),t*(-.1784*Math.abs(t)-.0663*t*t+1.0301)},r.fastApproximateAtan2=function(t,e){a.typeOf.number("x",t),a.typeOf.number("y",e);let i,o=Math.abs(t);i=Math.abs(e);let s=Math.max(o,i);i=Math.min(o,i);let h=i/s;if(isNaN(h))throw new n("either x or y must be nonzero");return o=r.fastApproximateAtan(h),o=Math.abs(e)>Math.abs(t)?r.PI_OVER_TWO-o:o,o=t<0?r.PI-o:o,o=e<0?-o:o,o};var M=r;export{M as a};