/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as G}from"./chunk-QYCM25U7.js";import{a as z}from"./chunk-L3YV42ES.js";import{b as B}from"./chunk-QTPIBP7S.js";import{a as C}from"./chunk-ZCCOD3XE.js";import{b as L}from"./chunk-YJEV67VS.js";import{a,b as D,d as I}from"./chunk-XFVXIGTK.js";import{a as S}from"./chunk-MPRZ6V46.js";import{a as x}from"./chunk-VZMWSUG7.js";import{e as T}from"./chunk-362ETHZ6.js";var p={numberOfPoints:function(e,t,r){let n=a.distance(e,t);return Math.ceil(n/r)},numberOfPointsRhumbLine:function(e,t,a){let r=Math.pow(e.longitude-t.longitude,2)+Math.pow(e.latitude-t.latitude,2);return Math.max(1,Math.ceil(Math.sqrt(r/(a*a))))}},Z=new D;p.extractHeights=function(e,t){let a=e.length,r=new Array(a);for(let n=0;n<a;n++){let a=e[n];r[n]=t.cartesianToCartographic(a,Z).height}return r};var Y=new L,V=new a,_=new a,F=new C(a.UNIT_X,0),v=new a,j=new C(a.UNIT_X,0),J=new a,K=new a,O=[];function U(e,t,a){let r,n=O;if(n.length=e,t===a){for(r=0;r<e;r++)n[r]=t;return n}let i=(a-t)/e;for(r=0;r<e;r++){let e=t+r*i;n[r]=e}return n}var N=new D,E=new D,b=new a,k=new a,Q=new a,M=new G,R=new z;function W(e,t,r,n,i,o,l,c){let s=n.scaleToGeodeticSurface(e,k),u=n.scaleToGeodeticSurface(t,Q),h=p.numberOfPoints(e,t,r),f=n.cartesianToCartographic(s,N),g=n.cartesianToCartographic(u,E),m=U(h,i,o);M.setEndPoints(f,g);let T=M.surfaceDistance/h,d=c;f.height=i;let w=n.cartographicToCartesian(f,b);a.pack(w,l,d),d+=3;for(let e=1;e<h;e++){let t=M.interpolateUsingSurfaceDistance(e*T,E);t.height=m[e],w=n.cartographicToCartesian(t,b),a.pack(w,l,d),d+=3}return d}function $(e,t,r,n,i,o,l,c){let s=n.cartesianToCartographic(e,N),u=n.cartesianToCartographic(t,E),h=p.numberOfPointsRhumbLine(s,u,r);s.height=0,u.height=0;let f=U(h,i,o);R.ellipsoid.equals(n)||(R=new z(void 0,void 0,n)),R.setEndPoints(s,u);let g=R.surfaceDistance/h,m=c;s.height=i;let T=n.cartographicToCartesian(s,b);a.pack(T,l,m),m+=3;for(let e=1;e<h;e++){let t=R.interpolateUsingSurfaceDistance(e*g,E);t.height=f[e],T=n.cartographicToCartesian(t,b),a.pack(T,l,m),m+=3}return m}p.wrapLongitude=function(e,t){let r=[],n=[];if(T(e)&&e.length>0){t=t??L.IDENTITY;let i=L.inverseTransformation(t,Y),o=L.multiplyByPoint(i,a.ZERO,V),l=a.normalize(L.multiplyByPointAsVector(i,a.UNIT_Y,_),_),c=C.fromPointNormal(o,l,F),s=a.normalize(L.multiplyByPointAsVector(i,a.UNIT_X,v),v),u=C.fromPointNormal(o,s,j),h=1;r.push(a.clone(e[0]));let p=r[0],f=e.length;for(let t=1;t<f;++t){let i=e[t];if(C.getPointDistance(u,p)<0||C.getPointDistance(u,i)<0){let e=B.lineSegmentPlane(p,i,c,J);if(T(e)){let t=a.multiplyByScalar(l,5e-9,K);C.getPointDistance(c,p)<0&&a.negate(t,t),r.push(a.add(e,t,new a)),n.push(h+1),a.negate(t,t),r.push(a.add(e,t,new a)),h=1}}r.push(a.clone(e[t])),h++,p=i}n.push(h)}return{positions:r,lengths:n}},p.generateArc=function(e){T(e)||(e={});let t=e.positions;if(!T(t))throw new x("options.positions is required.");let r=t.length,n=e.ellipsoid??I.default,i=e.height??0,o=Array.isArray(i);if(r<1)return[];if(1===r){let e=n.scaleToGeodeticSurface(t[0],k);if(i=o?i[0]:i,0!==i){let t=n.geodeticSurfaceNormal(e,b);a.multiplyByScalar(t,i,t),a.add(e,t,e)}return[e.x,e.y,e.z]}let l=e.minDistance;if(!T(l)){let t=e.granularity??S.RADIANS_PER_DEGREE;l=S.chordLength(t,n.maximumRadius)}let c,s=0;for(c=0;c<r-1;c++)s+=p.numberOfPoints(t[c],t[c+1],l);let u=3*(s+1),h=new Array(u),f=0;for(c=0;c<r-1;c++){f=W(t[c],t[c+1],l,n,o?i[c]:i,o?i[c+1]:i,h,f)}O.length=0;let g=t[r-1],m=n.cartesianToCartographic(g,N);m.height=o?i[r-1]:i;let d=n.cartographicToCartesian(m,b);return a.pack(d,h,u-3),h};var H=new D,tt=new D;p.generateRhumbArc=function(e){T(e)||(e={});let t=e.positions;if(!T(t))throw new x("options.positions is required.");let r=t.length,n=e.ellipsoid??I.default,i=e.height??0,o=Array.isArray(i);if(r<1)return[];if(1===r){let e=n.scaleToGeodeticSurface(t[0],k);if(i=o?i[0]:i,0!==i){let t=n.geodeticSurfaceNormal(e,b);a.multiplyByScalar(t,i,t),a.add(e,t,e)}return[e.x,e.y,e.z]}let l,c,s=e.granularity??S.RADIANS_PER_DEGREE,u=0,h=n.cartesianToCartographic(t[0],H);for(l=0;l<r-1;l++)c=n.cartesianToCartographic(t[l+1],tt),u+=p.numberOfPointsRhumbLine(h,c,s),h=D.clone(c,H);let f=3*(u+1),g=new Array(f),m=0;for(l=0;l<r-1;l++){m=$(t[l],t[l+1],s,n,o?i[l]:i,o?i[l+1]:i,g,m)}O.length=0;let d=t[r-1],w=n.cartesianToCartographic(d,N);w.height=o?i[r-1]:i;let C=n.cartographicToCartesian(w,b);return a.pack(C,g,f-3),g},p.generateCartesianArc=function(e){let t=p.generateArc(e),r=t.length/3,n=new Array(r);for(let e=0;e<r;e++)n[e]=a.unpack(t,3*e);return n},p.generateCartesianRhumbArc=function(e){let t=p.generateRhumbArc(e),r=t.length/3,n=new Array(r);for(let e=0;e<r;e++)n[e]=a.unpack(t,3*e);return n};var gt=p;export{gt as a};