/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as G}from"./chunk-ESSNY5GC.js";import{a as At}from"./chunk-CFRYEZJF.js";import{a as yt}from"./chunk-HCF5XBCP.js";import{a as $}from"./chunk-64C3WG2L.js";import{a as v}from"./chunk-QL3VAYCR.js";import{a as st}from"./chunk-SFW65PGL.js";import{a as ht}from"./chunk-BTGP76WP.js";import{b as ct,c as rt,d as F}from"./chunk-YQL7OPIW.js";import{a as lt,d as it}from"./chunk-DPQZPDIL.js";import{f as nt,h as bt}from"./chunk-YJEV67VS.js";import{a as P}from"./chunk-4BTDTSQG.js";import{a,b as _t,c as Q,d as D,e as C,f as dt}from"./chunk-XFVXIGTK.js";import{a as R}from"./chunk-MPRZ6V46.js";import{a as ot,b as k}from"./chunk-VZMWSUG7.js";import{e as Z}from"./chunk-362ETHZ6.js";var tt=new a,pt=new a,xt=new a,wt=new a,w=new Q,Mt=new C,Vt=new C,gt=new nt,Tt=new a,Nt=new a,Et=new a,ft=new _t,Pt=new a,Ft=new Q,St=new Q;function Ot(t,e,i){let o=e.vertexFormat,r=e.center,n=e.semiMajorAxis,s=e.semiMinorAxis,l=e.ellipsoid,u=e.stRotation,m=i?t.length/3*2:t.length/3,c=e.shadowVolume,p=o.st?new Float32Array(2*m):void 0,f=o.normal?new Float32Array(3*m):void 0,h=o.tangent?new Float32Array(3*m):void 0,d=o.bitangent?new Float32Array(3*m):void 0,y=c?new Float32Array(3*m):void 0,A=0,x=Tt,g=Nt,_=Et,b=new lt(l),v=b.project(l.cartesianToCartographic(r,ft),Pt),T=l.scaleToGeodeticSurface(r,tt);l.geodeticSurfaceNormal(T,T);let I=Mt,N=Vt;if(0!==u){let t=nt.fromAxisAngle(T,u,gt);I=C.fromQuaternion(t,I),t=nt.fromAxisAngle(T,-u,gt),N=C.fromQuaternion(t,N)}else I=C.clone(C.IDENTITY,I),N=C.clone(C.IDENTITY,N);let E=Q.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,Ft),M=Q.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,St),R=t.length,j=i?R:0,k=j/3*2;for(let e=0;e<R;e+=3){let r=e+1,u=e+2,m=a.fromArray(t,e,tt);if(o.st){let t=C.multiplyByVector(I,m,pt),e=b.project(l.cartesianToCartographic(t,ft),xt);a.subtract(e,v,e),w.x=(e.x+n)/(2*n),w.y=(e.y+s)/(2*s),E.x=Math.min(w.x,E.x),E.y=Math.min(w.y,E.y),M.x=Math.max(w.x,M.x),M.y=Math.max(w.y,M.y),i&&(p[A+k]=w.x,p[A+1+k]=w.y),p[A++]=w.x,p[A++]=w.y}(o.normal||o.tangent||o.bitangent||c)&&(x=l.geodeticSurfaceNormal(m,x),c&&(y[e+j]=-x.x,y[r+j]=-x.y,y[u+j]=-x.z),(o.normal||o.tangent||o.bitangent)&&((o.tangent||o.bitangent)&&(g=a.normalize(a.cross(a.UNIT_Z,x,g),g),C.multiplyByVector(N,g,g)),o.normal&&(f[e]=x.x,f[r]=x.y,f[u]=x.z,i&&(f[e+j]=-x.x,f[r+j]=-x.y,f[u+j]=-x.z)),o.tangent&&(h[e]=g.x,h[r]=g.y,h[u]=g.z,i&&(h[e+j]=-g.x,h[r+j]=-g.y,h[u+j]=-g.z)),o.bitangent&&(_=a.normalize(a.cross(x,g,_),_),d[e]=_.x,d[r]=_.y,d[u]=_.z,i&&(d[e+j]=_.x,d[r+j]=_.y,d[u+j]=_.z))))}if(o.st){R=p.length;for(let t=0;t<R;t+=2)p[t]=(p[t]-E.x)/(M.x-E.x),p[t+1]=(p[t+1]-E.y)/(M.y-E.y)}let S=new ht;if(o.position){let o=G.raisePositionsToHeight(t,e,i);S.position=new F({componentDatatype:P.DOUBLE,componentsPerAttribute:3,values:o})}if(o.st&&(S.st=new F({componentDatatype:P.FLOAT,componentsPerAttribute:2,values:p})),o.normal&&(S.normal=new F({componentDatatype:P.FLOAT,componentsPerAttribute:3,values:f})),o.tangent&&(S.tangent=new F({componentDatatype:P.FLOAT,componentsPerAttribute:3,values:h})),o.bitangent&&(S.bitangent=new F({componentDatatype:P.FLOAT,componentsPerAttribute:3,values:d})),c&&(S.extrudeDirection=new F({componentDatatype:P.FLOAT,componentsPerAttribute:3,values:y})),i&&Z(e.offsetAttribute)){let t=new Uint8Array(m);if(e.offsetAttribute===$.TOP)t=t.fill(1,0,m/2);else{let i=e.offsetAttribute===$.NONE?0:1;t=t.fill(i)}S.applyOffset=new F({componentDatatype:P.UNSIGNED_BYTE,componentsPerAttribute:1,values:t})}return S}function jt(t){let e,i,o,r,n,a=new Array(t*(t+1)*12-6),s=0;for(e=0,o=1,r=0;r<3;r++)a[s++]=o++,a[s++]=e,a[s++]=o;for(r=2;r<t+1;++r){for(o=r*(r+1)-1,e=(r-1)*r-1,a[s++]=o++,a[s++]=e,a[s++]=o,i=2*r,n=0;n<i-1;++n)a[s++]=o,a[s++]=e++,a[s++]=e,a[s++]=o++,a[s++]=e,a[s++]=o;a[s++]=o++,a[s++]=e,a[s++]=o}for(i=2*t,++o,++e,r=0;r<i-1;++r)a[s++]=o,a[s++]=e++,a[s++]=e,a[s++]=o++,a[s++]=e,a[s++]=o;for(a[s++]=o,a[s++]=e++,a[s++]=e,a[s++]=o++,a[s++]=e++,a[s++]=e,++e,r=t-1;r>1;--r){for(a[s++]=e++,a[s++]=e,a[s++]=o,i=2*r,n=0;n<i-1;++n)a[s++]=o,a[s++]=e++,a[s++]=e,a[s++]=o++,a[s++]=e,a[s++]=o;a[s++]=e++,a[s++]=e++,a[s++]=o++}for(r=0;r<3;r++)a[s++]=e++,a[s++]=e,a[s++]=o;return a}var K=new a;function Dt(t){let e=t.center;K=a.multiplyByScalar(t.ellipsoid.geodeticSurfaceNormal(e,K),t.height,K),K=a.add(e,K,K);let i=new it(K,t.semiMajorAxis),o=G.computeEllipsePositions(t,!0,!1),r=o.positions,n=o.numPts,s=Ot(r,t,!1),l=jt(n);return l=st.createTypedArray(r.length/3,l),{boundingSphere:i,attributes:s,indices:l}}function vt(t,e){let i=e.vertexFormat,o=e.center,r=e.semiMajorAxis,n=e.semiMinorAxis,s=e.ellipsoid,l=e.height,u=e.extrudedHeight,m=e.stRotation,c=t.length/3*2,p=new Float64Array(3*c),f=i.st?new Float32Array(2*c):void 0,h=i.normal?new Float32Array(3*c):void 0,d=i.tangent?new Float32Array(3*c):void 0,y=i.bitangent?new Float32Array(3*c):void 0,A=e.shadowVolume,x=A?new Float32Array(3*c):void 0,g=0,_=Tt,b=Nt,v=Et,T=new lt(s),I=T.project(s.cartesianToCartographic(o,ft),Pt),N=s.scaleToGeodeticSurface(o,tt);s.geodeticSurfaceNormal(N,N);let E=nt.fromAxisAngle(N,m,gt),M=C.fromQuaternion(E,Mt),R=Q.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,Ft),j=Q.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,St),k=t.length,S=k/3*2;for(let e=0;e<k;e+=3){let o,m=e+1,c=e+2,P=a.fromArray(t,e,tt);if(i.st){let t=C.multiplyByVector(M,P,pt),e=T.project(s.cartesianToCartographic(t,ft),xt);a.subtract(e,I,e),w.x=(e.x+r)/(2*r),w.y=(e.y+n)/(2*n),R.x=Math.min(w.x,R.x),R.y=Math.min(w.y,R.y),j.x=Math.max(w.x,j.x),j.y=Math.max(w.y,j.y),f[g+S]=w.x,f[g+1+S]=w.y,f[g++]=w.x,f[g++]=w.y}P=s.scaleToGeodeticSurface(P,P),o=a.clone(P,pt),_=s.geodeticSurfaceNormal(P,_),A&&(x[e+k]=-_.x,x[m+k]=-_.y,x[c+k]=-_.z);let F=a.multiplyByScalar(_,l,wt);if(P=a.add(P,F,P),F=a.multiplyByScalar(_,u,F),o=a.add(o,F,o),i.position&&(p[e+k]=o.x,p[m+k]=o.y,p[c+k]=o.z,p[e]=P.x,p[m]=P.y,p[c]=P.z),i.normal||i.tangent||i.bitangent){v=a.clone(_,v);let r=a.fromArray(t,(e+3)%k,wt);a.subtract(r,P,r);let n=a.subtract(o,P,xt);_=a.normalize(a.cross(n,r,_),_),i.normal&&(h[e]=_.x,h[m]=_.y,h[c]=_.z,h[e+k]=_.x,h[m+k]=_.y,h[c+k]=_.z),i.tangent&&(b=a.normalize(a.cross(v,_,b),b),d[e]=b.x,d[m]=b.y,d[c]=b.z,d[e+k]=b.x,d[e+1+k]=b.y,d[e+2+k]=b.z),i.bitangent&&(y[e]=v.x,y[m]=v.y,y[c]=v.z,y[e+k]=v.x,y[m+k]=v.y,y[c+k]=v.z)}}if(i.st){k=f.length;for(let t=0;t<k;t+=2)f[t]=(f[t]-R.x)/(j.x-R.x),f[t+1]=(f[t+1]-R.y)/(j.y-R.y)}let D=new ht;if(i.position&&(D.position=new F({componentDatatype:P.DOUBLE,componentsPerAttribute:3,values:p})),i.st&&(D.st=new F({componentDatatype:P.FLOAT,componentsPerAttribute:2,values:f})),i.normal&&(D.normal=new F({componentDatatype:P.FLOAT,componentsPerAttribute:3,values:h})),i.tangent&&(D.tangent=new F({componentDatatype:P.FLOAT,componentsPerAttribute:3,values:d})),i.bitangent&&(D.bitangent=new F({componentDatatype:P.FLOAT,componentsPerAttribute:3,values:y})),A&&(D.extrudeDirection=new F({componentDatatype:P.FLOAT,componentsPerAttribute:3,values:x})),Z(e.offsetAttribute)){let t=new Uint8Array(c);if(e.offsetAttribute===$.TOP)t=t.fill(1,0,c/2);else{let i=e.offsetAttribute===$.NONE?0:1;t=t.fill(i)}D.applyOffset=new F({componentDatatype:P.UNSIGNED_BYTE,componentsPerAttribute:1,values:t})}return D}function zt(t){let e=t.length/3,i=st.createTypedArray(e,6*e),o=0;for(let t=0;t<e;t++){let r=t,n=t+e,a=(r+1)%e,s=a+e;i[o++]=r,i[o++]=n,i[o++]=a,i[o++]=a,i[o++]=n,i[o++]=s}return i}var mt=new it,ut=new it;function Bt(t){let e=t.center,i=t.ellipsoid,o=t.semiMajorAxis,r=a.multiplyByScalar(i.geodeticSurfaceNormal(e,tt),t.height,tt);mt.center=a.add(e,r,mt.center),mt.radius=o,r=a.multiplyByScalar(i.geodeticSurfaceNormal(e,r),t.extrudedHeight,r),ut.center=a.add(e,r,ut.center),ut.radius=o;let n=G.computeEllipsePositions(t,!0,!0),s=n.positions,l=n.numPts,u=n.outerPositions,m=it.union(mt,ut),c=Ot(s,t,!0),p=jt(l),f=p.length;p.length=2*f;let h=s.length/3;for(let t=0;t<f;t+=3)p[t+f]=p[t+2]+h,p[t+1+f]=p[t+1]+h,p[t+2+f]=p[t]+h;let d=st.createTypedArray(2*h/3,p),y=new rt({attributes:c,indices:d,primitiveType:ct.TRIANGLES}),A=vt(u,t);p=zt(u);let x=st.createTypedArray(2*u.length/3,p),g=new rt({attributes:A,indices:x,primitiveType:ct.TRIANGLES}),_=yt.combineInstances([new At({geometry:y}),new At({geometry:g})]);return{boundingSphere:m,attributes:_[0].attributes,indices:_[0].indices}}function Ct(t,e,i,o,r,n,s){let l=G.computeEllipsePositions({center:t,semiMajorAxis:e,semiMinorAxis:i,rotation:o,granularity:r},!1,!0).outerPositions,u=l.length/3,m=new Array(u);for(let t=0;t<u;++t)m[t]=a.fromArray(l,3*t);let c=bt.fromCartesianArray(m,n,s);return c.width>R.PI&&(c.north=c.north>0?R.PI_OVER_TWO-R.EPSILON7:c.north,c.south=c.south<0?R.EPSILON7-R.PI_OVER_TWO:c.south,c.east=R.PI,c.west=-R.PI),c}function Y(t){let e=(t=t??dt.EMPTY_OBJECT).center,i=t.ellipsoid??D.default,o=t.semiMajorAxis,r=t.semiMinorAxis,n=t.granularity??R.RADIANS_PER_DEGREE,s=t.vertexFormat??v.DEFAULT;if(k.defined("options.center",e),k.typeOf.number("options.semiMajorAxis",o),k.typeOf.number("options.semiMinorAxis",r),o<r)throw new ot("semiMajorAxis must be greater than or equal to the semiMinorAxis.");if(n<=0)throw new ot("granularity must be greater than zero.");let l=t.height??0,u=t.extrudedHeight??l;this._center=a.clone(e),this._semiMajorAxis=o,this._semiMinorAxis=r,this._ellipsoid=D.clone(i),this._rotation=t.rotation??0,this._stRotation=t.stRotation??0,this._height=Math.max(u,l),this._granularity=n,this._vertexFormat=v.clone(s),this._extrudedHeight=Math.min(u,l),this._shadowVolume=t.shadowVolume??!1,this._workerName="createEllipseGeometry",this._offsetAttribute=t.offsetAttribute,this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0}Y.packedLength=a.packedLength+D.packedLength+v.packedLength+9,Y.pack=function(t,e,i){return k.defined("value",t),k.defined("array",e),i=i??0,a.pack(t._center,e,i),i+=a.packedLength,D.pack(t._ellipsoid,e,i),i+=D.packedLength,v.pack(t._vertexFormat,e,i),i+=v.packedLength,e[i++]=t._semiMajorAxis,e[i++]=t._semiMinorAxis,e[i++]=t._rotation,e[i++]=t._stRotation,e[i++]=t._height,e[i++]=t._granularity,e[i++]=t._extrudedHeight,e[i++]=t._shadowVolume?1:0,e[i]=t._offsetAttribute??-1,e};var Rt=new a,It=new D,Lt=new v,H={center:Rt,ellipsoid:It,vertexFormat:Lt,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,shadowVolume:void 0,offsetAttribute:void 0};function kt(t){let e=-t._stRotation;if(0===e)return[0,0,0,1,1,0];let i=G.computeEllipsePositions({center:t._center,semiMajorAxis:t._semiMajorAxis,semiMinorAxis:t._semiMinorAxis,rotation:t._rotation,granularity:t._granularity},!1,!0).outerPositions,o=i.length/3,r=new Array(o);for(let t=0;t<o;++t)r[t]=a.fromArray(i,3*t);let n=t._ellipsoid,s=t.rectangle;return rt._textureCoordinateRotationPoints(r,e,n,s)}Y.unpack=function(t,e,i){k.defined("array",t),e=e??0;let o=a.unpack(t,e,Rt);e+=a.packedLength;let r=D.unpack(t,e,It);e+=D.packedLength;let n=v.unpack(t,e,Lt);e+=v.packedLength;let s=t[e++],l=t[e++],u=t[e++],m=t[e++],c=t[e++],p=t[e++],f=t[e++],h=1===t[e++],d=t[e];return Z(i)?(i._center=a.clone(o,i._center),i._ellipsoid=D.clone(r,i._ellipsoid),i._vertexFormat=v.clone(n,i._vertexFormat),i._semiMajorAxis=s,i._semiMinorAxis=l,i._rotation=u,i._stRotation=m,i._height=c,i._granularity=p,i._extrudedHeight=f,i._shadowVolume=h,i._offsetAttribute=-1===d?void 0:d,i):(H.height=c,H.extrudedHeight=f,H.granularity=p,H.stRotation=m,H.rotation=u,H.semiMajorAxis=s,H.semiMinorAxis=l,H.shadowVolume=h,H.offsetAttribute=-1===d?void 0:d,new Y(H))},Y.computeRectangle=function(t,e){let i=(t=t??dt.EMPTY_OBJECT).center,o=t.ellipsoid??D.default,r=t.semiMajorAxis,n=t.semiMinorAxis,a=t.granularity??R.RADIANS_PER_DEGREE,s=t.rotation??0;if(k.defined("options.center",i),k.typeOf.number("options.semiMajorAxis",r),k.typeOf.number("options.semiMinorAxis",n),r<n)throw new ot("semiMajorAxis must be greater than or equal to the semiMinorAxis.");if(a<=0)throw new ot("granularity must be greater than zero.");return Ct(i,r,n,s,a,o,e)},Y.createGeometry=function(t){if(t._semiMajorAxis<=0||t._semiMinorAxis<=0)return;let e=t._height,i=t._extrudedHeight,o=!R.equalsEpsilon(e,i,0,R.EPSILON2);t._center=t._ellipsoid.scaleToGeodeticSurface(t._center,t._center);let r,n={center:t._center,semiMajorAxis:t._semiMajorAxis,semiMinorAxis:t._semiMinorAxis,ellipsoid:t._ellipsoid,rotation:t._rotation,height:e,granularity:t._granularity,vertexFormat:t._vertexFormat,stRotation:t._stRotation};if(o)n.extrudedHeight=i,n.shadowVolume=t._shadowVolume,n.offsetAttribute=t._offsetAttribute,r=Bt(n);else if(r=Dt(n),Z(t._offsetAttribute)){let e=r.attributes.position.values.length,i=t._offsetAttribute===$.NONE?0:1,o=new Uint8Array(e/3).fill(i);r.attributes.applyOffset=new F({componentDatatype:P.UNSIGNED_BYTE,componentsPerAttribute:1,values:o})}return new rt({attributes:r.attributes,indices:r.indices,primitiveType:ct.TRIANGLES,boundingSphere:r.boundingSphere,offsetAttribute:t._offsetAttribute})},Y.createShadowVolume=function(t,e,i){let o=t._granularity,r=t._ellipsoid,n=e(o,r),a=i(o,r);return new Y({center:t._center,semiMajorAxis:t._semiMajorAxis,semiMinorAxis:t._semiMinorAxis,ellipsoid:r,rotation:t._rotation,stRotation:t._stRotation,granularity:o,extrudedHeight:n,height:a,vertexFormat:v.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(Y.prototype,{rectangle:{get:function(){return Z(this._rectangle)||(this._rectangle=Ct(this._center,this._semiMajorAxis,this._semiMinorAxis,this._rotation,this._granularity,this._ellipsoid)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return Z(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=kt(this)),this._textureCoordinateRotationPoints}}});var de=Y;export{de as a};