/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as wt}from"./chunk-64C3WG2L.js";import{a as C}from"./chunk-QL3VAYCR.js";import{a as kt}from"./chunk-SFW65PGL.js";import{a as Ct}from"./chunk-BTGP76WP.js";import{b as dt,c as _t,d as N}from"./chunk-YQL7OPIW.js";import{d as ht}from"./chunk-DPQZPDIL.js";import{a as M}from"./chunk-4BTDTSQG.js";import{a as s,c as lt,d as it,f as pt}from"./chunk-XFVXIGTK.js";import{a as E}from"./chunk-MPRZ6V46.js";import{a as g}from"./chunk-VZMWSUG7.js";import{e as v}from"./chunk-362ETHZ6.js";var yt=new s,vt=new s,Et=new s,Mt=new s,Nt=new s,Rt=new s(1,1,1),Pt=Math.cos,At=Math.sin;function x(t){let e=(t=t??pt.EMPTY_OBJECT).radii??Rt,i=t.innerRadii??e,n=t.minimumClock??0,a=t.maximumClock??E.TWO_PI,o=t.minimumCone??0,r=t.maximumCone??E.PI,m=Math.round(t.stackPartitions??64),c=Math.round(t.slicePartitions??64),u=t.vertexFormat??C.DEFAULT;if(c<3)throw new g("options.slicePartitions cannot be less than three.");if(m<3)throw new g("options.stackPartitions cannot be less than three.");this._radii=s.clone(e),this._innerRadii=s.clone(i),this._minimumClock=n,this._maximumClock=a,this._minimumCone=o,this._maximumCone=r,this._stackPartitions=m,this._slicePartitions=c,this._vertexFormat=C.clone(u),this._offsetAttribute=t.offsetAttribute,this._workerName="createEllipsoidGeometry"}x.packedLength=2*s.packedLength+C.packedLength+7,x.pack=function(t,e,i){if(!v(t))throw new g("value is required");if(!v(e))throw new g("array is required");return i=i??0,s.pack(t._radii,e,i),i+=s.packedLength,s.pack(t._innerRadii,e,i),i+=s.packedLength,C.pack(t._vertexFormat,e,i),i+=C.packedLength,e[i++]=t._minimumClock,e[i++]=t._maximumClock,e[i++]=t._minimumCone,e[i++]=t._maximumCone,e[i++]=t._stackPartitions,e[i++]=t._slicePartitions,e[i]=t._offsetAttribute??-1,e};var ot,bt=new s,xt=new s,Ot=new C,L={radii:bt,innerRadii:xt,vertexFormat:Ot,minimumClock:void 0,maximumClock:void 0,minimumCone:void 0,maximumCone:void 0,stackPartitions:void 0,slicePartitions:void 0,offsetAttribute:void 0};x.unpack=function(t,e,i){if(!v(t))throw new g("array is required");e=e??0;let n=s.unpack(t,e,bt);e+=s.packedLength;let a=s.unpack(t,e,xt);e+=s.packedLength;let o=C.unpack(t,e,Ot);e+=C.packedLength;let r=t[e++],m=t[e++],c=t[e++],u=t[e++],l=t[e++],f=t[e++],p=t[e];return v(i)?(i._radii=s.clone(n,i._radii),i._innerRadii=s.clone(a,i._innerRadii),i._vertexFormat=C.clone(o,i._vertexFormat),i._minimumClock=r,i._maximumClock=m,i._minimumCone=c,i._maximumCone=u,i._stackPartitions=l,i._slicePartitions=f,i._offsetAttribute=-1===p?void 0:p,i):(L.minimumClock=r,L.maximumClock=m,L.minimumCone=c,L.maximumCone=u,L.stackPartitions=l,L.slicePartitions=f,L.offsetAttribute=-1===p?void 0:p,new x(L))},x.createGeometry=function(t){let e=t._radii;if(e.x<=0||e.y<=0||e.z<=0)return;let i=t._innerRadii;if(i.x<=0||i.y<=0||i.z<=0)return;let n=t._minimumClock,a=t._maximumClock,o=t._minimumCone,r=t._maximumCone,m=t._vertexFormat,c=t._slicePartitions+1,u=t._stackPartitions+1;c=Math.round(c*Math.abs(a-n)/E.TWO_PI),u=Math.round(u*Math.abs(r-o)/E.PI),c<2&&(c=2),u<2&&(u=2);let l,f,p=0,h=[o],_=[n];for(l=0;l<u;l++)h.push(o+l*(r-o)/(u-1));for(h.push(r),f=0;f<c;f++)_.push(n+f*(a-n)/(c-1));_.push(a);let d=h.length,k=_.length,x=0,C=1,w=i.x!==e.x||i.y!==e.y||i.z!==e.z,P=!1,y=!1,A=!1;w&&(C=2,o>0&&(P=!0,x+=c-1),r<Math.PI&&(y=!0,x+=c-1),(a-n)%E.TWO_PI?(A=!0,x+=2*(u-1)+1):x+=1);let g=k*d*C,b=new Float64Array(3*g),L=new Array(g).fill(!1),T=new Array(g).fill(!1),F=c*u*C,O=6*(F+x+1-(c+u)*C),I=kt.createTypedArray(F,O),z=m.normal?new Float32Array(3*g):void 0,D=m.tangent?new Float32Array(3*g):void 0,R=m.bitangent?new Float32Array(3*g):void 0,j=m.st?new Float32Array(2*g):void 0,G=new Array(d),W=new Array(d);for(l=0;l<d;l++)G[l]=At(h[l]),W[l]=Pt(h[l]);let S=new Array(k),U=new Array(k);for(f=0;f<k;f++)U[f]=Pt(_[f]),S[f]=At(_[f]);for(l=0;l<d;l++)for(f=0;f<k;f++)b[p++]=e.x*G[l]*U[f],b[p++]=e.y*G[l]*S[f],b[p++]=e.z*W[l];let B,Y,Z,Q,V=g/2;if(w)for(l=0;l<d;l++)for(f=0;f<k;f++)b[p++]=i.x*G[l]*U[f],b[p++]=i.y*G[l]*S[f],b[p++]=i.z*W[l],L[V]=!0,l>0&&l!==d-1&&0!==f&&f!==k-1&&(T[V]=!0),V++;for(p=0,l=1;l<d-2;l++)for(B=l*k,Y=(l+1)*k,f=1;f<k-2;f++)I[p++]=Y+f,I[p++]=Y+f+1,I[p++]=B+f+1,I[p++]=Y+f,I[p++]=B+f+1,I[p++]=B+f;if(w){let t=d*k;for(l=1;l<d-2;l++)for(B=t+l*k,Y=t+(l+1)*k,f=1;f<k-2;f++)I[p++]=Y+f,I[p++]=B+f,I[p++]=B+f+1,I[p++]=Y+f,I[p++]=B+f+1,I[p++]=Y+f+1}if(w){if(P)for(Q=d*k,l=1;l<k-2;l++)I[p++]=l,I[p++]=l+1,I[p++]=Q+l+1,I[p++]=l,I[p++]=Q+l+1,I[p++]=Q+l;if(y)for(Z=d*k-k,Q=d*k*C-k,l=1;l<k-2;l++)I[p++]=Z+l+1,I[p++]=Z+l,I[p++]=Q+l,I[p++]=Z+l+1,I[p++]=Q+l,I[p++]=Q+l+1}if(A){for(l=1;l<d-2;l++)Q=k*d+k*l,Z=k*l,I[p++]=Q,I[p++]=Z+k,I[p++]=Z,I[p++]=Q,I[p++]=Q+k,I[p++]=Z+k;for(l=1;l<d-2;l++)Q=k*d+k*(l+1)-1,Z=k*(l+1)-1,I[p++]=Z+k,I[p++]=Q,I[p++]=Z,I[p++]=Z+k,I[p++]=Q+k,I[p++]=Q}let q=new Ct;m.position&&(q.position=new N({componentDatatype:M.DOUBLE,componentsPerAttribute:3,values:b}));let K,X=0,H=0,J=0,$=0,tt=g/2,et=it.fromCartesian3(e),nt=it.fromCartesian3(i);if(m.st||m.normal||m.tangent||m.bitangent){for(l=0;l<g;l++){K=L[l]?nt:et;let t=s.fromArray(b,3*l,yt),e=K.geodeticSurfaceNormal(t,vt);if(T[l]&&s.negate(e,e),m.st){let t=lt.negate(e,Nt);j[X++]=Math.atan2(t.y,t.x)/E.TWO_PI+.5,j[X++]=Math.asin(e.z)/Math.PI+.5}if(m.normal&&(z[H++]=e.x,z[H++]=e.y,z[H++]=e.z),m.tangent||m.bitangent){let t,i=Et,n=0;if(L[l]&&(n=tt),t=!P&&l>=n&&l<n+2*k?s.UNIT_X:s.UNIT_Z,s.cross(t,e,i),s.normalize(i,i),m.tangent&&(D[J++]=i.x,D[J++]=i.y,D[J++]=i.z),m.bitangent){let t=s.cross(e,i,Mt);s.normalize(t,t),R[$++]=t.x,R[$++]=t.y,R[$++]=t.z}}}m.st&&(q.st=new N({componentDatatype:M.FLOAT,componentsPerAttribute:2,values:j})),m.normal&&(q.normal=new N({componentDatatype:M.FLOAT,componentsPerAttribute:3,values:z})),m.tangent&&(q.tangent=new N({componentDatatype:M.FLOAT,componentsPerAttribute:3,values:D})),m.bitangent&&(q.bitangent=new N({componentDatatype:M.FLOAT,componentsPerAttribute:3,values:R}))}if(v(t._offsetAttribute)){let e=b.length,i=t._offsetAttribute===wt.NONE?0:1,n=new Uint8Array(e/3).fill(i);q.applyOffset=new N({componentDatatype:M.UNSIGNED_BYTE,componentsPerAttribute:1,values:n})}return new _t({attributes:q,indices:I,primitiveType:dt.TRIANGLES,boundingSphere:ht.fromEllipsoid(et),offsetAttribute:t._offsetAttribute})},x.getUnitEllipsoid=function(){return v(ot)||(ot=x.createGeometry(new x({radii:new s(1,1,1),vertexFormat:C.POSITION_ONLY}))),ot};var Kt=x;export{Kt as a};