/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{c as Z}from"./chunk-DPQZPDIL.js";import{a as o,b as at,e as b}from"./chunk-XFVXIGTK.js";import{a as R}from"./chunk-MPRZ6V46.js";import{a as w,b as tt}from"./chunk-VZMWSUG7.js";import{e as g}from"./chunk-362ETHZ6.js";var et={};function ft(e,t,r){let n=e+t;return R.sign(e)!==R.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}et.computeDiscriminant=function(e,t,r){if("number"!=typeof e)throw new w("a is a required number.");if("number"!=typeof t)throw new w("b is a required number.");if("number"!=typeof r)throw new w("c is a required number.");return t*t-4*e*r},et.computeRealRoots=function(e,t,r){if("number"!=typeof e)throw new w("a is a required number.");if("number"!=typeof t)throw new w("b is a required number.");if("number"!=typeof r)throw new w("c is a required number.");let n;if(0===e)return 0===t?[]:[-r/t];if(0===t){if(0===r)return[0,0];let t=Math.abs(r),i=Math.abs(e);if(t<i&&t/i<R.EPSILON14)return[0,0];if(t>i&&i/t<R.EPSILON14)return[];if(n=-r/e,n<0)return[];let o=Math.sqrt(n);return[-o,o]}if(0===r)return n=-t/e,n<0?[n,0]:[0,n];let i=ft(t*t,-(4*e*r),R.EPSILON14);if(i<0)return[];let o=-.5*ft(t,R.sign(t)*Math.sqrt(i),R.EPSILON14);return t>0?[o/e,r/o]:[r/o,o/e]};var T=et,rt={};function nt(e,t,r,n){let i,o,a=e,u=t/3,s=r/3,l=n,w=a*s,f=u*l,c=u*u,h=s*s,m=a*s-c,d=a*l-u*s,g=u*l-h,p=4*m*g-d*d;if(p<0){let e,t,r;c*f>=w*h?(e=a,t=m,r=-2*u*m+a*d):(e=l,t=g,r=-l*d+2*s*g);let n=-(r<0?-1:1)*Math.abs(e)*Math.sqrt(-p);o=-r+n;let b=o/2,q=b<0?-Math.pow(-b,1/3):Math.pow(b,1/3),R=o===n?-q:-t/q;return i=t<=0?q+R:-r/(q*q+R*R+t),c*f>=w*h?[(i-u)/a]:[-l/(i+s)]}let b=m,q=-2*u*m+a*d,R=g,O=-l*d+2*s*g,M=Math.sqrt(p),y=Math.sqrt(3)/2,S=Math.abs(Math.atan2(a*M,-q)/3);i=2*Math.sqrt(-b);let P=Math.cos(S);o=i*P;let N=i*(-P/2-y*Math.sin(S)),L=o+N>2*u?o-u:N-u,E=a,I=L/E;S=Math.abs(Math.atan2(l*M,-O)/3),i=2*Math.sqrt(-R),P=Math.cos(S),o=i*P,N=i*(-P/2-y*Math.sin(S));let T=-l,v=o+N<2*s?o+s:N+s,x=T/v,z=-L*v-E*T,C=(s*z-u*(L*T))/(-u*z+s*(E*v));return I<=C?I<=x?C<=x?[I,C,x]:[I,x,C]:[x,I,C]:I<=x?[C,I,x]:C<=x?[C,x,I]:[x,C,I]}rt.computeDiscriminant=function(e,t,r,n){if("number"!=typeof e)throw new w("a is a required number.");if("number"!=typeof t)throw new w("b is a required number.");if("number"!=typeof r)throw new w("c is a required number.");if("number"!=typeof n)throw new w("d is a required number.");let i=t*t,o=r*r;return 18*e*t*r*n+i*o-27*(e*e)*(n*n)-4*(e*o*r+i*t*n)},rt.computeRealRoots=function(e,t,r,n){if("number"!=typeof e)throw new w("a is a required number.");if("number"!=typeof t)throw new w("b is a required number.");if("number"!=typeof r)throw new w("c is a required number.");if("number"!=typeof n)throw new w("d is a required number.");let i,o;if(0===e)return T.computeRealRoots(t,r,n);if(0===t){if(0===r){if(0===n)return[0,0,0];o=-n/e;let t=o<0?-Math.pow(-o,1/3):Math.pow(o,1/3);return[t,t,t]}return 0===n?(i=T.computeRealRoots(e,0,r),0===i.Length?[0]:[i[0],0,i[1]]):nt(e,0,r,n)}return 0===r?0===n?(o=-t/e,o<0?[o,0,0]:[0,0,o]):nt(e,t,0,n):0===n?(i=T.computeRealRoots(e,t,r),0===i.length?[0]:i[1]<=0?[i[0],i[1],0]:i[0]>=0?[0,i[0],i[1]]:[i[0],0,i[1]]):nt(e,t,r,n)};var Y=rt,ot={};function z(e,t,r,n){let i=e*e,o=t-3*i/8,a=r-t*e/2+i*e/8,u=n-r*e/4+t*i/16-3*i*i/256,s=Y.computeRealRoots(1,2*o,o*o-4*u,-a*a);if(s.length>0){let t=-e/4,r=s[s.length-1];if(Math.abs(r)<R.EPSILON14){let e=T.computeRealRoots(1,o,u);if(2===e.length){let r,n=e[0],i=e[1];if(n>=0&&i>=0){let e=Math.sqrt(n),r=Math.sqrt(i);return[t-r,t-e,t+e,t+r]}if(n>=0&&i<0)return r=Math.sqrt(n),[t-r,t+r];if(n<0&&i>=0)return r=Math.sqrt(i),[t-r,t+r]}return[]}if(r>0){let e=Math.sqrt(r),n=(o+r-a/e)/2,i=(o+r+a/e)/2,u=T.computeRealRoots(1,e,n),s=T.computeRealRoots(1,-e,i);return 0!==u.length?(u[0]+=t,u[1]+=t,0!==s.length?(s[0]+=t,s[1]+=t,u[1]<=s[0]?[u[0],u[1],s[0],s[1]]:s[1]<=u[0]?[s[0],s[1],u[0],u[1]]:u[0]>=s[0]&&u[1]<=s[1]?[s[0],u[0],u[1],s[1]]:s[0]>=u[0]&&s[1]<=u[1]?[u[0],s[0],s[1],u[1]]:u[0]>s[0]&&u[0]<s[1]?[s[0],u[0],s[1],u[1]]:[u[0],s[0],u[1],s[1]]):u):0!==s.length?(s[0]+=t,s[1]+=t,s):[]}}return[]}function H(e,t,r,n){let i=e*e,o=-2*t,a=r*e+t*t-4*n,u=i*n-r*t*e+r*r,s=Y.computeRealRoots(1,o,a,u);if(s.length>0){let o,a,u,l,w,f,c=s[0],h=t-c,m=h*h,d=e/2,g=h/2,p=m-4*n,b=m+4*Math.abs(n),q=i-4*c,O=i+4*Math.abs(c);if(c<0||p*O<q*b){let t=Math.sqrt(q);o=t/2,a=0===t?0:(e*g-r)/t}else{let t=Math.sqrt(p);o=0===t?0:(e*g-r)/t,a=t/2}0===d&&0===o?(u=0,l=0):R.sign(d)===R.sign(o)?(u=d+o,l=c/u):(l=d-o,u=c/l),0===g&&0===a?(w=0,f=0):R.sign(g)===R.sign(a)?(w=g+a,f=n/w):(f=g-a,w=n/f);let M=T.computeRealRoots(1,u,w),y=T.computeRealRoots(1,l,f);if(0!==M.length)return 0!==y.length?M[1]<=y[0]?[M[0],M[1],y[0],y[1]]:y[1]<=M[0]?[y[0],y[1],M[0],M[1]]:M[0]>=y[0]&&M[1]<=y[1]?[y[0],M[0],M[1],y[1]]:y[0]>=M[0]&&y[1]<=M[1]?[M[0],y[0],y[1],M[1]]:M[0]>y[0]&&M[0]<y[1]?[y[0],M[0],y[1],M[1]]:[M[0],y[0],M[1],y[1]]:M;if(0!==y.length)return y}return[]}ot.computeDiscriminant=function(e,t,r,n,i){if("number"!=typeof e)throw new w("a is a required number.");if("number"!=typeof t)throw new w("b is a required number.");if("number"!=typeof r)throw new w("c is a required number.");if("number"!=typeof n)throw new w("d is a required number.");if("number"!=typeof i)throw new w("e is a required number.");let o=e*e,a=t*t,u=a*t,s=r*r,l=s*r,f=n*n,c=f*n,h=i*i;return a*s*f-4*u*c-4*e*l*f+18*e*t*r*c-27*o*f*f+256*(o*e)*(h*i)+i*(18*u*r*n-4*a*l+16*e*s*s-80*e*t*s*n-6*e*a*f+144*o*r*f)+h*(144*e*a*r-27*a*a-128*o*s-192*o*t*n)},ot.computeRealRoots=function(e,t,r,n,i){if("number"!=typeof e)throw new w("a is a required number.");if("number"!=typeof t)throw new w("b is a required number.");if("number"!=typeof r)throw new w("c is a required number.");if("number"!=typeof n)throw new w("d is a required number.");if("number"!=typeof i)throw new w("e is a required number.");if(Math.abs(e)<R.EPSILON15)return Y.computeRealRoots(t,r,n,i);let o=t/e,a=r/e,u=n/e,s=i/e,l=o<0?1:0;switch(l+=a<0?l+1:l,l+=u<0?l+1:l,l+=s<0?l+1:l,l){case 0:case 3:case 4:case 6:case 7:case 9:case 10:case 12:case 13:case 14:case 15:return z(o,a,u,s);case 1:case 2:case 5:case 8:case 11:return H(o,a,u,s);default:return}};var dt=ot;function F(e,t){t=o.clone(t??o.ZERO),o.equals(t,o.ZERO)||o.normalize(t,t),this.origin=o.clone(e??o.ZERO),this.direction=t}F.clone=function(e,t){if(g(e))return g(t)?(t.origin=o.clone(e.origin),t.direction=o.clone(e.direction),t):new F(e.origin,e.direction)},F.getPoint=function(e,t,r){return tt.typeOf.object("ray",e),tt.typeOf.number("t",t),g(r)||(r=new o),r=o.multiplyByScalar(e.direction,t,r),o.add(e.origin,r,r)};var it=F,O={rayPlane:function(e,t,r){if(!g(e))throw new w("ray is required.");if(!g(t))throw new w("plane is required.");g(r)||(r=new o);let n=e.origin,i=e.direction,a=t.normal,u=o.dot(a,i);if(Math.abs(u)<R.EPSILON15)return;let s=(-t.distance-o.dot(a,n))/u;return s<0?void 0:(r=o.multiplyByScalar(i,s,r),o.add(n,r,r))}},bt=new o,Ot=new o,St=new o,mt=new o,lt=new o;O.rayTriangleParametric=function(e,t,r,n,i){if(!g(e))throw new w("ray is required.");if(!g(t))throw new w("p0 is required.");if(!g(r))throw new w("p1 is required.");if(!g(n))throw new w("p2 is required.");i=i??!1;let a,u,s,l,f,c=e.origin,h=e.direction,m=o.subtract(r,t,bt),d=o.subtract(n,t,Ot),p=o.cross(h,d,St),b=o.dot(m,p);if(i){if(b<R.EPSILON6||(a=o.subtract(c,t,mt),s=o.dot(a,p),s<0||s>b)||(u=o.cross(a,m,lt),l=o.dot(h,u),l<0||s+l>b))return;f=o.dot(d,u)/b}else{if(Math.abs(b)<R.EPSILON6)return;let e=1/b;if(a=o.subtract(c,t,mt),s=o.dot(a,p)*e,s<0||s>1||(u=o.cross(a,m,lt),l=o.dot(h,u)*e,l<0||s+l>1))return;f=o.dot(d,u)*e}return f},O.rayTriangle=function(e,t,r,n,i,a){let u=O.rayTriangleParametric(e,t,r,n,i);if(g(u)&&!(u<0))return g(a)||(a=new o),o.multiplyByScalar(e.direction,u,a),o.add(e.origin,a,a)};var Pt=new it;function Et(e,t,r,n){let i=t*t-4*e*r;if(i<0)return;if(i>0){let r=1/(2*e),o=Math.sqrt(i),a=(-t+o)*r,u=(-t-o)*r;return a<u?(n.root0=a,n.root1=u):(n.root0=u,n.root1=a),n}let o=-t/(2*e);return 0!==o?(n.root0=n.root1=o,n):void 0}O.lineSegmentTriangle=function(e,t,r,n,i,a,u){if(!g(e))throw new w("v0 is required.");if(!g(t))throw new w("v1 is required.");if(!g(r))throw new w("p0 is required.");if(!g(n))throw new w("p1 is required.");if(!g(i))throw new w("p2 is required.");let s=Pt;o.clone(e,s.origin),o.subtract(t,e,s.direction),o.normalize(s.direction,s.direction);let l=O.rayTriangleParametric(s,r,n,i,a);if(!(!g(l)||l<0||l>o.distance(e,t)))return g(u)||(u=new o),o.multiplyByScalar(s.direction,l,u),o.add(s.origin,u,u)};var Ct={root0:0,root1:0};function Mt(e,t,r){g(r)||(r=new Z);let n=e.origin,i=e.direction,a=t.center,u=t.radius*t.radius,s=o.subtract(n,a,St),l=Et(o.dot(i,i),2*o.dot(i,s),o.magnitudeSquared(s)-u,Ct);if(g(l))return r.start=l.root0,r.stop=l.root1,r}O.raySphere=function(e,t,r){if(!g(e))throw new w("ray is required.");if(!g(t))throw new w("sphere is required.");if(r=Mt(e,t,r),g(r)&&!(r.stop<0))return r.start=Math.max(r.start,0),r};var Nt=new it;O.lineSegmentSphere=function(e,t,r,n){if(!g(e))throw new w("p0 is required.");if(!g(t))throw new w("p1 is required.");if(!g(r))throw new w("sphere is required.");let i=Nt;o.clone(e,i.origin);let a=o.subtract(t,e,i.direction),u=o.magnitude(a);if(o.normalize(a,a),n=Mt(i,r,n),!(!g(n)||n.stop<0||n.start>u))return n.start=Math.max(n.start,0),n.stop=Math.min(n.stop,u),n};var Lt=new o,It=new o;function Q(e,t,r){let n=e+t;return R.sign(e)!==R.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}O.rayEllipsoid=function(e,t){if(!g(e))throw new w("ray is required.");if(!g(t))throw new w("ellipsoid is required.");let r,n,i,a,u,s=t.oneOverRadii,l=o.multiplyComponents(s,e.origin,Lt),f=o.multiplyComponents(s,e.direction,It),c=o.magnitudeSquared(l),h=o.dot(l,f);if(c>1){if(h>=0)return;let e=h*h;if(r=c-1,n=o.magnitudeSquared(f),i=n*r,e<i)return;if(e>i){a=h*h-i,u=-h+Math.sqrt(a);let e=u/n,t=r/u;return e<t?new Z(e,t):{start:t,stop:e}}let t=Math.sqrt(r/n);return new Z(t,t)}return c<1?(r=c-1,n=o.magnitudeSquared(f),i=n*r,a=h*h-i,u=-h+Math.sqrt(a),new Z(0,u/n)):h<0?(n=o.magnitudeSquared(f),new Z(0,-h/n)):void 0},O.quadraticVectorExpression=function(e,t,r,n,i){let a,u=n*n,s=i*i,l=(e[b.COLUMN1ROW1]-e[b.COLUMN2ROW2])*s,w=i*(n*Q(e[b.COLUMN1ROW0],e[b.COLUMN0ROW1],R.EPSILON15)+t.y),f=e[b.COLUMN0ROW0]*u+e[b.COLUMN2ROW2]*s+n*t.x+r,c=s*Q(e[b.COLUMN2ROW1],e[b.COLUMN1ROW2],R.EPSILON15),h=i*(n*Q(e[b.COLUMN2ROW0],e[b.COLUMN0ROW2])+t.z),m=[];if(0===h&&0===c){if(a=T.computeRealRoots(l,w,f),0===a.length)return m;let e=a[0],t=Math.sqrt(Math.max(1-e*e,0));if(m.push(new o(n,i*e,i*-t)),m.push(new o(n,i*e,i*t)),2===a.length){let e=a[1],t=Math.sqrt(Math.max(1-e*e,0));m.push(new o(n,i*e,i*-t)),m.push(new o(n,i*e,i*t))}return m}let d=h*h,g=c*c,p=h*c,q=l*l+g,O=2*(w*l+p),M=2*f*l+w*w-g+d,y=2*(f*w-p),S=f*f-d;if(0===q&&0===O&&0===M&&0===y)return m;a=dt.computeRealRoots(q,O,M,y,S);let P=a.length;if(0===P)return m;for(let e=0;e<P;++e){let t,r=a[e],u=r*r,s=Math.max(1-u,0),d=Math.sqrt(s);t=R.sign(l)===R.sign(f)?Q(l*u+f,w*r,R.EPSILON12):R.sign(f)===R.sign(w*r)?Q(l*u,w*r+f,R.EPSILON12):Q(l*u+w*r,f,R.EPSILON12);let g=t*Q(c*r,h,R.EPSILON15);g<0?m.push(new o(n,i*r,i*d)):g>0?m.push(new o(n,i*r,i*-d)):0!==d?(m.push(new o(n,i*r,i*-d)),m.push(new o(n,i*r,i*d)),++e):m.push(new o(n,i*r,i*d))}return m};var st=new o,ht=new o,wt=new o,J=new o,Dt=new o,Bt=new b,xt=new b,Tt=new b,zt=new b,Wt=new b,qt=new b,gt=new b,pt=new o,vt=new o,Ut=new at;O.grazingAltitudeLocation=function(e,t){if(!g(e))throw new w("ray is required.");if(!g(t))throw new w("ellipsoid is required.");let r=e.origin,n=e.direction;if(!o.equals(r,o.ZERO)){let e=t.geodeticSurfaceNormal(r,st);if(o.dot(n,e)>=0)return r}let i=g(this.rayEllipsoid(e,t)),a=t.transformPositionToScaledSpace(n,st),u=o.normalize(a,a),s=o.mostOrthogonalAxis(a,J),l=o.normalize(o.cross(s,u,ht),ht),f=o.normalize(o.cross(u,l,wt),wt),c=Bt;c[0]=u.x,c[1]=u.y,c[2]=u.z,c[3]=l.x,c[4]=l.y,c[5]=l.z,c[6]=f.x,c[7]=f.y,c[8]=f.z;let h=b.transpose(c,xt),m=b.fromScale(t.radii,Tt),d=b.fromScale(t.oneOverRadii,zt),p=Wt;p[0]=0,p[1]=-n.z,p[2]=n.y,p[3]=n.z,p[4]=0,p[5]=-n.x,p[6]=-n.y,p[7]=n.x,p[8]=0;let q,M,y=b.multiply(b.multiply(h,d,qt),p,qt),S=b.multiply(b.multiply(y,m,gt),c,gt),P=b.multiplyByVector(y,r,Dt),N=O.quadraticVectorExpression(S,o.negate(P,st),0,0,1),L=N.length;if(L>0){let e=o.clone(o.ZERO,vt),a=Number.NEGATIVE_INFINITY;for(let t=0;t<L;++t){q=b.multiplyByVector(m,b.multiplyByVector(c,N[t],pt),pt);let i=o.normalize(o.subtract(q,r,J),J),u=o.dot(i,n);u>a&&(a=u,e=o.clone(q,e))}let u=t.cartesianToCartographic(e,Ut);return a=R.clamp(a,0,1),M=o.magnitude(o.subtract(e,r,J))*Math.sqrt(1-a*a),M=i?-M:M,u.height=M,t.cartographicToCartesian(u,new o)}};var Vt=new o;O.lineSegmentPlane=function(e,t,r,n){if(!g(e))throw new w("endPoint0 is required.");if(!g(t))throw new w("endPoint1 is required.");if(!g(r))throw new w("plane is required.");g(n)||(n=new o);let i=o.subtract(t,e,Vt),a=r.normal,u=o.dot(a,i);if(Math.abs(u)<R.EPSILON6)return;let s=o.dot(a,e),l=-(r.distance+s)/u;return l<0||l>1?void 0:(o.multiplyByScalar(i,l,n),o.add(e,n,n),n)},O.trianglePlaneIntersection=function(e,t,r,n){if(!(g(e)&&g(t)&&g(r)&&g(n)))throw new w("p0, p1, p2, and plane are required.");let i,a,u=n.normal,s=n.distance,l=o.dot(u,e)+s<0,f=o.dot(u,t)+s<0,c=o.dot(u,r)+s<0,h=0;if(h+=l?1:0,h+=f?1:0,h+=c?1:0,(1===h||2===h)&&(i=new o,a=new o),1===h){if(l)return O.lineSegmentPlane(e,t,n,i),O.lineSegmentPlane(e,r,n,a),{positions:[e,t,r,i,a],indices:[0,3,4,1,2,4,1,4,3]};if(f)return O.lineSegmentPlane(t,r,n,i),O.lineSegmentPlane(t,e,n,a),{positions:[e,t,r,i,a],indices:[1,3,4,2,0,4,2,4,3]};if(c)return O.lineSegmentPlane(r,e,n,i),O.lineSegmentPlane(r,t,n,a),{positions:[e,t,r,i,a],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===h){if(!l)return O.lineSegmentPlane(t,e,n,i),O.lineSegmentPlane(r,e,n,a),{positions:[e,t,r,i,a],indices:[1,2,4,1,4,3,0,3,4]};if(!f)return O.lineSegmentPlane(r,t,n,i),O.lineSegmentPlane(e,t,n,a),{positions:[e,t,r,i,a],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return O.lineSegmentPlane(e,r,n,i),O.lineSegmentPlane(t,r,n,a),{positions:[e,t,r,i,a],indices:[0,1,4,0,4,3,2,3,4]}}};var me=O;export{it as a,me as b};