/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as J}from"./chunk-WZSOKNIB.js";import{a as I}from"./chunk-ZCCOD3XE.js";import{b as B,c as G,d as k}from"./chunk-DPQZPDIL.js";import{b as j,h as X}from"./chunk-YJEV67VS.js";import{a as t,b as S,c as z,d as F,e as d}from"./chunk-XFVXIGTK.js";import{a as g}from"./chunk-MPRZ6V46.js";import{a as b,b as W}from"./chunk-VZMWSUG7.js";import{e as p}from"./chunk-362ETHZ6.js";function w(e,n){this.center=t.clone(e??t.ZERO),this.halfAxes=d.clone(n??d.ZERO)}w.packedLength=t.packedLength+d.packedLength,w.pack=function(e,n,a){return W.typeOf.object("value",e),W.defined("array",n),a=a??0,t.pack(e.center,n,a),d.pack(e.halfAxes,n,a+t.packedLength),n},w.unpack=function(e,n,a){return W.defined("array",e),n=n??0,p(a)||(a=new w),t.unpack(e,n,a.center),d.unpack(e,n+t.packedLength,a.halfAxes),a};var pt=new t,Ct=new t,ut=new t,Pt=new t,xt=new t,yt=new t,At=new d,Nt={unitary:new d,diagonal:new d};w.fromPoints=function(e,n){if(p(n)||(n=new w),!p(e)||0===e.length)return n.halfAxes=d.ZERO,n.center=t.ZERO,n;let a,r=e.length,o=t.clone(e[0],pt);for(a=1;a<r;a++)t.add(o,e[a],o);let i=1/r;t.multiplyByScalar(o,i,o);let s,c=0,u=0,l=0,h=0,m=0,f=0;for(a=0;a<r;a++)s=t.subtract(e[a],o,Ct),c+=s.x*s.x,u+=s.x*s.y,l+=s.x*s.z,h+=s.y*s.y,m+=s.y*s.z,f+=s.z*s.z;c*=i,u*=i,l*=i,h*=i,m*=i,f*=i;let b=At;b[0]=c,b[1]=u,b[2]=l,b[3]=u,b[4]=h,b[5]=m,b[6]=l,b[7]=m,b[8]=f;let x=d.computeEigenDecomposition(b,Nt),g=d.clone(x.unitary,n.halfAxes),y=d.getColumn(g,0,Pt),M=d.getColumn(g,1,xt),O=d.getColumn(g,2,yt),N=-Number.MAX_VALUE,T=-Number.MAX_VALUE,I=-Number.MAX_VALUE,A=Number.MAX_VALUE,S=Number.MAX_VALUE,C=Number.MAX_VALUE;for(a=0;a<r;a++)s=e[a],N=Math.max(t.dot(y,s),N),T=Math.max(t.dot(M,s),T),I=Math.max(t.dot(O,s),I),A=Math.min(t.dot(y,s),A),S=Math.min(t.dot(M,s),S),C=Math.min(t.dot(O,s),C);y=t.multiplyByScalar(y,.5*(A+N),y),M=t.multiplyByScalar(M,.5*(S+T),M),O=t.multiplyByScalar(O,.5*(C+I),O);let P=t.add(y,M,n.center);t.add(P,O,P);let R=ut;return R.x=N-A,R.y=T-S,R.z=I-C,t.multiplyByScalar(R,.5,R),d.multiplyByScale(n.halfAxes,R,n.halfAxes),n};var et=new t,Mt=new t;function K(e,n,a,r,o,i,s,c,u,l,h){if(!(p(o)&&p(i)&&p(s)&&p(c)&&p(u)&&p(l)))throw new b("all extents (minimum/maximum X/Y/Z) are required.");p(h)||(h=new w);let m=h.halfAxes;d.setColumn(m,0,n,m),d.setColumn(m,1,a,m),d.setColumn(m,2,r,m);let f=et;f.x=(o+i)/2,f.y=(s+c)/2,f.z=(u+l)/2;let x=Mt;x.x=(i-o)/2,x.y=(c-s)/2,x.z=(l-u)/2;let g=h.center;return f=d.multiplyByVector(m,f,f),t.add(e,f,g),d.multiplyByScale(m,x,m),h}var Q=new S,Ot=new t,bt=new S,Tt=new S,St=new S,gt=new S,Et=new S,Rt=new t,$=new t,Wt=new t,H=new t,zt=new t,It=new z,Lt=new z,Ut=new z,qt=new z,jt=new z,Bt=new t,vt=new t,_t=new t,Vt=new t,Dt=new z,Xt=new t,kt=new t,Zt=new t,Yt=new I(t.UNIT_X,0);w.fromRectangle=function(e,n,a,r,o){if(!p(e))throw new b("rectangle is required");if(e.width<0||e.width>g.TWO_PI)throw new b("Rectangle width must be between 0 and 2 * pi");if(e.height<0||e.height>g.PI)throw new b("Rectangle height must be between 0 and pi");if(p(r)&&!g.equalsEpsilon(r.radii.x,r.radii.y,g.EPSILON15))throw new b("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");let i,s,c,d,u,l,w;if(n=n??0,a=a??0,r=r??F.default,e.width<=g.PI){let t=X.center(e,Q),h=r.cartographicToCartesian(t,Ot),m=new J(h,r);w=m.plane;let p=t.longitude,f=e.south<0&&e.north>0?0:t.latitude,b=S.fromRadians(p,e.north,a,bt),x=S.fromRadians(e.west,e.north,a,Tt),g=S.fromRadians(e.west,f,a,St),y=S.fromRadians(e.west,e.south,a,gt),M=S.fromRadians(p,e.south,a,Et),O=r.cartographicToCartesian(b,Rt),N=r.cartographicToCartesian(x,$),T=r.cartographicToCartesian(g,Wt),A=r.cartographicToCartesian(y,H),C=r.cartographicToCartesian(M,zt),P=m.projectPointToNearestOnPlane(O,It),R=m.projectPointToNearestOnPlane(N,Lt),E=m.projectPointToNearestOnPlane(T,Ut),z=m.projectPointToNearestOnPlane(A,qt),U=m.projectPointToNearestOnPlane(C,jt);return i=Math.min(R.x,E.x,z.x),s=-i,d=Math.max(R.y,P.y),c=Math.min(z.y,U.y),x.height=y.height=n,N=r.cartographicToCartesian(x,$),A=r.cartographicToCartesian(y,H),u=Math.min(I.getPointDistance(w,N),I.getPointDistance(w,A)),l=a,K(m.origin,m.xAxis,m.yAxis,m.zAxis,i,s,c,d,u,l,o)}let h=e.south>0,m=e.north<0,f=h?e.south:m?e.north:0,x=X.center(e,Q).longitude,y=t.fromRadians(x,f,a,r,Bt);y.z=0;let M=Math.abs(y.x)<g.EPSILON10&&Math.abs(y.y)<g.EPSILON10?t.UNIT_X:t.normalize(y,vt),O=t.UNIT_Z,N=t.cross(M,O,_t);w=I.fromPointNormal(y,M,Yt);let T=t.fromRadians(x+g.PI_OVER_TWO,f,a,r,Vt);s=t.dot(I.projectPointOntoPlane(w,T,Dt),N),i=-s,d=t.fromRadians(0,e.north,m?n:a,r,Xt).z,c=t.fromRadians(0,e.south,h?n:a,r,kt).z;let A=t.fromRadians(e.east,f,a,r,Zt);return u=I.getPointDistance(w,A),l=0,K(y,N,O,M,i,s,c,d,u,l,o)},w.fromTransformation=function(t,e){return W.typeOf.object("transformation",t),p(e)||(e=new w),e.center=j.getTranslation(t,e.center),e.halfAxes=j.getMatrix3(t,e.halfAxes),e.halfAxes=d.multiplyByScalar(e.halfAxes,.5,e.halfAxes),e},w.clone=function(e,n){if(p(e))return p(n)?(t.clone(e.center,n.center),d.clone(e.halfAxes,n.halfAxes),n):new w(e.center,e.halfAxes)},w.intersectPlane=function(e,n){if(!p(e))throw new b("box is required.");if(!p(n))throw new b("plane is required.");let a=e.center,r=n.normal,o=e.halfAxes,i=r.x,s=r.y,c=r.z,u=Math.abs(i*o[d.COLUMN0ROW0]+s*o[d.COLUMN0ROW1]+c*o[d.COLUMN0ROW2])+Math.abs(i*o[d.COLUMN1ROW0]+s*o[d.COLUMN1ROW1]+c*o[d.COLUMN1ROW2])+Math.abs(i*o[d.COLUMN2ROW0]+s*o[d.COLUMN2ROW1]+c*o[d.COLUMN2ROW2]),l=t.dot(r,a)+n.distance;return l<=-u?B.OUTSIDE:l>=u?B.INSIDE:B.INTERSECTING};var nt=new t,at=new t,ct=new t,Ft=new t,tt=new t,Gt=new t;w.distanceSquaredTo=function(e,n){if(!p(e))throw new b("box is required.");if(!p(n))throw new b("cartesian is required.");let a=t.subtract(n,e.center,et),r=e.halfAxes,o=d.getColumn(r,0,nt),i=d.getColumn(r,1,at),s=d.getColumn(r,2,ct),c=t.magnitude(o),u=t.magnitude(i),l=t.magnitude(s),w=!0,h=!0,m=!0;c>0?t.divideByScalar(o,c,o):w=!1,u>0?t.divideByScalar(i,u,i):h=!1,l>0?t.divideByScalar(s,l,s):m=!1;let f,x,y,M=!w+!h+!m;if(1===M){let e=o;f=i,x=s,h?m||(e=s,x=o):(e=i,f=o),y=t.cross(f,x,tt),e===o?o=y:e===i?i=y:e===s&&(s=y)}else if(2===M){f=o,h?f=i:m&&(f=s);let e=t.UNIT_Y;e.equalsEpsilon(f,g.EPSILON3)&&(e=t.UNIT_X),x=t.cross(f,e,Ft),t.normalize(x,x),y=t.cross(f,x,tt),t.normalize(y,y),f===o?(i=x,s=y):f===i?(s=x,o=y):f===s&&(o=x,i=y)}else 3===M&&(o=t.UNIT_X,i=t.UNIT_Y,s=t.UNIT_Z);let O=Gt;O.x=t.dot(a,o),O.y=t.dot(a,i),O.z=t.dot(a,s);let N,T=0;return O.x<-c?(N=O.x+c,T+=N*N):O.x>c&&(N=O.x-c,T+=N*N),O.y<-u?(N=O.y+u,T+=N*N):O.y>u&&(N=O.y-u,T+=N*N),O.z<-l?(N=O.z+l,T+=N*N):O.z>l&&(N=O.z-l,T+=N*N),T};var Jt=new t,Kt=new t;w.computePlaneDistances=function(e,n,a,r){if(!p(e))throw new b("box is required.");if(!p(n))throw new b("position is required.");if(!p(a))throw new b("direction is required.");p(r)||(r=new G);let o=Number.POSITIVE_INFINITY,i=Number.NEGATIVE_INFINITY,s=e.center,c=e.halfAxes,u=d.getColumn(c,0,nt),l=d.getColumn(c,1,at),w=d.getColumn(c,2,ct),h=t.add(u,l,Jt);t.add(h,w,h),t.add(h,s,h);let m=t.subtract(h,n,Kt),f=t.dot(a,m);return o=Math.min(f,o),i=Math.max(f,i),t.add(s,u,h),t.add(h,l,h),t.subtract(h,w,h),t.subtract(h,n,m),f=t.dot(a,m),o=Math.min(f,o),i=Math.max(f,i),t.add(s,u,h),t.subtract(h,l,h),t.add(h,w,h),t.subtract(h,n,m),f=t.dot(a,m),o=Math.min(f,o),i=Math.max(f,i),t.add(s,u,h),t.subtract(h,l,h),t.subtract(h,w,h),t.subtract(h,n,m),f=t.dot(a,m),o=Math.min(f,o),i=Math.max(f,i),t.subtract(s,u,h),t.add(h,l,h),t.add(h,w,h),t.subtract(h,n,m),f=t.dot(a,m),o=Math.min(f,o),i=Math.max(f,i),t.subtract(s,u,h),t.add(h,l,h),t.subtract(h,w,h),t.subtract(h,n,m),f=t.dot(a,m),o=Math.min(f,o),i=Math.max(f,i),t.subtract(s,u,h),t.subtract(h,l,h),t.add(h,w,h),t.subtract(h,n,m),f=t.dot(a,m),o=Math.min(f,o),i=Math.max(f,i),t.subtract(s,u,h),t.subtract(h,l,h),t.subtract(h,w,h),t.subtract(h,n,m),f=t.dot(a,m),o=Math.min(f,o),i=Math.max(f,i),r.start=o,r.stop=i,r};var Qt=new t,$t=new t,Ht=new t;w.computeCorners=function(e,n){W.typeOf.object("box",e),p(n)||(n=[new t,new t,new t,new t,new t,new t,new t,new t]);let a=e.center,r=e.halfAxes,o=d.getColumn(r,0,Qt),i=d.getColumn(r,1,$t),s=d.getColumn(r,2,Ht);return t.clone(a,n[0]),t.subtract(n[0],o,n[0]),t.subtract(n[0],i,n[0]),t.subtract(n[0],s,n[0]),t.clone(a,n[1]),t.subtract(n[1],o,n[1]),t.subtract(n[1],i,n[1]),t.add(n[1],s,n[1]),t.clone(a,n[2]),t.subtract(n[2],o,n[2]),t.add(n[2],i,n[2]),t.subtract(n[2],s,n[2]),t.clone(a,n[3]),t.subtract(n[3],o,n[3]),t.add(n[3],i,n[3]),t.add(n[3],s,n[3]),t.clone(a,n[4]),t.add(n[4],o,n[4]),t.subtract(n[4],i,n[4]),t.subtract(n[4],s,n[4]),t.clone(a,n[5]),t.add(n[5],o,n[5]),t.subtract(n[5],i,n[5]),t.add(n[5],s,n[5]),t.clone(a,n[6]),t.add(n[6],o,n[6]),t.add(n[6],i,n[6]),t.subtract(n[6],s,n[6]),t.clone(a,n[7]),t.add(n[7],o,n[7]),t.add(n[7],i,n[7]),t.add(n[7],s,n[7]),n};var te=new d;w.computeTransformation=function(t,e){W.typeOf.object("box",t),p(e)||(e=new j);let n=t.center,a=d.multiplyByUniformScale(t.halfAxes,2,te);return j.fromRotationTranslation(a,n,e)};var ee=new k;w.isOccluded=function(t,e){if(!p(t))throw new b("box is required.");if(!p(e))throw new b("occluder is required.");let n=k.fromOrientedBoundingBox(t,ee);return!e.isBoundingSphereVisible(n)},w.prototype.intersectPlane=function(t){return w.intersectPlane(this,t)},w.prototype.distanceSquaredTo=function(t){return w.distanceSquaredTo(this,t)},w.prototype.computePlaneDistances=function(t,e,n){return w.computePlaneDistances(this,t,e,n)},w.prototype.computeCorners=function(t){return w.computeCorners(this,t)},w.prototype.computeTransformation=function(t){return w.computeTransformation(this,t)},w.prototype.isOccluded=function(t){return w.isOccluded(this,t)},w.equals=function(e,n){return e===n||p(e)&&p(n)&&t.equals(e.center,n.center)&&d.equals(e.halfAxes,n.halfAxes)},w.prototype.clone=function(t){return w.clone(this,t)},w.prototype.equals=function(t){return w.equals(this,t)};var Pe=w;export{Pe as a};