/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as L}from"./chunk-ESSNY5GC.js";import{a as S}from"./chunk-64C3WG2L.js";import{a as D}from"./chunk-SFW65PGL.js";import{a as H}from"./chunk-BTGP76WP.js";import{b as T,c as B,d as x}from"./chunk-YQL7OPIW.js";import{d as E}from"./chunk-DPQZPDIL.js";import{a as O}from"./chunk-4BTDTSQG.js";import{a as c,d,f as V}from"./chunk-XFVXIGTK.js";import{a as w}from"./chunk-MPRZ6V46.js";import{a as A}from"./chunk-VZMWSUG7.js";import{e as a}from"./chunk-362ETHZ6.js";var q=new c,g=new c;function U(e){let t=e.center;g=c.multiplyByScalar(e.ellipsoid.geodeticSurfaceNormal(t,g),e.height,g),g=c.add(t,g,g);let i=new E(g,e.semiMajorAxis),r=L.computeEllipsePositions(e,!1,!0).outerPositions,n=new H({position:new x({componentDatatype:O.DOUBLE,componentsPerAttribute:3,values:L.raisePositionsToHeight(r,e,!1)})}),o=r.length/3,s=D.createTypedArray(o,2*o),a=0;for(let e=0;e<o;++e)s[a++]=e,s[a++]=(e+1)%o;return{boundingSphere:i,attributes:n,indices:s}}var j=new E,N=new E;function R(e){let t=e.center,i=e.ellipsoid,r=e.semiMajorAxis,n=c.multiplyByScalar(i.geodeticSurfaceNormal(t,q),e.height,q);j.center=c.add(t,n,j.center),j.radius=r,n=c.multiplyByScalar(i.geodeticSurfaceNormal(t,n),e.extrudedHeight,n),N.center=c.add(t,n,N.center),N.radius=r;let o=L.computeEllipsePositions(e,!1,!0).outerPositions,s=new H({position:new x({componentDatatype:O.DOUBLE,componentsPerAttribute:3,values:L.raisePositionsToHeight(o,e,!0)})});o=s.position.values;let u=E.union(j,N),l=o.length/3;if(a(e.offsetAttribute)){let t=new Uint8Array(l);if(e.offsetAttribute===S.TOP)t=t.fill(1,0,l/2);else{let i=e.offsetAttribute===S.NONE?0:1;t=t.fill(i)}s.applyOffset=new x({componentDatatype:O.UNSIGNED_BYTE,componentsPerAttribute:1,values:t})}let d=e.numberOfVerticalLines??16;d=w.clamp(d,0,l/2);let f=D.createTypedArray(l,2*l+2*d);l/=2;let h,m,p=0;for(h=0;h<l;++h)f[p++]=h,f[p++]=(h+1)%l,f[p++]=h+l,f[p++]=(h+1)%l+l;if(d>0){let e=Math.min(d,l);m=Math.round(l/e);let t=Math.min(m*d,l);for(h=0;h<t;h+=m)f[p++]=h,f[p++]=h+l}return{boundingSphere:u,attributes:s,indices:f}}function M(e){let t=(e=e??V.EMPTY_OBJECT).center,i=e.ellipsoid??d.default,r=e.semiMajorAxis,n=e.semiMinorAxis,o=e.granularity??w.RADIANS_PER_DEGREE;if(!a(t))throw new A("center is required.");if(!a(r))throw new A("semiMajorAxis is required.");if(!a(n))throw new A("semiMinorAxis is required.");if(r<n)throw new A("semiMajorAxis must be greater than or equal to the semiMinorAxis.");if(o<=0)throw new A("granularity must be greater than zero.");let s=e.height??0,u=e.extrudedHeight??s;this._center=c.clone(t),this._semiMajorAxis=r,this._semiMinorAxis=n,this._ellipsoid=d.clone(i),this._rotation=e.rotation??0,this._height=Math.max(u,s),this._granularity=o,this._extrudedHeight=Math.min(u,s),this._numberOfVerticalLines=Math.max(e.numberOfVerticalLines??16,0),this._offsetAttribute=e.offsetAttribute,this._workerName="createEllipseOutlineGeometry"}M.packedLength=c.packedLength+d.packedLength+8,M.pack=function(e,t,i){if(!a(e))throw new A("value is required");if(!a(t))throw new A("array is required");return i=i??0,c.pack(e._center,t,i),i+=c.packedLength,d.pack(e._ellipsoid,t,i),i+=d.packedLength,t[i++]=e._semiMajorAxis,t[i++]=e._semiMinorAxis,t[i++]=e._rotation,t[i++]=e._height,t[i++]=e._granularity,t[i++]=e._extrudedHeight,t[i++]=e._numberOfVerticalLines,t[i]=e._offsetAttribute??-1,t};var y=new c,C=new d,_={center:y,ellipsoid:C,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,numberOfVerticalLines:void 0,offsetAttribute:void 0};M.unpack=function(e,t,i){if(!a(e))throw new A("array is required");t=t??0;let r=c.unpack(e,t,y);t+=c.packedLength;let n=d.unpack(e,t,C);t+=d.packedLength;let o=e[t++],s=e[t++],u=e[t++],l=e[t++],f=e[t++],h=e[t++],m=e[t++],p=e[t];return a(i)?(i._center=c.clone(r,i._center),i._ellipsoid=d.clone(n,i._ellipsoid),i._semiMajorAxis=o,i._semiMinorAxis=s,i._rotation=u,i._height=l,i._granularity=f,i._extrudedHeight=h,i._numberOfVerticalLines=m,i._offsetAttribute=-1===p?void 0:p,i):(_.height=l,_.extrudedHeight=h,_.granularity=f,_.rotation=u,_.semiMajorAxis=o,_.semiMinorAxis=s,_.numberOfVerticalLines=m,_.offsetAttribute=-1===p?void 0:p,new M(_))},M.createGeometry=function(e){if(e._semiMajorAxis<=0||e._semiMinorAxis<=0)return;let t=e._height,i=e._extrudedHeight,r=!w.equalsEpsilon(t,i,0,w.EPSILON2);e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);let n,o={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:t,granularity:e._granularity,numberOfVerticalLines:e._numberOfVerticalLines};if(r)o.extrudedHeight=i,o.offsetAttribute=e._offsetAttribute,n=R(o);else if(n=U(o),a(e._offsetAttribute)){let t=n.attributes.position.values.length,i=e._offsetAttribute===S.NONE?0:1,r=new Uint8Array(t/3).fill(i);n.attributes.applyOffset=new x({componentDatatype:O.UNSIGNED_BYTE,componentsPerAttribute:1,values:r})}return new B({attributes:n.attributes,indices:n.indices,primitiveType:T.LINES,boundingSphere:n.boundingSphere,offsetAttribute:e._offsetAttribute})};var ie=M;export{ie as a};