/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as _}from"./chunk-MQYSNG5N.js";import{a as te}from"./chunk-WZSOKNIB.js";import{a as ie,b as j,f as Z,g as fe}from"./chunk-YJEV67VS.js";import{a as e,b as se,c as ee,e as O}from"./chunk-XFVXIGTK.js";import{a as Q}from"./chunk-MPRZ6V46.js";import{a as le}from"./chunk-VZMWSUG7.js";import{e as $}from"./chunk-362ETHZ6.js";var Ee={ROUNDED:0,MITERED:1,BEVELED:2},G=Object.freeze(Ee),me={};function P(e,t){if(!$(e))throw new le("identifier is required.");$(me[e])||(me[e]=!0,console.warn(t??e))}P.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",P.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",P.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored",P.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored";var ue=P,w=[new e,new e],Se=new e,Te=new e,Be=new e,Ce=new e,ze=new e,Ae=new e,be=new e,Oe=new e,ve=new e,I=new e,W=new e,R={},re=new se;function De(e,t){let n=new Array(e.length);for(let r=0;r<e.length;r++){let o=e[r];re=t.cartesianToCartographic(o,re),n[r]=re.height,e[r]=t.scaleToGeodeticSurface(o,o)}return n}function ne(t,n,r,o){let a,l=t[0],i=t[1],c=e.angleBetween(l,i),s=Math.ceil(c/o),u=new Array(s);if(n===r){for(a=0;a<s;a++)u[a]=n;return u.push(r),u}let d=(r-n)/s;for(a=1;a<s;a++){let e=n+a*d;u[a]=e}return u[0]=n,u.push(r),u}var X=new e,Y=new e;function je(t,n,r,o){let a=new te(r,o),l=a.projectPointOntoPlane(e.add(r,t,X),X),i=a.projectPointOntoPlane(e.add(r,n,Y),Y),c=ee.angleBetween(l,i);return i.x*l.y-i.y*l.x>=0?-c:c}var He=new e(-1,0,0),H=new j,Me=new j,oe=new O,Ne=O.IDENTITY.clone(),Ve=new e,Fe=new ie,he=new e;function v(t,n,r,o,a,l,i,c){let s=Ve,u=Fe;H=fe.eastNorthUpToFixedFrame(t,a,H),s=j.multiplyByPointAsVector(H,He,s),s=e.normalize(s,s);let d=je(s,n,t,a);oe=O.fromRotationZ(d,oe),he.z=l,H=j.multiplyTransformation(H,j.fromRotationTranslation(oe,he,Me),H);let w=Ne;w[0]=i;for(let t=0;t<c;t++)for(let t=0;t<r.length;t+=3)u=e.fromArray(r,t,u),u=O.multiplyByVector(w,u,u),u=j.multiplyByPoint(H,u,u),o.push(u.x,u.y,u.z);return o}var Ge=new e;function ce(t,n,r,o,a,l,i){for(let c=0;c<t.length;c+=3){o=v(e.fromArray(t,c,Ge),n,r,o,a,l[c/3],i,1)}return o}function Ie(e,t){let n=e.length,r=new Array(6*n),o=0,a=t.x+t.width/2,l=t.y+t.height/2,i=e[0];r[o++]=i.x-a,r[o++]=0,r[o++]=i.y-l;for(let t=1;t<n;t++){i=e[t];let n=i.x-a,c=i.y-l;r[o++]=n,r[o++]=0,r[o++]=c,r[o++]=n,r[o++]=0,r[o++]=c}return i=e[0],r[o++]=i.x-a,r[o++]=0,r[o++]=i.y-l,r}function de(e,t){let n=e.length,r=new Array(3*n),o=0,a=t.x+t.width/2,l=t.y+t.height/2;for(let t=0;t<n;t++)r[o++]=e[t].x-a,r[o++]=0,r[o++]=e[t].y-l;return r}var ge=new Z,ye=new e,we=new O;function pe(t,n,r,o,a,l,i,c,s,u){let d,w,g,m=e.angleBetween(e.subtract(n,t,I),e.subtract(r,t,W)),h=o===G.BEVELED?0:Math.ceil(m/Q.toRadians(5));if(d=a?O.fromQuaternion(Z.fromAxisAngle(e.negate(t,I),m/(h+1),ge),we):O.fromQuaternion(Z.fromAxisAngle(t,m/(h+1),ge),we),n=e.clone(n,ye),h>0){let r=u?2:1;for(let o=0;o<h;o++)n=O.multiplyByVector(d,n,n),w=e.subtract(n,t,I),w=e.normalize(w,w),a||(w=e.negate(w,w)),g=l.scaleToGeodeticSurface(n,W),i=v(g,w,c,i,l,s,1,r)}else w=e.subtract(n,t,I),w=e.normalize(w,w),a||(w=e.negate(w,w)),g=l.scaleToGeodeticSurface(n,W),i=v(g,w,c,i,l,s,1,1),r=e.clone(r,ye),w=e.subtract(r,t,I),w=e.normalize(w,w),a||(w=e.negate(w,w)),g=l.scaleToGeodeticSurface(r,W),i=v(g,w,c,i,l,s,1,1);return i}R.removeDuplicatesFromShape=function(e){let t=e.length,n=[];for(let r=t-1,o=0;o<t;r=o++){let t=e[r],a=e[o];ee.equals(t,a)||n.push(a)}return n},R.angleIsGreaterThanPi=function(t,n,r,o){let a=new te(r,o),l=a.projectPointOntoPlane(e.add(r,t,X),X),i=a.projectPointOntoPlane(e.add(r,n,Y),Y);return i.x*l.y-i.y*l.x>=0};var Le=new e,qe=new e;R.computePositions=function(t,n,r,o,a){let l=o._ellipsoid,i=De(t,l),c=o._granularity,s=o._cornerType,u=a?Ie(n,r):de(n,r),d=a?de(n,r):void 0,g=r.height/2,m=r.width/2,h=t.length,y=[],f=a?[]:void 0,p=Se,E=Te,x=Be,b=Ce,O=ze,B=Ae,P=be,S=Oe,j=ve,z=t[0],T=t[1];b=l.geodeticSurfaceNormal(z,b),p=e.subtract(T,z,p),p=e.normalize(p,p),S=e.cross(b,p,S),S=e.normalize(S,S);let A,H,D=i[0],V=i[1];a&&(f=v(z,S,d,f,l,D+g,1,1)),j=e.clone(z,j),z=T,E=e.negate(p,E);for(let n=1;n<h-1;n++){let r=a?2:1;if(T=t[n+1],z.equals(T)){ue("Positions are too close and are considered equivalent with rounding error.");continue}p=e.subtract(T,z,p),p=e.normalize(p,p),b=l.geodeticSurfaceNormal(z,b);let o=e.multiplyByScalar(b,e.dot(p,b),Le);e.subtract(p,o,o),e.normalize(o,o);let d=e.multiplyByScalar(b,e.dot(E,b),qe);if(e.subtract(E,d,d),e.normalize(d,d),Q.equalsEpsilon(Math.abs(e.dot(o,d)),1,Q.EPSILON7))y=v(j,S,u,y,l,D+g,1,1),j=z;else{x=e.add(p,E,x),x=e.normalize(x,x),x=e.cross(x,b,x),x=e.cross(b,x,x),x=e.normalize(x,x);let t=1/Math.max(.25,e.magnitude(e.cross(x,E,I))),n=R.angleIsGreaterThanPi(p,E,z,l);n?(O=e.add(z,e.multiplyByScalar(x,t*m,x),O),B=e.add(O,e.multiplyByScalar(S,m,B),B),w[0]=e.clone(j,w[0]),w[1]=e.clone(B,w[1]),A=ne(w,D+g,V+g,c),H=_.generateArc({positions:w,granularity:c,ellipsoid:l}),y=ce(H,S,u,y,l,A,1),S=e.cross(b,p,S),S=e.normalize(S,S),P=e.add(O,e.multiplyByScalar(S,m,P),P),s===G.ROUNDED||s===G.BEVELED?pe(O,B,P,s,n,l,y,u,V+g,a):(x=e.negate(x,x),y=v(z,x,u,y,l,V+g,t,r)),j=e.clone(P,j)):(O=e.add(z,e.multiplyByScalar(x,t*m,x),O),B=e.add(O,e.multiplyByScalar(S,-m,B),B),w[0]=e.clone(j,w[0]),w[1]=e.clone(B,w[1]),A=ne(w,D+g,V+g,c),H=_.generateArc({positions:w,granularity:c,ellipsoid:l}),y=ce(H,S,u,y,l,A,1),S=e.cross(b,p,S),S=e.normalize(S,S),P=e.add(O,e.multiplyByScalar(S,-m,P),P),s===G.ROUNDED||s===G.BEVELED?pe(O,B,P,s,n,l,y,u,V+g,a):y=v(z,x,u,y,l,V+g,t,r),j=e.clone(P,j)),E=e.negate(p,E)}D=V,V=i[n+1],z=T}w[0]=e.clone(j,w[0]),w[1]=e.clone(z,w[1]),A=ne(w,D+g,V+g,c),H=_.generateArc({positions:w,granularity:c,ellipsoid:l}),y=ce(H,S,u,y,l,A,1),a&&(f=v(z,S,d,f,l,V+g,1,1)),h=y.length;let N=a?h+f.length:h,M=new Float64Array(N);return M.set(y),a&&M.set(f,h),M};var ct=R;export{G as a,ue as b,ct as c};