/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as h}from"./chunk-MPRZ6V46.js";import{a as g,b as c}from"./chunk-VZMWSUG7.js";import{e as u}from"./chunk-362ETHZ6.js";function f(e,t,n){this.x=e??0,this.y=t??0,this.z=n??0}f.fromSpherical=function(e,t){c.typeOf.object("spherical",e),u(t)||(t=new f);let n=e.clock,r=e.cone,a=e.magnitude??1,i=a*Math.sin(r);return t.x=i*Math.cos(n),t.y=i*Math.sin(n),t.z=a*Math.cos(r),t},f.fromElements=function(e,t,n,r){return u(r)?(r.x=e,r.y=t,r.z=n,r):new f(e,t,n)},f.clone=function(e,t){if(u(e))return u(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new f(e.x,e.y,e.z)},f.fromCartesian4=f.clone,f.packedLength=3,f.pack=function(e,t,n){return c.typeOf.object("value",e),c.defined("array",t),n=n??0,t[n++]=e.x,t[n++]=e.y,t[n]=e.z,t},f.unpack=function(e,t,n){return c.defined("array",e),t=t??0,u(n)||(n=new f),n.x=e[t++],n.y=e[t++],n.z=e[t],n},f.packArray=function(e,t){c.defined("array",e);let n=e.length,r=3*n;if(u(t)){if(!Array.isArray(t)&&t.length!==r)throw new g("If result is a typed array, it must have exactly array.length * 3 elements");t.length!==r&&(t.length=r)}else t=new Array(r);for(let r=0;r<n;++r)f.pack(e[r],t,3*r);return t},f.unpackArray=function(e,t){if(c.defined("array",e),c.typeOf.number.greaterThanOrEquals("array.length",e.length,3),e.length%3!=0)throw new g("array length must be a multiple of 3.");let n=e.length;u(t)?t.length=n/3:t=new Array(n/3);for(let r=0;r<n;r+=3){let n=r/3;t[n]=f.unpack(e,r,t[n])}return t},f.fromArray=f.unpack,f.maximumComponent=function(e){return c.typeOf.object("cartesian",e),Math.max(e.x,e.y,e.z)},f.minimumComponent=function(e){return c.typeOf.object("cartesian",e),Math.min(e.x,e.y,e.z)},f.minimumByComponent=function(e,t,n){return c.typeOf.object("first",e),c.typeOf.object("second",t),c.typeOf.object("result",n),n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},f.maximumByComponent=function(e,t,n){return c.typeOf.object("first",e),c.typeOf.object("second",t),c.typeOf.object("result",n),n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},f.clamp=function(e,t,n,r){c.typeOf.object("value",e),c.typeOf.object("min",t),c.typeOf.object("max",n),c.typeOf.object("result",r);let a=h.clamp(e.x,t.x,n.x),i=h.clamp(e.y,t.y,n.y),u=h.clamp(e.z,t.z,n.z);return r.x=a,r.y=i,r.z=u,r},f.magnitudeSquared=function(e){return c.typeOf.object("cartesian",e),e.x*e.x+e.y*e.y+e.z*e.z},f.magnitude=function(e){return Math.sqrt(f.magnitudeSquared(e))};var X=new f;f.distance=function(e,t){return c.typeOf.object("left",e),c.typeOf.object("right",t),f.subtract(e,t,X),f.magnitude(X)},f.distanceSquared=function(e,t){return c.typeOf.object("left",e),c.typeOf.object("right",t),f.subtract(e,t,X),f.magnitudeSquared(X)},f.normalize=function(e,t){c.typeOf.object("cartesian",e),c.typeOf.object("result",t);let n=f.magnitude(e);if(t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,isNaN(t.x)||isNaN(t.y)||isNaN(t.z))throw new g("normalized result is not a number");return t},f.dot=function(e,t){return c.typeOf.object("left",e),c.typeOf.object("right",t),e.x*t.x+e.y*t.y+e.z*t.z},f.multiplyComponents=function(e,t,n){return c.typeOf.object("left",e),c.typeOf.object("right",t),c.typeOf.object("result",n),n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n},f.divideComponents=function(e,t,n){return c.typeOf.object("left",e),c.typeOf.object("right",t),c.typeOf.object("result",n),n.x=e.x/t.x,n.y=e.y/t.y,n.z=e.z/t.z,n},f.add=function(e,t,n){return c.typeOf.object("left",e),c.typeOf.object("right",t),c.typeOf.object("result",n),n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n},f.subtract=function(e,t,n){return c.typeOf.object("left",e),c.typeOf.object("right",t),c.typeOf.object("result",n),n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n},f.multiplyByScalar=function(e,t,n){return c.typeOf.object("cartesian",e),c.typeOf.number("scalar",t),c.typeOf.object("result",n),n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n},f.divideByScalar=function(e,t,n){return c.typeOf.object("cartesian",e),c.typeOf.number("scalar",t),c.typeOf.object("result",n),n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n},f.negate=function(e,t){return c.typeOf.object("cartesian",e),c.typeOf.object("result",t),t.x=-e.x,t.y=-e.y,t.z=-e.z,t},f.abs=function(e,t){return c.typeOf.object("cartesian",e),c.typeOf.object("result",t),t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var Tn=new f;f.lerp=function(e,t,n,r){return c.typeOf.object("start",e),c.typeOf.object("end",t),c.typeOf.number("t",n),c.typeOf.object("result",r),f.multiplyByScalar(t,n,Tn),r=f.multiplyByScalar(e,1-n,r),f.add(Tn,r,r)};var Y=new f,dn=new f;f.angleBetween=function(e,t){c.typeOf.object("left",e),c.typeOf.object("right",t),f.normalize(e,Y),f.normalize(t,dn);let n=f.dot(Y,dn),r=f.magnitude(f.cross(Y,dn,Y));return Math.atan2(r,n)};var Yn=new f;f.mostOrthogonalAxis=function(e,t){c.typeOf.object("cartesian",e),c.typeOf.object("result",t);let n=f.normalize(e,Yn);return f.abs(n,n),t=n.x<=n.y?n.x<=n.z?f.clone(f.UNIT_X,t):f.clone(f.UNIT_Z,t):n.y<=n.z?f.clone(f.UNIT_Y,t):f.clone(f.UNIT_Z,t)},f.projectVector=function(e,t,n){c.defined("a",e),c.defined("b",t),c.defined("result",n);let r=f.dot(e,t)/f.dot(t,t);return f.multiplyByScalar(t,r,n)},f.equals=function(e,t){return e===t||u(e)&&u(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},f.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},f.equalsEpsilon=function(e,t,n,r){return e===t||u(e)&&u(t)&&h.equalsEpsilon(e.x,t.x,n,r)&&h.equalsEpsilon(e.y,t.y,n,r)&&h.equalsEpsilon(e.z,t.z,n,r)},f.cross=function(e,t,n){c.typeOf.object("left",e),c.typeOf.object("right",t),c.typeOf.object("result",n);let r=e.x,a=e.y,i=e.z,u=t.x,o=t.y,l=t.z,f=a*l-i*o,s=i*u-r*l,y=r*o-a*u;return n.x=f,n.y=s,n.z=y,n},f.midpoint=function(e,t,n){return c.typeOf.object("left",e),c.typeOf.object("right",t),c.typeOf.object("result",n),n.x=.5*(e.x+t.x),n.y=.5*(e.y+t.y),n.z=.5*(e.z+t.z),n},f.fromDegrees=function(e,t,n,r,a){return c.typeOf.number("longitude",e),c.typeOf.number("latitude",t),e=h.toRadians(e),t=h.toRadians(t),f.fromRadians(e,t,n,r,a)};var T=new f,V=new f;f._ellipsoidRadiiSquared=new f(40680631590769,40680631590769,40408299984661.445),f.fromRadians=function(e,t,n,r,a){c.typeOf.number("longitude",e),c.typeOf.number("latitude",t),n=n??0;let i=u(r)?r.radiiSquared:f._ellipsoidRadiiSquared,o=Math.cos(t);T.x=o*Math.cos(e),T.y=o*Math.sin(e),T.z=Math.sin(t),T=f.normalize(T,T),f.multiplyComponents(i,T,V);let l=Math.sqrt(f.dot(T,V));return V=f.divideByScalar(V,l,V),T=f.multiplyByScalar(T,n,T),u(a)||(a=new f),f.add(V,T,a)},f.fromDegreesArray=function(e,t,n){if(c.defined("coordinates",e),e.length<2||e.length%2!=0)throw new g("the number of coordinates must be a multiple of 2 and at least 2");let r=e.length;u(n)?n.length=r/2:n=new Array(r/2);for(let a=0;a<r;a+=2){let r=e[a],i=e[a+1],u=a/2;n[u]=f.fromDegrees(r,i,0,t,n[u])}return n},f.fromRadiansArray=function(e,t,n){if(c.defined("coordinates",e),e.length<2||e.length%2!=0)throw new g("the number of coordinates must be a multiple of 2 and at least 2");let r=e.length;u(n)?n.length=r/2:n=new Array(r/2);for(let a=0;a<r;a+=2){let r=e[a],i=e[a+1],u=a/2;n[u]=f.fromRadians(r,i,0,t,n[u])}return n},f.fromDegreesArrayHeights=function(e,t,n){if(c.defined("coordinates",e),e.length<3||e.length%3!=0)throw new g("the number of coordinates must be a multiple of 3 and at least 3");let r=e.length;u(n)?n.length=r/3:n=new Array(r/3);for(let a=0;a<r;a+=3){let r=e[a],i=e[a+1],u=e[a+2],o=a/3;n[o]=f.fromDegrees(r,i,u,t,n[o])}return n},f.fromRadiansArrayHeights=function(e,t,n){if(c.defined("coordinates",e),e.length<3||e.length%3!=0)throw new g("the number of coordinates must be a multiple of 3 and at least 3");let r=e.length;u(n)?n.length=r/3:n=new Array(r/3);for(let a=0;a<r;a+=3){let r=e[a],i=e[a+1],u=e[a+2],o=a/3;n[o]=f.fromRadians(r,i,u,t,n[o])}return n},f.ZERO=Object.freeze(new f(0,0,0)),f.ONE=Object.freeze(new f(1,1,1)),f.UNIT_X=Object.freeze(new f(1,0,0)),f.UNIT_Y=Object.freeze(new f(0,1,0)),f.UNIT_Z=Object.freeze(new f(0,0,1)),f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.equalsEpsilon=function(e,t,n){return f.equalsEpsilon(this,e,t,n)},f.prototype.toString=function(){return`(${this.x}, ${this.y}, ${this.z})`};var y=f,Xn=new y,Gn=new y;function Hn(e,t,n,r,a){if(!u(e))throw new g("cartesian is required.");if(!u(t))throw new g("oneOverRadii is required.");if(!u(n))throw new g("oneOverRadiiSquared is required.");if(!u(r))throw new g("centerToleranceSquared is required.");let i=e.x,o=e.y,c=e.z,l=t.x,f=t.y,s=t.z,p=i*i*l*l,d=o*o*f*f,m=c*c*s*s,O=p+d+m,b=Math.sqrt(1/O),x=y.multiplyByScalar(e,b,Xn);if(O<r)return isFinite(b)?y.clone(x,a):void 0;let j=n.x,z=n.y,w=n.z,q=Gn;q.x=x.x*j*2,q.y=x.y*z*2,q.z=x.z*w*2;let v,S,E,A,M,_,R,T,N,I,C,k=(1-b)*y.magnitude(e)/(.5*y.magnitude(q)),F=0;do{k-=F,E=1/(1+k*j),A=1/(1+k*z),M=1/(1+k*w),_=E*E,R=A*A,T=M*M,N=_*E,I=R*A,C=T*M,v=p*_+d*R+m*T-1,S=p*N*j+d*I*z+m*C*w,F=v/(-2*S)}while(Math.abs(v)>h.EPSILON12);return u(a)?(a.x=i*E,a.y=o*A,a.z=c*M,a):new y(i*E,o*A,c*M)}var G=Hn;function j(e,t,n){this.longitude=e??0,this.latitude=t??0,this.height=n??0}j.fromRadians=function(e,t,n,r){return c.typeOf.number("longitude",e),c.typeOf.number("latitude",t),n=n??0,u(r)?(r.longitude=e,r.latitude=t,r.height=n,r):new j(e,t,n)},j.fromDegrees=function(e,t,n,r){return c.typeOf.number("longitude",e),c.typeOf.number("latitude",t),e=h.toRadians(e),t=h.toRadians(t),j.fromRadians(e,t,n,r)};var Qn=new y,Jn=new y,Kn=new y;j._ellipsoidOneOverRadii=new y(1/6378137,1/6378137,1/6356752.314245179),j._ellipsoidOneOverRadiiSquared=new y(1/40680631590769,1/40680631590769,1/40408299984661.445),j._ellipsoidCenterToleranceSquared=h.EPSILON1,j.fromCartesian=function(e,t,n){let r=u(t)?t.oneOverRadii:j._ellipsoidOneOverRadii,a=u(t)?t.oneOverRadiiSquared:j._ellipsoidOneOverRadiiSquared,i=u(t)?t._centerToleranceSquared:j._ellipsoidCenterToleranceSquared,o=G(e,r,a,i,Jn);if(!u(o))return;let c=y.multiplyComponents(o,a,Qn);c=y.normalize(c,c);let l=y.subtract(e,o,Kn),f=Math.atan2(c.y,c.x),s=Math.asin(c.z),p=h.sign(y.dot(l,e))*y.magnitude(l);return u(n)?(n.longitude=f,n.latitude=s,n.height=p,n):new j(f,s,p)},j.toCartesian=function(e,t,n){return c.defined("cartographic",e),y.fromRadians(e.longitude,e.latitude,e.height,t,n)},j.clone=function(e,t){if(u(e))return u(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new j(e.longitude,e.latitude,e.height)},j.equals=function(e,t){return e===t||u(e)&&u(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},j.equalsEpsilon=function(e,t,n){return n=n??0,e===t||u(e)&&u(t)&&Math.abs(e.longitude-t.longitude)<=n&&Math.abs(e.latitude-t.latitude)<=n&&Math.abs(e.height-t.height)<=n},j.ZERO=Object.freeze(new j(0,0,0)),j.prototype.clone=function(e){return j.clone(this,e)},j.prototype.equals=function(e){return j.equals(this,e)},j.prototype.equalsEpsilon=function(e,t){return j.equalsEpsilon(this,e,t)},j.prototype.toString=function(){return`(${this.longitude}, ${this.latitude}, ${this.height})`};var $=j;function a(e,t){this.x=e??0,this.y=t??0}a.fromElements=function(e,t,n){return u(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){if(u(e))return u(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y)},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(e,t,n){return c.typeOf.object("value",e),c.defined("array",t),n=n??0,t[n++]=e.x,t[n]=e.y,t},a.unpack=function(e,t,n){return c.defined("array",e),t=t??0,u(n)||(n=new a),n.x=e[t++],n.y=e[t],n},a.packArray=function(e,t){c.defined("array",e);let n=e.length,r=2*n;if(u(t)){if(!Array.isArray(t)&&t.length!==r)throw new g("If result is a typed array, it must have exactly array.length * 2 elements");t.length!==r&&(t.length=r)}else t=new Array(r);for(let r=0;r<n;++r)a.pack(e[r],t,2*r);return t},a.unpackArray=function(e,t){if(c.defined("array",e),c.typeOf.number.greaterThanOrEquals("array.length",e.length,2),e.length%2!=0)throw new g("array length must be a multiple of 2.");let n=e.length;u(t)?t.length=n/2:t=new Array(n/2);for(let r=0;r<n;r+=2){let n=r/2;t[n]=a.unpack(e,r,t[n])}return t},a.fromArray=a.unpack,a.maximumComponent=function(e){return c.typeOf.object("cartesian",e),Math.max(e.x,e.y)},a.minimumComponent=function(e){return c.typeOf.object("cartesian",e),Math.min(e.x,e.y)},a.minimumByComponent=function(e,t,n){return c.typeOf.object("first",e),c.typeOf.object("second",t),c.typeOf.object("result",n),n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n},a.maximumByComponent=function(e,t,n){return c.typeOf.object("first",e),c.typeOf.object("second",t),c.typeOf.object("result",n),n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n},a.clamp=function(e,t,n,r){c.typeOf.object("value",e),c.typeOf.object("min",t),c.typeOf.object("max",n),c.typeOf.object("result",r);let a=h.clamp(e.x,t.x,n.x),i=h.clamp(e.y,t.y,n.y);return r.x=a,r.y=i,r},a.magnitudeSquared=function(e){return c.typeOf.object("cartesian",e),e.x*e.x+e.y*e.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var H=new a;a.distance=function(e,t){return c.typeOf.object("left",e),c.typeOf.object("right",t),a.subtract(e,t,H),a.magnitude(H)},a.distanceSquared=function(e,t){return c.typeOf.object("left",e),c.typeOf.object("right",t),a.subtract(e,t,H),a.magnitudeSquared(H)},a.normalize=function(e,t){c.typeOf.object("cartesian",e),c.typeOf.object("result",t);let n=a.magnitude(e);if(t.x=e.x/n,t.y=e.y/n,isNaN(t.x)||isNaN(t.y))throw new g("normalized result is not a number");return t},a.dot=function(e,t){return c.typeOf.object("left",e),c.typeOf.object("right",t),e.x*t.x+e.y*t.y},a.cross=function(e,t){return c.typeOf.object("left",e),c.typeOf.object("right",t),e.x*t.y-e.y*t.x},a.multiplyComponents=function(e,t,n){return c.typeOf.object("left",e),c.typeOf.object("right",t),c.typeOf.object("result",n),n.x=e.x*t.x,n.y=e.y*t.y,n},a.divideComponents=function(e,t,n){return c.typeOf.object("left",e),c.typeOf.object("right",t),c.typeOf.object("result",n),n.x=e.x/t.x,n.y=e.y/t.y,n},a.add=function(e,t,n){return c.typeOf.object("left",e),c.typeOf.object("right",t),c.typeOf.object("result",n),n.x=e.x+t.x,n.y=e.y+t.y,n},a.subtract=function(e,t,n){return c.typeOf.object("left",e),c.typeOf.object("right",t),c.typeOf.object("result",n),n.x=e.x-t.x,n.y=e.y-t.y,n},a.multiplyByScalar=function(e,t,n){return c.typeOf.object("cartesian",e),c.typeOf.number("scalar",t),c.typeOf.object("result",n),n.x=e.x*t,n.y=e.y*t,n},a.divideByScalar=function(e,t,n){return c.typeOf.object("cartesian",e),c.typeOf.number("scalar",t),c.typeOf.object("result",n),n.x=e.x/t,n.y=e.y/t,n},a.negate=function(e,t){return c.typeOf.object("cartesian",e),c.typeOf.object("result",t),t.x=-e.x,t.y=-e.y,t},a.abs=function(e,t){return c.typeOf.object("cartesian",e),c.typeOf.object("result",t),t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var ln=new a;a.lerp=function(e,t,n,r){return c.typeOf.object("start",e),c.typeOf.object("end",t),c.typeOf.number("t",n),c.typeOf.object("result",r),a.multiplyByScalar(t,n,ln),r=a.multiplyByScalar(e,1-n,r),a.add(ln,r,r)};var Cn=new a,Nn=new a;a.angleBetween=function(e,t){return c.typeOf.object("left",e),c.typeOf.object("right",t),a.normalize(e,Cn),a.normalize(t,Nn),h.acosClamped(a.dot(Cn,Nn))};var ne=new a;a.mostOrthogonalAxis=function(e,t){c.typeOf.object("cartesian",e),c.typeOf.object("result",t);let n=a.normalize(e,ne);return a.abs(n,n),t=n.x<=n.y?a.clone(a.UNIT_X,t):a.clone(a.UNIT_Y,t)},a.equals=function(e,t){return e===t||u(e)&&u(t)&&e.x===t.x&&e.y===t.y},a.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]},a.equalsEpsilon=function(e,t,n,r){return e===t||u(e)&&u(t)&&h.equalsEpsilon(e.x,t.x,n,r)&&h.equalsEpsilon(e.y,t.y,n,r)},a.ZERO=Object.freeze(new a(0,0)),a.ONE=Object.freeze(new a(1,1)),a.UNIT_X=Object.freeze(new a(1,0)),a.UNIT_Y=Object.freeze(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,n){return a.equalsEpsilon(this,e,t,n)},a.prototype.toString=function(){return`(${this.x}, ${this.y})`};var yn=a;function Fn(e,t,n,r){t=t??0,n=n??0,r=r??0,c.typeOf.number.greaterThanOrEquals("x",t,0),c.typeOf.number.greaterThanOrEquals("y",n,0),c.typeOf.number.greaterThanOrEquals("z",r,0),e._radii=new y(t,n,r),e._radiiSquared=new y(t*t,n*n,r*r),e._radiiToTheFourth=new y(t*t*t*t,n*n*n*n,r*r*r*r),e._oneOverRadii=new y(0===t?0:1/t,0===n?0:1/n,0===r?0:1/r),e._oneOverRadiiSquared=new y(0===t?0:1/(t*t),0===n?0:1/(n*n),0===r?0:1/(r*r)),e._minimumRadius=Math.min(t,n,r),e._maximumRadius=Math.max(t,n,r),e._centerToleranceSquared=h.EPSILON1,0!==e._radiiSquared.z&&(e._squaredXOverSquaredZ=e._radiiSquared.x/e._radiiSquared.z)}function O(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,Fn(this,e,t,n)}Object.defineProperties(O.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),O.clone=function(e,t){if(!u(e))return;let n=e._radii;return u(t)?(y.clone(n,t._radii),y.clone(e._radiiSquared,t._radiiSquared),y.clone(e._radiiToTheFourth,t._radiiToTheFourth),y.clone(e._oneOverRadii,t._oneOverRadii),y.clone(e._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=e._minimumRadius,t._maximumRadius=e._maximumRadius,t._centerToleranceSquared=e._centerToleranceSquared,t):new O(n.x,n.y,n.z)},O.fromCartesian3=function(e,t){return u(t)||(t=new O),u(e)&&Fn(t,e.x,e.y,e.z),t},O.WGS84=Object.freeze(new O(6378137,6378137,6356752.314245179)),O.UNIT_SPHERE=Object.freeze(new O(1,1,1)),O.MOON=Object.freeze(new O(h.LUNAR_RADIUS,h.LUNAR_RADIUS,h.LUNAR_RADIUS)),O._default=O.WGS84,Object.defineProperties(O,{default:{get:function(){return O._default},set:function(e){c.typeOf.object("value",e),O._default=e,y._ellipsoidRadiiSquared=e.radiiSquared,$._ellipsoidOneOverRadii=e.oneOverRadii,$._ellipsoidOneOverRadiiSquared=e.oneOverRadiiSquared,$._ellipsoidCenterToleranceSquared=e._centerToleranceSquared}}}),O.prototype.clone=function(e){return O.clone(this,e)},O.packedLength=y.packedLength,O.pack=function(e,t,n){return c.typeOf.object("value",e),c.defined("array",t),n=n??0,y.pack(e._radii,t,n),t},O.unpack=function(e,t,n){c.defined("array",e),t=t??0;let r=y.unpack(e,t);return O.fromCartesian3(r,n)},O.prototype.geocentricSurfaceNormal=y.normalize,O.prototype.geodeticSurfaceNormalCartographic=function(e,t){c.typeOf.object("cartographic",e);let n=e.longitude,r=e.latitude,a=Math.cos(r),i=a*Math.cos(n),o=a*Math.sin(n),l=Math.sin(r);return u(t)||(t=new y),t.x=i,t.y=o,t.z=l,y.normalize(t,t)},O.prototype.geodeticSurfaceNormal=function(e,t){if(c.typeOf.object("cartesian",e),isNaN(e.x)||isNaN(e.y)||isNaN(e.z))throw new g("cartesian has a NaN component");if(!y.equalsEpsilon(e,y.ZERO,h.EPSILON14))return u(t)||(t=new y),t=y.multiplyComponents(e,this._oneOverRadiiSquared,t),y.normalize(t,t)};var ee=new y,oe=new y;O.prototype.cartographicToCartesian=function(e,t){let n=ee,r=oe;this.geodeticSurfaceNormalCartographic(e,n),y.multiplyComponents(this._radiiSquared,n,r);let a=Math.sqrt(y.dot(n,r));return y.divideByScalar(r,a,r),y.multiplyByScalar(n,e.height,n),u(t)||(t=new y),y.add(r,n,t)},O.prototype.cartographicArrayToCartesianArray=function(e,t){c.defined("cartographics",e);let n=e.length;u(t)?t.length=n:t=new Array(n);for(let r=0;r<n;r++)t[r]=this.cartographicToCartesian(e[r],t[r]);return t};var te=new y,ce=new y,ie=new y;O.prototype.cartesianToCartographic=function(e,t){let n=this.scaleToGeodeticSurface(e,ce);if(!u(n))return;let r=this.geodeticSurfaceNormal(n,te),a=y.subtract(e,n,ie),i=Math.atan2(r.y,r.x),o=Math.asin(r.z),c=h.sign(y.dot(a,e))*y.magnitude(a);return u(t)?(t.longitude=i,t.latitude=o,t.height=c,t):new $(i,o,c)},O.prototype.cartesianArrayToCartographicArray=function(e,t){c.defined("cartesians",e);let n=e.length;u(t)?t.length=n:t=new Array(n);for(let r=0;r<n;++r)t[r]=this.cartesianToCartographic(e[r],t[r]);return t},O.prototype.scaleToGeodeticSurface=function(e,t){return G(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},O.prototype.scaleToGeocentricSurface=function(e,t){c.typeOf.object("cartesian",e),u(t)||(t=new y);let n=e.x,r=e.y,a=e.z,i=this._oneOverRadiiSquared,o=1/Math.sqrt(n*n*i.x+r*r*i.y+a*a*i.z);return y.multiplyByScalar(e,o,t)},O.prototype.transformPositionToScaledSpace=function(e,t){return u(t)||(t=new y),y.multiplyComponents(e,this._oneOverRadii,t)},O.prototype.transformPositionFromScaledSpace=function(e,t){return u(t)||(t=new y),y.multiplyComponents(e,this._radii,t)},O.prototype.equals=function(e){return this===e||u(e)&&y.equals(this._radii,e._radii)},O.prototype.toString=function(){return this._radii.toString()},O.prototype.getSurfaceNormalIntersectionWithZAxis=function(e,t,n){if(c.typeOf.object("position",e),!h.equalsEpsilon(this._radii.x,this._radii.y,h.EPSILON15))throw new g("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");c.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),t=t??0;let r=this._squaredXOverSquaredZ;if(u(n)||(n=new y),n.x=0,n.y=0,n.z=e.z*(1-r),!(Math.abs(n.z)>=this._radii.z-t))return n};var fe=new y;O.prototype.getLocalCurvature=function(e,t){c.typeOf.object("surfacePosition",e),u(t)||(t=new yn);let n=this.getSurfaceNormalIntersectionWithZAxis(e,0,fe),r=y.distance(e,n),a=r*(this.minimumRadius*r/this.maximumRadius**2)**2;return yn.fromElements(1/r,1/a,t)};var re=[.14887433898163,.43339539412925,.67940956829902,.86506336668898,.97390652851717,0],pe=[.29552422471475,.26926671930999,.21908636251598,.14945134915058,.066671344308684,0];function xn(e,t,n){c.typeOf.number("a",e),c.typeOf.number("b",t),c.typeOf.func("func",n);let r=.5*(t+e),a=.5*(t-e),i=0;for(let e=0;e<5;e++){let t=a*re[e];i+=pe[e]*(n(r+t)+n(r-t))}return i*=a,i}O.prototype.surfaceArea=function(e){c.typeOf.object("rectangle",e);let t=e.west,n=e.east,r=e.south,a=e.north;for(;n<t;)n+=h.TWO_PI;let i=this._radiiSquared,u=i.x,o=i.y,l=i.z,f=u*o;return xn(r,a,(function(e){let r=Math.cos(e),a=Math.sin(e);return Math.cos(e)*xn(t,n,(function(e){let t=Math.cos(e),n=Math.sin(e);return Math.sqrt(f*a*a+l*(o*t*t+u*n*n)*r*r)}))}))};var oo=O;function r(e,t,n,r,a,i,u,o,c){this[0]=e??0,this[1]=r??0,this[2]=u??0,this[3]=t??0,this[4]=a??0,this[5]=o??0,this[6]=n??0,this[7]=i??0,this[8]=c??0}r.packedLength=9,r.pack=function(e,t,n){return c.typeOf.object("value",e),c.defined("array",t),n=n??0,t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t},r.unpack=function(e,t,n){return c.defined("array",e),t=t??0,u(n)||(n=new r),n[0]=e[t++],n[1]=e[t++],n[2]=e[t++],n[3]=e[t++],n[4]=e[t++],n[5]=e[t++],n[6]=e[t++],n[7]=e[t++],n[8]=e[t++],n},r.packArray=function(e,t){c.defined("array",e);let n=e.length,a=9*n;if(u(t)){if(!Array.isArray(t)&&t.length!==a)throw new g("If result is a typed array, it must have exactly array.length * 9 elements");t.length!==a&&(t.length=a)}else t=new Array(a);for(let a=0;a<n;++a)r.pack(e[a],t,9*a);return t},r.unpackArray=function(e,t){if(c.defined("array",e),c.typeOf.number.greaterThanOrEquals("array.length",e.length,9),e.length%9!=0)throw new g("array length must be a multiple of 9.");let n=e.length;u(t)?t.length=n/9:t=new Array(n/9);for(let a=0;a<n;a+=9){let n=a/9;t[n]=r.unpack(e,a,t[n])}return t},r.clone=function(e,t){if(u(e))return u(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new r(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},r.fromArray=r.unpack,r.fromColumnMajorArray=function(e,t){return c.defined("values",e),r.clone(e,t)},r.fromRowMajorArray=function(e,t){return c.defined("values",e),u(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new r(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},r.fromQuaternion=function(e,t){c.typeOf.object("quaternion",e);let n=e.x*e.x,a=e.x*e.y,i=e.x*e.z,o=e.x*e.w,l=e.y*e.y,f=e.y*e.z,s=e.y*e.w,y=e.z*e.z,p=e.z*e.w,d=e.w*e.w,h=n-l-y+d,m=2*(a-p),O=2*(i+s),b=2*(a+p),g=-n+l-y+d,x=2*(f-o),j=2*(i-s),z=2*(f+o),w=-n-l+y+d;return u(t)?(t[0]=h,t[1]=b,t[2]=j,t[3]=m,t[4]=g,t[5]=z,t[6]=O,t[7]=x,t[8]=w,t):new r(h,m,O,b,g,x,j,z,w)},r.fromHeadingPitchRoll=function(e,t){c.typeOf.object("headingPitchRoll",e);let n=Math.cos(-e.pitch),a=Math.cos(-e.heading),i=Math.cos(e.roll),o=Math.sin(-e.pitch),l=Math.sin(-e.heading),f=Math.sin(e.roll),s=n*a,y=-i*l+f*o*a,p=f*l+i*o*a,d=n*l,h=i*a+f*o*l,m=-f*a+i*o*l,O=-o,b=f*n,g=i*n;return u(t)?(t[0]=s,t[1]=d,t[2]=O,t[3]=y,t[4]=h,t[5]=b,t[6]=p,t[7]=m,t[8]=g,t):new r(s,y,p,d,h,m,O,b,g)},r.fromScale=function(e,t){return c.typeOf.object("scale",e),u(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new r(e.x,0,0,0,e.y,0,0,0,e.z)},r.fromUniformScale=function(e,t){return c.typeOf.number("scale",e),u(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new r(e,0,0,0,e,0,0,0,e)},r.fromCrossProduct=function(e,t){return c.typeOf.object("vector",e),u(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new r(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},r.fromRotationX=function(e,t){c.typeOf.number("angle",e);let n=Math.cos(e),a=Math.sin(e);return u(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=a,t[6]=0,t[7]=-a,t[8]=n,t):new r(1,0,0,0,n,-a,0,a,n)},r.fromRotationY=function(e,t){c.typeOf.number("angle",e);let n=Math.cos(e),a=Math.sin(e);return u(t)?(t[0]=n,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=n,t):new r(n,0,a,0,1,0,-a,0,n)},r.fromRotationZ=function(e,t){c.typeOf.number("angle",e);let n=Math.cos(e),a=Math.sin(e);return u(t)?(t[0]=n,t[1]=a,t[2]=0,t[3]=-a,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new r(n,-a,0,a,n,0,0,0,1)},r.toArray=function(e,t){return c.typeOf.object("matrix",e),u(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},r.getElementIndex=function(e,t){return c.typeOf.number.greaterThanOrEquals("row",t,0),c.typeOf.number.lessThanOrEquals("row",t,2),c.typeOf.number.greaterThanOrEquals("column",e,0),c.typeOf.number.lessThanOrEquals("column",e,2),3*e+t},r.getColumn=function(e,t,n){c.typeOf.object("matrix",e),c.typeOf.number.greaterThanOrEquals("index",t,0),c.typeOf.number.lessThanOrEquals("index",t,2),c.typeOf.object("result",n);let r=3*t,a=e[r],i=e[r+1],u=e[r+2];return n.x=a,n.y=i,n.z=u,n},r.setColumn=function(e,t,n,a){c.typeOf.object("matrix",e),c.typeOf.number.greaterThanOrEquals("index",t,0),c.typeOf.number.lessThanOrEquals("index",t,2),c.typeOf.object("cartesian",n),c.typeOf.object("result",a);let i=3*t;return(a=r.clone(e,a))[i]=n.x,a[i+1]=n.y,a[i+2]=n.z,a},r.getRow=function(e,t,n){c.typeOf.object("matrix",e),c.typeOf.number.greaterThanOrEquals("index",t,0),c.typeOf.number.lessThanOrEquals("index",t,2),c.typeOf.object("result",n);let r=e[t],a=e[t+3],i=e[t+6];return n.x=r,n.y=a,n.z=i,n},r.setRow=function(e,t,n,a){return c.typeOf.object("matrix",e),c.typeOf.number.greaterThanOrEquals("index",t,0),c.typeOf.number.lessThanOrEquals("index",t,2),c.typeOf.object("cartesian",n),c.typeOf.object("result",a),(a=r.clone(e,a))[t]=n.x,a[t+3]=n.y,a[t+6]=n.z,a};var ue=new y;r.setScale=function(e,t,n){c.typeOf.object("matrix",e),c.typeOf.object("scale",t),c.typeOf.object("result",n);let a=r.getScale(e,ue),i=t.x/a.x,u=t.y/a.y,o=t.z/a.z;return n[0]=e[0]*i,n[1]=e[1]*i,n[2]=e[2]*i,n[3]=e[3]*u,n[4]=e[4]*u,n[5]=e[5]*u,n[6]=e[6]*o,n[7]=e[7]*o,n[8]=e[8]*o,n};var ae=new y;r.setUniformScale=function(e,t,n){c.typeOf.object("matrix",e),c.typeOf.number("scale",t),c.typeOf.object("result",n);let a=r.getScale(e,ae),i=t/a.x,u=t/a.y,o=t/a.z;return n[0]=e[0]*i,n[1]=e[1]*i,n[2]=e[2]*i,n[3]=e[3]*u,n[4]=e[4]*u,n[5]=e[5]*u,n[6]=e[6]*o,n[7]=e[7]*o,n[8]=e[8]*o,n};var mn=new y;r.getScale=function(e,t){return c.typeOf.object("matrix",e),c.typeOf.object("result",t),t.x=y.magnitude(y.fromElements(e[0],e[1],e[2],mn)),t.y=y.magnitude(y.fromElements(e[3],e[4],e[5],mn)),t.z=y.magnitude(y.fromElements(e[6],e[7],e[8],mn)),t};var kn=new y;r.getMaximumScale=function(e){return r.getScale(e,kn),y.maximumComponent(kn)};var de=new y;r.setRotation=function(e,t,n){c.typeOf.object("matrix",e),c.typeOf.object("result",n);let a=r.getScale(e,de);return n[0]=t[0]*a.x,n[1]=t[1]*a.x,n[2]=t[2]*a.x,n[3]=t[3]*a.y,n[4]=t[4]*a.y,n[5]=t[5]*a.y,n[6]=t[6]*a.z,n[7]=t[7]*a.z,n[8]=t[8]*a.z,n};var ye=new y;function me(e){let t=0;for(let n=0;n<9;++n){let r=e[n];t+=r*r}return Math.sqrt(t)}r.getRotation=function(e,t){c.typeOf.object("matrix",e),c.typeOf.object("result",t);let n=r.getScale(e,ye);return t[0]=e[0]/n.x,t[1]=e[1]/n.x,t[2]=e[2]/n.x,t[3]=e[3]/n.y,t[4]=e[4]/n.y,t[5]=e[5]/n.y,t[6]=e[6]/n.z,t[7]=e[7]/n.z,t[8]=e[8]/n.z,t},r.multiply=function(e,t,n){c.typeOf.object("left",e),c.typeOf.object("right",t),c.typeOf.object("result",n);let r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],u=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],o=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],l=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],f=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],s=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],y=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=r,n[1]=a,n[2]=i,n[3]=u,n[4]=o,n[5]=l,n[6]=f,n[7]=s,n[8]=y,n},r.add=function(e,t,n){return c.typeOf.object("left",e),c.typeOf.object("right",t),c.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},r.subtract=function(e,t,n){return c.typeOf.object("left",e),c.typeOf.object("right",t),c.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},r.multiplyByVector=function(e,t,n){c.typeOf.object("matrix",e),c.typeOf.object("cartesian",t),c.typeOf.object("result",n);let r=t.x,a=t.y,i=t.z,u=e[0]*r+e[3]*a+e[6]*i,o=e[1]*r+e[4]*a+e[7]*i,l=e[2]*r+e[5]*a+e[8]*i;return n.x=u,n.y=o,n.z=l,n},r.multiplyByScalar=function(e,t,n){return c.typeOf.object("matrix",e),c.typeOf.number("scalar",t),c.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},r.multiplyByScale=function(e,t,n){return c.typeOf.object("matrix",e),c.typeOf.object("scale",t),c.typeOf.object("result",n),n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.x,n[3]=e[3]*t.y,n[4]=e[4]*t.y,n[5]=e[5]*t.y,n[6]=e[6]*t.z,n[7]=e[7]*t.z,n[8]=e[8]*t.z,n},r.multiplyByUniformScale=function(e,t,n){return c.typeOf.object("matrix",e),c.typeOf.number("scale",t),c.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},r.negate=function(e,t){return c.typeOf.object("matrix",e),c.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},r.transpose=function(e,t){c.typeOf.object("matrix",e),c.typeOf.object("result",t);let n=e[0],r=e[3],a=e[6],i=e[1],u=e[4],o=e[7],l=e[2],f=e[5],s=e[8];return t[0]=n,t[1]=r,t[2]=a,t[3]=i,t[4]=u,t[5]=o,t[6]=l,t[7]=f,t[8]=s,t};var sn=[1,0,0],On=[2,2,1];function se(e){let t=0;for(let n=0;n<3;++n){let a=e[r.getElementIndex(On[n],sn[n])];t+=2*a*a}return Math.sqrt(t)}function Oe(e,t){let n=h.EPSILON15,a=0,i=1;for(let t=0;t<3;++t){let n=Math.abs(e[r.getElementIndex(On[t],sn[t])]);n>a&&(i=t,a=n)}let u=1,o=0,c=sn[i],l=On[i];if(Math.abs(e[r.getElementIndex(l,c)])>n){let t,n=(e[r.getElementIndex(l,l)]-e[r.getElementIndex(c,c)])/2/e[r.getElementIndex(l,c)];t=n<0?-1/(-n+Math.sqrt(1+n*n)):1/(n+Math.sqrt(1+n*n)),u=1/Math.sqrt(1+t*t),o=t*u}return(t=r.clone(r.IDENTITY,t))[r.getElementIndex(c,c)]=t[r.getElementIndex(l,l)]=u,t[r.getElementIndex(l,c)]=o,t[r.getElementIndex(c,l)]=-o,t}var Q=new r,Bn=new r;r.computeEigenDecomposition=function(e,t){c.typeOf.object("matrix",e);let n=h.EPSILON20,a=0,i=0;u(t)||(t={});let o=t.unitary=r.clone(r.IDENTITY,t.unitary),l=t.diagonal=r.clone(e,t.diagonal),f=n*me(l);for(;i<10&&se(l)>f;)Oe(l,Q),r.transpose(Q,Bn),r.multiply(l,Q,l),r.multiply(Bn,l,l),r.multiply(o,Q,o),++a>2&&(++i,a=0);return t},r.abs=function(e,t){return c.typeOf.object("matrix",e),c.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},r.determinant=function(e){c.typeOf.object("matrix",e);let t=e[0],n=e[3],r=e[6],a=e[1],i=e[4],u=e[7],o=e[2],l=e[5],f=e[8];return t*(i*f-l*u)+a*(l*r-n*f)+o*(n*u-i*r)},r.inverse=function(e,t){c.typeOf.object("matrix",e),c.typeOf.object("result",t);let n=e[0],a=e[1],i=e[2],u=e[3],o=e[4],l=e[5],f=e[6],s=e[7],y=e[8],p=r.determinant(e);if(Math.abs(p)<=h.EPSILON15)throw new g("matrix is not invertible");t[0]=o*y-s*l,t[1]=s*i-a*y,t[2]=a*l-o*i,t[3]=f*l-u*y,t[4]=n*y-f*i,t[5]=u*i-n*l,t[6]=u*s-f*o,t[7]=f*a-n*s,t[8]=n*o-u*a;let d=1/p;return r.multiplyByScalar(t,d,t)};var be=new r;r.inverseTranspose=function(e,t){return c.typeOf.object("matrix",e),c.typeOf.object("result",t),r.inverse(r.transpose(e,be),t)},r.equals=function(e,t){return e===t||u(e)&&u(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},r.equalsEpsilon=function(e,t,n){return n=n??0,e===t||u(e)&&u(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},r.IDENTITY=Object.freeze(new r(1,0,0,0,1,0,0,0,1)),r.ZERO=Object.freeze(new r(0,0,0,0,0,0,0,0,0)),r.COLUMN0ROW0=0,r.COLUMN0ROW1=1,r.COLUMN0ROW2=2,r.COLUMN1ROW0=3,r.COLUMN1ROW1=4,r.COLUMN1ROW2=5,r.COLUMN2ROW0=6,r.COLUMN2ROW1=7,r.COLUMN2ROW2=8,Object.defineProperties(r.prototype,{length:{get:function(){return r.packedLength}}}),r.prototype.clone=function(e){return r.clone(this,e)},r.prototype.equals=function(e){return r.equals(this,e)},r.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]},r.prototype.equalsEpsilon=function(e,t){return r.equalsEpsilon(this,e,t)},r.prototype.toString=function(){return`(${this[0]}, ${this[3]}, ${this[6]})\n(${this[1]}, ${this[4]}, ${this[7]})\n(${this[2]}, ${this[5]}, ${this[8]})`};var uo=r,bn={};bn.EMPTY_OBJECT=Object.freeze({}),bn.EMPTY_ARRAY=Object.freeze([]);var x,yo=bn,z={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},A={};Object.defineProperties(A,{element:{get:function(){if(A.supportsFullscreen())return document[z.fullscreenElement]}},changeEventName:{get:function(){if(A.supportsFullscreen())return z.fullscreenchange}},errorEventName:{get:function(){if(A.supportsFullscreen())return z.fullscreenerror}},enabled:{get:function(){if(A.supportsFullscreen())return document[z.fullscreenEnabled]}},fullscreen:{get:function(){if(A.supportsFullscreen())return null!==A.element}}}),A.supportsFullscreen=function(){if(u(x))return x;x=!1;let e=document.body;if("function"==typeof e.requestFullscreen)return z.requestFullscreen="requestFullscreen",z.exitFullscreen="exitFullscreen",z.fullscreenEnabled="fullscreenEnabled",z.fullscreenElement="fullscreenElement",z.fullscreenchange="fullscreenchange",z.fullscreenerror="fullscreenerror",x=!0;let t,n=["webkit","moz","o","ms","khtml"];for(let r=0,a=n.length;r<a;++r){let a=n[r];t=`${a}RequestFullscreen`,"function"==typeof e[t]?(z.requestFullscreen=t,x=!0):(t=`${a}RequestFullScreen`,"function"==typeof e[t]&&(z.requestFullscreen=t,x=!0)),t=`${a}ExitFullscreen`,"function"==typeof document[t]?z.exitFullscreen=t:(t=`${a}CancelFullScreen`,"function"==typeof document[t]&&(z.exitFullscreen=t)),t=`${a}FullscreenEnabled`,void 0!==document[t]?z.fullscreenEnabled=t:(t=`${a}FullScreenEnabled`,void 0!==document[t]&&(z.fullscreenEnabled=t)),t=`${a}FullscreenElement`,void 0!==document[t]?z.fullscreenElement=t:(t=`${a}FullScreenElement`,void 0!==document[t]&&(z.fullscreenElement=t)),t=`${a}fullscreenchange`,void 0!==document[`on${t}`]&&("ms"===a&&(t="MSFullscreenChange"),z.fullscreenchange=t),t=`${a}fullscreenerror`,void 0!==document[`on${t}`]&&("ms"===a&&(t="MSFullscreenError"),z.fullscreenerror=t)}return x},A.requestFullscreen=function(e,t){A.supportsFullscreen()&&e[z.requestFullscreen]({vrDisplay:t})},A.exitFullscreen=function(){A.supportsFullscreen()&&document[z.exitFullscreen]()},A._names=z;var E,J,Pn,K,In,nn,gn,D,Sn,en,vn,on,Rn,hn,wn,jn,$n,tn,Un=A;function k(e){let t=e.split(".");for(let e=0,n=t.length;e<n;++e)t[e]=parseInt(t[e],10);return t}function zn(){if(!u(J)&&(J=!1,!cn())){let e=/ Chrome\/([\.0-9]+)/.exec(E.userAgent);null!==e&&(J=!0,Pn=k(e[1]))}return J}function he(){return zn()&&Pn}function Ln(){if(!u(K)&&(K=!1,!zn()&&!cn()&&/ Safari\/[\.0-9]+/.test(E.userAgent))){let e=/ Version\/([\.0-9]+)/.exec(E.userAgent);null!==e&&(K=!0,In=k(e[1]))}return K}function we(){return Ln()&&In}function Wn(){if(!u(nn)){nn=!1;let e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(E.userAgent);null!==e&&(nn=!0,(gn=k(e[1])).isNightly=!!e[2])}return nn}function je(){return Wn()&&gn}function Vn(){if(!u(D)){let e;D=!1,"Microsoft Internet Explorer"===E.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(E.userAgent),null!==e&&(D=!0,Sn=k(e[1]))):"Netscape"===E.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(E.userAgent),null!==e&&(D=!0,Sn=k(e[1])))}return D}function ge(){return Vn()&&Sn}function cn(){if(!u(en)){en=!1;let e=/ Edg\/([\.0-9]+)/.exec(E.userAgent);null!==e&&(en=!0,vn=k(e[1]))}return en}function Se(){return cn()&&vn}function fn(){if(!u(on)){on=!1;let e=/Firefox\/([\.0-9]+)/.exec(E.userAgent);null!==e&&(on=!0,Rn=k(e[1]))}return on}function ze(){return u(hn)||(hn=/Windows/i.test(E.appVersion)),hn}function Re(){return u(wn)||(wn="iPhone"===navigator.platform||"iPod"===navigator.platform||"iPad"===navigator.platform),wn}function Me(){return fn()&&Rn}function qe(){return u(jn)||(jn=!fn()&&typeof PointerEvent<"u"&&(!u(E.pointerEnabled)||E.pointerEnabled)),jn}function Dn(){if(!u(tn)){let e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");let t=e.style.imageRendering;(tn=u(t)&&""!==t)&&($n=t)}return tn}function Ee(){return Dn()?$n:void 0}function q(){if(!q.initialized)throw new g("You must call FeatureDetection.supportsWebP.initialize and wait for the promise to resolve before calling FeatureDetection.supportsWebP");return q._result}E=typeof navigator<"u"?navigator:{},q._promise=void 0,q._result=void 0,q.initialize=function(){return u(q._promise)||(q._promise=new Promise((e=>{let t=new Image;t.onload=function(){q._result=t.width>0&&t.height>0,e(q._result)},t.onerror=function(){q._result=!1,e(q._result)},t.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA"}))),q._promise},Object.defineProperties(q,{initialized:{get:function(){return u(q._result)}}});var v=[];typeof ArrayBuffer<"u"&&(v.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),typeof Uint8ClampedArray<"u"&&v.push(Uint8ClampedArray),typeof Uint8ClampedArray<"u"&&v.push(Uint8ClampedArray),typeof BigInt64Array<"u"&&v.push(BigInt64Array),typeof BigUint64Array<"u"&&v.push(BigUint64Array));var l={isChrome:zn,chromeVersion:he,isSafari:Ln,safariVersion:we,isWebkit:Wn,webkitVersion:je,isInternetExplorer:Vn,internetExplorerVersion:ge,isEdge:cn,edgeVersion:Se,isFirefox:fn,firefoxVersion:Me,isWindows:ze,isIPadOrIOS:Re,hardwareConcurrency:E.hardwareConcurrency??3,supportsPointerEvents:qe,supportsImageRenderingPixelated:Dn,supportsWebP:q,imageRenderingValue:Ee,typedArrayTypes:v,supportsBasis:function(e){return l.supportsWebAssembly()&&e.context.supportsBasis},supportsFullscreen:function(){return Un.supportsFullscreen()},supportsTypedArrays:function(){return typeof ArrayBuffer<"u"},supportsBigInt64Array:function(){return typeof BigInt64Array<"u"},supportsBigUint64Array:function(){return typeof BigUint64Array<"u"},supportsBigInt:function(){return typeof BigInt<"u"},supportsWebWorkers:function(){return typeof Worker<"u"},supportsWebAssembly:function(){return typeof WebAssembly<"u"},supportsWebgl2:function(e){return c.defined("scene",e),e.context.webgl2},supportsEsmWebWorkers:function(){return!fn()||parseInt(Rn)>=114}},go=l;export{y as a,$ as b,yn as c,oo as d,uo as e,yo as f,go as g};