/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as et}from"./chunk-QUETFIFY.js";import{a as Q}from"./chunk-M3XGH3FT.js";import"./chunk-SJMWDCKU.js";import{a as u}from"./chunk-CRK3ZLKL.js";import"./chunk-Z5ZDCTRN.js";import{a as I}from"./chunk-CFRYEZJF.js";import{a as $}from"./chunk-HCF5XBCP.js";import"./chunk-II365YZS.js";import"./chunk-IODKIN3W.js";import{a as f}from"./chunk-QL3VAYCR.js";import"./chunk-WZSOKNIB.js";import"./chunk-4GIZMT42.js";import{b as ot}from"./chunk-EIJCAXME.js";import{a as tt}from"./chunk-2DWCJX3G.js";import"./chunk-L3YV42ES.js";import"./chunk-QTPIBP7S.js";import"./chunk-ZCCOD3XE.js";import{a as J}from"./chunk-SFW65PGL.js";import{a as X}from"./chunk-BTGP76WP.js";import{b as W,c as Y,d as z}from"./chunk-YQL7OPIW.js";import{d as K}from"./chunk-DPQZPDIL.js";import{f as q}from"./chunk-YJEV67VS.js";import{a as B}from"./chunk-4BTDTSQG.js";import{a as i,c as H,d as m,e as g,f as U}from"./chunk-XFVXIGTK.js";import{a as V}from"./chunk-MPRZ6V46.js";import"./chunk-FO77LMQ7.js";import"./chunk-TYEGOJMY.js";import{b as G}from"./chunk-VZMWSUG7.js";import{e as d}from"./chunk-362ETHZ6.js";var st=new i,at=new et,pt=new H,lt=new H,mt=new i,ft=new i,ut=new i,M=new i,yt=new i,ht=new i,nt=new q,dt=new g,gt=new g,Pt=new i;function wt(t,e,n,o,r,a,s,c,p){let l=t.positions,u=ot.triangulate(t.positions2D,t.holes);u.length<3&&(u=[0,1,2]);let m=J.createTypedArray(l.length,u.length);m.set(u);let h=dt;if(0!==o){let t=q.fromAxisAngle(s,o,nt);if(h=g.fromQuaternion(t,h),e.tangent||e.bitangent){t=q.fromAxisAngle(s,-o,nt);let n=g.fromQuaternion(t,gt);c=i.normalize(g.multiplyByVector(n,c,c),c),e.bitangent&&(p=i.normalize(i.cross(s,c,p),p))}}else h=g.clone(g.IDENTITY,h);let y=lt;e.st&&(y.x=n.x,y.y=n.y);let f=l.length,k=3*f,x=new Float64Array(k),w=e.normal?new Float32Array(k):void 0,P=e.tangent?new Float32Array(k):void 0,j=e.bitangent?new Float32Array(k):void 0,F=e.st?new Float32Array(2*f):void 0,T=0,v=0,_=0,A=0,b=0;for(let t=0;t<f;t++){let o=l[t];if(x[T++]=o.x,x[T++]=o.y,x[T++]=o.z,e.st)if(d(r)&&r.positions.length===f)F[b++]=r.positions[t].x,F[b++]=r.positions[t].y;else{let t=a(g.multiplyByVector(h,o,st),pt);H.subtract(t,y,t);let e=V.clamp(t.x/n.width,0,1),i=V.clamp(t.y/n.height,0,1);F[b++]=e,F[b++]=i}e.normal&&(w[v++]=s.x,w[v++]=s.y,w[v++]=s.z),e.tangent&&(P[A++]=c.x,P[A++]=c.y,P[A++]=c.z),e.bitangent&&(j[_++]=p.x,j[_++]=p.y,j[_++]=p.z)}let L=new X;return e.position&&(L.position=new z({componentDatatype:B.DOUBLE,componentsPerAttribute:3,values:x})),e.normal&&(L.normal=new z({componentDatatype:B.FLOAT,componentsPerAttribute:3,values:w})),e.tangent&&(L.tangent=new z({componentDatatype:B.FLOAT,componentsPerAttribute:3,values:P})),e.bitangent&&(L.bitangent=new z({componentDatatype:B.FLOAT,componentsPerAttribute:3,values:j})),e.st&&(L.st=new z({componentDatatype:B.FLOAT,componentsPerAttribute:2,values:F})),new Y({attributes:L,indices:m,primitiveType:W.TRIANGLES})}function x(t){let e=(t=t??U.EMPTY_OBJECT).polygonHierarchy,n=t.textureCoordinates;G.defined("options.polygonHierarchy",e);let o=t.vertexFormat??f.DEFAULT;this._vertexFormat=f.clone(o),this._polygonHierarchy=e,this._stRotation=t.stRotation??0,this._ellipsoid=m.clone(t.ellipsoid??m.default),this._workerName="createCoplanarPolygonGeometry",this._textureCoordinates=n,this.packedLength=u.computeHierarchyPackedLength(e,i)+f.packedLength+m.packedLength+(d(n)?u.computeHierarchyPackedLength(n,H):1)+2}x.fromPositions=function(t){return t=t??U.EMPTY_OBJECT,G.defined("options.positions",t.positions),new x({polygonHierarchy:{positions:t.positions},vertexFormat:t.vertexFormat,stRotation:t.stRotation,ellipsoid:t.ellipsoid,textureCoordinates:t.textureCoordinates})},x.pack=function(t,e,n){return G.typeOf.object("value",t),G.defined("array",e),n=n??0,n=u.packPolygonHierarchy(t._polygonHierarchy,e,n,i),m.pack(t._ellipsoid,e,n),n+=m.packedLength,f.pack(t._vertexFormat,e,n),n+=f.packedLength,e[n++]=t._stRotation,d(t._textureCoordinates)?n=u.packPolygonHierarchy(t._textureCoordinates,e,n,H):e[n++]=-1,e[n++]=t.packedLength,e};var _t=m.clone(m.UNIT_SPHERE),At=new f,bt={polygonHierarchy:{}};x.unpack=function(t,e,n){G.defined("array",t),e=e??0;let o=u.unpackPolygonHierarchy(t,e,i);e=o.startingIndex,delete o.startingIndex;let r=m.unpack(t,e,_t);e+=m.packedLength;let a=f.unpack(t,e,At);e+=f.packedLength;let s=t[e++],c=-1===t[e]?void 0:u.unpackPolygonHierarchy(t,e,H);d(c)?(e=c.startingIndex,delete c.startingIndex):e++;let p=t[e++];return d(n)||(n=new x(bt)),n._polygonHierarchy=o,n._ellipsoid=m.clone(r,n._ellipsoid),n._vertexFormat=f.clone(a,n._vertexFormat),n._stRotation=s,n._textureCoordinates=c,n.packedLength=p,n},x.createGeometry=function(t){let e=t._vertexFormat,n=t._polygonHierarchy,o=t._stRotation,r=t._textureCoordinates,a=d(r),s=n.positions;if(s=tt(s,i.equalsEpsilon,!0),s.length<3)return;let c=mt,p=ft,l=ut,m=yt,h=ht;if(!Q.computeProjectTo2DArguments(s,M,m,h))return;if(c=i.cross(m,h,c),c=i.normalize(c,c),!i.equalsEpsilon(M,i.ZERO,V.EPSILON6)){let e=t._ellipsoid.geodeticSurfaceNormal(M,Pt);i.dot(c,e)<0&&(c=i.negate(c,c),m=i.negate(m,m))}let g=Q.createProjectPointsTo2DFunction(M,m,h),y=Q.createProjectPointTo2DFunction(M,m,h);e.tangent&&(p=i.clone(m,p)),e.bitangent&&(l=i.clone(h,l));let f=u.polygonsFromHierarchy(n,a,g,!1),k=f.hierarchy,x=f.polygons,w=a?u.polygonsFromHierarchy(r,!0,(function(t){return t}),!1).polygons:void 0;if(0===k.length)return;s=k[0].outerRing;let P=K.fromPoints(s),j=u.computeBoundingRectangle(c,y,s,o,at),F=[];for(let t=0;t<x.length;t++){let n=new I({geometry:wt(x[t],e,j,o,a?w[t]:void 0,y,c,p,l)});F.push(n)}let T=$.combineInstances(F)[0];T.attributes.position.values=new Float64Array(T.attributes.position.values),T.indices=J.createTypedArray(T.attributes.position.values.length/3,T.indices);let v=T.attributes;return e.position||delete v.position,new Y({attributes:v,indices:T.indices,primitiveType:T.primitiveType,boundingSphere:P})};var Z=x;function kt(t,e){return d(e)&&(t=Z.unpack(t,e)),Z.createGeometry(t)}var Xt=kt;export{Xt as default};