/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as M}from"./chunk-IQWHXQMD.js";import{a as ut}from"./chunk-WKCSG3U3.js";import"./chunk-MQYSNG5N.js";import"./chunk-QYCM25U7.js";import{a as bt}from"./chunk-64C3WG2L.js";import{a as J}from"./chunk-QL3VAYCR.js";import"./chunk-WZSOKNIB.js";import"./chunk-4GIZMT42.js";import{b as _t}from"./chunk-EIJCAXME.js";import{a as Pt}from"./chunk-2DWCJX3G.js";import"./chunk-L3YV42ES.js";import"./chunk-QTPIBP7S.js";import"./chunk-ZCCOD3XE.js";import{a as Nt}from"./chunk-SFW65PGL.js";import{a as Dt}from"./chunk-BTGP76WP.js";import{b as Mt,c as Ct,d as F}from"./chunk-YQL7OPIW.js";import{d as St}from"./chunk-DPQZPDIL.js";import{h as Et}from"./chunk-YJEV67VS.js";import{a as v}from"./chunk-4BTDTSQG.js";import{a as o,b as At,d as Y,f as Tt}from"./chunk-XFVXIGTK.js";import{a as it}from"./chunk-MPRZ6V46.js";import"./chunk-FO77LMQ7.js";import"./chunk-TYEGOJMY.js";import{b as ot}from"./chunk-VZMWSUG7.js";import{e as Q}from"./chunk-362ETHZ6.js";var Rt=new o,kt=new o,yt=new o,wt=new o,jt=new o,Ht=new o,st=new o,dt=new o;function Ut(t,e){for(let o=0;o<t.length;o++)t[o]=e.scaleToGeodeticSurface(t[o],t[o]);return t}function X(t,e,r,i,a,n){let s=t.normals,l=t.tangents,u=t.bitangents,d=o.normalize(o.cross(r,e,st),st);n.normal&&M.addAttribute(s,e,i,a),n.tangent&&M.addAttribute(l,d,i,a),n.bitangent&&M.addAttribute(u,r,i,a)}function Bt(t,e,r){let i,a,n,s=t.positions,l=t.corners,u=t.endPositions,d=t.lefts,h=t.normals,m=new Dt,c=0,f=0,g=0;for(a=0;a<s.length;a+=2)n=s[a].length-3,c+=n,g+=2*n,f+=s[a+1].length-3;for(c+=3,f+=3,a=0;a<l.length;a++){i=l[a];let t=l[a].leftPositions;Q(t)?(n=t.length,c+=n,g+=n):(n=l[a].rightPositions.length,f+=n,g+=n)}let p,A=Q(u);A&&(p=u[0].length-3,c+=p,f+=p,p/=3,g+=6*p);let y,b,_,w,T,I,k=c+f,E=new Float64Array(k),N={normals:e.normal?new Float32Array(k):void 0,tangents:e.tangent?new Float32Array(k):void 0,bitangents:e.bitangent?new Float32Array(k):void 0},P=0,O=k-1,x=Rt,G=kt,S=p/2,Y=Nt.createTypedArray(k/3,g),D=0;if(A){I=yt,T=wt;let t=u[0];for(x=o.fromArray(h,0,x),G=o.fromArray(d,0,G),a=0;a<S;a++)I=o.fromArray(t,3*(S-1-a),I),T=o.fromArray(t,3*(S+a),T),M.addAttribute(E,T,P),M.addAttribute(E,I,void 0,O),X(N,x,G,P,O,e),b=P/3,w=b+1,y=(O-2)/3,_=y-1,Y[D++]=y,Y[D++]=b,Y[D++]=_,Y[D++]=_,Y[D++]=b,Y[D++]=w,P+=3,O-=3}let V,W,L=0,j=0,J=s[L++],R=s[L++];for(E.set(J,P),E.set(R,O-R.length+1),G=o.fromArray(d,j,G),n=R.length-3,a=0;a<n;a+=3)V=r.geodeticSurfaceNormal(o.fromArray(J,a,st),st),W=r.geodeticSurfaceNormal(o.fromArray(R,n-a,dt),dt),x=o.normalize(o.add(V,W,x),x),X(N,x,G,P,O,e),b=P/3,w=b+1,y=(O-2)/3,_=y-1,Y[D++]=y,Y[D++]=b,Y[D++]=_,Y[D++]=_,Y[D++]=b,Y[D++]=w,P+=3,O-=3;for(V=r.geodeticSurfaceNormal(o.fromArray(J,n,st),st),W=r.geodeticSurfaceNormal(o.fromArray(R,n,dt),dt),x=o.normalize(o.add(V,W,x),x),j+=3,a=0;a<l.length;a++){let t;i=l[a];let u,m,c=i.leftPositions,f=i.rightPositions,g=Ht,p=yt,A=wt;if(x=o.fromArray(h,j,x),Q(c)){for(X(N,x,G,void 0,O,e),O-=3,u=w,m=_,t=0;t<c.length/3;t++)g=o.fromArray(c,3*t,g),Y[D++]=u,Y[D++]=m-t-1,Y[D++]=m-t,M.addAttribute(E,g,void 0,O),p=o.fromArray(E,3*(m-t-1),p),A=o.fromArray(E,3*u,A),G=o.normalize(o.subtract(p,A,G),G),X(N,x,G,void 0,O,e),O-=3;g=o.fromArray(E,3*u,g),p=o.subtract(o.fromArray(E,3*m,p),g,p),A=o.subtract(o.fromArray(E,3*(m-t),A),g,A),G=o.normalize(o.add(p,A,G),G),X(N,x,G,P,void 0,e),P+=3}else{for(X(N,x,G,P,void 0,e),P+=3,u=_,m=w,t=0;t<f.length/3;t++)g=o.fromArray(f,3*t,g),Y[D++]=u,Y[D++]=m+t,Y[D++]=m+t+1,M.addAttribute(E,g,P),p=o.fromArray(E,3*u,p),A=o.fromArray(E,3*(m+t),A),G=o.normalize(o.subtract(p,A,G),G),X(N,x,G,P,void 0,e),P+=3;g=o.fromArray(E,3*u,g),p=o.subtract(o.fromArray(E,3*(m+t),p),g,p),A=o.subtract(o.fromArray(E,3*m,A),g,A),G=o.normalize(o.negate(o.add(A,p,G),G),G),X(N,x,G,void 0,O,e),O-=3}for(J=s[L++],R=s[L++],J.splice(0,3),R.splice(R.length-3,3),E.set(J,P),E.set(R,O-R.length+1),n=R.length-3,j+=3,G=o.fromArray(d,j,G),t=0;t<R.length;t+=3)V=r.geodeticSurfaceNormal(o.fromArray(J,t,st),st),W=r.geodeticSurfaceNormal(o.fromArray(R,n-t,dt),dt),x=o.normalize(o.add(V,W,x),x),X(N,x,G,P,O,e),w=P/3,b=w-1,_=(O-2)/3,y=_+1,Y[D++]=y,Y[D++]=b,Y[D++]=_,Y[D++]=_,Y[D++]=b,Y[D++]=w,P+=3,O-=3;P-=3,O+=3}if(x=o.fromArray(h,h.length-3,x),X(N,x,G,P,O,e),A){P+=3,O-=3,I=yt,T=wt;let t=u[1];for(a=0;a<S;a++)I=o.fromArray(t,3*(p-a-1),I),T=o.fromArray(t,3*a,T),M.addAttribute(E,I,void 0,O),M.addAttribute(E,T,P),X(N,x,G,P,O,e),w=P/3,b=w-1,_=(O-2)/3,y=_+1,Y[D++]=y,Y[D++]=b,Y[D++]=_,Y[D++]=_,Y[D++]=b,Y[D++]=w,P+=3,O-=3}if(m.position=new F({componentDatatype:v.DOUBLE,componentsPerAttribute:3,values:E}),e.st){let t,e,o=new Float32Array(k/3*2),r=0;if(A){c/=3,f/=3;let i=Math.PI/(p+1);e=1/(c-p+1),t=1/(f-p+1);let n,s=p/2;for(a=s+1;a<p+1;a++)n=it.PI_OVER_TWO+i*a,o[r++]=t*(1+Math.cos(n)),o[r++]=.5*(1+Math.sin(n));for(a=1;a<f-p+1;a++)o[r++]=a*t,o[r++]=0;for(a=p;a>s;a--)n=it.PI_OVER_TWO-a*i,o[r++]=1-t*(1+Math.cos(n)),o[r++]=.5*(1+Math.sin(n));for(a=s;a>0;a--)n=it.PI_OVER_TWO-i*a,o[r++]=1-e*(1+Math.cos(n)),o[r++]=.5*(1+Math.sin(n));for(a=c-p;a>0;a--)o[r++]=a*e,o[r++]=1;for(a=1;a<s+1;a++)n=it.PI_OVER_TWO+i*a,o[r++]=e*(1+Math.cos(n)),o[r++]=.5*(1+Math.sin(n))}else{for(c/=3,f/=3,e=1/(c-1),t=1/(f-1),a=0;a<f;a++)o[r++]=a*t,o[r++]=0;for(a=c;a>0;a--)o[r++]=(a-1)*e,o[r++]=1}m.st=new F({componentDatatype:v.FLOAT,componentsPerAttribute:2,values:o})}return e.normal&&(m.normal=new F({componentDatatype:v.FLOAT,componentsPerAttribute:3,values:N.normals})),e.tangent&&(m.tangent=new F({componentDatatype:v.FLOAT,componentsPerAttribute:3,values:N.tangents})),e.bitangent&&(m.bitangent=new F({componentDatatype:v.FLOAT,componentsPerAttribute:3,values:N.bitangents})),{attributes:m,indices:Y}}function qt(t,e){if(!(e.normal||e.tangent||e.bitangent||e.st))return t;let r,i,a=t.position.values;(e.normal||e.bitangent)&&(r=t.normal.values,i=t.bitangent.values);let n,s=t.position.values.length/18,l=3*s,u=2*s,d=2*l;if(e.normal||e.bitangent||e.tangent){let s=e.normal?new Float32Array(6*l):void 0,u=e.tangent?new Float32Array(6*l):void 0,h=e.bitangent?new Float32Array(6*l):void 0,m=Rt,c=kt,f=yt,g=wt,p=jt,A=Ht,y=d;for(n=0;n<l;n+=3){let t=y+d;m=o.fromArray(a,n,m),c=o.fromArray(a,n+l,c),f=o.fromArray(a,(n+3)%l,f),c=o.subtract(c,m,c),f=o.subtract(f,m,f),g=o.normalize(o.cross(c,f,g),g),e.normal&&(M.addAttribute(s,g,t),M.addAttribute(s,g,t+3),M.addAttribute(s,g,y),M.addAttribute(s,g,y+3)),(e.tangent||e.bitangent)&&(A=o.fromArray(r,n,A),e.bitangent&&(M.addAttribute(h,A,t),M.addAttribute(h,A,t+3),M.addAttribute(h,A,y),M.addAttribute(h,A,y+3)),e.tangent&&(p=o.normalize(o.cross(A,g,p),p),M.addAttribute(u,p,t),M.addAttribute(u,p,t+3),M.addAttribute(u,p,y),M.addAttribute(u,p,y+3))),y+=6}if(e.normal){for(s.set(r),n=0;n<l;n+=3)s[n+l]=-r[n],s[n+l+1]=-r[n+1],s[n+l+2]=-r[n+2];t.normal.values=s}else t.normal=void 0;if(e.bitangent?(h.set(i),h.set(i,l),t.bitangent.values=h):t.bitangent=void 0,e.tangent){let e=t.tangent.values;u.set(e),u.set(e,l),t.tangent.values=u}}if(e.st){let e=t.st.values,o=new Float32Array(6*u);o.set(e),o.set(e,u);let r=2*u;for(let t=0;t<2;t++){for(o[r++]=e[0],o[r++]=e[1],n=2;n<u;n+=2){let t=e[n],i=e[n+1];o[r++]=t,o[r++]=i,o[r++]=t,o[r++]=i}o[r++]=e[0],o[r++]=e[1]}t.st.values=o}return t}function Ot(t,e,o){o[e++]=t[0],o[e++]=t[1],o[e++]=t[2];for(let r=3;r<t.length;r+=3){let i=t[r],a=t[r+1],n=t[r+2];o[e++]=i,o[e++]=a,o[e++]=n,o[e++]=i,o[e++]=a,o[e++]=n}return o[e++]=t[0],o[e++]=t[1],o[e++]=t[2],o}function Jt(t,e){let o=new J({position:e.position,normal:e.normal||e.bitangent||t.shadowVolume,tangent:e.tangent,bitangent:e.normal||e.bitangent,st:e.st}),r=t.ellipsoid,i=Bt(M.computePositions(t),o,r),a=t.height,n=t.extrudedHeight,s=i.attributes,l=i.indices,u=s.position.values,d=u.length,h=new Float64Array(6*d),m=new Float64Array(d);m.set(u);let c=new Float64Array(4*d);u=_t.scaleToGeodeticHeight(u,a,r),c=Ot(u,0,c),m=_t.scaleToGeodeticHeight(m,n,r),c=Ot(m,2*d,c),h.set(u),h.set(m,d),h.set(c,2*d),s.position.values=h,s=qt(s,e);let f,g=d/3;if(t.shadowVolume){let t=s.normal.values;d=t.length;let o=new Float32Array(6*d);for(f=0;f<d;f++)t[f]=-t[f];o.set(t,d),o=Ot(t,4*d,o),s.extrudeDirection=new F({componentDatatype:v.FLOAT,componentsPerAttribute:3,values:o}),e.normal||(s.normal=void 0)}if(Q(t.offsetAttribute)){let e=new Uint8Array(6*g);if(t.offsetAttribute===bt.TOP)e=e.fill(1,0,g).fill(1,2*g,4*g);else{let o=t.offsetAttribute===bt.NONE?0:1;e=e.fill(o)}s.applyOffset=new F({componentDatatype:v.UNSIGNED_BYTE,componentsPerAttribute:1,values:e})}let p=l.length,A=g+g,y=Nt.createTypedArray(h.length/3,2*p+3*A);y.set(l);let b,_,w,T,I=p;for(f=0;f<p;f+=3){let t=l[f],e=l[f+1],o=l[f+2];y[I++]=o+g,y[I++]=e+g,y[I++]=t+g}for(f=0;f<A;f+=2)b=f+A,_=b+A,w=b+1,T=_+1,y[I++]=b,y[I++]=_,y[I++]=w,y[I++]=w,y[I++]=_,y[I++]=T;return{attributes:s,indices:y}}var Vt=new o,ht=new o,K=new At;function zt(t,e,r,i,a,n){let s=o.subtract(e,t,Vt);o.normalize(s,s);let l=r.geodeticSurfaceNormal(t,ht),u=o.cross(s,l,Vt);o.multiplyByScalar(u,i,u);let d=a.latitude,h=a.longitude,m=n.latitude,c=n.longitude;o.add(t,u,ht),r.cartesianToCartographic(ht,K);let f=K.latitude,g=K.longitude;d=Math.min(d,f),h=Math.min(h,g),m=Math.max(m,f),c=Math.max(c,g),o.subtract(t,u,ht),r.cartesianToCartographic(ht,K),f=K.latitude,g=K.longitude,d=Math.min(d,f),h=Math.min(h,g),m=Math.max(m,f),c=Math.max(c,g),a.latitude=d,a.longitude=h,n.latitude=m,n.longitude=c}var G=new o,gt=new o,I=new At,W=new At;function Yt(t,e,r,i,a){t=Ut(t,e);let n=Pt(t,o.equalsEpsilon),s=n.length;if(s<2||r<=0)return new Et;let l,u,d=.5*r;if(I.latitude=Number.POSITIVE_INFINITY,I.longitude=Number.POSITIVE_INFINITY,W.latitude=Number.NEGATIVE_INFINITY,W.longitude=Number.NEGATIVE_INFINITY,i===ut.ROUNDED){let t=n[0];o.subtract(t,n[1],G),o.normalize(G,G),o.multiplyByScalar(G,d,G),o.add(t,G,gt),e.cartesianToCartographic(gt,K),l=K.latitude,u=K.longitude,I.latitude=Math.min(I.latitude,l),I.longitude=Math.min(I.longitude,u),W.latitude=Math.max(W.latitude,l),W.longitude=Math.max(W.longitude,u)}for(let t=0;t<s-1;++t)zt(n[t],n[t+1],e,d,I,W);let h=n[s-1];o.subtract(h,n[s-2],G),o.normalize(G,G),o.multiplyByScalar(G,d,G),o.add(h,G,gt),zt(h,gt,e,d,I,W),i===ut.ROUNDED&&(e.cartesianToCartographic(gt,K),l=K.latitude,u=K.longitude,I.latitude=Math.min(I.latitude,l),I.longitude=Math.min(I.longitude,u),W.latitude=Math.max(W.latitude,l),W.longitude=Math.max(W.longitude,u));let m=Q(a)?a:new Et;return m.north=W.latitude,m.south=I.latitude,m.east=W.longitude,m.west=I.longitude,m}function tt(t){let e=(t=t??Tt.EMPTY_OBJECT).positions,r=t.width;ot.defined("options.positions",e),ot.defined("options.width",r);let i=t.height??0,a=t.extrudedHeight??i;this._positions=e,this._ellipsoid=Y.clone(t.ellipsoid??Y.default),this._vertexFormat=J.clone(t.vertexFormat??J.DEFAULT),this._width=r,this._height=Math.max(i,a),this._extrudedHeight=Math.min(i,a),this._cornerType=t.cornerType??ut.ROUNDED,this._granularity=t.granularity??it.RADIANS_PER_DEGREE,this._shadowVolume=t.shadowVolume??!1,this._workerName="createCorridorGeometry",this._offsetAttribute=t.offsetAttribute,this._rectangle=void 0,this.packedLength=1+e.length*o.packedLength+Y.packedLength+J.packedLength+7}tt.pack=function(t,e,r){ot.defined("value",t),ot.defined("array",e),r=r??0;let i=t._positions,a=i.length;e[r++]=a;for(let t=0;t<a;++t,r+=o.packedLength)o.pack(i[t],e,r);return Y.pack(t._ellipsoid,e,r),r+=Y.packedLength,J.pack(t._vertexFormat,e,r),r+=J.packedLength,e[r++]=t._width,e[r++]=t._height,e[r++]=t._extrudedHeight,e[r++]=t._cornerType,e[r++]=t._granularity,e[r++]=t._shadowVolume?1:0,e[r]=t._offsetAttribute??-1,e};var It=Y.clone(Y.UNIT_SPHERE),Wt=new J,x={positions:void 0,ellipsoid:It,vertexFormat:Wt,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0,shadowVolume:void 0,offsetAttribute:void 0};tt.unpack=function(t,e,r){ot.defined("array",t),e=e??0;let i=t[e++],a=new Array(i);for(let r=0;r<i;++r,e+=o.packedLength)a[r]=o.unpack(t,e);let n=Y.unpack(t,e,It);e+=Y.packedLength;let s=J.unpack(t,e,Wt);e+=J.packedLength;let l=t[e++],u=t[e++],d=t[e++],h=t[e++],m=t[e++],c=1===t[e++],f=t[e];return Q(r)?(r._positions=a,r._ellipsoid=Y.clone(n,r._ellipsoid),r._vertexFormat=J.clone(s,r._vertexFormat),r._width=l,r._height=u,r._extrudedHeight=d,r._cornerType=h,r._granularity=m,r._shadowVolume=c,r._offsetAttribute=-1===f?void 0:f,r):(x.positions=a,x.width=l,x.height=u,x.extrudedHeight=d,x.cornerType=h,x.granularity=m,x.shadowVolume=c,x.offsetAttribute=-1===f?void 0:f,new tt(x))},tt.computeRectangle=function(t,e){let o=(t=t??Tt.EMPTY_OBJECT).positions,r=t.width;return ot.defined("options.positions",o),ot.defined("options.width",r),Yt(o,t.ellipsoid??Y.default,r,t.cornerType??ut.ROUNDED,e)},tt.createGeometry=function(t){let e=t._positions,r=t._width,i=t._ellipsoid;e=Ut(e,i);let a=Pt(e,o.equalsEpsilon);if(a.length<2||r<=0)return;let n,s=t._height,l=t._extrudedHeight,u=!it.equalsEpsilon(s,l,0,it.EPSILON2),d=t._vertexFormat,h={ellipsoid:i,positions:a,width:r,cornerType:t._cornerType,granularity:t._granularity,saveAttributes:!0};if(u)h.height=s,h.extrudedHeight=l,h.shadowVolume=t._shadowVolume,h.offsetAttribute=t._offsetAttribute,n=Jt(h,d);else{if(n=Bt(M.computePositions(h),d,i),n.attributes.position.values=_t.scaleToGeodeticHeight(n.attributes.position.values,s,i),Q(t._offsetAttribute)){let e=t._offsetAttribute===bt.NONE?0:1,o=n.attributes.position.values.length,r=new Uint8Array(o/3).fill(e);n.attributes.applyOffset=new F({componentDatatype:v.UNSIGNED_BYTE,componentsPerAttribute:1,values:r})}}let m=n.attributes,c=St.fromVertices(m.position.values,void 0,3);return d.position||(n.attributes.position.values=void 0),new Ct({attributes:m,indices:n.indices,primitiveType:Mt.TRIANGLES,boundingSphere:c,offsetAttribute:t._offsetAttribute})},tt.createShadowVolume=function(t,e,o){let r=t._granularity,i=t._ellipsoid,a=e(r,i),n=o(r,i);return new tt({positions:t._positions,width:t._width,cornerType:t._cornerType,ellipsoid:i,granularity:r,extrudedHeight:a,height:n,vertexFormat:J.POSITION_ONLY,shadowVolume:!0})},Object.defineProperties(tt.prototype,{rectangle:{get:function(){return Q(this._rectangle)||(this._rectangle=Yt(this._positions,this._ellipsoid,this._width,this._cornerType)),this._rectangle}},textureCoordinateRotationPoints:{get:function(){return[0,0,0,1,1,0]}}});var Lt=tt;function Gt(t,e){return Q(e)&&(t=Lt.unpack(t,e)),t._ellipsoid=Y.clone(t._ellipsoid),Lt.createGeometry(t)}var Ae=Gt;export{Ae as default};