/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as C}from"./chunk-IQWHXQMD.js";import{a as Q}from"./chunk-WKCSG3U3.js";import"./chunk-MQYSNG5N.js";import"./chunk-QYCM25U7.js";import{a as J}from"./chunk-64C3WG2L.js";import"./chunk-WZSOKNIB.js";import"./chunk-4GIZMT42.js";import{b as K}from"./chunk-EIJCAXME.js";import{a as it}from"./chunk-2DWCJX3G.js";import"./chunk-L3YV42ES.js";import"./chunk-QTPIBP7S.js";import"./chunk-ZCCOD3XE.js";import{a as X}from"./chunk-SFW65PGL.js";import{a as et}from"./chunk-BTGP76WP.js";import{b as I,c as tt,d as z}from"./chunk-YQL7OPIW.js";import{d as x}from"./chunk-DPQZPDIL.js";import"./chunk-YJEV67VS.js";import{a as q}from"./chunk-4BTDTSQG.js";import{a as A,d as P,f as $}from"./chunk-XFVXIGTK.js";import{a as Y}from"./chunk-MPRZ6V46.js";import"./chunk-FO77LMQ7.js";import"./chunk-TYEGOJMY.js";import{b as B}from"./chunk-VZMWSUG7.js";import{e as N}from"./chunk-362ETHZ6.js";var ot=new A,nt=new A,lt=new A;function ft(t,e){for(let i=0;i<t.length;i++)t[i]=e.scaleToGeodeticSurface(t[i],t[i]);return t}function st(t,e){let i,r,o,s=[],n=t.positions,l=t.corners,a=t.endPositions,h=new et,u=0,p=0,f=0;for(r=0;r<n.length;r+=2)o=n[r].length-3,u+=o,f+=o/3*4,p+=n[r+1].length-3;for(u+=3,p+=3,r=0;r<l.length;r++){i=l[r];let t=l[r].leftPositions;N(t)?(o=t.length,u+=o,f+=o/3*2):(o=l[r].rightPositions.length,p+=o,f+=o/3*2)}let c,d=N(a);d&&(c=a[0].length-3,u+=c,p+=c,c/=3,f+=4*c);let g,m,y,_,b,k,v=u+p,P=new Float64Array(v),E=0,T=v-1,j=c/2,w=X.createTypedArray(v/3,f+4),O=0;if(w[O++]=E/3,w[O++]=(T-2)/3,d){s.push(E/3),k=ot,b=nt;let t=a[0];for(r=0;r<j;r++)k=A.fromArray(t,3*(j-1-r),k),b=A.fromArray(t,3*(j+r),b),C.addAttribute(P,b,E),C.addAttribute(P,k,void 0,T),m=E/3,_=m+1,g=(T-2)/3,y=g-1,w[O++]=g,w[O++]=y,w[O++]=m,w[O++]=_,E+=3,T-=3}let G=0,M=n[G++],D=n[G++];for(P.set(M,E),P.set(D,T-D.length+1),o=D.length-3,s.push(E/3,(T-2)/3),r=0;r<o;r+=3)m=E/3,_=m+1,g=(T-2)/3,y=g-1,w[O++]=g,w[O++]=y,w[O++]=m,w[O++]=_,E+=3,T-=3;for(r=0;r<l.length;r++){let t;i=l[r];let a,h=i.leftPositions,u=i.rightPositions,p=lt;if(N(h)){for(T-=3,a=y,s.push(_),t=0;t<h.length/3;t++)p=A.fromArray(h,3*t,p),w[O++]=a-t-1,w[O++]=a-t,C.addAttribute(P,p,void 0,T),T-=3;s.push(a-Math.floor(h.length/6)),e===Q.BEVELED&&s.push((T-2)/3+1),E+=3}else{for(E+=3,a=_,s.push(y),t=0;t<u.length/3;t++)p=A.fromArray(u,3*t,p),w[O++]=a+t,w[O++]=a+t+1,C.addAttribute(P,p,E),E+=3;s.push(a+Math.floor(u.length/6)),e===Q.BEVELED&&s.push(E/3-1),T-=3}for(M=n[G++],D=n[G++],M.splice(0,3),D.splice(D.length-3,3),P.set(M,E),P.set(D,T-D.length+1),o=D.length-3,t=0;t<D.length;t+=3)_=E/3,m=_-1,y=(T-2)/3,g=y+1,w[O++]=g,w[O++]=y,w[O++]=m,w[O++]=_,E+=3,T-=3;E-=3,T+=3,s.push(E/3,(T-2)/3)}if(d){E+=3,T-=3,k=ot,b=nt;let t=a[1];for(r=0;r<j;r++)k=A.fromArray(t,3*(c-r-1),k),b=A.fromArray(t,3*r,b),C.addAttribute(P,k,void 0,T),C.addAttribute(P,b,E),_=E/3,m=_-1,y=(T-2)/3,g=y+1,w[O++]=g,w[O++]=y,w[O++]=m,w[O++]=_,E+=3,T-=3;s.push(E/3)}else s.push(E/3,(T-2)/3);return w[O++]=E/3,w[O++]=(T-2)/3,h.position=new z({componentDatatype:q.DOUBLE,componentsPerAttribute:3,values:P}),{attributes:h,indices:w,wallIndices:s}}function ct(t){let e=t.ellipsoid,i=st(C.computePositions(t),t.cornerType),r=i.wallIndices,o=t.height,s=t.extrudedHeight,n=i.attributes,l=i.indices,a=n.position.values,h=a.length,u=new Float64Array(h);u.set(a);let p=new Float64Array(2*h);if(a=K.scaleToGeodeticHeight(a,o,e),u=K.scaleToGeodeticHeight(u,s,e),p.set(a),p.set(u,h),n.position.values=p,h/=3,N(t.offsetAttribute)){let e=new Uint8Array(2*h);if(t.offsetAttribute===J.TOP)e=e.fill(1,0,h);else{let i=t.offsetAttribute===J.NONE?0:1;e=e.fill(i)}n.applyOffset=new z({componentDatatype:q.UNSIGNED_BYTE,componentsPerAttribute:1,values:e})}let f,c=l.length,d=X.createTypedArray(p.length/3,2*(c+r.length));d.set(l);let g,m,A=c;for(f=0;f<c;f+=2){let t=l[f],e=l[f+1];d[A++]=t+h,d[A++]=e+h}for(f=0;f<r.length;f++)g=r[f],m=g+h,d[A++]=g,d[A++]=m;return{attributes:n,indices:d}}function M(t){let e=(t=t??$.EMPTY_OBJECT).positions,i=t.width;B.typeOf.object("options.positions",e),B.typeOf.number("options.width",i);let r=t.height??0,o=t.extrudedHeight??r;this._positions=e,this._ellipsoid=P.clone(t.ellipsoid??P.default),this._width=i,this._height=Math.max(r,o),this._extrudedHeight=Math.min(r,o),this._cornerType=t.cornerType??Q.ROUNDED,this._granularity=t.granularity??Y.RADIANS_PER_DEGREE,this._offsetAttribute=t.offsetAttribute,this._workerName="createCorridorOutlineGeometry",this.packedLength=1+e.length*A.packedLength+P.packedLength+6}M.pack=function(t,e,i){B.typeOf.object("value",t),B.typeOf.object("array",e),i=i??0;let r=t._positions,o=r.length;e[i++]=o;for(let t=0;t<o;++t,i+=A.packedLength)A.pack(r[t],e,i);return P.pack(t._ellipsoid,e,i),i+=P.packedLength,e[i++]=t._width,e[i++]=t._height,e[i++]=t._extrudedHeight,e[i++]=t._cornerType,e[i++]=t._granularity,e[i]=t._offsetAttribute??-1,e};var rt=P.clone(P.UNIT_SPHERE),v={positions:void 0,ellipsoid:rt,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0,offsetAttribute:void 0};M.unpack=function(t,e,i){B.typeOf.object("array",t),e=e??0;let r=t[e++],o=new Array(r);for(let i=0;i<r;++i,e+=A.packedLength)o[i]=A.unpack(t,e);let s=P.unpack(t,e,rt);e+=P.packedLength;let n=t[e++],l=t[e++],a=t[e++],h=t[e++],u=t[e++],p=t[e];return N(i)?(i._positions=o,i._ellipsoid=P.clone(s,i._ellipsoid),i._width=n,i._height=l,i._extrudedHeight=a,i._cornerType=h,i._granularity=u,i._offsetAttribute=-1===p?void 0:p,i):(v.positions=o,v.width=n,v.height=l,v.extrudedHeight=a,v.cornerType=h,v.granularity=u,v.offsetAttribute=-1===p?void 0:p,new M(v))},M.createGeometry=function(t){let e=t._positions,i=t._width,r=t._ellipsoid;e=ft(e,r);let o=it(e,A.equalsEpsilon);if(o.length<2||i<=0)return;let s,n=t._height,l=t._extrudedHeight,a=!Y.equalsEpsilon(n,l,0,Y.EPSILON2),h={ellipsoid:r,positions:o,width:i,cornerType:t._cornerType,granularity:t._granularity,saveAttributes:!1};if(a)h.height=n,h.extrudedHeight=l,h.offsetAttribute=t._offsetAttribute,s=ct(h);else{if(s=st(C.computePositions(h),h.cornerType),s.attributes.position.values=K.scaleToGeodeticHeight(s.attributes.position.values,n,r),N(t._offsetAttribute)){let e=s.attributes.position.values.length,i=t._offsetAttribute===J.NONE?0:1,r=new Uint8Array(e/3).fill(i);s.attributes.applyOffset=new z({componentDatatype:q.UNSIGNED_BYTE,componentsPerAttribute:1,values:r})}}let u=s.attributes,p=x.fromVertices(u.position.values,void 0,3);return new tt({attributes:u,indices:s.indices,primitiveType:I.LINES,boundingSphere:p,offsetAttribute:t._offsetAttribute})};var Z=M;function ht(t,e){return N(e)&&(t=Z.unpack(t,e)),t._ellipsoid=P.clone(t._ellipsoid),Z.createGeometry(t)}var Ot=ht;export{Ot as default};