/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as _e}from"./chunk-WV2B3Y5P.js";import{a as W}from"./chunk-Z5ZDCTRN.js";import{a as Ct}from"./chunk-IODKIN3W.js";import{a as Oe}from"./chunk-QYCM25U7.js";import{a as Le}from"./chunk-2DWCJX3G.js";import{a as te}from"./chunk-L3YV42ES.js";import{b as Qt}from"./chunk-QTPIBP7S.js";import{a as jt}from"./chunk-ZCCOD3XE.js";import{c as Ce,d as zt}from"./chunk-YQL7OPIW.js";import{a as Pt,d as U}from"./chunk-DPQZPDIL.js";import{d as xe,e as Ne,f as Kt,h as Y}from"./chunk-YJEV67VS.js";import{a as Bt}from"./chunk-4BTDTSQG.js";import{a as t,b as u,c as Rt,d as B,e as bt,f as vt}from"./chunk-XFVXIGTK.js";import{a as p}from"./chunk-MPRZ6V46.js";import"./chunk-FO77LMQ7.js";import"./chunk-TYEGOJMY.js";import{a as wt,b as tt}from"./chunk-VZMWSUG7.js";import{e as g}from"./chunk-362ETHZ6.js";function it(t){t=t??vt.EMPTY_OBJECT,this._ellipsoid=t.ellipsoid??B.default,this._rectangle=t.rectangle??Y.MAX_VALUE,this._projection=new Pt(this._ellipsoid),this._numberOfLevelZeroTilesX=t.numberOfLevelZeroTilesX??2,this._numberOfLevelZeroTilesY=t.numberOfLevelZeroTilesY??1}Object.defineProperties(it.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),it.prototype.getNumberOfXTilesAtLevel=function(t){return this._numberOfLevelZeroTilesX<<t},it.prototype.getNumberOfYTilesAtLevel=function(t){return this._numberOfLevelZeroTilesY<<t},it.prototype.rectangleToNativeRectangle=function(t,e){tt.defined("rectangle",t);let n=p.toDegrees(t.west),i=p.toDegrees(t.south),r=p.toDegrees(t.east),a=p.toDegrees(t.north);return g(e)?(e.west=n,e.south=i,e.east=r,e.north=a,e):new Y(n,i,r,a)},it.prototype.tileXYToNativeRectangle=function(t,e,n,i){let r=this.tileXYToRectangle(t,e,n,i);return r.west=p.toDegrees(r.west),r.south=p.toDegrees(r.south),r.east=p.toDegrees(r.east),r.north=p.toDegrees(r.north),r},it.prototype.tileXYToRectangle=function(t,e,n,i){let r=this._rectangle,a=this.getNumberOfXTilesAtLevel(n),o=this.getNumberOfYTilesAtLevel(n),l=r.width/a,s=t*l+r.west,u=(t+1)*l+r.west,p=r.height/o,c=r.north-e*p,h=r.north-(e+1)*p;return g(i)||(i=new Y(s,h,u,c)),i.west=s,i.south=h,i.east=u,i.north=c,i},it.prototype.positionToTileXY=function(t,e,n){let i=this._rectangle;if(!Y.contains(i,t))return;let r=this.getNumberOfXTilesAtLevel(e),a=this.getNumberOfYTilesAtLevel(e),o=i.width/r,l=i.height/a,s=t.longitude;i.east<i.west&&(s+=p.TWO_PI);let u=(s-i.west)/o|0;u>=r&&(u=r-1);let c=(i.north-t.latitude)/l|0;return c>=a&&(c=a-1),g(n)?(n.x=u,n.y=c,n):new Rt(u,c)};var De=it,Ie=new t,He=new t,ke=new u,ee=new t,hn=new t,ye=new U,pn=new De,_t=[new u,new u,new u,new u],Lt=new Rt,w={};function Ae(t){u.fromRadians(t.east,t.north,0,_t[0]),u.fromRadians(t.west,t.north,0,_t[1]),u.fromRadians(t.east,t.south,0,_t[2]),u.fromRadians(t.west,t.south,0,_t[3]);let e,n=0,i=0,r=0,a=0,o=w._terrainHeightsMaxLevel;for(e=0;e<=o;++e){let t=!1;for(let n=0;n<4;++n){let i=_t[n];if(pn.positionToTileXY(i,e,Lt),0===n)r=Lt.x,a=Lt.y;else if(r!==Lt.x||a!==Lt.y){t=!0;break}}if(t)break;n=r,i=a}if(0!==e)return{x:n,y:i,level:e>o?o:e-1}}w.initialize=function(){let t=w._initPromise;return g(t)||(t=xe.fetchJson(Ne("Assets/approximateTerrainHeights.json")).then((function(t){w._terrainHeights=t})),w._initPromise=t),t},w.getMinimumMaximumHeights=function(e,n){if(tt.defined("rectangle",e),!g(w._terrainHeights))throw new wt("You must call ApproximateTerrainHeights.initialize and wait for the promise to resolve before using this function");n=n??B.default;let i=Ae(e),r=w._defaultMinTerrainHeight,a=w._defaultMaxTerrainHeight;if(g(i)){let o=`${i.level}-${i.x}-${i.y}`,l=w._terrainHeights[o];g(l)&&(r=l[0],a=l[1]),n.cartographicToCartesian(Y.northeast(e,ke),Ie),n.cartographicToCartesian(Y.southwest(e,ke),He),t.midpoint(He,Ie,ee);let s=n.scaleToGeodeticSurface(ee,hn);if(g(s)){let e=t.distance(ee,s);r=Math.min(r,-e)}else r=w._defaultMinTerrainHeight}return r=Math.max(w._defaultMinTerrainHeight,r),{minimumTerrainHeight:r,maximumTerrainHeight:a}},w.getBoundingSphere=function(t,e){if(tt.defined("rectangle",t),!g(w._terrainHeights))throw new wt("You must call ApproximateTerrainHeights.initialize and wait for the promise to resolve before using this function");e=e??B.default;let n=Ae(t),i=w._defaultMaxTerrainHeight;if(g(n)){let t=`${n.level}-${n.x}-${n.y}`,e=w._terrainHeights[t];g(e)&&(i=e[1])}let r=U.fromRectangle3D(t,e,0);return U.fromRectangle3D(t,e,i,ye),U.union(r,ye,r)},w._terrainHeightsMaxLevel=6,w._defaultMaxTerrainHeight=9e3,w._defaultMinTerrainHeight=-1e5,w._terrainHeights=void 0,w._initPromise=void 0,Object.defineProperties(w,{initialized:{get:function(){return g(w._terrainHeights)}}});var Ft=w,le=[Pt,_e],dn=le.length,Ke=Math.cos(p.toRadians(30)),Me=Math.cos(p.toRadians(150)),Qe=0,tn=1e3;function at(t){let e=(t=t??vt.EMPTY_OBJECT).positions;if(!g(e)||e.length<2)throw new wt("At least two positions are required.");if(g(t.arcType)&&t.arcType!==W.GEODESIC&&t.arcType!==W.RHUMB)throw new wt("Valid options for arcType are ArcType.GEODESIC and ArcType.RHUMB.");this.width=t.width??1,this._positions=e,this.granularity=t.granularity??9999,this.loop=t.loop??!1,this.arcType=t.arcType??W.GEODESIC,this._ellipsoid=B.default,this._projectionIndex=0,this._workerName="createGroundPolylineGeometry",this._scene3DOnly=!1}Object.defineProperties(at.prototype,{packedLength:{get:function(){return 1+3*this._positions.length+1+1+1+B.packedLength+1+1}}}),at.setProjectionAndEllipsoid=function(t,e){let n=0;for(let t=0;t<dn;t++)if(e instanceof le[t]){n=t;break}t._projectionIndex=n,t._ellipsoid=e.ellipsoid};var fn=new t,Re=new t,Pe=new t;function se(e,n,i,r,a){let o=R(r,e,0,fn),l=R(r,e,i,Re),s=R(r,n,0,Pe),u=et(l,o,Re),p=et(s,o,Pe);return t.cross(p,u,a),t.normalize(a,a)}var mn=new u,gn=new t,un=new t,wn=new t;function ne(e,n,i,r,a,o,l,s,u,p,c){if(0===a)return;let h;o===W.GEODESIC?h=new Oe(e,n,l):o===W.RHUMB&&(h=new te(e,n,l));let g=h.surfaceDistance;if(g<a)return;let d=se(e,n,r,l,wn),f=Math.ceil(g/a),w=g/f,m=w,y=f-1,T=s.length;for(let e=0;e<y;e++){let e=h.interpolateUsingSurfaceDistance(m,mn),n=R(l,e,i,gn),a=R(l,e,r,un);t.pack(d,s,T),t.pack(n,u,T),t.pack(a,p,T),c.push(e.latitude),c.push(e.longitude),T+=3,m+=w}}var oe=new u;function R(t,e,n,i){return u.clone(e,oe),oe.height=n,u.toCartesian(oe,t,i)}function et(e,n,i){return t.subtract(e,n,i),t.normalize(i,i),i}function be(e,n,i,r){return r=et(e,n,r),r=t.cross(r,i,r),r=t.normalize(r,r),r=t.cross(i,r,r)}at.pack=function(e,n,i){tt.typeOf.object("value",e),tt.defined("array",n);let r=i??0,a=e._positions,o=a.length;n[r++]=o;for(let e=0;e<o;++e){let i=a[e];t.pack(i,n,r),r+=3}return n[r++]=e.granularity,n[r++]=e.loop?1:0,n[r++]=e.arcType,B.pack(e._ellipsoid,n,r),r+=B.packedLength,n[r++]=e._projectionIndex,n[r++]=e._scene3DOnly?1:0,n},at.unpack=function(e,n,i){tt.defined("array",e);let r=n??0,a=e[r++],o=new Array(a);for(let n=0;n<a;n++)o[n]=t.unpack(e,r),r+=3;let l=e[r++],s=1===e[r++],u=e[r++],p=B.unpack(e,r);r+=B.packedLength;let c=e[r++],h=1===e[r++];return g(i)||(i=new at({positions:o})),i._positions=o,i.granularity=l,i.loop=s,i.arcType=u,i._ellipsoid=p,i._projectionIndex=c,i._scene3DOnly=h,i};var Sn=new t,Tn=new t,En=new t,en=new t,xn=0,Nn=-1;function ie(e,n,i,r,a){let o=et(i,n,en),l=be(e,n,o,Sn),s=be(r,n,o,Tn);if(p.equalsEpsilon(t.dot(l,s),Nn,p.EPSILON5))return a=t.cross(o,l,a),a=t.normalize(a,a);a=t.add(s,l,a),a=t.normalize(a,a);let u=t.cross(o,a,En);return t.dot(s,u)<xn&&(a=t.negate(a,a)),a}var Gt=jt.fromPointNormal(t.ZERO,t.UNIT_Y),Cn=new t,_n=new t,Ln=new t,On=new t,Dn=new t,Xt=new t,Yt=new u,ve=new u,Be=new u;at.createGeometry=function(e){let n,i,r=!e._scene3DOnly,a=e.loop,o=e._ellipsoid,l=e.granularity,s=e.arcType,c=new le[e._projectionIndex](o),h=Qe,d=tn,f=e._positions,w=f.length;2===w&&(a=!1);let m,y,T,O,_,k,E,P=new te(void 0,void 0,o),L=[f[0]];for(i=0;i<w-1;i++)m=f[i],y=f[i+1],_=Qt.lineSegmentPlane(m,y,Gt,Xt),g(_)&&!t.equalsEpsilon(_,m,p.EPSILON7)&&!t.equalsEpsilon(_,y,p.EPSILON7)&&(e.arcType===W.GEODESIC?L.push(t.clone(_)):e.arcType===W.RHUMB&&(E=o.cartesianToCartographic(_,Yt).longitude,T=o.cartesianToCartographic(m,Yt),O=o.cartesianToCartographic(y,ve),P.setEndPoints(T,O),k=P.findIntersectionWithLongitude(E,Be),_=o.cartographicToCartesian(k,Xt),g(_)&&!t.equalsEpsilon(_,m,p.EPSILON7)&&!t.equalsEpsilon(_,y,p.EPSILON7)&&L.push(t.clone(_)))),L.push(y);a&&(m=f[w-1],y=f[0],_=Qt.lineSegmentPlane(m,y,Gt,Xt),g(_)&&!t.equalsEpsilon(_,m,p.EPSILON7)&&!t.equalsEpsilon(_,y,p.EPSILON7)&&(e.arcType===W.GEODESIC?L.push(t.clone(_)):e.arcType===W.RHUMB&&(E=o.cartesianToCartographic(_,Yt).longitude,T=o.cartesianToCartographic(m,Yt),O=o.cartesianToCartographic(y,ve),P.setEndPoints(T,O),k=P.findIntersectionWithLongitude(E,Be),_=o.cartographicToCartesian(k,Xt),g(_)&&!t.equalsEpsilon(_,m,p.EPSILON7)&&!t.equalsEpsilon(_,y,p.EPSILON7)&&L.push(t.clone(_)))));let b=L.length,v=new Array(b);for(i=0;i<b;i++){let t=u.fromCartesian(L[i],o);t.height=0,v[i]=t}if(v=Le(v,u.equalsEpsilon),b=v.length,b<2)return;let I=[],A=[],j=[],N=[],S=Cn,Y=_n,x=Ln,D=On,M=Dn,C=v[0],B=v[1];for(S=R(o,v[b-1],h,S),D=R(o,B,h,D),Y=R(o,C,h,Y),x=R(o,C,d,x),M=a?ie(S,Y,x,D,M):se(C,B,d,o,M),t.pack(M,A,0),t.pack(Y,j,0),t.pack(x,N,0),I.push(C.latitude),I.push(C.longitude),ne(C,B,h,d,l,s,o,A,j,N,I),i=1;i<b-1;++i){S=t.clone(Y,S),Y=t.clone(D,Y);let e=v[i];R(o,e,d,x),R(o,v[i+1],h,D),ie(S,Y,x,D,M),n=A.length,t.pack(M,A,n),t.pack(Y,j,n),t.pack(x,N,n),I.push(e.latitude),I.push(e.longitude),ne(v[i],v[i+1],h,d,l,s,o,A,j,N,I)}let z=v[b-1],H=v[b-2];if(Y=R(o,z,h,Y),x=R(o,z,d,x),a){let t=v[0];S=R(o,H,h,S),D=R(o,t,h,D),M=ie(S,Y,x,D,M)}else M=se(H,z,d,o,M);if(n=A.length,t.pack(M,A,n),t.pack(Y,j,n),t.pack(x,N,n),I.push(z.latitude),I.push(z.longitude),a){for(ne(z,C,h,d,l,s,o,A,j,N,I),n=A.length,i=0;i<3;++i)A[n+i]=A[i],j[n+i]=j[i],N[n+i]=N[i];I.push(C.latitude),I.push(C.longitude)}return Qn(a,c,j,N,A,I,r)};var In=new t,Hn=new bt,kn=new Kt;function ze(e,n,i,r){let a=et(i,n,In),o=t.dot(a,e);if(o>Ke||o<Me){let t=et(r,i,en),n=o<Me?p.PI_OVER_TWO:-p.PI_OVER_TWO,a=Kt.fromAxisAngle(t,n,kn),l=bt.fromQuaternion(a,Hn);return bt.multiplyByVector(l,e,e),!0}return!1}var je=new u,yn=new t,Fe=new t;function Ot(e,n,i,r,a){let o=u.toCartesian(n,e._ellipsoid,yn),l=t.add(o,i,Fe),s=!1,c=e._ellipsoid,h=c.cartesianToCartographic(l,je);Math.abs(n.longitude-h.longitude)>p.PI_OVER_TWO&&(s=!0,l=t.subtract(o,i,Fe),h=c.cartesianToCartographic(l,je)),h.height=0;let g=e.project(h,a);return(a=t.subtract(g,r,a)).z=0,a=t.normalize(a,a),s&&t.negate(a,a),a}var An=new t,Xe=new t;function Ye(e,n,i,r,a,o){let l=t.subtract(n,e,An);t.normalize(l,l);let s=i-Qe,u=t.multiplyByScalar(l,s,Xe);t.add(e,u,a);let p=r-tn;u=t.multiplyByScalar(l,p,Xe),t.add(n,u,o)}var Mn=new t;function Ut(e,n){let i=jt.getPointDistance(Gt,e),r=jt.getPointDistance(Gt,n),a=Mn;p.equalsEpsilon(i,0,p.EPSILON2)?(a=et(n,e,a),t.multiplyByScalar(a,p.EPSILON2,a),t.add(e,a,e)):p.equalsEpsilon(r,0,p.EPSILON2)&&(a=et(e,n,a),t.multiplyByScalar(a,p.EPSILON2,a),t.add(n,a,n))}function Rn(t,e){let n=Math.abs(t.longitude),i=Math.abs(e.longitude);if(p.equalsEpsilon(n,p.PI,p.EPSILON11)){let i=p.sign(e.longitude);return t.longitude=i*(n-p.EPSILON11),1}if(p.equalsEpsilon(i,p.PI,p.EPSILON11)){let n=p.sign(t.longitude);return e.longitude=n*(i-p.EPSILON11),2}return 0}var nn=new u,on=new u,Ue=new t,re=new t,Ge=new t,qe=new t,Pn=new t,We=new t,bn=[nn,on],vn=new Y,Bn=new t,zn=new t,jn=new t,Fn=new t,Xn=new t,Yn=new t,ae=new t,ce=new t,Un=new t,Gn=new t,qn=new t,Ze=new t,Wn=new t,Zn=new t,Vn=new Ct,$n=new Ct,Ve=new t,Jn=new t,$e=new t,Kn=[new U,new U],rn=[0,2,1,0,3,2,0,7,3,0,4,7,0,5,4,0,1,5,5,7,4,5,6,7,5,2,6,5,1,2,3,6,2,3,7,6],Je=rn.length;function Qn(e,n,i,r,a,o,l){let s,u,c,h,g,d,f=n._ellipsoid,w=i.length/3-1,m=8*w,y=4*m,T=36*w,O=m>65535?new Uint32Array(T):new Uint16Array(T),_=new Float64Array(3*m),k=new Float32Array(y),E=new Float32Array(y),P=new Float32Array(y),L=new Float32Array(y),b=new Float32Array(y);l&&(c=new Float32Array(y),h=new Float32Array(y),g=new Float32Array(y),d=new Float32Array(2*m));let v=o.length/2,I=0,R=nn;R.height=0;let A=on;A.height=0;let j=Ue,N=re;if(l)for(u=0,s=1;s<v;s++)R.latitude=o[u],R.longitude=o[u+1],A.latitude=o[u+2],A.longitude=o[u+3],j=n.project(R,j),N=n.project(A,N),I+=t.distance(j,N),u+=2;let S=r.length/3;N=t.unpack(r,0,N);let x,D=0;for(u=3,s=1;s<S;s++)j=t.clone(N,j),N=t.unpack(r,u,N),D+=t.distance(j,N),u+=3;u=3;let M=0,C=0,B=0,z=0,H=!1,X=t.unpack(i,0,qe),G=t.unpack(r,0,re),W=t.unpack(a,0,We);if(e){ze(W,t.unpack(i,i.length-6,Ge),X,G)&&(W=t.negate(W,W))}let F=0,Z=0,q=0;for(s=0;s<w;s++){let e,s,w,m,y=t.clone(X,Ge),T=t.clone(G,Ue),O=t.clone(W,Pn);if(H&&(O=t.negate(O,O)),X=t.unpack(i,u,qe),G=t.unpack(r,u,re),W=t.unpack(a,u,We),H=ze(W,y,X,G),R.latitude=o[M],R.longitude=o[M+1],A.latitude=o[M+2],A.longitude=o[M+3],l){let i=Rn(R,A);e=n.project(R,Xn),s=n.project(A,Yn);let r=et(s,e,Ve);r.y=Math.abs(r.y),w=ae,m=ce,0===i||t.dot(r,t.UNIT_Y)>Ke?(w=Ot(n,R,O,e,ae),m=Ot(n,A,W,s,ce)):1===i?(m=Ot(n,A,W,s,ce),w.x=0,w.y=p.sign(R.longitude-Math.abs(A.longitude)),w.z=0):(w=Ot(n,R,O,e,ae),m.x=0,m.y=p.sign(R.longitude-A.longitude),m.z=0)}let v=t.distance(T,G),j=Ct.fromCartesian(y,Vn),N=t.subtract(X,y,Un),S=t.normalize(N,Ze),U=t.subtract(T,y,Gn);U=t.normalize(U,U);let V=t.cross(S,U,Ze);V=t.normalize(V,V);let Q=t.cross(U,O,Wn);Q=t.normalize(Q,Q);let J=t.subtract(G,X,qn);J=t.normalize(J,J);let $=t.cross(W,J,Zn);$=t.normalize($,$);let K,tt,nt,it=v/D,rt=F/D,at=0,ot=0,lt=0;if(l){at=t.distance(e,s),K=Ct.fromCartesian(e,$n),tt=t.subtract(s,e,Ve),nt=t.normalize(tt,Jn);let n=nt.x;nt.x=nt.y,nt.y=-n,ot=at/I,lt=Z/I}for(x=0;x<8;x++){let e=z+4*x,n=C+2*x,i=e+3,r=x<4?1:-1,a=2===x||3===x||6===x||7===x?1:-1;t.pack(j.high,k,e),k[i]=N.x,t.pack(j.low,E,e),E[i]=N.y,t.pack(Q,P,e),P[i]=N.z,t.pack($,L,e),L[i]=it*r,t.pack(V,b,e);let o=rt*a;0===o&&a<0&&(o=9),b[i]=o,l&&(c[e]=K.high.x,c[e+1]=K.high.y,c[e+2]=K.low.x,c[e+3]=K.low.y,g[e]=-w.y,g[e+1]=w.x,g[e+2]=m.y,g[e+3]=-m.x,h[e]=tt.x,h[e+1]=tt.y,h[e+2]=nt.x,h[e+3]=nt.y,d[n]=ot*r,o=lt*a,0===o&&a<0&&(o=9),d[n+1]=o)}let st=jn,ut=Fn,pt=Bn,ct=zn,ht=Y.fromCartographicArray(bn,vn),gt=Ft.getMinimumMaximumHeights(ht,f),dt=gt.minimumTerrainHeight,ft=gt.maximumTerrainHeight;q+=Math.abs(dt),q+=Math.abs(ft),Ye(y,T,dt,ft,st,pt),Ye(X,G,dt,ft,ut,ct);let wt=t.multiplyByScalar(V,p.EPSILON5,$e);t.add(st,wt,st),t.add(ut,wt,ut),t.add(pt,wt,pt),t.add(ct,wt,ct),Ut(st,ut),Ut(pt,ct),t.pack(st,_,B),t.pack(ut,_,B+3),t.pack(ct,_,B+6),t.pack(pt,_,B+9),wt=t.multiplyByScalar(V,-2*p.EPSILON5,$e),t.add(st,wt,st),t.add(ut,wt,ut),t.add(pt,wt,pt),t.add(ct,wt,ct),Ut(st,ut),Ut(pt,ct),t.pack(st,_,B+12),t.pack(ut,_,B+15),t.pack(ct,_,B+18),t.pack(pt,_,B+21),M+=2,u+=3,C+=16,B+=24,z+=32,F+=v,Z+=at}u=0;let V=0;for(s=0;s<w;s++){for(x=0;x<Je;x++)O[u+x]=rn[x]+V;V+=8,u+=Je}let Q=Kn;U.fromVertices(i,t.ZERO,3,Q[0]),U.fromVertices(r,t.ZERO,3,Q[1]);let J=U.fromBoundingSpheres(Q);J.radius+=q/(2*w);let $={position:new zt({componentDatatype:Bt.DOUBLE,componentsPerAttribute:3,normalize:!1,values:_}),startHiAndForwardOffsetX:rt(k),startLoAndForwardOffsetY:rt(E),startNormalAndForwardOffsetZ:rt(P),endNormalAndTextureCoordinateNormalizationX:rt(L),rightNormalAndTextureCoordinateNormalizationY:rt(b)};return l&&($.startHiLo2D=rt(c),$.offsetAndRight2D=rt(h),$.startEndNormals2D=rt(g),$.texcoordNormalization2D=new zt({componentDatatype:Bt.FLOAT,componentsPerAttribute:2,normalize:!1,values:d})),new Ce({attributes:$,indices:O,boundingSphere:J})}function rt(t){return new zt({componentDatatype:Bt.FLOAT,componentsPerAttribute:4,normalize:!1,values:t})}at._projectNormal=Ot;var he=at;function to(t,e){return Ft.initialize().then((function(){return g(e)&&(t=he.unpack(t,e)),he.createGeometry(t)}))}var Qo=to;export{Qo as default};