/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as mt}from"./chunk-QUETFIFY.js";import{a as L}from"./chunk-CRK3ZLKL.js";import{a as st}from"./chunk-Z5ZDCTRN.js";import{a as rt}from"./chunk-CFRYEZJF.js";import{a as bt}from"./chunk-HCF5XBCP.js";import"./chunk-II365YZS.js";import"./chunk-IODKIN3W.js";import{a as lt}from"./chunk-64C3WG2L.js";import{a as q}from"./chunk-QL3VAYCR.js";import{a as Z}from"./chunk-WZSOKNIB.js";import"./chunk-4GIZMT42.js";import{a as dt,b as ot}from"./chunk-EIJCAXME.js";import"./chunk-2DWCJX3G.js";import"./chunk-L3YV42ES.js";import{a as wt,b as yt}from"./chunk-QTPIBP7S.js";import"./chunk-ZCCOD3XE.js";import{a as ct}from"./chunk-SFW65PGL.js";import"./chunk-BTGP76WP.js";import{c as ut,d as $}from"./chunk-YQL7OPIW.js";import{d as Tt}from"./chunk-DPQZPDIL.js";import{f as at,h as _t}from"./chunk-YJEV67VS.js";import{a as X}from"./chunk-4BTDTSQG.js";import{a as c,b as et,c as O,d as S,e as D,f as Pt}from"./chunk-XFVXIGTK.js";import{a as l}from"./chunk-MPRZ6V46.js";import"./chunk-FO77LMQ7.js";import"./chunk-TYEGOJMY.js";import{a as ft,b as Y}from"./chunk-VZMWSUG7.js";import{e as P}from"./chunk-362ETHZ6.js";function b(t,e){this.position=t,P(this.position)||(this.position=new O),this.tangentPlane=e,P(this.tangentPlane)||(this.tangentPlane=b.NORTH_POLE_TANGENT_PLANE)}Object.defineProperties(b.prototype,{ellipsoid:{get:function(){return this.tangentPlane.ellipsoid}},x:{get:function(){return this.position.x}},y:{get:function(){return this.position.y}},conformalLatitude:{get:function(){let t=O.magnitude(this.position),e=2*this.ellipsoid.maximumRadius;return this.tangentPlane.plane.normal.z*(l.PI_OVER_TWO-2*Math.atan2(t,e))}},longitude:{get:function(){let t=l.PI_OVER_TWO+Math.atan2(this.y,this.x);return t>Math.PI&&(t-=l.TWO_PI),t}}});var nt=new et,Rt=new c;b.prototype.getLatitude=function(t){P(t)||(t=S.default),nt.latitude=this.conformalLatitude,nt.longitude=this.longitude,nt.height=0;let e=this.ellipsoid.cartographicToCartesian(nt,Rt);return t.cartesianToCartographic(e,nt),nt.latitude};var It=new wt,Lt=new c,Ft=new c;b.fromCartesian=function(t,e){Y.defined("cartesian",t);let o=l.signNotZero(t.z),i=b.NORTH_POLE_TANGENT_PLANE,n=b.SOUTH_POLE;o<0&&(i=b.SOUTH_POLE_TANGENT_PLANE,n=b.NORTH_POLE);let r=It;r.origin=i.ellipsoid.scaleToGeocentricSurface(t,r.origin),r.direction=c.subtract(r.origin,n,Lt),c.normalize(r.direction,r.direction);let a=yt.rayPlane(r,i.plane,Ft),s=c.subtract(a,n,a),u=c.dot(i.xAxis,s),h=o*c.dot(i.yAxis,s);return P(e)?(e.position=new O(u,h),e.tangentPlane=i,e):new b(new O(u,h),i)},b.fromCartesianArray=function(t,e){Y.defined("cartesians",t);let o=t.length;P(e)?e.length=o:e=new Array(o);for(let i=0;i<o;i++)e[i]=b.fromCartesian(t[i],e[i]);return e},b.clone=function(t,e){if(P(t))return P(e)?(e.position=t.position,e.tangentPlane=t.tangentPlane,e):new b(t.position,t.tangentPlane)},b.HALF_UNIT_SPHERE=Object.freeze(new S(.5,.5,.5)),b.NORTH_POLE=Object.freeze(new c(0,0,.5)),b.SOUTH_POLE=Object.freeze(new c(0,0,-.5)),b.NORTH_POLE_TANGENT_PLANE=Object.freeze(new Z(b.NORTH_POLE,b.HALF_UNIT_SPHERE)),b.SOUTH_POLE_TANGENT_PLANE=Object.freeze(new Z(b.SOUTH_POLE,b.HALF_UNIT_SPHERE));var z=b,vt=new et,Ot=new et;function St(t,e,o,i){let n=i.cartesianToCartographic(t,vt).height,r=i.cartesianToCartographic(e,Ot);r.height=n,i.cartographicToCartesian(r,e);let a=i.cartesianToCartographic(o,Ot);a.height=n-100,i.cartographicToCartesian(a,o)}var Et=new mt,Vt=new c,Bt=new c,Mt=new c,jt=new c,kt=new c,zt=new c,ht=new c,Q=new c,it=new c,Dt=new O,Ut=new O,Wt=new c,At=new at,Gt=new D,Yt=new D;function gt(t){let e=t.vertexFormat,o=t.geometry,i=t.shadowVolume,n=o.attributes.position.values,r=P(o.attributes.st)?o.attributes.st.values:void 0,a=n.length,s=t.wall,u=t.top||s,h=t.bottom||s;if(e.st||e.normal||e.tangent||e.bitangent||i){let p=t.boundingRectangle,g=t.rotationAxis,m=t.projectTo2d,d=t.ellipsoid,f=t.stRotation,y=t.perPositionHeight,_=Dt;_.x=p.x,_.y=p.y;let T,b=e.st?new Float32Array(a/3*2):void 0;e.normal&&(T=y&&u&&!s?o.attributes.normal.values:new Float32Array(a));let w=e.tangent?new Float32Array(a):void 0,I=e.bitangent?new Float32Array(a):void 0,E=i?new Float32Array(a):void 0,A=0,v=0,x=Bt,H=Mt,N=jt,L=!0,R=Gt,C=Yt;if(0!==f){let t=at.fromAxisAngle(g,f,At);R=D.fromQuaternion(t,R),t=at.fromAxisAngle(g,-f,At),C=D.fromQuaternion(t,C)}else R=D.clone(D.IDENTITY,R),C=D.clone(D.IDENTITY,C);let S=0,k=0;u&&h&&(S=a/2,k=a/3,a/=2);for(let o=0;o<a;o+=3){let g=c.fromArray(n,o,Wt);if(e.st&&!P(r)){let t=D.multiplyByVector(R,g,Vt);t=d.scaleToGeodeticSurface(t,t);let e=m([t],Ut)[0];O.subtract(e,_,e);let o=l.clamp(e.x/p.width,0,1),i=l.clamp(e.y/p.height,0,1);h&&(b[A+k]=o,b[A+1+k]=i),u&&(b[A]=o,b[A+1]=i),A+=2}if(e.normal||e.tangent||e.bitangent||i){let r=v+1,p=v+2;if(s){if(o+3<a){let t=c.fromArray(n,o+3,kt);if(L){let e=c.fromArray(n,o+a,zt);y&&St(g,t,e,d),c.subtract(t,g,t),c.subtract(e,g,e),x=c.normalize(c.cross(e,t,x),x),L=!1}c.equalsEpsilon(t,g,l.EPSILON10)&&(L=!0)}(e.tangent||e.bitangent)&&(N=d.geodeticSurfaceNormal(g,N),e.tangent&&(H=c.normalize(c.cross(N,x,H),H)))}else x=d.geodeticSurfaceNormal(g,x),(e.tangent||e.bitangent)&&(y&&(ht=c.fromArray(T,v,ht),Q=c.cross(c.UNIT_Z,ht,Q),Q=c.normalize(D.multiplyByVector(C,Q,Q),Q),e.bitangent&&(it=c.normalize(c.cross(ht,Q,it),it))),H=c.cross(c.UNIT_Z,x,H),H=c.normalize(D.multiplyByVector(C,H,H),H),e.bitangent&&(N=c.normalize(c.cross(x,H,N),N)));e.normal&&(t.wall?(T[v+S]=x.x,T[r+S]=x.y,T[p+S]=x.z):h&&(T[v+S]=-x.x,T[r+S]=-x.y,T[p+S]=-x.z),(u&&!y||s)&&(T[v]=x.x,T[r]=x.y,T[p]=x.z)),i&&(s&&(x=d.geodeticSurfaceNormal(g,x)),E[v+S]=-x.x,E[r+S]=-x.y,E[p+S]=-x.z),e.tangent&&(t.wall?(w[v+S]=H.x,w[r+S]=H.y,w[p+S]=H.z):h&&(w[v+S]=-H.x,w[r+S]=-H.y,w[p+S]=-H.z),u&&(y?(w[v]=Q.x,w[r]=Q.y,w[p]=Q.z):(w[v]=H.x,w[r]=H.y,w[p]=H.z))),e.bitangent&&(h&&(I[v+S]=N.x,I[r+S]=N.y,I[p+S]=N.z),u&&(y?(I[v]=it.x,I[r]=it.y,I[p]=it.z):(I[v]=N.x,I[r]=N.y,I[p]=N.z))),v+=3}}e.st&&!P(r)&&(o.attributes.st=new $({componentDatatype:X.FLOAT,componentsPerAttribute:2,values:b})),e.normal&&(o.attributes.normal=new $({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:T})),e.tangent&&(o.attributes.tangent=new $({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:w})),e.bitangent&&(o.attributes.bitangent=new $({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:I})),i&&(o.attributes.extrudeDirection=new $({componentDatatype:X.FLOAT,componentsPerAttribute:3,values:E}))}if(t.extrude&&P(t.offsetAttribute)){let e=n.length/3,i=new Uint8Array(e);if(t.offsetAttribute===lt.TOP)u&&h||s?i=i.fill(1,0,e/2):u&&(i=i.fill(1));else{let e=t.offsetAttribute===lt.NONE?0:1;i=i.fill(e)}o.attributes.applyOffset=new $({componentDatatype:X.UNSIGNED_BYTE,componentsPerAttribute:1,values:i})}return o}var Ht=[];function qt(t,e,o,i,n,r,a,s,l,c){let u,h={walls:[]};if(a||s){let n,p,g=L.createGeometryFromPositions(t,e,o,i,r,l,c),m=g.attributes.position.values,d=g.indices;if(a&&s){let t=m.concat(m);n=t.length/3,p=ct.createTypedArray(n,2*d.length),p.set(d);let e=d.length,i=n/2;for(u=0;u<e;u+=3){let t=p[u]+i,o=p[u+1]+i,n=p[u+2]+i;p[u+e]=n,p[u+1+e]=o,p[u+2+e]=t}if(g.attributes.position.values=t,r&&l.normal){let e=g.attributes.normal.values;g.attributes.normal.values=new Float32Array(t.length),g.attributes.normal.values.set(e)}if(l.st&&P(o)){let t=g.attributes.st.values;g.attributes.st.values=new Float32Array(2*n),g.attributes.st.values=t.concat(t)}g.indices=p}else if(s){for(n=m.length/3,p=ct.createTypedArray(n,d.length),u=0;u<d.length;u+=3)p[u]=d[u+2],p[u+1]=d[u+1],p[u+2]=d[u];g.indices=p}h.topAndBottom=new rt({geometry:g})}let p=n.outerRing,g=Z.fromPoints(p,t),m=g.projectPointsOntoPlane(p,Ht),d=ot.computeWindingOrder2D(m);d===dt.CLOCKWISE&&(p=p.slice().reverse());let f=L.computeWallGeometry(p,o,t,i,r,c);h.walls.push(new rt({geometry:f}));let y=n.holes;for(u=0;u<y.length;u++){let e=y[u];m=g.projectPointsOntoPlane(e,Ht),d=ot.computeWindingOrder2D(m),d===dt.COUNTER_CLOCKWISE&&(e=e.slice().reverse()),f=L.computeWallGeometry(e,o,t,i,r,c),h.walls.push(new rt({geometry:f}))}return h}function W(t){if(Y.typeOf.object("options",t),Y.typeOf.object("options.polygonHierarchy",t.polygonHierarchy),P(t.perPositionHeight)&&t.perPositionHeight&&P(t.height))throw new ft("Cannot use both options.perPositionHeight and options.height");if(P(t.arcType)&&t.arcType!==st.GEODESIC&&t.arcType!==st.RHUMB)throw new ft("Invalid arcType. Valid options are ArcType.GEODESIC and ArcType.RHUMB.");let e=t.polygonHierarchy,o=t.vertexFormat??q.DEFAULT,i=t.ellipsoid??S.default,n=t.granularity??l.RADIANS_PER_DEGREE,r=t.stRotation??0,a=t.textureCoordinates,s=t.perPositionHeight??!1,u=s&&P(t.extrudedHeight),h=t.height??0,p=t.extrudedHeight??h;if(!u){let t=Math.max(h,p);p=Math.min(h,p),h=t}this._vertexFormat=q.clone(o),this._ellipsoid=S.clone(i),this._granularity=n,this._stRotation=r,this._height=h,this._extrudedHeight=p,this._closeTop=t.closeTop??!0,this._closeBottom=t.closeBottom??!0,this._polygonHierarchy=e,this._perPositionHeight=s,this._perPositionHeightExtrude=u,this._shadowVolume=t.shadowVolume??!1,this._workerName="createPolygonGeometry",this._offsetAttribute=t.offsetAttribute,this._arcType=t.arcType??st.GEODESIC,this._rectangle=void 0,this._textureCoordinateRotationPoints=void 0,this._textureCoordinates=a,this.packedLength=L.computeHierarchyPackedLength(e,c)+S.packedLength+q.packedLength+(a?L.computeHierarchyPackedLength(a,O):1)+12}W.fromPositions=function(t){return t=t??Pt.EMPTY_OBJECT,Y.defined("options.positions",t.positions),new W({polygonHierarchy:{positions:t.positions},height:t.height,extrudedHeight:t.extrudedHeight,vertexFormat:t.vertexFormat,stRotation:t.stRotation,ellipsoid:t.ellipsoid,granularity:t.granularity,perPositionHeight:t.perPositionHeight,closeTop:t.closeTop,closeBottom:t.closeBottom,offsetAttribute:t.offsetAttribute,arcType:t.arcType,textureCoordinates:t.textureCoordinates})},W.pack=function(t,e,o){return Y.typeOf.object("value",t),Y.defined("array",e),o=o??0,o=L.packPolygonHierarchy(t._polygonHierarchy,e,o,c),S.pack(t._ellipsoid,e,o),o+=S.packedLength,q.pack(t._vertexFormat,e,o),o+=q.packedLength,e[o++]=t._height,e[o++]=t._extrudedHeight,e[o++]=t._granularity,e[o++]=t._stRotation,e[o++]=t._perPositionHeightExtrude?1:0,e[o++]=t._perPositionHeight?1:0,e[o++]=t._closeTop?1:0,e[o++]=t._closeBottom?1:0,e[o++]=t._shadowVolume?1:0,e[o++]=t._offsetAttribute??-1,e[o++]=t._arcType,P(t._textureCoordinates)?o=L.packPolygonHierarchy(t._textureCoordinates,e,o,O):e[o++]=-1,e[o++]=t.packedLength,e};var Qt=S.clone(S.UNIT_SPHERE),Zt=new q,Kt={polygonHierarchy:{}};W.unpack=function(t,e,o){Y.defined("array",t),e=e??0;let i=L.unpackPolygonHierarchy(t,e,c);e=i.startingIndex,delete i.startingIndex;let n=S.unpack(t,e,Qt);e+=S.packedLength;let r=q.unpack(t,e,Zt);e+=q.packedLength;let a=t[e++],s=t[e++],l=t[e++],u=t[e++],h=1===t[e++],p=1===t[e++],g=1===t[e++],m=1===t[e++],d=1===t[e++],f=t[e++],y=t[e++],_=-1===t[e]?void 0:L.unpackPolygonHierarchy(t,e,O);P(_)?(e=_.startingIndex,delete _.startingIndex):e++;let T=t[e++];return P(o)||(o=new W(Kt)),o._polygonHierarchy=i,o._ellipsoid=S.clone(n,o._ellipsoid),o._vertexFormat=q.clone(r,o._vertexFormat),o._height=a,o._extrudedHeight=s,o._granularity=l,o._stRotation=u,o._perPositionHeightExtrude=h,o._perPositionHeight=p,o._closeTop=g,o._closeBottom=m,o._shadowVolume=d,o._offsetAttribute=-1===f?void 0:f,o._arcType=y,o._textureCoordinates=_,o.packedLength=T,o};var Jt=new O,Xt=new O,$t=new z;function xt(t,e,o,i,n,r){let a=t.longitude,s=a>=0?a:a+l.TWO_PI;n.westOverIdl=Math.min(n.westOverIdl,s),n.eastOverIdl=Math.max(n.eastOverIdl,s),r.west=Math.min(r.west,a),r.east=Math.max(r.east,a);let c=t.getLatitude(o),u=c;if(r.south=Math.min(r.south,c),r.north=Math.max(r.north,c),i!==st.RHUMB){let i=O.subtract(e.position,t.position,Jt),n=O.dot(e.position,i)/O.dot(i,i);if(n>0&&n<1){let t=O.add(e.position,O.multiplyByScalar(i,-n,i),Xt),a=z.clone(e,$t);a.position=t;let s=a.getLatitude(o);r.south=Math.min(r.south,s),r.north=Math.max(r.north,s),Math.abs(c)>Math.abs(s)&&(u=s)}}let h=e.x*t.y-t.x*e.y,p=Math.sign(h);0!==p&&(p*=O.angleBetween(e.position,t.position)),u>=0&&(n.northAngle+=p),u<=0&&(n.southAngle+=p)}var Ct=new z,te=new z,U={northAngle:0,southAngle:0,westOverIdl:0,eastOverIdl:0};W.computeRectangleFromPositions=function(t,e,o,i){if(Y.defined("positions",t),P(i)||(i=new _t),t.length<3)return i;i.west=Number.POSITIVE_INFINITY,i.east=Number.NEGATIVE_INFINITY,i.south=Number.POSITIVE_INFINITY,i.north=Number.NEGATIVE_INFINITY,U.northAngle=0,U.southAngle=0,U.westOverIdl=Number.POSITIVE_INFINITY,U.eastOverIdl=Number.NEGATIVE_INFINITY;let n=t.length,r=z.fromCartesian(t[0],te);for(let a=1;a<n;a++){let n=z.fromCartesian(t[a],Ct);xt(n,r,e,o,U,i),r=z.clone(n,r)}return xt(z.fromCartesian(t[0],Ct),r,e,o,U,i),i.east-i.west>U.eastOverIdl-U.westOverIdl&&(i.west=U.westOverIdl,i.east=U.eastOverIdl,i.east>l.PI&&(i.east=i.east-l.TWO_PI),i.west>l.PI&&(i.west=i.west-l.TWO_PI)),l.equalsEpsilon(Math.abs(U.northAngle),l.TWO_PI,l.EPSILON10)&&(i.north=l.PI_OVER_TWO,i.east=l.PI,i.west=-l.PI),l.equalsEpsilon(Math.abs(U.southAngle),l.TWO_PI,l.EPSILON10)&&(i.south=-l.PI_OVER_TWO,i.east=l.PI,i.west=-l.PI),i};var ee=new z;function oe(t,e,o){return t.height>=l.PI||t.width>=l.PI?z.fromCartesian(e[0],ee).tangentPlane:Z.fromPoints(e,o)}var Nt=new et;function ne(t,e,o){return(i,n)=>{if(t.height>=l.PI||t.width>=l.PI){if(t.south<0&&t.north>0){P(n)||(n=[]);for(let t=0;t<i.length;++t){let e=o.cartesianToCartographic(i[t],Nt);n[t]=new O(e.longitude/l.PI,e.latitude/l.PI_OVER_TWO)}return n.length=i.length,n}return z.fromCartesianArray(i,n)}return Z.fromPoints(e,o).projectPointsOntoPlane(i,n)}}function ie(t,e,o){if(t.height>=l.PI||t.width>=l.PI)return(e,i)=>{if(t.south<0&&t.north>0){let t=o.cartesianToCartographic(e,Nt);return P(i)||(i=new O),i.x=t.longitude/l.PI,i.y=t.latitude/l.PI_OVER_TWO,i}return z.fromCartesian(e,i)};let i=Z.fromPoints(e,o);return(t,e)=>i.projectPointsOntoPlane(t,e)}function re(t,e,o,i){return(n,r)=>!i&&(t.height>=l.PI_OVER_TWO||t.width>=2*l.PI_OVER_THREE)?L.splitPolygonsOnEquator(n,e,o,r):n}function se(t,e,o,i){if(e.height>=l.PI||e.width>=l.PI)return mt.fromRectangle(e,void 0,Et);let n=t,r=Z.fromPoints(n,o);return L.computeBoundingRectangle(r.plane.normal,r.projectPointOntoPlane.bind(r),n,i,Et)}function ae(t){let e=-t._stRotation;if(0===e)return[0,0,0,1,1,0];let o=t._ellipsoid,i=t._polygonHierarchy.positions,n=t.rectangle;return ut._textureCoordinateRotationPoints(i,e,o,n)}W.createGeometry=function(t){let e=t._vertexFormat,o=t._ellipsoid,i=t._granularity,n=t._stRotation,r=t._polygonHierarchy,a=t._perPositionHeight,s=t._closeTop,c=t._closeBottom,u=t._arcType,h=t._textureCoordinates,p=P(h),g=r.positions;if(g.length<3)return;let m=t.rectangle,d=L.polygonsFromHierarchy(r,p,ne(m,g,o),!a,o,re(m,o,u,a)),f=d.hierarchy,y=d.polygons,_=p?L.polygonsFromHierarchy(h,!0,(function(t){return t}),!1,o).polygons:void 0;if(0===f.length)return;let O,T=f[0].outerRing,b=se(T,m,o,n),w=[],I=t._height,E=t._extrudedHeight,A=t._perPositionHeightExtrude||!l.equalsEpsilon(I,E,0,l.EPSILON2),v={perPositionHeight:a,vertexFormat:e,geometry:void 0,rotationAxis:oe(m,T,o).plane.normal,projectTo2d:ie(m,T,o),boundingRectangle:b,ellipsoid:o,stRotation:n,textureCoordinates:void 0,bottom:!1,top:!0,wall:!1,extrude:!1,arcType:u};if(A)for(v.extrude=!0,v.top=s,v.bottom=c,v.shadowVolume=t._shadowVolume,v.offsetAttribute=t._offsetAttribute,O=0;O<y.length;O++){let t,n=qt(o,y[O],p?_[O]:void 0,i,f[O],a,s,c,e,u);s&&c?(t=n.topAndBottom,v.geometry=L.scaleToGeodeticHeightExtruded(t.geometry,I,E,o,a)):s?(t=n.topAndBottom,t.geometry.attributes.position.values=ot.scaleToGeodeticHeight(t.geometry.attributes.position.values,I,o,!a),v.geometry=t.geometry):c&&(t=n.topAndBottom,t.geometry.attributes.position.values=ot.scaleToGeodeticHeight(t.geometry.attributes.position.values,E,o,!0),v.geometry=t.geometry),(s||c)&&(v.wall=!1,t.geometry=gt(v),w.push(t));let r=n.walls;v.wall=!0;for(let t=0;t<r.length;t++){let e=r[t];v.geometry=L.scaleToGeodeticHeightExtruded(e.geometry,I,E,o,a),e.geometry=gt(v),w.push(e)}}else for(O=0;O<y.length;O++){let n=new rt({geometry:L.createGeometryFromPositions(o,y[O],p?_[O]:void 0,i,a,e,u)});if(n.geometry.attributes.position.values=ot.scaleToGeodeticHeight(n.geometry.attributes.position.values,I,o,!a),v.geometry=n.geometry,n.geometry=gt(v),P(t._offsetAttribute)){let e=n.geometry.attributes.position.values.length,o=t._offsetAttribute===lt.NONE?0:1,i=new Uint8Array(e/3).fill(o);n.geometry.attributes.applyOffset=new $({componentDatatype:X.UNSIGNED_BYTE,componentsPerAttribute:1,values:i})}w.push(n)}let x=bt.combineInstances(w)[0];x.attributes.position.values=new Float64Array(x.attributes.position.values),x.indices=ct.createTypedArray(x.attributes.position.values.length/3,x.indices);let H=x.attributes,N=Tt.fromVertices(H.position.values);return e.position||delete H.position,new ut({attributes:H,indices:x.indices,primitiveType:x.primitiveType,boundingSphere:N,offsetAttribute:t._offsetAttribute})},W.createShadowVolume=function(t,e,o){let i=t._granularity,n=t._ellipsoid,r=e(i,n),a=o(i,n);return new W({polygonHierarchy:t._polygonHierarchy,ellipsoid:n,stRotation:t._stRotation,granularity:i,perPositionHeight:!1,extrudedHeight:r,height:a,vertexFormat:q.POSITION_ONLY,shadowVolume:!0,arcType:t._arcType})},Object.defineProperties(W.prototype,{rectangle:{get:function(){if(!P(this._rectangle)){let t=this._polygonHierarchy.positions;this._rectangle=W.computeRectangleFromPositions(t,this._ellipsoid,this._arcType)}return this._rectangle}},textureCoordinateRotationPoints:{get:function(){return P(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=ae(this)),this._textureCoordinateRotationPoints}}});var pt=W;function ce(t,e){return P(e)&&(t=pt.unpack(t,e)),t._ellipsoid=S.clone(t._ellipsoid),pt.createGeometry(t)}var Xe=ce;export{Xe as default};