/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a}from"./chunk-CRK3ZLKL.js";import{a as P}from"./chunk-Z5ZDCTRN.js";import{a as F}from"./chunk-CFRYEZJF.js";import{a as V}from"./chunk-HCF5XBCP.js";import"./chunk-II365YZS.js";import"./chunk-IODKIN3W.js";import{a as C}from"./chunk-64C3WG2L.js";import{a as M}from"./chunk-WZSOKNIB.js";import"./chunk-4GIZMT42.js";import{a as W,b as D}from"./chunk-EIJCAXME.js";import"./chunk-2DWCJX3G.js";import"./chunk-L3YV42ES.js";import"./chunk-QTPIBP7S.js";import"./chunk-ZCCOD3XE.js";import{a as G}from"./chunk-SFW65PGL.js";import{a as B}from"./chunk-BTGP76WP.js";import{b as U,c as S,d as w}from"./chunk-YQL7OPIW.js";import{d as x}from"./chunk-DPQZPDIL.js";import"./chunk-YJEV67VS.js";import{a as T}from"./chunk-4BTDTSQG.js";import{a as v,d as y,f as j}from"./chunk-XFVXIGTK.js";import{a as L}from"./chunk-MPRZ6V46.js";import"./chunk-FO77LMQ7.js";import"./chunk-TYEGOJMY.js";import{a as N,b as O}from"./chunk-VZMWSUG7.js";import{e as E}from"./chunk-362ETHZ6.js";var Y=[],k=[];function K(e,t,i,r,o){let n=M.fromPoints(t,e).projectPointsOntoPlane(t,Y);D.computeWindingOrder2D(n)===W.CLOCKWISE&&(n.reverse(),t=t.slice().reverse());let s,p,u=t.length,l=0;if(r)for(s=new Float64Array(2*u*3),p=0;p<u;p++){let e=t[p],i=t[(p+1)%u];s[l++]=e.x,s[l++]=e.y,s[l++]=e.z,s[l++]=i.x,s[l++]=i.y,s[l++]=i.z}else{let r=0;if(o===P.GEODESIC)for(p=0;p<u;p++)r+=a.subdivideLineCount(t[p],t[(p+1)%u],i);else if(o===P.RHUMB)for(p=0;p<u;p++)r+=a.subdivideRhumbLineCount(e,t[p],t[(p+1)%u],i);for(s=new Float64Array(3*r),p=0;p<u;p++){let r;o===P.GEODESIC?r=a.subdivideLine(t[p],t[(p+1)%u],i,k):o===P.RHUMB&&(r=a.subdivideRhumbLine(e,t[p],t[(p+1)%u],i,k));let n=r.length;for(let e=0;e<n;++e)s[l++]=r[e]}}u=s.length/3;let h=2*u,c=G.createTypedArray(u,h);for(l=0,p=0;p<u-1;p++)c[l++]=p,c[l++]=p+1;return c[l++]=u-1,c[l++]=0,new F({geometry:new S({attributes:new B({position:new w({componentDatatype:T.DOUBLE,componentsPerAttribute:3,values:s})}),indices:c,primitiveType:U.LINES})})}function q(e,t,i,r,o){let n=M.fromPoints(t,e).projectPointsOntoPlane(t,Y);D.computeWindingOrder2D(n)===W.CLOCKWISE&&(n.reverse(),t=t.slice().reverse());let s,p,u=t.length,l=new Array(u),h=0;if(r)for(s=new Float64Array(2*u*3*2),p=0;p<u;++p){l[p]=h/3;let e=t[p],i=t[(p+1)%u];s[h++]=e.x,s[h++]=e.y,s[h++]=e.z,s[h++]=i.x,s[h++]=i.y,s[h++]=i.z}else{let r=0;if(o===P.GEODESIC)for(p=0;p<u;p++)r+=a.subdivideLineCount(t[p],t[(p+1)%u],i);else if(o===P.RHUMB)for(p=0;p<u;p++)r+=a.subdivideRhumbLineCount(e,t[p],t[(p+1)%u],i);for(s=new Float64Array(3*r*2),p=0;p<u;++p){let r;l[p]=h/3,o===P.GEODESIC?r=a.subdivideLine(t[p],t[(p+1)%u],i,k):o===P.RHUMB&&(r=a.subdivideRhumbLine(e,t[p],t[(p+1)%u],i,k));let n=r.length;for(let e=0;e<n;++e)s[h++]=r[e]}}u=s.length/6;let c=l.length,y=2*(2*u+c),f=G.createTypedArray(u+c,y);for(h=0,p=0;p<u;++p)f[h++]=p,f[h++]=(p+1)%u,f[h++]=p+u,f[h++]=(p+1)%u+u;for(p=0;p<c;p++){let e=l[p];f[h++]=e,f[h++]=e+u}return new F({geometry:new S({attributes:new B({position:new w({componentDatatype:T.DOUBLE,componentsPerAttribute:3,values:s})}),indices:f,primitiveType:U.LINES})})}function A(e){if(O.typeOf.object("options",e),O.typeOf.object("options.polygonHierarchy",e.polygonHierarchy),e.perPositionHeight&&E(e.height))throw new N("Cannot use both options.perPositionHeight and options.height");if(E(e.arcType)&&e.arcType!==P.GEODESIC&&e.arcType!==P.RHUMB)throw new N("Invalid arcType. Valid options are ArcType.GEODESIC and ArcType.RHUMB.");let t=e.polygonHierarchy,i=e.ellipsoid??y.default,r=e.granularity??L.RADIANS_PER_DEGREE,o=e.perPositionHeight??!1,n=o&&E(e.extrudedHeight),s=e.arcType??P.GEODESIC,p=e.height??0,u=e.extrudedHeight??p;if(!n){let e=Math.max(p,u);u=Math.min(p,u),p=e}this._ellipsoid=y.clone(i),this._granularity=r,this._height=p,this._extrudedHeight=u,this._arcType=s,this._polygonHierarchy=t,this._perPositionHeight=o,this._perPositionHeightExtrude=n,this._offsetAttribute=e.offsetAttribute,this._workerName="createPolygonOutlineGeometry",this.packedLength=a.computeHierarchyPackedLength(t,v)+y.packedLength+8}A.pack=function(e,t,i){return O.typeOf.object("value",e),O.defined("array",t),i=i??0,i=a.packPolygonHierarchy(e._polygonHierarchy,t,i,v),y.pack(e._ellipsoid,t,i),i+=y.packedLength,t[i++]=e._height,t[i++]=e._extrudedHeight,t[i++]=e._granularity,t[i++]=e._perPositionHeightExtrude?1:0,t[i++]=e._perPositionHeight?1:0,t[i++]=e._arcType,t[i++]=e._offsetAttribute??-1,t[i]=e.packedLength,t};var J=y.clone(y.UNIT_SPHERE),Q={polygonHierarchy:{}};A.unpack=function(e,t,i){O.defined("array",e),t=t??0;let r=a.unpackPolygonHierarchy(e,t,v);t=r.startingIndex,delete r.startingIndex;let o=y.unpack(e,t,J);t+=y.packedLength;let n=e[t++],s=e[t++],p=e[t++],u=1===e[t++],l=1===e[t++],h=e[t++],c=e[t++],f=e[t];return E(i)||(i=new A(Q)),i._polygonHierarchy=r,i._ellipsoid=y.clone(o,i._ellipsoid),i._height=n,i._extrudedHeight=s,i._granularity=p,i._perPositionHeight=l,i._perPositionHeightExtrude=u,i._arcType=h,i._offsetAttribute=-1===c?void 0:c,i.packedLength=f,i},A.fromPositions=function(e){return e=e??j.EMPTY_OBJECT,O.defined("options.positions",e.positions),new A({polygonHierarchy:{positions:e.positions},height:e.height,extrudedHeight:e.extrudedHeight,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight,arcType:e.arcType,offsetAttribute:e.offsetAttribute})},A.createGeometry=function(e){let t=e._ellipsoid,i=e._granularity,r=e._polygonHierarchy,o=e._perPositionHeight,n=e._arcType,s=a.polygonOutlinesFromHierarchy(r,!o,t);if(0===s.length)return;let p,u,l,h=[],c=L.chordLength(i,t.maximumRadius),y=e._height,f=e._extrudedHeight;if(e._perPositionHeightExtrude||!L.equalsEpsilon(y,f,0,L.EPSILON2))for(l=0;l<s.length;l++){if(p=q(t,s[l],c,o,n),p.geometry=a.scaleToGeodeticHeightExtruded(p.geometry,y,f,t,o),E(e._offsetAttribute)){let t=p.geometry.attributes.position.values.length/3,i=new Uint8Array(t);e._offsetAttribute===C.TOP?i=i.fill(1,0,t/2):(u=e._offsetAttribute===C.NONE?0:1,i=i.fill(u)),p.geometry.attributes.applyOffset=new w({componentDatatype:T.UNSIGNED_BYTE,componentsPerAttribute:1,values:i})}h.push(p)}else for(l=0;l<s.length;l++){if(p=K(t,s[l],c,o,n),p.geometry.attributes.position.values=D.scaleToGeodeticHeight(p.geometry.attributes.position.values,y,t,!o),E(e._offsetAttribute)){let t=p.geometry.attributes.position.values.length;u=e._offsetAttribute===C.NONE?0:1;let i=new Uint8Array(t/3).fill(u);p.geometry.attributes.applyOffset=new w({componentDatatype:T.UNSIGNED_BYTE,componentsPerAttribute:1,values:i})}h.push(p)}let d=V.combineInstances(h)[0],g=x.fromVertices(d.attributes.position.values);return new S({attributes:d.attributes,indices:d.indices,primitiveType:d.primitiveType,boundingSphere:g,offsetAttribute:e._offsetAttribute})};var z=A;function X(e,t){return E(t)&&(e=z.unpack(e,t)),e._ellipsoid=y.clone(e._ellipsoid),z.createGeometry(e)}var Oe=X;export{Oe as default};