/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as m}from"./chunk-TVWUDJC6.js";import{a as R}from"./chunk-Z5ZDCTRN.js";import{a as N}from"./chunk-MQYSNG5N.js";import"./chunk-QYCM25U7.js";import{a as g}from"./chunk-QL3VAYCR.js";import{a as le}from"./chunk-2DWCJX3G.js";import"./chunk-L3YV42ES.js";import"./chunk-QTPIBP7S.js";import"./chunk-ZCCOD3XE.js";import{a as se}from"./chunk-SFW65PGL.js";import{a as ce}from"./chunk-BTGP76WP.js";import{a as ne,b as re,c as ie,d as x}from"./chunk-YQL7OPIW.js";import{d as oe}from"./chunk-DPQZPDIL.js";import"./chunk-YJEV67VS.js";import{a as V}from"./chunk-4BTDTSQG.js";import{a as p,d as u,f as te}from"./chunk-XFVXIGTK.js";import{a as j}from"./chunk-MPRZ6V46.js";import"./chunk-FO77LMQ7.js";import"./chunk-TYEGOJMY.js";import{a as F}from"./chunk-VZMWSUG7.js";import{e as h}from"./chunk-362ETHZ6.js";var me=[];function Ae(e,t,r,o,n){let a=me;a.length=n;let i,l=r.red,s=r.green,p=r.blue,c=r.alpha,h=o.red,u=o.green,d=o.blue,f=o.alpha;if(m.equals(r,o)){for(i=0;i<n;i++)a[i]=m.clone(r);return a}let g=(h-l)/n,k=(u-s)/n,w=(d-p)/n,y=(f-c)/n;for(i=0;i<n;i++)a[i]=new m(l+i*g,s+i*k,p+i*w,c+i*y);return a}function q(e){let t=(e=e??te.EMPTY_OBJECT).positions,r=e.colors,o=e.width??1,n=e.colorsPerVertex??!1;if(!h(t)||t.length<2)throw new F("At least two positions are required.");if("number"!=typeof o)throw new F("width must be a number");if(h(r)&&(n&&r.length<t.length||!n&&r.length<t.length-1))throw new F("colors has an invalid length.");this._positions=t,this._colors=r,this._width=o,this._colorsPerVertex=n,this._vertexFormat=g.clone(e.vertexFormat??g.DEFAULT),this._arcType=e.arcType??R.GEODESIC,this._granularity=e.granularity??j.RADIANS_PER_DEGREE,this._ellipsoid=u.clone(e.ellipsoid??u.default),this._workerName="createPolylineGeometry";let a=1+t.length*p.packedLength;a+=h(r)?1+r.length*m.packedLength:1,this.packedLength=a+u.packedLength+g.packedLength+4}q.pack=function(e,t,r){if(!h(e))throw new F("value is required");if(!h(t))throw new F("array is required");r=r??0;let o,n=e._positions,a=n.length;for(t[r++]=a,o=0;o<a;++o,r+=p.packedLength)p.pack(n[o],t,r);let i=e._colors;for(a=h(i)?i.length:0,t[r++]=a,o=0;o<a;++o,r+=m.packedLength)m.pack(i[o],t,r);return u.pack(e._ellipsoid,t,r),r+=u.packedLength,g.pack(e._vertexFormat,t,r),r+=g.packedLength,t[r++]=e._width,t[r++]=e._colorsPerVertex?1:0,t[r++]=e._arcType,t[r]=e._granularity,t};var de=u.clone(u.UNIT_SPHERE),ue=new g,O={positions:void 0,colors:void 0,ellipsoid:de,vertexFormat:ue,width:void 0,colorsPerVertex:void 0,arcType:void 0,granularity:void 0};q.unpack=function(e,t,r){if(!h(e))throw new F("array is required");t=t??0;let o,n=e[t++],a=new Array(n);for(o=0;o<n;++o,t+=p.packedLength)a[o]=p.unpack(e,t);n=e[t++];let i=n>0?new Array(n):void 0;for(o=0;o<n;++o,t+=m.packedLength)i[o]=m.unpack(e,t);let l=u.unpack(e,t,de);t+=u.packedLength;let s=g.unpack(e,t,ue);t+=g.packedLength;let c=e[t++],d=1===e[t++],f=e[t++],k=e[t];return h(r)?(r._positions=a,r._colors=i,r._ellipsoid=u.clone(l,r._ellipsoid),r._vertexFormat=g.clone(s,r._vertexFormat),r._width=c,r._colorsPerVertex=d,r._arcType=f,r._granularity=k,r):(O.positions=a,O.colors=i,O.width=c,O.colorsPerVertex=d,O.arcType=f,O.granularity=k,new q(O))};var pe=new p,ae=new p,fe=new p,he=new p;q.createGeometry=function(e){let t,r,o,n=e._width,a=e._vertexFormat,i=e._colors,l=e._colorsPerVertex,s=e._arcType,c=e._granularity,u=e._ellipsoid,d=[],f=le(e._positions,p.equalsEpsilon,!1,d);if(h(i)&&d.length>0){let e=0,t=d[0];i=i.filter((function(r,o){let n=!1;return n=l?o===t||0===o&&1===t:o+1===t,!n||(e++,t=d[e],!1)}))}let g=f.length;if(g<2||n<=0)return;if(s===R.GEODESIC||s===R.RHUMB){let e,o;s===R.GEODESIC?(e=j.chordLength(c,u.maximumRadius),o=N.numberOfPoints):(e=c,o=N.numberOfPointsRhumbLine);let n=N.extractHeights(f,u);if(h(i)){let n=1;for(t=0;t<g-1;++t)n+=o(f[t],f[t+1],e);let a=new Array(n),s=0;for(t=0;t<g-1;++t){let p=f[t],c=f[t+1],h=i[t],u=o(p,c,e);if(l&&t<n){let e=Ae(p,c,h,i[t+1],u),o=e.length;for(r=0;r<o;++r)a[s++]=e[r]}else for(r=0;r<u;++r)a[s++]=m.clone(h)}a[s]=m.clone(i[i.length-1]),i=a,me.length=0}f=s===R.GEODESIC?N.generateCartesianArc({positions:f,minDistance:e,ellipsoid:u,height:n}):N.generateCartesianRhumbArc({positions:f,granularity:e,ellipsoid:u,height:n})}g=f.length;let k,w=4*g-4,y=new Float64Array(3*w),_=new Float64Array(3*w),P=new Float64Array(3*w),v=new Float32Array(2*w),T=a.st?new Float32Array(2*w):void 0,E=h(i)?new Uint8Array(4*w):void 0,L=0,A=0,D=0,F=0;for(r=0;r<g;++r){let e,t;0===r?(k=pe,p.subtract(f[0],f[1],k),p.add(f[0],k,k)):k=f[r-1],p.clone(k,fe),p.clone(f[r],ae),r===g-1?(k=pe,p.subtract(f[g-1],f[g-2],k),p.add(f[g-1],k,k)):k=f[r+1],p.clone(k,he),h(E)&&(e=0===r||l?i[r]:i[r-1],r!==g-1&&(t=i[r]));let s=r===g-1?2:4;for(o=0===r?2:0;o<s;++o){p.pack(ae,y,L),p.pack(fe,_,L),p.pack(he,P,L),L+=3;let i=o-2<0?-1:1;if(v[A++]=o%2*2-1,v[A++]=i*n,a.st&&(T[D++]=r/(g-1),T[D++]=Math.max(v[A-2],0)),h(E)){let r=o<2?e:t;E[F++]=m.floatToByte(r.red),E[F++]=m.floatToByte(r.green),E[F++]=m.floatToByte(r.blue),E[F++]=m.floatToByte(r.alpha)}}}let O=new ce;O.position=new x({componentDatatype:V.DOUBLE,componentsPerAttribute:3,values:y}),O.prevPosition=new x({componentDatatype:V.DOUBLE,componentsPerAttribute:3,values:_}),O.nextPosition=new x({componentDatatype:V.DOUBLE,componentsPerAttribute:3,values:P}),O.expandAndWidth=new x({componentDatatype:V.FLOAT,componentsPerAttribute:2,values:v}),a.st&&(O.st=new x({componentDatatype:V.FLOAT,componentsPerAttribute:2,values:T})),h(E)&&(O.color=new x({componentDatatype:V.UNSIGNED_BYTE,componentsPerAttribute:4,values:E,normalize:!0}));let b=se.createTypedArray(w,6*g-6),G=0,S=0,C=g-1;for(r=0;r<C;++r)b[S++]=G,b[S++]=G+2,b[S++]=G+1,b[S++]=G+1,b[S++]=G+2,b[S++]=G+3,G+=4;return new ie({attributes:O,indices:b,primitiveType:re.TRIANGLES,boundingSphere:oe.fromPoints(f),geometryType:ne.POLYLINES})};var J=q;function ge(e,t){return h(t)&&(e=J.unpack(e,t)),e._ellipsoid=u.clone(e._ellipsoid),J.createGeometry(e)}var We=ge;export{We as default};