/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as W}from"./chunk-4BXRRGX5.js";import{a as Nt}from"./chunk-CFRYEZJF.js";import{a as zt}from"./chunk-HCF5XBCP.js";import"./chunk-II365YZS.js";import"./chunk-IODKIN3W.js";import{a as ft}from"./chunk-64C3WG2L.js";import{a as q}from"./chunk-QL3VAYCR.js";import{b as yt}from"./chunk-EIJCAXME.js";import"./chunk-L3YV42ES.js";import"./chunk-QTPIBP7S.js";import"./chunk-ZCCOD3XE.js";import{a as At}from"./chunk-SFW65PGL.js";import{a as Vt}from"./chunk-BTGP76WP.js";import{b as Mt,c as Pt,d as Y}from"./chunk-YQL7OPIW.js";import{d as at}from"./chunk-DPQZPDIL.js";import{f as Lt,h as E,i as bt}from"./chunk-YJEV67VS.js";import{a as U}from"./chunk-4BTDTSQG.js";import{a as w,b as mt,c as $,d as D,e as lt,f as St}from"./chunk-XFVXIGTK.js";import{a as I}from"./chunk-MPRZ6V46.js";import"./chunk-FO77LMQ7.js";import"./chunk-TYEGOJMY.js";import{a as Et,b as ct}from"./chunk-VZMWSUG7.js";import{e as K}from"./chunk-362ETHZ6.js";var Tt=new w,Bt=new w,Ut=new w,Yt=new w,qt=new E,Zt=new $,Kt=new at,$t=new at;function Xt(t,e){let n=new Pt({attributes:new Vt,primitiveType:Mt.TRIANGLES});return n.attributes.position=new Y({componentDatatype:U.DOUBLE,componentsPerAttribute:3,values:e.positions}),t.normal&&(n.attributes.normal=new Y({componentDatatype:U.FLOAT,componentsPerAttribute:3,values:e.normals})),t.tangent&&(n.attributes.tangent=new Y({componentDatatype:U.FLOAT,componentsPerAttribute:3,values:e.tangents})),t.bitangent&&(n.attributes.bitangent=new Y({componentDatatype:U.FLOAT,componentsPerAttribute:3,values:e.bitangents})),n}function Gt(t,e,n,o){let a=t.length,r=e.normal?new Float32Array(a):void 0,i=e.tangent?new Float32Array(a):void 0,s=e.bitangent?new Float32Array(a):void 0,l=0,u=Yt,c=Ut,m=Bt;if(e.normal||e.tangent||e.bitangent)for(let p=0;p<a;p+=3){let a=w.fromArray(t,p,Tt),h=l+1,f=l+2;m=n.geodeticSurfaceNormal(a,m),(e.tangent||e.bitangent)&&(w.cross(w.UNIT_Z,m,c),lt.multiplyByVector(o,c,c),w.normalize(c,c),e.bitangent&&w.normalize(w.cross(m,c,u),u)),e.normal&&(r[l]=m.x,r[h]=m.y,r[f]=m.z),e.tangent&&(i[l]=c.x,i[h]=c.y,i[f]=c.z),e.bitangent&&(s[l]=u.x,s[h]=u.y,s[f]=u.z),l+=3}return Xt(e,{positions:t,normals:r,tangents:i,bitangents:s})}var Ct=new w,jt=new w;function te(t,e,n){let o=t.length,a=e.normal?new Float32Array(o):void 0,r=e.tangent?new Float32Array(o):void 0,i=e.bitangent?new Float32Array(o):void 0,s=0,l=0,u=0,c=!0,m=Yt,p=Ut,h=Bt;if(e.normal||e.tangent||e.bitangent)for(let f=0;f<o;f+=6){let g=w.fromArray(t,f,Tt),d=w.fromArray(t,(f+6)%o,Ct);if(c){let e=w.fromArray(t,(f+3)%o,jt);w.subtract(d,g,d),w.subtract(e,g,e),h=w.normalize(w.cross(e,d,h),h),c=!1}w.equalsEpsilon(d,g,I.EPSILON10)&&(c=!0),(e.tangent||e.bitangent)&&(m=n.geodeticSurfaceNormal(g,m),e.tangent&&(p=w.normalize(w.cross(m,h,p),p))),e.normal&&(a[s++]=h.x,a[s++]=h.y,a[s++]=h.z,a[s++]=h.x,a[s++]=h.y,a[s++]=h.z),e.tangent&&(r[l++]=p.x,r[l++]=p.y,r[l++]=p.z,r[l++]=p.x,r[l++]=p.y,r[l++]=p.z),e.bitangent&&(i[u++]=m.x,i[u++]=m.y,i[u++]=m.z,i[u++]=m.x,i[u++]=m.y,i[u++]=m.z)}return Xt(e,{positions:t,normals:a,tangents:r,bitangents:i})}function It(t,e){let n=t._vertexFormat,o=t._ellipsoid,a=e.height,r=e.width,i=e.northCap,s=e.southCap,l=0,u=a,c=a,m=0;i&&(l=1,c-=1,m+=1),s&&(u-=1,c-=1,m+=1),m+=r*c;let p=n.position?new Float64Array(3*m):void 0,h=n.st?new Float32Array(2*m):void 0,f=0,g=0,d=Tt,w=Zt,y=Number.MAX_VALUE,_=Number.MAX_VALUE,b=-Number.MAX_VALUE,A=-Number.MAX_VALUE;for(let t=l;t<u;++t)for(let a=0;a<r;++a)W.computePosition(e,o,n.st,t,a,d,w),p[f++]=d.x,p[f++]=d.y,p[f++]=d.z,n.st&&(h[g++]=w.x,h[g++]=w.y,y=Math.min(y,w.x),_=Math.min(_,w.y),b=Math.max(b,w.x),A=Math.max(A,w.y));if(i&&(W.computePosition(e,o,n.st,0,0,d,w),p[f++]=d.x,p[f++]=d.y,p[f++]=d.z,n.st&&(h[g++]=w.x,h[g++]=w.y,y=w.x,_=w.y,b=w.x,A=w.y)),s&&(W.computePosition(e,o,n.st,a-1,0,d,w),p[f++]=d.x,p[f++]=d.y,p[f]=d.z,n.st&&(h[g++]=w.x,h[g]=w.y,y=Math.min(y,w.x),_=Math.min(_,w.y),b=Math.max(b,w.x),A=Math.max(A,w.y))),n.st&&(y<0||_<0||b>1||A>1))for(let t=0;t<h.length;t+=2)h[t]=(h[t]-y)/(b-y),h[t+1]=(h[t+1]-_)/(A-_);let v=Gt(p,n,o,e.tangentRotationMatrix),E=6*(r-1)*(c-1);i&&(E+=3*(r-1)),s&&(E+=3*(r-1));let x,P=At.createTypedArray(m,E),D=0,F=0;for(x=0;x<c-1;++x){for(let t=0;t<r-1;++t){let t=D,e=t+r,n=e+1,o=t+1;P[F++]=t,P[F++]=e,P[F++]=o,P[F++]=o,P[F++]=e,P[F++]=n,++D}++D}if(i||s){let t,e,n=m-1,o=m-1;if(i&&s&&(n=m-2),D=0,i)for(x=0;x<r-1;x++)t=D,e=t+1,P[F++]=n,P[F++]=t,P[F++]=e,++D;if(s)for(D=(c-1)*r,x=0;x<r-1;x++)t=D,e=t+1,P[F++]=t,P[F++]=o,P[F++]=e,++D}return v.indices=P,n.st&&(v.attributes.st=new Y({componentDatatype:U.FLOAT,componentsPerAttribute:2,values:h})),v}function ut(t,e,n,o,a){return t[e++]=o[n],t[e++]=o[n+1],t[e++]=o[n+2],t[e++]=a[n],t[e++]=a[n+1],t[e]=a[n+2],t}function ht(t,e,n,o){return t[e++]=o[n],t[e++]=o[n+1],t[e++]=o[n],t[e]=o[n+1],t}var Dt=new q;function ee(t,e){let n,o=t._shadowVolume,a=t._offsetAttribute,r=t._vertexFormat,i=t._extrudedHeight,s=t._surfaceHeight,l=t._ellipsoid,u=e.height,c=e.width;if(o){let e=q.clone(r,Dt);e.normal=!0,t._vertexFormat=e}let m=It(t,e);o&&(t._vertexFormat=r);let p=yt.scaleToGeodeticHeight(m.attributes.position.values,s,l,!1);p=new Float64Array(p);let h=p.length,f=2*h,g=new Float64Array(f);g.set(p);let d=yt.scaleToGeodeticHeight(m.attributes.position.values,i,l);g.set(d,h),m.attributes.position.values=g;let y,_,b=r.normal?new Float32Array(f):void 0,A=r.tangent?new Float32Array(f):void 0,v=r.bitangent?new Float32Array(f):void 0,E=r.st?new Float32Array(f/3*2):void 0;if(r.normal){for(_=m.attributes.normal.values,b.set(_),n=0;n<h;n++)_[n]=-_[n];b.set(_,h),m.attributes.normal.values=b}if(o){_=m.attributes.normal.values,r.normal||(m.attributes.normal=void 0);let t=new Float32Array(f);for(n=0;n<h;n++)_[n]=-_[n];t.set(_,h),m.attributes.extrudeDirection=new Y({componentDatatype:U.FLOAT,componentsPerAttribute:3,values:t})}let x,P=K(a);if(P){let t=h/3*2,e=new Uint8Array(t);a===ft.TOP?e=e.fill(1,0,t/2):(x=a===ft.NONE?0:1,e=e.fill(x)),m.attributes.applyOffset=new Y({componentDatatype:U.UNSIGNED_BYTE,componentsPerAttribute:1,values:e})}if(r.tangent){let t=m.attributes.tangent.values;for(A.set(t),n=0;n<h;n++)t[n]=-t[n];A.set(t,h),m.attributes.tangent.values=A}if(r.bitangent){let t=m.attributes.bitangent.values;v.set(t),v.set(t,h),m.attributes.bitangent.values=v}r.st&&(y=m.attributes.st.values,E.set(y),E.set(y,h/3*2),m.attributes.st.values=E);let D=m.indices,F=D.length,k=h/3,T=At.createTypedArray(f/3,2*F);for(T.set(D),n=0;n<F;n+=3)T[n+F]=D[n+2]+k,T[n+1+F]=D[n+1]+k,T[n+2+F]=D[n]+k;m.indices=T;let L=e.northCap,R=e.southCap,O=u,N=2,G=0,j=4,S=4;L&&(N-=1,O-=1,G+=1,j-=2,S-=1),R&&(N-=1,O-=1,G+=1,j-=2,S-=1),G+=N*c+2*O-j;let C=2*(G+S),M=new Float64Array(3*C),H=o?new Float32Array(3*C):void 0,V=P?new Uint8Array(C):void 0,J=r.st?new Float32Array(2*C):void 0,W=a===ft.TOP;P&&!W&&(x=a===ft.ALL?1:0,V=V.fill(x));let z,B=0,X=0,Q=0,Z=0,$=c*O;for(n=0;n<$;n+=c)z=3*n,M=ut(M,B,z,p,d),B+=6,r.st&&(J=ht(J,X,2*n,y),X+=4),o&&(Q+=3,H[Q++]=_[z],H[Q++]=_[z+1],H[Q++]=_[z+2]),W&&(V[Z++]=1,Z+=1);if(R){let t=L?$+1:$;for(z=3*t,n=0;n<2;n++)M=ut(M,B,z,p,d),B+=6,r.st&&(J=ht(J,X,2*t,y),X+=4),o&&(Q+=3,H[Q++]=_[z],H[Q++]=_[z+1],H[Q++]=_[z+2]),W&&(V[Z++]=1,Z+=1)}else for(n=$-c;n<$;n++)z=3*n,M=ut(M,B,z,p,d),B+=6,r.st&&(J=ht(J,X,2*n,y),X+=4),o&&(Q+=3,H[Q++]=_[z],H[Q++]=_[z+1],H[Q++]=_[z+2]),W&&(V[Z++]=1,Z+=1);for(n=$-1;n>0;n-=c)z=3*n,M=ut(M,B,z,p,d),B+=6,r.st&&(J=ht(J,X,2*n,y),X+=4),o&&(Q+=3,H[Q++]=_[z],H[Q++]=_[z+1],H[Q++]=_[z+2]),W&&(V[Z++]=1,Z+=1);if(L){let t=$;for(z=3*t,n=0;n<2;n++)M=ut(M,B,z,p,d),B+=6,r.st&&(J=ht(J,X,2*t,y),X+=4),o&&(Q+=3,H[Q++]=_[z],H[Q++]=_[z+1],H[Q++]=_[z+2]),W&&(V[Z++]=1,Z+=1)}else for(n=c-1;n>=0;n--)z=3*n,M=ut(M,B,z,p,d),B+=6,r.st&&(J=ht(J,X,2*n,y),X+=4),o&&(Q+=3,H[Q++]=_[z],H[Q++]=_[z+1],H[Q++]=_[z+2]),W&&(V[Z++]=1,Z+=1);let tt=te(M,r,l);r.st&&(tt.attributes.st=new Y({componentDatatype:U.FLOAT,componentsPerAttribute:2,values:J})),o&&(tt.attributes.extrudeDirection=new Y({componentDatatype:U.FLOAT,componentsPerAttribute:3,values:H})),P&&(tt.attributes.applyOffset=new Y({componentDatatype:U.UNSIGNED_BYTE,componentsPerAttribute:1,values:V}));let et,nt,ot,at,rt=At.createTypedArray(C,6*G);h=M.length/3;let it=0;for(n=0;n<h-1;n+=2){et=n,at=(et+2)%h;let t=w.fromArray(M,3*et,Ct),e=w.fromArray(M,3*at,jt);w.equalsEpsilon(t,e,I.EPSILON10)||(nt=(et+1)%h,ot=(nt+2)%h,rt[it++]=et,rt[it++]=nt,rt[it++]=at,rt[it++]=at,rt[it++]=nt,rt[it++]=ot)}return tt.indices=rt,tt=zt.combineInstances([new Nt({geometry:m}),new Nt({geometry:tt})]),tt[0]}var ne=[new w,new w,new w,new w],Wt=new mt,oe=new mt;function Ht(t,e,n,o,a){if(0===n)return E.clone(t,a);let r=W.computeOptions(t,e,n,0,qt,Wt),i=r.height,s=r.width,l=ne;return W.computePosition(r,o,!1,0,0,l[0]),W.computePosition(r,o,!1,0,s-1,l[1]),W.computePosition(r,o,!1,i-1,0,l[2]),W.computePosition(r,o,!1,i-1,s-1,l[3]),E.fromCartesianArray(l,o,a)}function J(t){let e=(t=t??St.EMPTY_OBJECT).rectangle;if(ct.typeOf.object("rectangle",e),E._validate(e),e.north<e.south)throw new Et("options.rectangle.north must be greater than or equal to options.rectangle.south");let n=t.height??0,o=t.extrudedHeight??n;this._rectangle=E.clone(e),this._granularity=t.granularity??I.RADIANS_PER_DEGREE,this._ellipsoid=D.clone(t.ellipsoid??D.default),this._surfaceHeight=Math.max(n,o),this._rotation=t.rotation??0,this._stRotation=t.stRotation??0,this._vertexFormat=q.clone(t.vertexFormat??q.DEFAULT),this._extrudedHeight=Math.min(n,o),this._shadowVolume=t.shadowVolume??!1,this._workerName="createRectangleGeometry",this._offsetAttribute=t.offsetAttribute,this._rotatedRectangle=void 0,this._textureCoordinateRotationPoints=void 0}J.packedLength=E.packedLength+D.packedLength+q.packedLength+7,J.pack=function(t,e,n){return ct.typeOf.object("value",t),ct.defined("array",e),n=n??0,E.pack(t._rectangle,e,n),n+=E.packedLength,D.pack(t._ellipsoid,e,n),n+=D.packedLength,q.pack(t._vertexFormat,e,n),n+=q.packedLength,e[n++]=t._granularity,e[n++]=t._surfaceHeight,e[n++]=t._rotation,e[n++]=t._stRotation,e[n++]=t._extrudedHeight,e[n++]=t._shadowVolume?1:0,e[n]=t._offsetAttribute??-1,e};var Jt=new E,Qt=D.clone(D.UNIT_SPHERE),G={rectangle:Jt,ellipsoid:Qt,vertexFormat:Dt,granularity:void 0,height:void 0,rotation:void 0,stRotation:void 0,extrudedHeight:void 0,shadowVolume:void 0,offsetAttribute:void 0};J.unpack=function(t,e,n){ct.defined("array",t),e=e??0;let o=E.unpack(t,e,Jt);e+=E.packedLength;let a=D.unpack(t,e,Qt);e+=D.packedLength;let r=q.unpack(t,e,Dt);e+=q.packedLength;let i=t[e++],s=t[e++],l=t[e++],u=t[e++],c=t[e++],m=1===t[e++],p=t[e];return K(n)?(n._rectangle=E.clone(o,n._rectangle),n._ellipsoid=D.clone(a,n._ellipsoid),n._vertexFormat=q.clone(r,n._vertexFormat),n._granularity=i,n._surfaceHeight=s,n._rotation=l,n._stRotation=u,n._extrudedHeight=c,n._shadowVolume=m,n._offsetAttribute=-1===p?void 0:p,n):(G.granularity=i,G.height=s,G.rotation=l,G.stRotation=u,G.extrudedHeight=c,G.shadowVolume=m,G.offsetAttribute=-1===p?void 0:p,new J(G))},J.computeRectangle=function(t,e){let n=(t=t??St.EMPTY_OBJECT).rectangle;if(ct.typeOf.object("rectangle",n),E._validate(n),n.north<n.south)throw new Et("options.rectangle.north must be greater than or equal to options.rectangle.south");let o=t.granularity??I.RADIANS_PER_DEGREE,a=t.ellipsoid??D.default;return Ht(n,o,t.rotation??0,a,e)};var ie=new lt,Ft=new Lt,ae=new mt;J.createGeometry=function(t){if(I.equalsEpsilon(t._rectangle.north,t._rectangle.south,I.EPSILON10)||I.equalsEpsilon(t._rectangle.east,t._rectangle.west,I.EPSILON10))return;let e=t._rectangle,n=t._ellipsoid,o=t._rotation,a=t._stRotation,r=t._vertexFormat,i=W.computeOptions(e,t._granularity,o,a,qt,Wt,oe),s=ie;if(0!==a||0!==o){let t=E.center(e,ae),o=n.geodeticSurfaceNormalCartographic(t,Ct);Lt.fromAxisAngle(o,-a,Ft),lt.fromQuaternion(Ft,s)}else lt.clone(lt.IDENTITY,s);let l,u,c=t._surfaceHeight,m=t._extrudedHeight,p=!I.equalsEpsilon(c,m,0,I.EPSILON2);if(i.lonScalar=1/t._rectangle.width,i.latScalar=1/t._rectangle.height,i.tangentRotationMatrix=s,e=t._rectangle,p){l=ee(t,i);let o=at.fromRectangle3D(e,n,c,$t),a=at.fromRectangle3D(e,n,m,Kt);u=at.union(o,a)}else{if(l=It(t,i),l.attributes.position.values=yt.scaleToGeodeticHeight(l.attributes.position.values,c,n,!1),K(t._offsetAttribute)){let e=l.attributes.position.values.length,n=t._offsetAttribute===ft.NONE?0:1,o=new Uint8Array(e/3).fill(n);l.attributes.applyOffset=new Y({componentDatatype:U.UNSIGNED_BYTE,componentsPerAttribute:1,values:o})}u=at.fromRectangle3D(e,n,c)}return r.position||delete l.attributes.position,new Pt({attributes:l.attributes,indices:l.indices,primitiveType:l.primitiveType,boundingSphere:u,offsetAttribute:t._offsetAttribute})},J.createShadowVolume=function(t,e,n){let o=t._granularity,a=t._ellipsoid,r=e(o,a),i=n(o,a);return new J({rectangle:t._rectangle,rotation:t._rotation,ellipsoid:a,stRotation:t._stRotation,granularity:o,extrudedHeight:i,height:r,vertexFormat:q.POSITION_ONLY,shadowVolume:!0})};var vt=new E,se=[new $,new $,new $],re=new bt,ce=new mt;function le(t){if(0===t._stRotation)return[0,0,0,1,1,0];let e=E.clone(t._rectangle,vt),n=t._granularity,o=t._ellipsoid,a=Ht(e,n,t._rotation-t._stRotation,o,vt),r=se;r[0].x=a.west,r[0].y=a.south,r[1].x=a.west,r[1].y=a.north,r[2].x=a.east,r[2].y=a.south;let i=t.rectangle,s=bt.fromRotation(t._stRotation,re),l=E.center(i,ce);for(let t=0;t<3;++t){let e=r[t];e.x-=l.longitude,e.y-=l.latitude,bt.multiplyByVector(s,e,e),e.x+=l.longitude,e.y+=l.latitude,e.x=(e.x-i.west)/i.width,e.y=(e.y-i.south)/i.height}let u=r[0],c=r[1],m=r[2],p=new Array(6);return $.pack(u,p),$.pack(c,p,2),$.pack(m,p,4),p}Object.defineProperties(J.prototype,{rectangle:{get:function(){return K(this._rotatedRectangle)||(this._rotatedRectangle=Ht(this._rectangle,this._granularity,this._rotation,this._ellipsoid)),this._rotatedRectangle}},textureCoordinateRotationPoints:{get:function(){return K(this._textureCoordinateRotationPoints)||(this._textureCoordinateRotationPoints=le(this)),this._textureCoordinateRotationPoints}}});var Ot=J;function fe(t,e){return K(e)&&(t=Ot.unpack(t,e)),t._ellipsoid=D.clone(t._ellipsoid),t._rectangle=E.clone(t._rectangle),Ot.createGeometry(t)}var Ye=fe;export{Ye as default};