/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as R}from"./chunk-4BXRRGX5.js";import{a as y}from"./chunk-64C3WG2L.js";import{b as z}from"./chunk-EIJCAXME.js";import"./chunk-L3YV42ES.js";import{a as q}from"./chunk-SFW65PGL.js";import{a as F}from"./chunk-BTGP76WP.js";import{b as v,c as B,d as T}from"./chunk-YQL7OPIW.js";import{d as P}from"./chunk-DPQZPDIL.js";import{h as b}from"./chunk-YJEV67VS.js";import{a as D}from"./chunk-4BTDTSQG.js";import{a as x,b as U,d as w,f as M}from"./chunk-XFVXIGTK.js";import{a as S}from"./chunk-MPRZ6V46.js";import"./chunk-FO77LMQ7.js";import"./chunk-TYEGOJMY.js";import{a as C}from"./chunk-VZMWSUG7.js";import{e as H}from"./chunk-362ETHZ6.js";var j=new P,K=new P,Q=new x,W=new b;function Y(t,e){let i=t._ellipsoid,r=e.height,o=e.width,n=e.northCap,a=e.southCap,s=r,l=2,u=0,c=4;n&&(l-=1,s-=1,u+=1,c-=2),a&&(l-=1,s-=1,u+=1,c-=2),u+=l*o+2*s-c;let h,p=new Float64Array(3*u),f=0,d=0,g=Q;if(n)R.computePosition(e,i,!1,d,0,g),p[f++]=g.x,p[f++]=g.y,p[f++]=g.z;else for(h=0;h<o;h++)R.computePosition(e,i,!1,d,h,g),p[f++]=g.x,p[f++]=g.y,p[f++]=g.z;for(h=o-1,d=1;d<r;d++)R.computePosition(e,i,!1,d,h,g),p[f++]=g.x,p[f++]=g.y,p[f++]=g.z;if(d=r-1,!a)for(h=o-2;h>=0;h--)R.computePosition(e,i,!1,d,h,g),p[f++]=g.x,p[f++]=g.y,p[f++]=g.z;for(h=0,d=r-2;d>0;d--)R.computePosition(e,i,!1,d,h,g),p[f++]=g.x,p[f++]=g.y,p[f++]=g.z;let m=p.length/3*2,_=q.createTypedArray(p.length/3,m),b=0;for(let t=0;t<p.length/3-1;t++)_[b++]=t,_[b++]=t+1;_[b++]=p.length/3-1,_[b++]=0;let w=new B({attributes:new F,primitiveType:v.LINES});return w.attributes.position=new T({componentDatatype:D.DOUBLE,componentsPerAttribute:3,values:p}),w.indices=_,w}function X(t,e){let i=t._surfaceHeight,r=t._extrudedHeight,o=t._ellipsoid,n=Y(t,e),a=e.height,s=e.width,l=z.scaleToGeodeticHeight(n.attributes.position.values,i,o,!1),u=l.length,c=new Float64Array(2*u);c.set(l);let h=z.scaleToGeodeticHeight(n.attributes.position.values,r,o);c.set(h,u),n.attributes.position.values=c;let p=e.northCap,f=e.southCap,d=4;p&&(d-=1),f&&(d-=1);let g=2*(c.length/3+d),m=q.createTypedArray(c.length/3,g);u=c.length/6;let _,b=0;for(let t=0;t<u-1;t++)m[b++]=t,m[b++]=t+1,m[b++]=t+u,m[b++]=t+u+1;if(m[b++]=u-1,m[b++]=0,m[b++]=u+u-1,m[b++]=u,m[b++]=0,m[b++]=u,p)_=a-1;else{let t=s-1;m[b++]=t,m[b++]=t+u,_=s+a-2}if(m[b++]=_,m[b++]=_+u,!f){let t=s+_-1;m[b++]=t,m[b]=t+u}return n.indices=m,n}function k(t){let e=(t=t??M.EMPTY_OBJECT).rectangle,i=t.granularity??S.RADIANS_PER_DEGREE,r=t.ellipsoid??w.default,o=t.rotation??0;if(!H(e))throw new C("rectangle is required.");if(b._validate(e),e.north<e.south)throw new C("options.rectangle.north must be greater than options.rectangle.south");let n=t.height??0,a=t.extrudedHeight??n;this._rectangle=b.clone(e),this._granularity=i,this._ellipsoid=r,this._surfaceHeight=Math.max(n,a),this._rotation=o,this._extrudedHeight=Math.min(n,a),this._offsetAttribute=t.offsetAttribute,this._workerName="createRectangleOutlineGeometry"}k.packedLength=b.packedLength+w.packedLength+5,k.pack=function(t,e,i){if(!H(t))throw new C("value is required");if(!H(e))throw new C("array is required");return i=i??0,b.pack(t._rectangle,e,i),i+=b.packedLength,w.pack(t._ellipsoid,e,i),i+=w.packedLength,e[i++]=t._granularity,e[i++]=t._surfaceHeight,e[i++]=t._rotation,e[i++]=t._extrudedHeight,e[i]=t._offsetAttribute??-1,e};var J=new b,V=w.clone(w.UNIT_SPHERE),N={rectangle:J,ellipsoid:V,granularity:void 0,height:void 0,rotation:void 0,extrudedHeight:void 0,offsetAttribute:void 0};k.unpack=function(t,e,i){if(!H(t))throw new C("array is required");e=e??0;let r=b.unpack(t,e,J);e+=b.packedLength;let o=w.unpack(t,e,V);e+=w.packedLength;let n=t[e++],a=t[e++],s=t[e++],l=t[e++],u=t[e];return H(i)?(i._rectangle=b.clone(r,i._rectangle),i._ellipsoid=w.clone(o,i._ellipsoid),i._surfaceHeight=a,i._rotation=s,i._extrudedHeight=l,i._offsetAttribute=-1===u?void 0:u,i):(N.granularity=n,N.height=a,N.rotation=s,N.extrudedHeight=l,N.offsetAttribute=-1===u?void 0:u,new k(N))};var Z=new U;k.createGeometry=function(t){let e,i,r=t._rectangle,o=t._ellipsoid,n=R.computeOptions(r,t._granularity,t._rotation,0,W,Z);if(S.equalsEpsilon(r.north,r.south,S.EPSILON10)||S.equalsEpsilon(r.east,r.west,S.EPSILON10))return;let a,s=t._surfaceHeight,l=t._extrudedHeight;if(!S.equalsEpsilon(s,l,0,S.EPSILON2)){if(e=X(t,n),H(t._offsetAttribute)){let i=e.attributes.position.values.length/3,r=new Uint8Array(i);t._offsetAttribute===y.TOP?r=r.fill(1,0,i/2):(a=t._offsetAttribute===y.NONE?0:1,r=r.fill(a)),e.attributes.applyOffset=new T({componentDatatype:D.UNSIGNED_BYTE,componentsPerAttribute:1,values:r})}let u=P.fromRectangle3D(r,o,s,K),c=P.fromRectangle3D(r,o,l,j);i=P.union(u,c)}else{if(e=Y(t,n),e.attributes.position.values=z.scaleToGeodeticHeight(e.attributes.position.values,s,o,!1),H(t._offsetAttribute)){let i=e.attributes.position.values.length;a=t._offsetAttribute===y.NONE?0:1;let r=new Uint8Array(i/3).fill(a);e.attributes.applyOffset=new T({componentDatatype:D.UNSIGNED_BYTE,componentsPerAttribute:1,values:r})}i=P.fromRectangle3D(r,o,s)}return new B({attributes:e.attributes,indices:e.indices,primitiveType:v.LINES,boundingSphere:i,offsetAttribute:t._offsetAttribute})};var O=k;function $(t,e){return H(e)&&(t=O.unpack(t,e)),t._ellipsoid=w.clone(t._ellipsoid),t._rectangle=b.clone(t._rectangle),O.createGeometry(t)}var Et=$;export{Et as default};