/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as r}from"./chunk-TVWUDJC6.js";import{a as L}from"./chunk-Z5ZDCTRN.js";import{a as P}from"./chunk-MQYSNG5N.js";import"./chunk-QYCM25U7.js";import"./chunk-L3YV42ES.js";import"./chunk-QTPIBP7S.js";import"./chunk-ZCCOD3XE.js";import{a as X}from"./chunk-SFW65PGL.js";import{a as W}from"./chunk-BTGP76WP.js";import{b as K,c as Q,d as H}from"./chunk-YQL7OPIW.js";import{d as j}from"./chunk-DPQZPDIL.js";import"./chunk-YJEV67VS.js";import{a as v}from"./chunk-4BTDTSQG.js";import{a as A,d as w,f as J}from"./chunk-XFVXIGTK.js";import{a as G}from"./chunk-MPRZ6V46.js";import"./chunk-FO77LMQ7.js";import"./chunk-TYEGOJMY.js";import{a as D}from"./chunk-VZMWSUG7.js";import{e as u}from"./chunk-362ETHZ6.js";function Z(e,t,o,a,n,i,l){let s,u=P.numberOfPoints(e,t,n),p=o.red,c=o.green,h=o.blue,f=o.alpha,y=a.red,m=a.green,d=a.blue,g=a.alpha;if(r.equals(o,a)){for(s=0;s<u;s++)i[l++]=r.floatToByte(p),i[l++]=r.floatToByte(c),i[l++]=r.floatToByte(h),i[l++]=r.floatToByte(f);return l}let T=(y-p)/u,k=(m-c)/u,w=(d-h)/u,_=(g-f)/u,B=l;for(s=0;s<u;s++)i[B++]=r.floatToByte(p+s*T),i[B++]=r.floatToByte(c+s*k),i[B++]=r.floatToByte(h+s*w),i[B++]=r.floatToByte(f+s*_);return B}function O(e){let t=(e=e??J.EMPTY_OBJECT).positions,o=e.colors,a=e.colorsPerVertex??!1;if(!u(t)||t.length<2)throw new D("At least two positions are required.");if(u(o)&&(a&&o.length<t.length||!a&&o.length<t.length-1))throw new D("colors has an invalid length.");this._positions=t,this._colors=o,this._colorsPerVertex=a,this._arcType=e.arcType??L.GEODESIC,this._granularity=e.granularity??G.RADIANS_PER_DEGREE,this._ellipsoid=e.ellipsoid??w.default,this._workerName="createSimplePolylineGeometry";let n=1+t.length*A.packedLength;n+=u(o)?1+o.length*r.packedLength:1,this.packedLength=n+w.packedLength+3}O.pack=function(e,t,o){if(!u(e))throw new D("value is required");if(!u(t))throw new D("array is required");o=o??0;let a,n=e._positions,i=n.length;for(t[o++]=i,a=0;a<i;++a,o+=A.packedLength)A.pack(n[a],t,o);let l=e._colors;for(i=u(l)?l.length:0,t[o++]=i,a=0;a<i;++a,o+=r.packedLength)r.pack(l[a],t,o);return w.pack(e._ellipsoid,t,o),o+=w.packedLength,t[o++]=e._colorsPerVertex?1:0,t[o++]=e._arcType,t[o]=e._granularity,t},O.unpack=function(e,t,o){if(!u(e))throw new D("array is required");t=t??0;let a,n=e[t++],i=new Array(n);for(a=0;a<n;++a,t+=A.packedLength)i[a]=A.unpack(e,t);n=e[t++];let l=n>0?new Array(n):void 0;for(a=0;a<n;++a,t+=r.packedLength)l[a]=r.unpack(e,t);let s=w.unpack(e,t);t+=w.packedLength;let p=1===e[t++],c=e[t++],h=e[t];return u(o)?(o._positions=i,o._colors=l,o._ellipsoid=s,o._colorsPerVertex=p,o._arcType=c,o._granularity=h,o):new O({positions:i,colors:l,ellipsoid:s,colorsPerVertex:p,arcType:c,granularity:h})};var U=new Array(2),q=new Array(2),$={positions:U,height:q,ellipsoid:void 0,minDistance:void 0,granularity:void 0};O.createGeometry=function(e){let t,o,a,n,i,l=e._positions,s=e._colors,p=e._colorsPerVertex,c=e._arcType,h=e._granularity,f=e._ellipsoid,y=G.chordLength(h,f.maximumRadius),m=u(s)&&!p,d=l.length,g=0;if(c===L.GEODESIC||c===L.RHUMB){let e,a,p;c===L.GEODESIC?(e=G.chordLength(h,f.maximumRadius),a=P.numberOfPoints,p=P.generateArc):(e=h,a=P.numberOfPointsRhumbLine,p=P.generateRhumbArc);let T=P.extractHeights(l,f),k=$;if(c===L.GEODESIC?k.minDistance=y:k.granularity=h,k.ellipsoid=f,m){let c=0;for(t=0;t<d-1;t++)c+=a(l[t],l[t+1],e)+1;o=new Float64Array(3*c),n=new Uint8Array(4*c),k.positions=U,k.height=q;let h=0;for(t=0;t<d-1;++t){U[0]=l[t],U[1]=l[t+1],q[0]=T[t],q[1]=T[t+1];let e=p(k);if(u(s)){let o=e.length/3;i=s[t];for(let e=0;e<o;++e)n[h++]=r.floatToByte(i.red),n[h++]=r.floatToByte(i.green),n[h++]=r.floatToByte(i.blue),n[h++]=r.floatToByte(i.alpha)}o.set(e,g),g+=e.length}}else if(k.positions=l,k.height=T,o=new Float64Array(p(k)),u(s)){for(n=new Uint8Array(o.length/3*4),t=0;t<d-1;++t){g=Z(l[t],l[t+1],s[t],s[t+1],y,n,g)}let e=s[d-1];n[g++]=r.floatToByte(e.red),n[g++]=r.floatToByte(e.green),n[g++]=r.floatToByte(e.blue),n[g++]=r.floatToByte(e.alpha)}}else{a=m?2*d-2:d,o=new Float64Array(3*a),n=u(s)?new Uint8Array(4*a):void 0;let e=0,p=0;for(t=0;t<d;++t){let a=l[t];if(m&&t>0&&(A.pack(a,o,e),e+=3,i=s[t-1],n[p++]=r.floatToByte(i.red),n[p++]=r.floatToByte(i.green),n[p++]=r.floatToByte(i.blue),n[p++]=r.floatToByte(i.alpha)),m&&t===d-1)break;A.pack(a,o,e),e+=3,u(s)&&(i=s[t],n[p++]=r.floatToByte(i.red),n[p++]=r.floatToByte(i.green),n[p++]=r.floatToByte(i.blue),n[p++]=r.floatToByte(i.alpha))}}let T=new W;T.position=new H({componentDatatype:v.DOUBLE,componentsPerAttribute:3,values:o}),u(s)&&(T.color=new H({componentDatatype:v.UNSIGNED_BYTE,componentsPerAttribute:4,values:n,normalize:!0})),a=o.length/3;let k=2*(a-1),w=X.createTypedArray(a,k),_=0;for(t=0;t<a-1;++t)w[_++]=t,w[_++]=t+1;return new Q({attributes:T,indices:w,primitiveType:K.LINES,boundingSphere:j.fromPoints(l)})};var Y=O;function x(e,r){return u(r)&&(e=Y.unpack(e,r)),e._ellipsoid=w.clone(e._ellipsoid),Y.createGeometry(e)}var _e=x;export{_e as default};