/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as R}from"./chunk-TVWUDJC6.js";import{a as It}from"./chunk-WHONDMPK.js";import{a as M}from"./chunk-SJMWDCKU.js";import{a as bt}from"./chunk-II365YZS.js";import"./chunk-WZSOKNIB.js";import"./chunk-4GIZMT42.js";import"./chunk-QTPIBP7S.js";import"./chunk-ZCCOD3XE.js";import{a as W}from"./chunk-SFW65PGL.js";import"./chunk-DPQZPDIL.js";import{h as z}from"./chunk-YJEV67VS.js";import"./chunk-4BTDTSQG.js";import{a as o,b as nt,d as j}from"./chunk-XFVXIGTK.js";import{a as et}from"./chunk-MPRZ6V46.js";import"./chunk-FO77LMQ7.js";import"./chunk-TYEGOJMY.js";import"./chunk-VZMWSUG7.js";import{e as A}from"./chunk-362ETHZ6.js";var kt=new o,Bt=new j,Nt=new z,E={min:void 0,max:void 0,indexBytesPerElement:void 0};function Pt(t){let e=new Float64Array(t),n=0;E.indexBytesPerElement=e[n++],E.min=e[n++],E.max=e[n++],o.unpack(e,n,kt),n+=o.packedLength,j.unpack(e,n,Bt),n+=j.packedLength,z.unpack(e,n,Nt)}function Tt(t){let e=t.length,n=0;for(let r=0;r<e;++r)n+=R.packedLength+3+t[r].batchIds.length;return n}function Ct(t,e,n){let r=e.length,a=2+r*M.packedLength+1+Tt(n),o=new Float64Array(a),i=0;o[i++]=t,o[i++]=r;for(let t=0;t<r;++t)M.pack(e[t],o,i),i+=M.packedLength;let s=n.length;o[i++]=s;for(let t=0;t<s;++t){let e=n[t];R.pack(e.color,o,i),i+=R.packedLength,o[i++]=e.offset,o[i++]=e.count;let r=e.batchIds,a=r.length;o[i++]=a;for(let t=0;t<a;++t)o[i++]=r[t]}return o}var yt=32767,wt=new o,Ht=new o,St=new o,Ut=new o,Ft=new o,Lt=new nt,Mt=new z;function Rt(t,e){let n;Pt(t.packedBuffer),n=2===E.indexBytesPerElement?new Uint16Array(t.indices):new Uint32Array(t.indices);let r=new Uint16Array(t.positions),a=new Uint32Array(t.counts),i=new Uint32Array(t.indexCounts),s=new Uint32Array(t.batchIds),f=new Uint32Array(t.batchTableColors),l=new Array(a.length),c=kt,h=Bt,u=Nt,m=E.min,p=E.max,d=t.minimumHeights,I=t.maximumHeights;A(d)&&A(I)&&(d=new Float32Array(d),I=new Float32Array(I));let g,k,w,b=r.length/2,y=r.subarray(0,b),T=r.subarray(b,2*b);bt.zigZagDeltaDecode(y,T);let N=new Float64Array(3*b);for(g=0;g<b;++g){let t=y[g],e=T[g],n=et.lerp(u.west,u.east,t/yt),r=et.lerp(u.south,u.north,e/yt),a=nt.fromRadians(n,r,0,Lt),i=h.cartographicToCartesian(a,wt);o.pack(i,N,3*g)}let x=a.length,j=new Array(x),L=new Array(x),S=0,P=0;for(g=0;g<x;++g)j[g]=S,L[g]=P,S+=a[g],P+=i[g];let U=new Float32Array(3*b*2),O=new Uint16Array(2*b),F=new Uint32Array(L.length),B=new Uint32Array(i.length),C=[],D={};for(g=0;g<x;++g)w=f[g],A(D[w])?(D[w].positionLength+=a[g],D[w].indexLength+=i[g],D[w].batchIds.push(g)):D[w]={positionLength:a[g],indexLength:i[g],offset:0,indexOffset:0,batchIds:[g]};let G,V=0,Y=0;for(w in D)if(D.hasOwnProperty(w)){G=D[w],G.offset=V,G.indexOffset=Y;let t=2*G.positionLength,e=2*G.indexLength+6*G.positionLength;V+=t,Y+=e,G.indexLength=e}let Z=[];for(w in D)D.hasOwnProperty(w)&&(G=D[w],Z.push({color:R.fromRgba(parseInt(w)),offset:G.indexOffset,count:G.indexLength,batchIds:G.batchIds}));for(g=0;g<x;++g){w=f[g],G=D[w];let t=G.offset,e=3*t,r=t,b=j[g],y=a[g],E=s[g],T=m,x=p;A(d)&&A(I)&&(T=d[g],x=I[g]);let S=Number.POSITIVE_INFINITY,P=Number.NEGATIVE_INFINITY,R=Number.POSITIVE_INFINITY,V=Number.NEGATIVE_INFINITY;for(k=0;k<y;++k){let t=o.unpack(N,3*b+3*k,wt);h.scaleToGeodeticSurface(t,t);let n=h.cartesianToCartographic(t,Lt),a=n.latitude,i=n.longitude;S=Math.min(a,S),P=Math.max(a,P),R=Math.min(i,R),V=Math.max(i,V);let s=h.geodeticSurfaceNormal(t,Ht),f=o.multiplyByScalar(s,T,St),l=o.add(t,f,Ut);f=o.multiplyByScalar(s,x,f);let u=o.add(t,f,Ft);o.subtract(u,c,u),o.subtract(l,c,l),o.pack(u,U,e),o.pack(l,U,e+3),O[r]=E,O[r+1]=E,e+=6,r+=2}u=Mt,u.west=R,u.east=V,u.south=S,u.north=P,l[g]=M.fromRectangle(u,m,p,h);let W=G.indexOffset,Y=L[g],Z=i[g];for(F[g]=W,k=0;k<Z;k+=3){let e=n[Y+k]-b,r=n[Y+k+1]-b,a=n[Y+k+2]-b;C[W++]=2*e+t,C[W++]=2*r+t,C[W++]=2*a+t,C[W++]=2*a+1+t,C[W++]=2*r+1+t,C[W++]=2*e+1+t}for(k=0;k<y;++k){let e=k,n=(k+1)%y;C[W++]=2*e+1+t,C[W++]=2*n+t,C[W++]=2*e+t,C[W++]=2*e+1+t,C[W++]=2*n+1+t,C[W++]=2*n+t}G.offset+=2*y,G.indexOffset=W,B[g]=W-F[g]}C=W.createTypedArray(U.length/3,C);let _=Z.length;for(let t=0;t<_;++t){let e=Z[t].batchIds,n=0,r=e.length;for(let t=0;t<r;++t)n+=B[e[t]];Z[t].count=n}let H=Ct(2===C.BYTES_PER_ELEMENT?W.UNSIGNED_SHORT:W.UNSIGNED_INT,l,Z);return e.push(U.buffer,C.buffer,F.buffer,B.buffer,O.buffer,H.buffer),{positions:U.buffer,indices:C.buffer,indexOffsets:F.buffer,indexCounts:B.buffer,batchIds:O.buffer,packedBuffer:H.buffer}}var Jt=It(Rt);export{Jt as default};