/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as Dt,b as Gt}from"./chunk-JDT4K6IX.js";import{a as Lt}from"./chunk-WHONDMPK.js";import{a as lt}from"./chunk-WV2B3Y5P.js";import{a as qt}from"./chunk-SJMWDCKU.js";import"./chunk-II365YZS.js";import"./chunk-WZSOKNIB.js";import{a as kt}from"./chunk-4GIZMT42.js";import"./chunk-QTPIBP7S.js";import"./chunk-ZCCOD3XE.js";import{d as zt}from"./chunk-DPQZPDIL.js";import{b as $,g as Ot,h as Vt}from"./chunk-YJEV67VS.js";import"./chunk-4BTDTSQG.js";import{a as P,b as N,c as wt,d as Ut}from"./chunk-XFVXIGTK.js";import{a as r}from"./chunk-MPRZ6V46.js";import"./chunk-FO77LMQ7.js";import{a as Ht}from"./chunk-TYEGOJMY.js";import"./chunk-VZMWSUG7.js";import{e as ht}from"./chunk-362ETHZ6.js";var $t=Uint16Array.BYTES_PER_ELEMENT,mt=Int32Array.BYTES_PER_ELEMENT,Pt=Uint32Array.BYTES_PER_ELEMENT,te=Float32Array.BYTES_PER_ELEMENT,H=Float64Array.BYTES_PER_ELEMENT;function tt(t,e,n){n=n??r;let i=t.length;for(let o=0;o<i;++o)if(n.equalsEpsilon(t[o],e,r.EPSILON12))return o;return-1}function ee(t,e){t.ellipsoid=Ut.clone(t.ellipsoid),t.rectangle=Vt.clone(t.rectangle);let n=re(t.buffer,t.relativeToCenter,t.ellipsoid,t.rectangle,t.nativeRectangle,t.exaggeration,t.exaggerationRelativeHeight,t.skirtHeight,t.includeWebMercatorT,t.negativeAltitudeExponentBias,t.negativeElevationThreshold),i=n.vertices;e.push(i.buffer);let r=n.indices;return e.push(r.buffer),{vertices:i.buffer,indices:r.buffer,numberOfAttributes:n.encoding.stride,minimumHeight:n.minimumHeight,maximumHeight:n.maximumHeight,boundingSphere3D:n.boundingSphere3D,orientedBoundingBox:n.orientedBoundingBox,occludeePointInScaledSpace:n.occludeePointInScaledSpace,encoding:n.encoding,vertexCountWithoutSkirts:n.vertexCountWithoutSkirts,indexCountWithoutSkirts:n.indexCountWithoutSkirts,westIndicesSouthToNorth:n.westIndicesSouthToNorth,southIndicesEastToWest:n.southIndicesEastToWest,eastIndicesNorthToSouth:n.eastIndicesNorthToSouth,northIndicesWestToEast:n.northIndicesWestToEast}}var u=new N,G=new P,oe=new P,ne=new P,ie=new $;function re(t,e,n,i,o,a,s,l,h,c,d){let m,g,p,I,T,f;ht(i)?(m=i.west,g=i.south,p=i.east,I=i.north,T=i.width,f=i.height):(m=r.toRadians(o.west),g=r.toRadians(o.south),p=r.toRadians(o.east),I=r.toRadians(o.north),T=r.toRadians(i.width),f=r.toRadians(i.height));let E,S,x=[g,I],w=[m,p],k=Ot.eastNorthUpToFixedFrame(e,n),M=$.inverseTransformation(k,ie);h&&(E=lt.geodeticLatitudeToMercatorAngle(g),S=1/(lt.geodeticLatitudeToMercatorAngle(I)-E));let b=1!==a,y=new DataView(t),B=Number.POSITIVE_INFINITY,R=Number.NEGATIVE_INFINITY,v=oe;v.x=Number.POSITIVE_INFINITY,v.y=Number.POSITIVE_INFINITY,v.z=Number.POSITIVE_INFINITY;let A=ne;A.x=Number.NEGATIVE_INFINITY,A.y=Number.NEGATIVE_INFINITY,A.z=Number.NEGATIVE_INFINITY;let F,_,W=0,V=0,j=0;for(_=0;_<4;++_){let t=W;F=y.getUint32(t,!0),t+=Pt;let e=r.toRadians(180*y.getFloat64(t,!0));t+=H,-1===tt(w,e)&&w.push(e);let n=r.toRadians(180*y.getFloat64(t,!0));t+=H,-1===tt(x,n)&&x.push(n),t+=2*H;let i=y.getInt32(t,!0);t+=mt,V+=i,i=y.getInt32(t,!0),j+=3*i,W+=F+Pt}let Y=[],C=[],O=new Array(V),U=new Array(V),D=new Array(V),L=h?new Array(V):[],Z=b?new Array(V):[],z=new Array(j),K=[],J=[],Q=[],X=[],q=0,et=0;for(W=0,_=0;_<4;++_){F=y.getUint32(W,!0),W+=Pt;let t=W,e=r.toRadians(180*y.getFloat64(W,!0));W+=H;let i=r.toRadians(180*y.getFloat64(W,!0));W+=H;let o=r.toRadians(180*y.getFloat64(W,!0)),a=.5*o;W+=H;let s=r.toRadians(180*y.getFloat64(W,!0)),l=.5*s;W+=H;let T=y.getInt32(W,!0);W+=mt;let f=y.getInt32(W,!0);W+=mt,W+=mt;let k=new Array(T);for(let t=0;t<T;++t){let T=e+y.getUint8(W++)*o;u.longitude=T;let f=i+y.getUint8(W++)*s;u.latitude=f;let H=y.getFloat32(W,!0);if(W+=te,0!==H&&H<d&&(H*=-Math.pow(2,c)),H*=6371010,u.height=H,-1!==tt(w,T)||-1!==tt(x,f)){let e=tt(Y,u,N);if(-1!==e){k[t]=C[e];continue}Y.push(N.clone(u)),C.push(q)}k[t]=q,Math.abs(T-m)<a?K.push({index:q,cartographic:N.clone(u)}):Math.abs(T-p)<a?Q.push({index:q,cartographic:N.clone(u)}):Math.abs(f-g)<l?J.push({index:q,cartographic:N.clone(u)}):Math.abs(f-I)<l&&X.push({index:q,cartographic:N.clone(u)}),B=Math.min(H,B),R=Math.max(H,R),D[q]=H;let F=n.cartographicToCartesian(u);if(O[q]=F,h&&(L[q]=(lt.geodeticLatitudeToMercatorAngle(f)-E)*S),b){let t=n.geodeticSurfaceNormal(F);Z[q]=t}$.multiplyByPoint(M,F,G),P.minimumByComponent(G,v,v),P.maximumByComponent(G,A,A);let _=(T-m)/(p-m);_=r.clamp(_,0,1);let V=(f-g)/(I-g);V=r.clamp(V,0,1),U[q]=new wt(_,V),++q}let _=3*f;for(let t=0;t<_;++t,++et)z[et]=k[y.getUint16(W,!0)],W+=$t;if(F!==W-t)throw new Ht("Invalid terrain tile.")}O.length=q,U.length=q,D.length=q,h&&(L.length=q),b&&(Z.length=q);let nt=q,it=et,rt={hMin:B,lastBorderPoint:void 0,skirtHeight:l,toENU:M,ellipsoid:n,minimum:v,maximum:A};K.sort((function(t,e){return e.cartographic.latitude-t.cartographic.latitude})),J.sort((function(t,e){return t.cartographic.longitude-e.cartographic.longitude})),Q.sort((function(t,e){return t.cartographic.latitude-e.cartographic.latitude})),X.sort((function(t,e){return e.cartographic.longitude-t.cartographic.longitude}));let ot=1e-5;if(gt(O,D,U,L,Z,z,rt,K,-ot*T,!0,-ot*f),gt(O,D,U,L,Z,z,rt,J,-ot*f,!1),gt(O,D,U,L,Z,z,rt,Q,ot*T,!0,ot*f),gt(O,D,U,L,Z,z,rt,X,ot*f,!1),K.length>0&&X.length>0){let t=K[0].index,e=nt,n=X[X.length-1].index,i=O.length-1;z.push(n,i,e,e,t,n)}V=O.length;let at,ut=zt.fromPoints(O);ht(i)&&(at=qt.fromRectangle(i,B,R,n));let st=new Dt(n).computeHorizonCullingPointPossiblyUnderEllipsoid(e,O,B),ct=new kt(v,A,e),dt=new Gt(e,ct,rt.hMin,R,k,!1,h,b,a,s),pt=new Float32Array(V*dt.stride),It=0;for(let t=0;t<V;++t)It=dt.encode(pt,It,O[t],U[t],D[t],void 0,L[t],Z[t]);let Tt=K.map((function(t){return t.index})).reverse(),ft=J.map((function(t){return t.index})).reverse(),Et=Q.map((function(t){return t.index})).reverse(),Nt=X.map((function(t){return t.index})).reverse();return ft.unshift(Et[Et.length-1]),ft.push(Tt[0]),Nt.unshift(Tt[Tt.length-1]),Nt.push(Et[0]),{vertices:pt,indices:new Uint16Array(z),maximumHeight:R,minimumHeight:B,encoding:dt,boundingSphere3D:ut,orientedBoundingBox:at,occludeePointInScaledSpace:st,vertexCountWithoutSkirts:nt,indexCountWithoutSkirts:it,westIndicesSouthToNorth:Tt,southIndicesEastToWest:ft,eastIndicesNorthToSouth:Et,northIndicesWestToEast:Nt}}function gt(t,e,n,i,o,a,s,l,h,c,d){let m=l.length;for(let g=0;g<m;++g){let p=l[g],I=p.cartographic,T=p.index,f=t.length,E=I.longitude,S=I.latitude;S=r.clamp(S,-r.PI_OVER_TWO,r.PI_OVER_TWO);let x=I.height-s.skirtHeight;s.hMin=Math.min(s.hMin,x),N.fromRadians(E,S,x,u),c&&(u.longitude+=h),c?g===m-1?u.latitude+=d:0===g&&(u.latitude-=d):u.latitude+=h;let w=s.ellipsoid.cartographicToCartesian(u);t.push(w),e.push(x),n.push(wt.clone(n[T])),i.length>0&&i.push(i[T]),o.length>0&&o.push(o[T]),$.multiplyByPoint(s.toENU,w,G);let k=s.minimum,M=s.maximum;P.minimumByComponent(G,k,k),P.maximumByComponent(G,M,M);let b=s.lastBorderPoint;if(ht(b)){let t=b.index;a.push(t,f-1,f,f,T,t)}s.lastBorderPoint=p}}var we=Lt(ee);export{we as default};