/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as Ct,b as vt}from"./chunk-JDT4K6IX.js";import{a as Mt}from"./chunk-WHONDMPK.js";import{a as z}from"./chunk-WV2B3Y5P.js";import"./chunk-II365YZS.js";import{a as Wt}from"./chunk-4GIZMT42.js";import{a as X}from"./chunk-SFW65PGL.js";import"./chunk-DPQZPDIL.js";import{b as U,g as bt,h as At}from"./chunk-YJEV67VS.js";import"./chunk-4BTDTSQG.js";import{a as P,b as wt,c as lt,d as pt}from"./chunk-XFVXIGTK.js";import{a as f}from"./chunk-MPRZ6V46.js";import"./chunk-FO77LMQ7.js";import"./chunk-TYEGOJMY.js";import{a as m}from"./chunk-VZMWSUG7.js";import{e as w}from"./chunk-362ETHZ6.js";function T(){m.throwInstantiationError()}Object.defineProperties(T.prototype,{errorEvent:{get:m.throwInstantiationError},credit:{get:m.throwInstantiationError},tilingScheme:{get:m.throwInstantiationError},hasWaterMask:{get:m.throwInstantiationError},hasVertexNormals:{get:m.throwInstantiationError},availability:{get:m.throwInstantiationError}});var Ot=[];T.getRegularGridIndices=function(t,e){if(t*e>=f.FOUR_GIGABYTES)throw new m("The total number of vertices (width * height) must be less than 4,294,967,296.");let r=Ot[t];w(r)||(Ot[t]=r=[]);let n=r[e];return w(n)||(n=t*e<f.SIXTY_FOUR_KILOBYTES?r[e]=new Uint16Array((t-1)*(e-1)*6):r[e]=new Uint32Array((t-1)*(e-1)*6),Pt(t,e,n,0)),n};var Gt=[];T.getRegularGridIndicesAndEdgeIndices=function(t,e){if(t*e>=f.FOUR_GIGABYTES)throw new m("The total number of vertices (width * height) must be less than 4,294,967,296.");let r=Gt[t];w(r)||(Gt[t]=r=[]);let n=r[e];if(!w(n)){let i=T.getRegularGridIndices(t,e),o=Lt(t,e),a=o.westIndicesSouthToNorth,s=o.southIndicesEastToWest,h=o.eastIndicesNorthToSouth,u=o.northIndicesWestToEast;n=r[e]={indices:i,westIndicesSouthToNorth:a,southIndicesEastToWest:s,eastIndicesNorthToSouth:h,northIndicesWestToEast:u}}return n};var kt=[];function Lt(t,e){let r,n=new Array(e),i=new Array(t),o=new Array(e),a=new Array(t);for(r=0;r<t;++r)a[r]=r,i[r]=t*e-1-r;for(r=0;r<e;++r)o[r]=(r+1)*t-1,n[r]=(e-r-1)*t;return{westIndicesSouthToNorth:n,southIndicesEastToWest:i,eastIndicesNorthToSouth:o,northIndicesWestToEast:a}}function Pt(t,e,r,n){let i=0;for(let o=0;o<e-1;++o){for(let e=0;e<t-1;++e){let e=i,o=e+t,a=o+1,s=e+1;r[n++]=e,r[n++]=o,r[n++]=s,r[n++]=s,r[n++]=o,r[n++]=a,++i}++i}}function Z(t,e,r,n){let i=t[0],o=t.length;for(let a=1;a<o;++a){let o=t[a];r[n++]=i,r[n++]=o,r[n++]=e,r[n++]=e,r[n++]=o,r[n++]=e+1,i=o,++e}return n}T.getRegularGridAndSkirtIndicesAndEdgeIndices=function(t,e){if(t*e>=f.FOUR_GIGABYTES)throw new m("The total number of vertices (width * height) must be less than 4,294,967,296.");let r=kt[t];w(r)||(kt[t]=r=[]);let n=r[e];if(!w(n)){let i=t*e,o=(t-1)*(e-1)*6,a=2*t+2*e,s=i+a,h=o+6*Math.max(0,a-4),u=Lt(t,e),c=u.westIndicesSouthToNorth,l=u.southIndicesEastToWest,I=u.eastIndicesNorthToSouth,d=u.northIndicesWestToEast,m=X.createTypedArray(s,h);Pt(t,e,m,0),T.addSkirtIndices(c,l,I,d,i,m,o),n=r[e]={indices:m,westIndicesSouthToNorth:c,southIndicesEastToWest:l,eastIndicesNorthToSouth:I,northIndicesWestToEast:d,indexCountWithoutSkirts:o}}return n},T.addSkirtIndices=function(t,e,r,n,i,o,a){let s=i;a=Z(t,s,o,a),s+=t.length,a=Z(e,s,o,a),s+=e.length,a=Z(r,s,o,a),s+=r.length,Z(n,s,o,a)},T.heightmapTerrainQuality=.25,T.getEstimatedLevelZeroGeometricErrorForAHeightmap=function(t,e,r){return 2*t.maximumRadius*Math.PI*T.heightmapTerrainQuality/(e*r)},T.prototype.requestTileGeometry=m.throwInstantiationError,T.prototype.getLevelMaximumGeometricError=m.throwInstantiationError,T.prototype.getTileDataAvailable=m.throwInstantiationError,T.prototype.loadTileDataAvailability=m.throwInstantiationError;var Vt=T,ht=32767,D=new P,Xt=new P,Zt=new P,u=new wt,Y=new lt;function Jt(t,e){let r,n,i=t.quantizedVertices,o=i.length/3,a=t.octEncodedNormals,s=t.westIndices.length+t.eastIndices.length+t.southIndices.length+t.northIndices.length,h=t.includeWebMercatorT,c=t.exaggeration,l=t.exaggerationRelativeHeight,I=1!==c,d=At.clone(t.rectangle),m=d.west,T=d.south,g=d.east,p=d.north,N=pt.clone(t.ellipsoid),E=t.minimumHeight,y=t.maximumHeight,S=t.relativeToCenter,b=bt.eastNorthUpToFixedFrame(S,N),A=U.inverseTransformation(b,new U);h&&(r=z.geodeticLatitudeToMercatorAngle(T),n=1/(z.geodeticLatitudeToMercatorAngle(p)-r));let k=i.subarray(0,o),x=i.subarray(o,2*o),G=i.subarray(2*o,3*o),M=w(a),W=new Array(o),v=new Array(o),F=new Array(o),V=h?new Array(o):[],O=I?new Array(o):[],_=Xt;_.x=Number.POSITIVE_INFINITY,_.y=Number.POSITIVE_INFINITY,_.z=Number.POSITIVE_INFINITY;let H=Zt;H.x=Number.NEGATIVE_INFINITY,H.y=Number.NEGATIVE_INFINITY,H.z=Number.NEGATIVE_INFINITY;let j=Number.POSITIVE_INFINITY,Z=Number.NEGATIVE_INFINITY,C=Number.POSITIVE_INFINITY,L=Number.NEGATIVE_INFINITY;for(let t=0;t<o;++t){let e=k[t],i=x[t],o=e/ht,a=i/ht,s=f.lerp(E,y,G[t]/ht);u.longitude=f.lerp(m,g,o),u.latitude=f.lerp(T,p,a),u.height=s,j=Math.min(u.longitude,j),Z=Math.max(u.longitude,Z),C=Math.min(u.latitude,C),L=Math.max(u.latitude,L);let c=N.cartographicToCartesian(u);W[t]=new lt(o,a),v[t]=s,F[t]=c,h&&(V[t]=(z.geodeticLatitudeToMercatorAngle(u.latitude)-r)*n),I&&(O[t]=N.geodeticSurfaceNormal(c)),U.multiplyByPoint(A,c,D),P.minimumByComponent(D,_,_),P.maximumByComponent(D,H,H)}let B,R=tt(t.westIndices,(function(t,e){return W[t].y-W[e].y})),Q=tt(t.eastIndices,(function(t,e){return W[e].y-W[t].y})),K=tt(t.southIndices,(function(t,e){return W[e].x-W[t].x})),q=tt(t.northIndices,(function(t,e){return W[t].x-W[e].x}));E<0&&(B=new Ct(N).computeHorizonCullingPointPossiblyUnderEllipsoid(S,F,E));let et=E;et=Math.min(et,J(t.westIndices,t.westSkirtHeight,v,W,d,N,A,_,H)),et=Math.min(et,J(t.southIndices,t.southSkirtHeight,v,W,d,N,A,_,H)),et=Math.min(et,J(t.eastIndices,t.eastSkirtHeight,v,W,d,N,A,_,H)),et=Math.min(et,J(t.northIndices,t.northSkirtHeight,v,W,d,N,A,_,H));let rt=new Wt(_,H,S),nt=new vt(S,rt,et,y,b,M,h,I,c,l),it=nt.stride,ot=new Float32Array(o*it+s*it),at=0;for(let t=0;t<o;++t){if(M){let e=2*t;Y.x=a[e],Y.y=a[e+1]}at=nt.encode(ot,at,F[t],W[t],v[t],Y,V[t],O[t])}let st=Math.max(0,2*(s-4)),ut=t.indices.length+3*st,ct=X.createTypedArray(o+s,ut);ct.set(t.indices,0);let It=1e-4,dt=(Z-j)*It,mt=(L-C)*It,Tt=-dt,gt=dt,ft=mt,wt=-mt,Nt=o*it;return $(ot,Nt,R,nt,v,W,a,N,d,t.westSkirtHeight,r,n,Tt,0),Nt+=t.westIndices.length*it,$(ot,Nt,K,nt,v,W,a,N,d,t.southSkirtHeight,r,n,0,wt),Nt+=t.southIndices.length*it,$(ot,Nt,Q,nt,v,W,a,N,d,t.eastSkirtHeight,r,n,gt,0),Nt+=t.eastIndices.length*it,$(ot,Nt,q,nt,v,W,a,N,d,t.northSkirtHeight,r,n,0,ft),Vt.addSkirtIndices(R,K,Q,q,o,ct,t.indices.length),e.push(ot.buffer,ct.buffer),{vertices:ot.buffer,indices:ct.buffer,westIndicesSouthToNorth:R,southIndicesEastToWest:K,eastIndicesNorthToSouth:Q,northIndicesWestToEast:q,vertexStride:it,center:S,minimumHeight:E,maximumHeight:y,occludeePointInScaledSpace:B,encoding:nt,indexCountWithoutSkirts:t.indices.length}}function J(t,e,r,n,i,o,a,s,h){let c=Number.POSITIVE_INFINITY,l=i.north,I=i.south,d=i.east,m=i.west;d<m&&(d+=f.TWO_PI);let T=t.length;for(let i=0;i<T;++i){let T=t[i],g=r[T],w=n[T];u.longitude=f.lerp(m,d,w.x),u.latitude=f.lerp(I,l,w.y),u.height=g-e;let p=o.cartographicToCartesian(u,D);U.multiplyByPoint(a,p,p),P.minimumByComponent(p,s,s),P.maximumByComponent(p,h,h),c=Math.min(c,u.height)}return c}function $(t,e,r,n,i,o,a,s,h,c,l,I,d,m){let T=w(a),g=h.north,p=h.south,N=h.east,E=h.west;N<E&&(N+=f.TWO_PI);let y=r.length;for(let h=0;h<y;++h){let w=r[h],y=i[w],S=o[w];u.longitude=f.lerp(E,N,S.x)+d,u.latitude=f.lerp(p,g,S.y)+m,u.height=y-c;let b,A,k=s.cartographicToCartesian(u,D);if(T){let t=2*w;Y.x=a[t],Y.y=a[t+1]}n.hasWebMercatorT&&(b=(z.geodeticLatitudeToMercatorAngle(u.latitude)-l)*I),n.hasGeodeticSurfaceNormals&&(A=s.geodeticSurfaceNormal(k)),e=n.encode(t,e,k,S,u.height,Y,b,A)}}function tt(t,e){let r;return"function"==typeof t.slice&&(r=t.slice(),"function"!=typeof r.sort&&(r=void 0)),w(r)||(r=Array.prototype.slice.call(t)),r.sort(e),r}var Se=Mt(Jt);export{Se as default};