/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.130
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
import{a as nt}from"./chunk-A4QYP4X5.js";import"./chunk-MQYSNG5N.js";import"./chunk-QYCM25U7.js";import{a as w}from"./chunk-QL3VAYCR.js";import"./chunk-2DWCJX3G.js";import"./chunk-L3YV42ES.js";import"./chunk-QTPIBP7S.js";import"./chunk-ZCCOD3XE.js";import{a as ot}from"./chunk-SFW65PGL.js";import{a as it}from"./chunk-BTGP76WP.js";import{b as tt,c as et,d as R}from"./chunk-YQL7OPIW.js";import{d as I}from"./chunk-DPQZPDIL.js";import"./chunk-YJEV67VS.js";import{a as N}from"./chunk-4BTDTSQG.js";import{a as s,d as l,f as K}from"./chunk-XFVXIGTK.js";import{a as V}from"./chunk-MPRZ6V46.js";import"./chunk-FO77LMQ7.js";import"./chunk-TYEGOJMY.js";import{a as y}from"./chunk-VZMWSUG7.js";import{e as r}from"./chunk-362ETHZ6.js";var Q=new s,J=new s,lt=new s,st=new s,pt=new s,ut=new s,ft=new s;function E(t){let e=(t=t??K.EMPTY_OBJECT).positions,i=t.maximumHeights,n=t.minimumHeights;if(!r(e))throw new y("options.positions is required.");if(r(i)&&i.length!==e.length)throw new y("options.positions and options.maximumHeights must have the same length.");if(r(n)&&n.length!==e.length)throw new y("options.positions and options.minimumHeights must have the same length.");let o=t.vertexFormat??w.DEFAULT,a=t.granularity??V.RADIANS_PER_DEGREE,m=t.ellipsoid??l.default;this._positions=e,this._minimumHeights=n,this._maximumHeights=i,this._vertexFormat=w.clone(o),this._granularity=a,this._ellipsoid=l.clone(m),this._workerName="createWallGeometry";let p=1+e.length*s.packedLength+2;r(n)&&(p+=n.length),r(i)&&(p+=i.length),this.packedLength=p+l.packedLength+w.packedLength+1}E.pack=function(t,e,i){if(!r(t))throw new y("value is required");if(!r(e))throw new y("array is required");i=i??0;let n,o=t._positions,a=o.length;for(e[i++]=a,n=0;n<a;++n,i+=s.packedLength)s.pack(o[n],e,i);let m=t._minimumHeights;if(a=r(m)?m.length:0,e[i++]=a,r(m))for(n=0;n<a;++n)e[i++]=m[n];let p=t._maximumHeights;if(a=r(p)?p.length:0,e[i++]=a,r(p))for(n=0;n<a;++n)e[i++]=p[n];return l.pack(t._ellipsoid,e,i),i+=l.packedLength,w.pack(t._vertexFormat,e,i),e[i+=w.packedLength]=t._granularity,e};var mt=l.clone(l.UNIT_SPHERE),rt=new w,U={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:mt,vertexFormat:rt,granularity:void 0};E.unpack=function(t,e,i){if(!r(t))throw new y("array is required");e=e??0;let n,o,a,m=t[e++],p=new Array(m);for(n=0;n<m;++n,e+=s.packedLength)p[n]=s.unpack(t,e);if(m=t[e++],m>0)for(o=new Array(m),n=0;n<m;++n)o[n]=t[e++];if(m=t[e++],m>0)for(a=new Array(m),n=0;n<m;++n)a[n]=t[e++];let u=l.unpack(t,e,mt);e+=l.packedLength;let h=w.unpack(t,e,rt),c=t[e+=w.packedLength];return r(i)?(i._positions=p,i._minimumHeights=o,i._maximumHeights=a,i._ellipsoid=l.clone(u,i._ellipsoid),i._vertexFormat=w.clone(h,i._vertexFormat),i._granularity=c,i):(U.positions=p,U.minimumHeights=o,U.maximumHeights=a,U.granularity=c,new E(U))},E.fromConstantHeights=function(t){let e=(t=t??K.EMPTY_OBJECT).positions;if(!r(e))throw new y("options.positions is required.");let i,n,o=t.minimumHeight,s=t.maximumHeight,a=r(o),m=r(s);if(a||m){let t=e.length;i=a?new Array(t):void 0,n=m?new Array(t):void 0;for(let e=0;e<t;++e)a&&(i[e]=o),m&&(n[e]=s)}return new E({positions:e,maximumHeights:n,minimumHeights:i,ellipsoid:t.ellipsoid,vertexFormat:t.vertexFormat})},E.createGeometry=function(t){let e=t._positions,i=t._minimumHeights,n=t._maximumHeights,o=t._vertexFormat,a=t._granularity,m=t._ellipsoid,l=nt.computePositions(m,e,n,i,a,!0);if(!r(l))return;let p=l.bottomPositions,u=l.topPositions,h=l.numCorners,c=u.length,g=2*c,f=o.position?new Float64Array(g):void 0,w=o.normal?new Float32Array(g):void 0,y=o.tangent?new Float32Array(g):void 0,d=o.bitangent?new Float32Array(g):void 0,k=o.st?new Float32Array(g/3*2):void 0,_=0,v=0,A=0,E=0,x=0,L=ft,P=ut,H=pt,F=!0;c/=3;let j,T=0,b=1/(c-h-1);for(j=0;j<c;++j){let t=3*j,e=s.fromArray(u,t,Q),i=s.fromArray(p,t,J);if(o.position&&(f[_++]=i.x,f[_++]=i.y,f[_++]=i.z,f[_++]=e.x,f[_++]=e.y,f[_++]=e.z),o.st&&(k[x++]=T,k[x++]=0,k[x++]=T,k[x++]=1),o.normal||o.tangent||o.bitangent){let i=s.clone(s.ZERO,st),n=s.subtract(e,m.geodeticSurfaceNormal(e,J),J);if(j+1<c&&(i=s.fromArray(u,t+3,st)),F){let t=s.subtract(i,e,lt),r=s.subtract(n,e,Q);L=s.normalize(s.cross(r,t,L),L),F=!1}s.equalsEpsilon(e,i,V.EPSILON10)?F=!0:(T+=b,o.tangent&&(P=s.normalize(s.subtract(i,e,P),P)),o.bitangent&&(H=s.normalize(s.cross(L,P,H),H))),o.normal&&(w[v++]=L.x,w[v++]=L.y,w[v++]=L.z,w[v++]=L.x,w[v++]=L.y,w[v++]=L.z),o.tangent&&(y[E++]=P.x,y[E++]=P.y,y[E++]=P.z,y[E++]=P.x,y[E++]=P.y,y[E++]=P.z),o.bitangent&&(d[A++]=H.x,d[A++]=H.y,d[A++]=H.z,d[A++]=H.x,d[A++]=H.y,d[A++]=H.z)}}let O=new it;o.position&&(O.position=new R({componentDatatype:N.DOUBLE,componentsPerAttribute:3,values:f})),o.normal&&(O.normal=new R({componentDatatype:N.FLOAT,componentsPerAttribute:3,values:w})),o.tangent&&(O.tangent=new R({componentDatatype:N.FLOAT,componentsPerAttribute:3,values:y})),o.bitangent&&(O.bitangent=new R({componentDatatype:N.FLOAT,componentsPerAttribute:3,values:d})),o.st&&(O.st=new R({componentDatatype:N.FLOAT,componentsPerAttribute:2,values:k}));let D=g/3;g-=6*(h+1);let S=ot.createTypedArray(D,g),G=0;for(j=0;j<D-2;j+=2){let t=j,e=j+2,i=s.fromArray(f,3*t,Q),n=s.fromArray(f,3*e,J);if(s.equalsEpsilon(i,n,V.EPSILON10))continue;let r=j+1,o=j+3;S[G++]=r,S[G++]=t,S[G++]=o,S[G++]=o,S[G++]=t,S[G++]=e}return new et({attributes:O,indices:S,primitiveType:tt.TRIANGLES,boundingSphere:new I.fromVertices(f)})};var X=E;function ht(t,e){return r(e)&&(t=X.unpack(t,e)),t._ellipsoid=l.clone(t._ellipsoid),X.createGeometry(t)}var Ot=ht;export{Ot as default};